# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from msrest.serialization import Model


class UsageMetric(Model):
    """A metric describing the usage of a resource.

    :param name: The name of the metric.
    :type name: :class:`MetricName
     <azure.mgmt.loganalytics.models.MetricName>`
    :param unit: The units used for the metric.
    :type unit: str
    :param current_value: The current value of the metric.
    :type current_value: float
    :param limit: The quota limit for the metric.
    :type limit: float
    :param next_reset_time: The time that the metric's value will reset.
    :type next_reset_time: datetime
    :param quota_period: The quota period that determines the length of time
     between value resets.
    :type quota_period: str
    """

    _attribute_map = {
        'name': {'key': 'name', 'type': 'MetricName'},
        'unit': {'key': 'unit', 'type': 'str'},
        'current_value': {'key': 'currentValue', 'type': 'float'},
        'limit': {'key': 'limit', 'type': 'float'},
        'next_reset_time': {'key': 'nextResetTime', 'type': 'iso-8601'},
        'quota_period': {'key': 'quotaPeriod', 'type': 'str'},
    }

    def __init__(self, name=None, unit=None, current_value=None, limit=None, next_reset_time=None, quota_period=None):
        self.name = name
        self.unit = unit
        self.current_value = current_value
        self.limit = limit
        self.next_reset_time = next_reset_time
        self.quota_period = quota_period
