# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from .proxy_resource import ProxyResource


class StorageInsight(ProxyResource):
    """The top level storage insight resource container.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :param tags: Resource tags
    :type tags: dict
    :param containers: The names of the blob containers that the workspace
     should read
    :type containers: list of str
    :param tables: The names of the Azure tables that the workspace should
     read
    :type tables: list of str
    :param storage_account: The storage account connection details
    :type storage_account: :class:`StorageAccount
     <azure.mgmt.loganalytics.models.StorageAccount>`
    :ivar status: The status of the storage insight
    :vartype status: :class:`StorageInsightStatus
     <azure.mgmt.loganalytics.models.StorageInsightStatus>`
    :param e_tag: The ETag of the storage insight.
    :type e_tag: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'storage_account': {'required': True},
        'status': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'containers': {'key': 'properties.containers', 'type': '[str]'},
        'tables': {'key': 'properties.tables', 'type': '[str]'},
        'storage_account': {'key': 'properties.storageAccount', 'type': 'StorageAccount'},
        'status': {'key': 'properties.status', 'type': 'StorageInsightStatus'},
        'e_tag': {'key': 'eTag', 'type': 'str'},
    }

    def __init__(self, storage_account, tags=None, containers=None, tables=None, e_tag=None):
        super(StorageInsight, self).__init__(tags=tags)
        self.containers = containers
        self.tables = tables
        self.storage_account = storage_account
        self.status = None
        self.e_tag = e_tag
