import os
from setuptools import setup

README = open(os.path.join(os.path.dirname(__file__), 'README.rst')).read()

# allow setup.py to be run from any path
os.chdir(os.path.normpath(os.path.join(os.path.abspath(__file__), os.pardir)))

setup(
    name='django-misaka',
    version='0.1',
    packages=['django_misaka'],
    include_package_data=True,
    install_requires=[
        'houdini.py',
        'misaka',
        'Pygments',
    ],
    license='MIT',
    description=('A Django template tag for rendering '
                 'Markdown (by Misaka Markdown parser).'),
    long_description=README,
    url='http://github.com/jietu/django-misaka/',
    author='Jie Tu',
    author_email='jietu@python-taiwan.org',
    classifiers=[
        'Development Status :: 3 - Alpha',
        'Environment :: Web Environment',
        'Framework :: Django',
        'Intended Audience :: Developers',
        'License :: OSI Approved :: MIT License',
        'Operating System :: OS Independent',
        'Programming Language :: Python',
        'Programming Language :: Python :: 2.6',
        'Programming Language :: Python :: 2.7',
        'Topic :: Internet :: WWW/HTTP',
        'Topic :: Internet :: WWW/HTTP :: Dynamic Content',
    ],
)
