# -*- coding: utf-8 -*-
"""
著作權所有 (C) 民國103年 意傳文化科技
開發者：薛丞宏
網址：http://意傳.台灣
語料來源：請看各資料庫內說明

本程式乃自由軟體，您必須遵照SocialCalc設計的通用公共授權（Common Public Attribution License, CPAL)來修改和重新發佈這一程式，詳情請參閱條文。授權大略如下，若有歧異，以授權原文為主：
	１．得使用、修改、複製並發佈此程式碼，且必須以通用公共授權發行；
	２．任何以程式碼衍生的執行檔或網路服務，必須公開該程式碼；
	３．將此程式的原始碼當函式庫引用入商業軟體，且不需公開非關此函式庫的任何程式碼

此開放原始碼、共享軟體或說明文件之使用或散佈不負擔保責任，並拒絕負擔因使用上述軟體或說明文件所致任何及一切賠償責任或損害。

臺灣言語工具緣起於本土文化推廣與傳承，非常歡迎各界用於商業軟體，但希望在使用之餘，能夠提供建議、錯誤回報或修補，回饋給這塊土地。

感謝您的使用與推廣～～勞力！承蒙！
"""

from 臺灣言語工具.資料庫.資料庫連線 import 資料庫連線
from 臺灣言語工具.資料庫.整合.教育部閩南語常用詞辭典 import 教育部閩南語辭典名
from 臺灣言語工具.資料庫.欄位資訊 import 閩南語
from 臺灣言語工具.解析整理.拆文分析器 import 拆文分析器
from 臺灣言語工具.解析整理.轉物件音家私 import 轉物件音家私
from 臺灣言語工具.基本元素.字 import 字
import random
from 臺灣言語工具.解析整理.字物件篩仔 import 字物件篩仔
from 臺灣言語工具.解析整理.物件譀鏡 import 物件譀鏡
from 臺灣言語工具.音標系統.閩南語.臺灣閩南語羅馬字拼音 import 臺灣閩南語羅馬字拼音
from 臺灣言語工具.解析整理.解析錯誤 import 解析錯誤
from 臺灣言語工具.資料庫.欄位資訊 import 混合優勢音腔口
from 臺灣言語工具.資料庫.欄位資訊 import 偏泉優勢音腔口
from 臺灣言語工具.資料庫.欄位資訊 import 偏漳優勢音腔口
from 臺灣言語工具.基本元素.公用變數 import 標點符號

class 揣閩南語題目:
	揣來源資料 = lambda self, 來源, 腔口:資料庫連線.prepare('SELECT ' +
		'"子"."流水號","子"."型體","子"."音標" ' +
		'FROM "言語"."文字" AS "子" ' +
		' WHERE "子"."腔口" = $1 ' +
		' AND "子"."種類"=\'字詞\' ' +
		' AND "子"."來源"=$2 ' +
		' AND "子"."地區"=\'臺員\' '
#  		+ ' AND "子"."型體" LIKE \'危\' '
# 		+ 'ORDER BY "子"."流水號" '
# 	 	+ 'LIMIT 200 '
		)(腔口, 來源)
	是俗音無 = lambda self, 流水號:資料庫連線.prepare('SELECT "乙流水號"' +
		'FROM "言語"."演化" ' +
		'WHERE "乙流水號"=$1 ' +
		'AND "乙對甲的演化類型"= \'俗音\''
		).first(流水號)
	俗音 = [('危', 'ui5')]
	_分析器 = 拆文分析器()
	_篩仔 = 字物件篩仔()
	_譀鏡 = 物件譀鏡()
	def __init__(self):
		self.資料 = []
	def 匯入資料庫辭典(self):
# 		self.資料 = list(self.揣來源資料(教育部閩南語辭典名))
		型音對照 = {}
		for 腔口 in [混合優勢音腔口, 偏泉優勢音腔口, 偏漳優勢音腔口, ]:
			self.揣資料庫加到型音對照(型音對照, 腔口)
		for 型, 組陣列 in 型音對照.items():
			整合組物件 = 組陣列[0]
# 			print('頭仔')
			所在 = 0
			for 整合詞物件 in 整合組物件.內底詞:
				for 整合字物件 in 整合詞物件.內底字:
					if 整合字物件.音 in 標點符號:
						整合字物件.音集 = {整合字物件.音}
					else:
						整合字物件.音集 = {臺灣閩南語羅馬字拼音(整合字物件.音).轉閏號調()}
					所在 += 1
			if 1 <= 所在 <= 4:
				pass
			else:
				continue
# 			print('中的')
			for 組物件 in 組陣列[1:]:
				所在 = 0
				字陣列 = self._篩仔.篩出字物件(組物件)
				for 整合詞物件 in 整合組物件.內底詞:
					for 整合字物件 in 整合詞物件.內底字:
						if 整合字物件.音 in 標點符號:
							整合字物件.音集.add(整合字物件.音)
						else:
							整合字物件.音集.add(臺灣閩南語羅馬字拼音(整合字物件.音).轉閏號調())
						所在 += 1
# 			print('尾仔')
			for 整合詞物件 in 整合組物件.內底詞:
				for 整合字物件 in 整合詞物件.內底字:
					整合字物件.音 = '/'.join(整合字物件.音集)
					del 整合字物件.音集
			self.資料.append((整合組物件, 所在))

	def 出字型(self, 數量):
		return self.換出題款(數量, 0, 1)
	def 出字音(self, 數量):
		return self.換出題款(數量, 1, 0)
	def 換出題款(self, 數量, 問編號, 答編號):
		題目 = self.出題(數量)
		問 = []
		答 = []
		for 一題 in 題目:
			問.append((一題[問編號], ''))
			答.append((一題[答編號], ''))
		return (問, 答)
	def 出題(self, 數量):
		揀過 = set()
		揀著 = []
		if 數量 > len(self.資料):
			數量 = len(self.資料)
		while len(揀著) < 數量:
			所在 = random.randrange(len(self.資料))
			if 所在 not in 揀過:
				揀過.add(所在)
				組物件, 長度 = self.資料[所在]
				問 = random.randrange(長度)
				這馬 = 0
				for 詞物件 in 組物件.內底詞:
					for 字物件 in 詞物件.內底字:
						if 這馬 == 問:
							原本型 = 字物件.型
							原本音 = 字物件.音
							字物件.型 = '「' + 字物件.型 + '」'
							字物件.音 = '「' + 字物件.音 + '」'
							題目音 = self._譀鏡.看音(組物件)\
								.replace('-0', '--').replace(' 0', '--')\
								.replace('0', '--')
							揀著.append((self._譀鏡.看型(組物件), 題目音))
							字物件.型 = 原本型
							字物件.音 = 原本音
						這馬 += 1
# 				揀著.append(self.資料[所在])
		return 揀著
	def 揣資料庫加到型音對照(self, 型音對照, 腔口):
		for 流水號, 型, 音 in self.揣來源資料(教育部閩南語辭典名, 腔口):
			if self.是俗音無(流水號) == None:
				if (型, 音) in self.俗音:
					print('資料庫內底有俗音，流={0}，{1}，{2}'.format(流水號, 型, 音))
				else:
					try:
						組物件 = self._分析器.產生對齊組(型, 音)  # 檢查有對齊無
			# 			音=音
						if 型 not in 型音對照:
							型音對照[型] = [組物件]
						else:
							型音對照[型].append(組物件)
					except:
						print(流水號, '無法度對齊！！')
		return
# 輕聲　inn3-0a2　好
# 括號　好
# 雞ke/kue　好
# 俗音
if __name__ == '__main__':
	閩南語題目 = 揣閩南語題目()
	閩南語題目.匯入資料庫辭典()
	print(閩南語題目.出題(10))
	print(閩南語題目.出字型(10))
	print(閩南語題目.出字音(10))
