/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.vfs2.provider.http;

import java.io.IOException;
import org.apache.commons.httpclient.Header;
import org.apache.commons.httpclient.HeaderElement;
import org.apache.commons.httpclient.methods.HeadMethod;
import org.apache.commons.vfs2.FileContent;
import org.apache.commons.vfs2.FileContentInfo;
import org.apache.commons.vfs2.FileContentInfoFactory;
import org.apache.commons.vfs2.FileSystemException;
import org.apache.commons.vfs2.impl.DefaultFileContentInfo;
import org.apache.commons.vfs2.provider.http.HttpFileObject;
import org.apache.commons.vfs2.util.FileObjectUtils;

public class HttpFileContentInfoFactory
implements FileContentInfoFactory {
    @Override
    public FileContentInfo create(FileContent fileContent) throws FileSystemException {
        HeaderElement[] element;
        HeadMethod headMethod;
        String contentType = null;
        String contentEncoding = null;
        try (HttpFileObject httpFile = (HttpFileObject)FileObjectUtils.getAbstractFileObject(fileContent.getFile());){
            headMethod = httpFile.getHeadMethod();
        }
        catch (IOException e) {
            throw new FileSystemException(e);
        }
        Header header = headMethod.getResponseHeader("content-type");
        if (header != null && (element = header.getElements()) != null && element.length > 0) {
            contentType = element[0].getName();
        }
        contentEncoding = headMethod.getResponseCharSet();
        return new DefaultFileContentInfo(contentType, contentEncoding);
    }
}

