'''
Created on Dec 4, 2013

A custom class created for Storing the HTTPError values which can later be used for reporting purpose. 

This class initialized a hash containing the HTTPError code and its corresponding error messages. 

@author: harshanarayana

@change:     2013-12-04    Initial Draft. A custom Class contianing the list of Errors for HTTP. Will be used for Reporting.
             2013-12-17    Documentation Updated.

'''
__version__ = "0.0.2"
__date__ = "06th December 2013"
__author__ = "Harsha Narayana"

class ErrorCodes(object):
    
    def __init__(self, errorCode):
        '''
        Constructor
        
        @param errorCode : HTTPError Code in Integer format. 
        '''
        self.__errorCode = errorCode
        self.__errMessage = { 
    100: ('Continue', 'Request received, please continue'),
    101: ('Switching Protocols',
          'Switching to new protocol; obey Upgrade header'),

    200: ('OK', 'Request fulfilled, document follows'),
    201: ('Created', 'Document created, URL follows'),
    202: ('Accepted',
          'Request accepted, processing continues off-line'),
    203: ('Non-Authoritative Information', 'Request fulfilled from cache'),
    204: ('No Content', 'Request fulfilled, nothing follows'),
    205: ('Reset Content', 'Clear input form for further input.'),
    206: ('Partial Content', 'Partial content follows.'),

    300: ('Multiple Choices',
          'Object has several resources -- see URI list'),
    301: ('Moved Permanently', 'Object moved permanently -- see URI list'),
    302: ('Found', 'Object moved temporarily -- see URI list'),
    303: ('See Other', 'Object moved -- see Method and URL list'),
    304: ('Not Modified',
          'Document has not changed since given time'),
    305: ('Use Proxy',
          'You must use proxy specified in Location to access this '
          'resource.'),
    307: ('Temporary Redirect',
          'Object moved temporarily -- see URI list'),

    400: ('Bad Request',
          'Bad request syntax or unsupported method'),
    401: ('Unauthorized',
          'No permission -- see authorization schemes'),
    402: ('Payment Required',
          'No payment -- see charging schemes'),
    403: ('Forbidden',
          'Request forbidden -- authorization will not help'),
    404: ('Not Found', 'Nothing matches the given URI'),
    405: ('Method Not Allowed',
          'Specified method is invalid for this server.'),
    406: ('Not Acceptable', 'URI not available in preferred format.'),
    407: ('Proxy Authentication Required', 'You must authenticate with '
          'this proxy before proceeding.'),
    408: ('Request Timeout', 'Request timed out; try again later.'),
    409: ('Conflict', 'Request conflict.'),
    410: ('Gone',
          'URI no longer exists and has been permanently removed.'),
    411: ('Length Required', 'Client must specify Content-Length.'),
    412: ('Precondition Failed', 'Precondition in headers is false.'),
    413: ('Request Entity Too Large', 'Entity is too large.'),
    414: ('Request-URI Too Long', 'URI is too long.'),
    415: ('Unsupported Media Type', 'Entity body in unsupported format.'),
    416: ('Requested Range Not Satisfiable',
          'Cannot satisfy request range.'),
    417: ('Expectation Failed',
          'Expect condition could not be satisfied.'),

    500: ('Internal Server Error', 'Server got itself in trouble'),
    501: ('Not Implemented',
          'Server does not support this operation'),
    502: ('Bad Gateway', 'Invalid responses from another server/proxy.'),
    503: ('Service Unavailable',
          'The server cannot process the request due to a high load'),
    504: ('Gateway Timeout',
          'The gateway server did not receive a timely response'),
    505: ('HTTP Version Not Supported', 'Cannot fulfill request.'),
    }
        
    def getErrorCode(self):
        '''
        Get method for HTTPError Code
        
        @return: self.__errorCode
        '''
        return self.__errorCode
    
    def getError(self):
        '''
        Get method for HTTPError information. The return data is a Tuple. 
        
        @return: self.__errMessage[self.__errorCode]
        
        The 1st Element of Tuple is the Short Description and the 2nd Element is the long description. 
        '''
        if ( self.__errMessage.has_key(self.getErrorCode())):
            return self.__errMessage[self.getErrorCode()]
        else:
            return ('Unknown Error', 'No Error Code Information found in the Library')
        
    def setErrorCode(self, value):
        '''
        Set method for HTTPError Code. 
        '''
        self.__errorCode = value