def function():
    import tkinter as tk
    from tkinter import filedialog, messagebox
    #import subprocess
    import os
    import threading

    def update(port, file_path):
        os.system(f"esptool --port {port} write_flash 0 {file_path}")
        status_label.config(text="File written")

    def update_and_erase(port, file_path):
        os.system(f"esptool --port {port} erase_flash")
        os.system(f"esptool --port {port} write_flash 0 {file_path}")
        status_label.config(text="Flash erased and file written")

    def erase(port):
        os.system(f"esptool --port {port} erase_flash")
        status_label.config(text="Flash erased")

    def select_file():
        file_path = filedialog.askopenfilename(
            title="Select File to Update ESP32", 
            filetypes=[("All files", "*.*"), ("Python files", "*.py"), ("Binary files", "*.bin")]
        )
        return file_path

    def start_update():
        port = port_entry.get()
        if not port:
            status_label.config(text="Please enter the port!")
            return

        if operation.get() == "erase_write":
            file_path = select_file()
            if file_path:
                threading.Thread(target=update_and_erase, args=(port, file_path)).start()
                status_label.config(text="Flashing in progress...")
            else:
                status_label.config(text="No file selected!")

        elif operation.get() == "write":
            file_path = select_file()
            if file_path:
                threading.Thread(target=update, args=(port, file_path)).start()
                status_label.config(text="Flashing in progress...")
            else:
                status_label.config(text="No file selected!")

        elif operation.get() == "erase":
            threading.Thread(target=erase, args=(port,)).start()
            status_label.config(text="Erasing in progress...")

        else:
            status_label.config(text="Please select an operation!")

    """def list_files(port):
        try:
            result = subprocess.run(["mpfshell", "-n", "-c", f"open {port}; ls"], check=True, stdout=subprocess.PIPE, stderr=subprocess.PIPE)
            files = result.stdout.decode('utf-8').split('\n')
            return files
        except subprocess.CalledProcessError as e:
            print(e.stderr.decode('utf-8'))
            messagebox.showerror("Error", f"Failed to list files: {e.stderr.decode('utf-8')}")
            return []
    """
    def select_port():
        port = port_entry.get()
        if not port:
            messagebox.showwarning("Input Error", "Please enter the port!")
            return

        #threading.Thread(target=update_file_list, args=(port,)).start()
    """
    def update_file_list(port):
        files = list_files(port)
        files_list.delete(0, tk.END)
        if files:
            for file in files:
                if file.strip():  # Avoid adding empty lines
                    files_list.insert(tk.END, file)
        else:
            files_list.insert(tk.END, "No files found or error reading files.")
    """
    # Create the main Tkinter window
    root = tk.Tk()
    root.title("ESP32 Firmware Updater")

    # Entry field for the COM port
    tk.Label(root, text="COM Port:").grid(row=0, column=0, padx=5, pady=5, sticky="w")
    port_entry = tk.Entry(root)
    port_entry.grid(row=0, column=1, padx=5, pady=5)

    # Operation options
    operation = tk.StringVar(value="write")
    tk.Radiobutton(root, text="Erase and Write", variable=operation, value="erase_write").grid(row=1, column=0, columnspan=2, padx=5, pady=5)
    tk.Radiobutton(root, text="Write", variable=operation, value="write").grid(row=2, column=0, columnspan=2, padx=5, pady=5)
    tk.Radiobutton(root, text="Erase", variable=operation, value="erase").grid(row=3, column=0, columnspan=2, padx=5, pady=5)

    # Button to start the update operation
    tk.Button(root, text="Start Update", command=start_update).grid(row=4, column=0, columnspan=2, padx=5, pady=5)

    # Status label
    status_label = tk.Label(root, text="")
    status_label.grid(row=5, column=0, columnspan=2, padx=5, pady=5)
    """
    # Button to list files
    tk.Button(root, text="List Files", command=select_port).grid(row=6, column=0, columnspan=2, padx=5, pady=5)
    s
    # Listbox to display files
    files_list = tk.Listbox(root, width=50)
    files_list.grid(row=7, column=0, columnspan=2, padx=5, pady=5)
    """
    # Run the Tkinter main loop
    root.mainloop()
