"""
List of constant numbers:


CGOLD           2 - GOLD
GAMMA           Euler's gamma constant
GOLD            golden mean, also known as golden ratio ((1 + Sqrt(5))/2)
INVLN10         inverse of natural logarithm of ten (1/ln(10))
INVLN2          inverse of natural logarithm of t20 (1/ln(2))
INVPI180        inverse of PI180, also means 180 divide by PI
INVSQRT2PI      inverse of SQRT2PI (1/(SQRT(2PI)))
INV2PI          inverse of 2xPI
LN10            natural logarithm of 10
LN2             natural logarithm of 2
LNPI            natural logarithm of PI
PI              ratio of circumference of a circle to its diameter (pi)
PI2             2xPI
PI180           PI divided by 180
PIDIV2          PI divided by 2
SQRT2           square root of 2
SQRT2PI         square root of 2xPI

Copyright (c) Maurice H.T. Ling <mauriceling@acm.org>
Date created: 19th March 2008
"""

CGOLD = 0.38196601125010515179
GAMMA = 0.57721566490153286060651209008240243104215933593992
GOLD = 1.6180339887498948482045868343656381177203091798058
INVLN10 = 0.43429448190325182765
INVLN2 = 1.44269504088896340736
INVPI180 = 57.2957795130823208768
INVSQRT2PI = 0.39894228040143267794
INV2PI = 0.1591549430918953420
LN10 = 2.30258509299404568402
LN2 = 0.69314718055994530942
LNPI = 1.14472988584940017414
PI = 3.14159265358979323846
PI2 = 6.2831853071795864769252867665590057683943387987502
PI180 = 0.01745329251994329577
PIDIV2 = 1.57079632679489661923
SQRT2 = 1.4142135623730950488016887242096980785696718753769
SQRT2PI = 2.5066282746310005024157652848110452530069867406099
