'''OpenGL extension SGIX.ycrcb

This module customises the behaviour of the 
OpenGL.raw.GL.SGIX.ycrcb to provide a more 
Python-friendly API

The official definition of this extension is available here:
http://www.opengl.org/registry/specs/SGIX/ycrcb.txt
'''
from OpenGL import platform, constant, arrays
from OpenGL import extensions, wrapper
from OpenGL.GL import glget
import ctypes
from OpenGL.raw.GL import _types
from OpenGL.raw.GL.SGIX.ycrcb import *
from OpenGL.raw.GL.SGIX.ycrcb import _EXTENSION_NAME

def glInitYcrcbSGIX():
    '''Return boolean indicating whether this extension is available'''
    from OpenGL import extensions
    return extensions.hasGLExtension( _EXTENSION_NAME )

### END AUTOGENERATED SECTION
from OpenGL import images as _i
_i.COMPONENT_COUNTS[ GL_YCRCB_422_SGIX ] = 1 # must be GL_UNSIGNED_BYTE
_i.COMPONENT_COUNTS[ GL_YCRCB_444_SGIX ] = 1 # must be GL_UNSIGNED_SHORT
