'''OpenGL extension SGIX.texture_scale_bias

This module customises the behaviour of the 
OpenGL.raw.GL.SGIX.texture_scale_bias to provide a more 
Python-friendly API

The official definition of this extension is available here:
http://www.opengl.org/registry/specs/SGIX/texture_scale_bias.txt
'''
from OpenGL import platform, constant, arrays
from OpenGL import extensions, wrapper
from OpenGL.GL import glget
import ctypes
from OpenGL.raw.GL import _types
from OpenGL.raw.GL.SGIX.texture_scale_bias import *
from OpenGL.raw.GL.SGIX.texture_scale_bias import _EXTENSION_NAME

def glInitTextureScaleBiasSGIX():
    '''Return boolean indicating whether this extension is available'''
    from OpenGL import extensions
    return extensions.hasGLExtension( _EXTENSION_NAME )

### END AUTOGENERATED SECTION