'''OpenGL extension MESA.pack_invert

This module customises the behaviour of the 
OpenGL.raw.GL.MESA.pack_invert to provide a more 
Python-friendly API

The official definition of this extension is available here:
http://www.opengl.org/registry/specs/MESA/pack_invert.txt
'''
from OpenGL import platform, constant, arrays
from OpenGL import extensions, wrapper
from OpenGL.GL import glget
import ctypes
from OpenGL.raw.GL import _types
from OpenGL.raw.GL.MESA.pack_invert import *
from OpenGL.raw.GL.MESA.pack_invert import _EXTENSION_NAME

def glInitPackInvertMESA():
    '''Return boolean indicating whether this extension is available'''
    from OpenGL import extensions
    return extensions.hasGLExtension( _EXTENSION_NAME )

### END AUTOGENERATED SECTION