'''OpenGL extension ARB.texture_compression

This module customises the behaviour of the 
OpenGL.raw.GL.ARB.texture_compression to provide a more 
Python-friendly API

The official definition of this extension is available here:
http://www.opengl.org/registry/specs/ARB/texture_compression.txt
'''
from OpenGL import platform, constant, arrays
from OpenGL import extensions, wrapper
from OpenGL.GL import glget
import ctypes
from OpenGL.raw.GL import _types
from OpenGL.raw.GL.ARB.texture_compression import *
from OpenGL.raw.GL.ARB.texture_compression import _EXTENSION_NAME

def glInitTextureCompressionARB():
    '''Return boolean indicating whether this extension is available'''
    from OpenGL import extensions
    return extensions.hasGLExtension( _EXTENSION_NAME )

### END AUTOGENERATED SECTION
from OpenGL.GL import images

for dimensions in (1,2,3):
    for function in ('glCompressedTexImage%sDARB','glCompressedTexSubImage%sDARB'):
        name = function%(dimensions,)
        globals()[ name ] = images.compressedImageFunction(
            globals()[ name ]
        )
        try:
            del name, function
        except NameError as err:
            pass
    try:
        del dimensions
    except NameError as err:
        pass

if glGetCompressedTexImageARB:
    def glGetCompressedTexImageARB( target, level, img=None ):
        """Retrieve a compressed texture image"""
        if img is None:
            length = glget.glGetTexLevelParameteriv(
                target, 0,
                GL_TEXTURE_COMPRESSED_IMAGE_SIZE_ARB,
            )
            img = arrays.ArrayDataType.zeros( (length,), GL_1_0.GL_UNSIGNED_BYTE )
        return glGetCompressedTexImageARB(target, 0, img);
