'''OpenGL extension ARB.framebuffer_object

This module customises the behaviour of the 
OpenGL.raw.GL.ARB.framebuffer_object to provide a more 
Python-friendly API

The official definition of this extension is available here:
http://www.opengl.org/registry/specs/ARB/framebuffer_object.txt
'''
from OpenGL import platform, constant, arrays
from OpenGL import extensions, wrapper
from OpenGL.GL import glget
import ctypes
from OpenGL.raw.GL import _types
from OpenGL.raw.GL.ARB.framebuffer_object import *
from OpenGL.raw.GL.ARB.framebuffer_object import _EXTENSION_NAME

def glInitFramebufferObjectARB():
    '''Return boolean indicating whether this extension is available'''
    from OpenGL import extensions
    return extensions.hasGLExtension( _EXTENSION_NAME )

### END AUTOGENERATED SECTION
from OpenGL.lazywrapper import lazy as _lazy 

glGenFramebuffers = wrapper.wrapper(glGenFramebuffers).setOutput(
                'framebuffers', 
                lambda x: (x,), 
                'n')
                
glGenRenderbuffers = wrapper.wrapper(glGenRenderbuffers).setOutput(
                'renderbuffers', 
                lambda x: (x,), 
                'n')


@_lazy( glDeleteFramebuffers )
def glDeleteFramebuffers( baseOperation, n, framebuffers=None ):
    """glDeleteFramebuffers( framebuffers ) -> None 
    """
    if framebuffers is None:
        framebuffers = arrays.GLuintArray.asArray( n )
        n = arrays.GLuintArray.arraySize( framebuffers )
    return baseOperation( n, framebuffers )

# Setup the GL_UNSIGNED_INT_24_8 image type
from OpenGL import images
from OpenGL.raw.GL.VERSION.GL_1_1 import GL_UNSIGNED_INT
images.TYPE_TO_ARRAYTYPE[ GL_UNSIGNED_INT_24_8 ] = GL_UNSIGNED_INT
images.TIGHT_PACK_FORMATS[ GL_UNSIGNED_INT_24_8 ] = 4

# The extensions actually use the _EXT forms, which is a bit confusing 
# for users, IMO.
GL_FRAMEBUFFER_INCOMPLETE_DIMENSIONS = constant.Constant( 'GL_FRAMEBUFFER_INCOMPLETE_DIMENSIONS', 0x8CD9 )
GL_FRAMEBUFFER_INCOMPLETE_FORMATS = constant.Constant( 'GL_FRAMEBUFFER_INCOMPLETE_FORMATS', 0x8CDA )
GL_FRAMEBUFFER_UNSUPPORTED = constant.Constant( 'GL_FRAMEBUFFER_UNSUPPORTED', 0x8CDD )
del images 
del GL_UNSIGNED_INT
