'''OpenGL extension ARB.compute_variable_group_size

This module customises the behaviour of the 
OpenGL.raw.GL.ARB.compute_variable_group_size to provide a more 
Python-friendly API

The official definition of this extension is available here:
http://www.opengl.org/registry/specs/ARB/compute_variable_group_size.txt
'''
from OpenGL import platform, constant, arrays
from OpenGL import extensions, wrapper
from OpenGL.GL import glget
import ctypes
from OpenGL.raw.GL import _types
from OpenGL.raw.GL.ARB.compute_variable_group_size import *
from OpenGL.raw.GL.ARB.compute_variable_group_size import _EXTENSION_NAME

def glInitComputeVariableGroupSizeARB():
    '''Return boolean indicating whether this extension is available'''
    from OpenGL import extensions
    return extensions.hasGLExtension( _EXTENSION_NAME )

### END AUTOGENERATED SECTION