'''OpenGL extension EXT.platform_x11

This module customises the behaviour of the 
OpenGL.raw.EGL.EXT.platform_x11 to provide a more 
Python-friendly API

The official definition of this extension is available here:
http://www.opengl.org/registry/specs/EXT/platform_x11.txt
'''
from OpenGL import platform, constant, arrays
from OpenGL import extensions, wrapper
from OpenGL.GL import glget
import ctypes
from OpenGL.raw.EGL import _types
from OpenGL.raw.EGL.EXT.platform_x11 import *
from OpenGL.raw.EGL.EXT.platform_x11 import _EXTENSION_NAME

def glInitPlatformX11EXT():
    '''Return boolean indicating whether this extension is available'''
    from OpenGL import extensions
    return extensions.hasGLExtension( _EXTENSION_NAME )

### END AUTOGENERATED SECTION