# -*- coding: utf-8 -*-
"""
Time zone functions. Part of the pygeoip package.

@author: Jennifer Ennis <zaylea@gmail.com>

@license: Copyright(C) 2004 MaxMind LLC

This program is free software: you can redistribute it and/or modify
it under the terms of the GNU Lesser General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU Lesser General Public License
along with this program.  If not, see <http://www.gnu.org/licenses/lgpl.txt>.
"""

__all__ = ['time_zone_by_country_and_region']

_country = {}
_country["AD"] = "Europe/Andorra"
_country["AE"] = "Asia/Dubai"
_country["AF"] = "Asia/Kabul"
_country["AG"] = "America/Antigua"
_country["AI"] = "America/Anguilla"
_country["AL"] = "Europe/Tirane"
_country["AM"] = "Asia/Yerevan"
_country["AO"] = "Africa/Luanda"
_country["AR"] = {}
_country["AR"]["01"] = "America/Argentina/Buenos_Aires"
_country["AR"]["02"] = "America/Argentina/Catamarca"
_country["AR"]["03"] = "America/Argentina/Tucuman"
_country["AR"]["04"] = "America/Argentina/Rio_Gallegos"
_country["AR"]["05"] = "America/Argentina/Cordoba"
_country["AR"]["06"] = "America/Argentina/Tucuman"
_country["AR"]["07"] = "America/Argentina/Buenos_Aires"
_country["AR"]["08"] = "America/Argentina/Buenos_Aires"
_country["AR"]["09"] = "America/Argentina/Tucuman"
_country["AR"]["10"] = "America/Argentina/Jujuy"
_country["AR"]["11"] = "America/Argentina/San_Luis"
_country["AR"]["12"] = "America/Argentina/La_Rioja"
_country["AR"]["13"] = "America/Argentina/Mendoza"
_country["AR"]["14"] = "America/Argentina/Buenos_Aires"
_country["AR"]["15"] = "America/Argentina/San_Luis"
_country["AR"]["16"] = "America/Argentina/Buenos_Aires"
_country["AR"]["17"] = "America/Argentina/Salta"
_country["AR"]["18"] = "America/Argentina/San_Juan"
_country["AR"]["19"] = "America/Argentina/San_Luis"
_country["AR"]["20"] = "America/Argentina/Rio_Gallegos"
_country["AR"]["21"] = "America/Argentina/Buenos_Aires"
_country["AR"]["22"] = "America/Argentina/Catamarca"
_country["AR"]["23"] = "America/Argentina/Ushuaia"
_country["AR"]["24"] = "America/Argentina/Tucuman"
_country["AS"] = "US/Samoa"
_country["AT"] = "Europe/Vienna"
_country["AU"] = {}
_country["AU"]["01"] = "Australia/Canberra"
_country["AU"]["02"] = "Australia/NSW"
_country["AU"]["03"] = "Australia/North"
_country["AU"]["04"] = "Australia/Queensland"
_country["AU"]["05"] = "Australia/South"
_country["AU"]["06"] = "Australia/Tasmania"
_country["AU"]["07"] = "Australia/Victoria"
_country["AU"]["08"] = "Australia/West"
_country["AW"] = "America/Aruba"
_country["AX"] = "Europe/Mariehamn"
_country["AZ"] = "Asia/Baku"
_country["BA"] = "Europe/Sarajevo"
_country["BB"] = "America/Barbados"
_country["BD"] = "Asia/Dhaka"
_country["BE"] = "Europe/Brussels"
_country["BF"] = "Africa/Ouagadougou"
_country["BG"] = "Europe/Sofia"
_country["BH"] = "Asia/Bahrain"
_country["BI"] = "Africa/Bujumbura"
_country["BJ"] = "Africa/Porto-Novo"
_country["BL"] = "America/St_Barthelemy"
_country["BM"] = "Atlantic/Bermuda"
_country["BN"] = "Asia/Brunei"
_country["BO"] = "America/La_Paz"
_country["BQ"] = "America/Curacao"
_country["BR"] = {}
_country["BR"]["01"] = "America/Rio_Branco"
_country["BR"]["02"] = "America/Maceio"
_country["BR"]["03"] = "America/Sao_Paulo"
_country["BR"]["04"] = "America/Manaus"
_country["BR"]["05"] = "America/Bahia"
_country["BR"]["06"] = "America/Fortaleza"
_country["BR"]["07"] = "America/Sao_Paulo"
_country["BR"]["08"] = "America/Sao_Paulo"
_country["BR"]["11"] = "America/Campo_Grande"
_country["BR"]["13"] = "America/Belem"
_country["BR"]["14"] = "America/Cuiaba"
_country["BR"]["15"] = "America/Sao_Paulo"
_country["BR"]["16"] = "America/Belem"
_country["BR"]["17"] = "America/Recife"
_country["BR"]["18"] = "America/Sao_Paulo"
_country["BR"]["20"] = "America/Fortaleza"
_country["BR"]["21"] = "America/Sao_Paulo"
_country["BR"]["22"] = "America/Recife"
_country["BR"]["23"] = "America/Sao_Paulo"
_country["BR"]["24"] = "America/Porto_Velho"
_country["BR"]["25"] = "America/Boa_Vista"
_country["BR"]["26"] = "America/Sao_Paulo"
_country["BR"]["27"] = "America/Sao_Paulo"
_country["BR"]["28"] = "America/Maceio"
_country["BR"]["29"] = "America/Sao_Paulo"
_country["BR"]["30"] = "America/Recife"
_country["BR"]["31"] = "America/Araguaina"
_country["BS"] = "America/Nassau"
_country["BT"] = "Asia/Thimphu"
_country["BW"] = "Africa/Gaborone"
_country["BY"] = "Europe/Minsk"
_country["BZ"] = "America/Belize"
_country["CA"] = {}
_country["CA"]["AB"] = "America/Edmonton"
_country["CA"]["BC"] = "America/Vancouver"
_country["CA"]["MB"] = "America/Winnipeg"
_country["CA"]["NB"] = "America/Halifax"
_country["CA"]["NL"] = "America/St_Johns"
_country["CA"]["NS"] = "America/Halifax"
_country["CA"]["NT"] = "America/Yellowknife"
_country["CA"]["NU"] = "America/Rankin_Inlet"
_country["CA"]["ON"] = "America/Rainy_River"
_country["CA"]["PE"] = "America/Halifax"
_country["CA"]["QC"] = "America/Montreal"
_country["CA"]["SK"] = "America/Regina"
_country["CA"]["YT"] = "America/Whitehorse"
_country["CC"] = "Indian/Cocos"
_country["CD"] = {}
_country["CD"]["02"] = "Africa/Kinshasa"
_country["CD"]["05"] = "Africa/Lubumbashi"
_country["CD"]["06"] = "Africa/Kinshasa"
_country["CD"]["08"] = "Africa/Kinshasa"
_country["CD"]["10"] = "Africa/Lubumbashi"
_country["CD"]["11"] = "Africa/Lubumbashi"
_country["CD"]["12"] = "Africa/Lubumbashi"
_country["CF"] = "Africa/Bangui"
_country["CG"] = "Africa/Brazzaville"
_country["CH"] = "Europe/Zurich"
_country["CI"] = "Africa/Abidjan"
_country["CK"] = "Pacific/Rarotonga"
_country["CL"] = "Chile/Continental"
_country["CM"] = "Africa/Lagos"
_country["CN"] = {}
_country["CN"]["01"] = "Asia/Shanghai"
_country["CN"]["02"] = "Asia/Shanghai"
_country["CN"]["03"] = "Asia/Shanghai"
_country["CN"]["04"] = "Asia/Shanghai"
_country["CN"]["05"] = "Asia/Harbin"
_country["CN"]["06"] = "Asia/Chongqing"
_country["CN"]["07"] = "Asia/Shanghai"
_country["CN"]["08"] = "Asia/Harbin"
_country["CN"]["09"] = "Asia/Shanghai"
_country["CN"]["10"] = "Asia/Shanghai"
_country["CN"]["11"] = "Asia/Chongqing"
_country["CN"]["12"] = "Asia/Shanghai"
_country["CN"]["13"] = "Asia/Urumqi"
_country["CN"]["14"] = "Asia/Chongqing"
_country["CN"]["15"] = "Asia/Chongqing"
_country["CN"]["16"] = "Asia/Chongqing"
_country["CN"]["18"] = "Asia/Chongqing"
_country["CN"]["19"] = "Asia/Harbin"
_country["CN"]["20"] = "Asia/Harbin"
_country["CN"]["21"] = "Asia/Chongqing"
_country["CN"]["22"] = "Asia/Harbin"
_country["CN"]["23"] = "Asia/Shanghai"
_country["CN"]["24"] = "Asia/Chongqing"
_country["CN"]["25"] = "Asia/Shanghai"
_country["CN"]["26"] = "Asia/Chongqing"
_country["CN"]["28"] = "Asia/Shanghai"
_country["CN"]["29"] = "Asia/Chongqing"
_country["CN"]["30"] = "Asia/Chongqing"
_country["CN"]["31"] = "Asia/Chongqing"
_country["CN"]["32"] = "Asia/Chongqing"
_country["CN"]["33"] = "Asia/Chongqing"
_country["CO"] = "America/Bogota"
_country["CR"] = "America/Costa_Rica"
_country["CU"] = "America/Havana"
_country["CV"] = "Atlantic/Cape_Verde"
_country["CW"] = "America/Curacao"
_country["CX"] = "Indian/Christmas"
_country["CY"] = "Asia/Nicosia"
_country["CZ"] = "Europe/Prague"
_country["DE"] = "Europe/Berlin"
_country["DJ"] = "Africa/Djibouti"
_country["DK"] = "Europe/Copenhagen"
_country["DM"] = "America/Dominica"
_country["DO"] = "America/Santo_Domingo"
_country["DZ"] = "Africa/Algiers"
_country["EC"] = {}
_country["EC"]["01"] = "Pacific/Galapagos"
_country["EC"]["02"] = "America/Guayaquil"
_country["EC"]["03"] = "America/Guayaquil"
_country["EC"]["04"] = "America/Guayaquil"
_country["EC"]["05"] = "America/Guayaquil"
_country["EC"]["06"] = "America/Guayaquil"
_country["EC"]["07"] = "America/Guayaquil"
_country["EC"]["08"] = "America/Guayaquil"
_country["EC"]["09"] = "America/Guayaquil"
_country["EC"]["10"] = "America/Guayaquil"
_country["EC"]["11"] = "America/Guayaquil"
_country["EC"]["12"] = "America/Guayaquil"
_country["EC"]["13"] = "America/Guayaquil"
_country["EC"]["14"] = "America/Guayaquil"
_country["EC"]["15"] = "America/Guayaquil"
_country["EC"]["17"] = "America/Guayaquil"
_country["EC"]["18"] = "America/Guayaquil"
_country["EC"]["19"] = "America/Guayaquil"
_country["EC"]["20"] = "America/Guayaquil"
_country["EC"]["22"] = "America/Guayaquil"
_country["EE"] = "Europe/Tallinn"
_country["EG"] = "Africa/Cairo"
_country["EH"] = "Africa/El_Aaiun"
_country["ER"] = "Africa/Asmera"
_country["ES"] = {}
_country["ES"]["07"] = "Europe/Madrid"
_country["ES"]["27"] = "Europe/Madrid"
_country["ES"]["29"] = "Europe/Madrid"
_country["ES"]["31"] = "Europe/Madrid"
_country["ES"]["32"] = "Europe/Madrid"
_country["ES"]["34"] = "Europe/Madrid"
_country["ES"]["39"] = "Europe/Madrid"
_country["ES"]["51"] = "Africa/Ceuta"
_country["ES"]["52"] = "Europe/Madrid"
_country["ES"]["53"] = "Atlantic/Canary"
_country["ES"]["54"] = "Europe/Madrid"
_country["ES"]["55"] = "Europe/Madrid"
_country["ES"]["56"] = "Europe/Madrid"
_country["ES"]["57"] = "Europe/Madrid"
_country["ES"]["58"] = "Europe/Madrid"
_country["ES"]["59"] = "Europe/Madrid"
_country["ES"]["60"] = "Europe/Madrid"
_country["ET"] = "Africa/Addis_Ababa"
_country["FI"] = "Europe/Helsinki"
_country["FJ"] = "Pacific/Fiji"
_country["FK"] = "Atlantic/Stanley"
_country["FO"] = "Atlantic/Faeroe"
_country["FR"] = "Europe/Paris"
_country["GA"] = "Africa/Libreville"
_country["GB"] = "Europe/London"
_country["GD"] = "America/Grenada"
_country["GE"] = "Asia/Tbilisi"
_country["GF"] = "America/Cayenne"
_country["GG"] = "Europe/Guernsey"
_country["GH"] = "Africa/Accra"
_country["GI"] = "Europe/Gibraltar"
_country["GL"] = {}
_country["GL"]["01"] = "America/Thule"
_country["GL"]["02"] = "America/Godthab"
_country["GL"]["03"] = "America/Godthab"
_country["GM"] = "Africa/Banjul"
_country["GN"] = "Africa/Conakry"
_country["GP"] = "America/Guadeloupe"
_country["GQ"] = "Africa/Malabo"
_country["GR"] = "Europe/Athens"
_country["GS"] = "Atlantic/South_Georgia"
_country["GT"] = "America/Guatemala"
_country["GU"] = "Pacific/Guam"
_country["GW"] = "Africa/Bissau"
_country["GY"] = "America/Guyana"
_country["HK"] = "Asia/Hong_Kong"
_country["HN"] = "America/Tegucigalpa"
_country["HR"] = "Europe/Zagreb"
_country["HT"] = "America/Port-au-Prince"
_country["HU"] = "Europe/Budapest"
_country["ID"] = {}
_country["ID"]["01"] = "Asia/Pontianak"
_country["ID"]["02"] = "Asia/Makassar"
_country["ID"]["03"] = "Asia/Jakarta"
_country["ID"]["04"] = "Asia/Jakarta"
_country["ID"]["05"] = "Asia/Jakarta"
_country["ID"]["06"] = "Asia/Jakarta"
_country["ID"]["07"] = "Asia/Jakarta"
_country["ID"]["08"] = "Asia/Jakarta"
_country["ID"]["09"] = "Asia/Jayapura"
_country["ID"]["10"] = "Asia/Jakarta"
_country["ID"]["11"] = "Asia/Pontianak"
_country["ID"]["12"] = "Asia/Makassar"
_country["ID"]["13"] = "Asia/Makassar"
_country["ID"]["14"] = "Asia/Makassar"
_country["ID"]["15"] = "Asia/Jakarta"
_country["ID"]["16"] = "Asia/Makassar"
_country["ID"]["17"] = "Asia/Makassar"
_country["ID"]["18"] = "Asia/Makassar"
_country["ID"]["19"] = "Asia/Pontianak"
_country["ID"]["20"] = "Asia/Makassar"
_country["ID"]["21"] = "Asia/Makassar"
_country["ID"]["22"] = "Asia/Makassar"
_country["ID"]["23"] = "Asia/Makassar"
_country["ID"]["24"] = "Asia/Jakarta"
_country["ID"]["25"] = "Asia/Pontianak"
_country["ID"]["26"] = "Asia/Pontianak"
_country["ID"]["30"] = "Asia/Jakarta"
_country["ID"]["31"] = "Asia/Makassar"
_country["ID"]["33"] = "Asia/Jakarta"
_country["IE"] = "Europe/Dublin"
_country["IL"] = "Asia/Jerusalem"
_country["IM"] = "Europe/Isle_of_Man"
_country["IN"] = "Asia/Calcutta"
_country["IO"] = "Indian/Chagos"
_country["IQ"] = "Asia/Baghdad"
_country["IR"] = "Asia/Tehran"
_country["IS"] = "Atlantic/Reykjavik"
_country["IT"] = "Europe/Rome"
_country["JE"] = "Europe/Jersey"
_country["JM"] = "America/Jamaica"
_country["JO"] = "Asia/Amman"
_country["JP"] = "Asia/Tokyo"
_country["KE"] = "Africa/Nairobi"
_country["KG"] = "Asia/Bishkek"
_country["KH"] = "Asia/Phnom_Penh"
_country["KI"] = "Pacific/Tarawa"
_country["KM"] = "Indian/Comoro"
_country["KN"] = "America/St_Kitts"
_country["KP"] = "Asia/Pyongyang"
_country["KR"] = "Asia/Seoul"
_country["KW"] = "Asia/Kuwait"
_country["KY"] = "America/Cayman"
_country["KZ"] = {}
_country["KZ"]["01"] = "Asia/Almaty"
_country["KZ"]["02"] = "Asia/Almaty"
_country["KZ"]["03"] = "Asia/Qyzylorda"
_country["KZ"]["04"] = "Asia/Aqtobe"
_country["KZ"]["05"] = "Asia/Qyzylorda"
_country["KZ"]["06"] = "Asia/Aqtau"
_country["KZ"]["07"] = "Asia/Oral"
_country["KZ"]["08"] = "Asia/Qyzylorda"
_country["KZ"]["09"] = "Asia/Aqtau"
_country["KZ"]["10"] = "Asia/Qyzylorda"
_country["KZ"]["11"] = "Asia/Almaty"
_country["KZ"]["12"] = "Asia/Qyzylorda"
_country["KZ"]["13"] = "Asia/Aqtobe"
_country["KZ"]["14"] = "Asia/Qyzylorda"
_country["KZ"]["15"] = "Asia/Almaty"
_country["KZ"]["16"] = "Asia/Aqtobe"
_country["KZ"]["17"] = "Asia/Almaty"
_country["LA"] = "Asia/Vientiane"
_country["LB"] = "Asia/Beirut"
_country["LC"] = "America/St_Lucia"
_country["LI"] = "Europe/Vaduz"
_country["LK"] = "Asia/Colombo"
_country["LR"] = "Africa/Monrovia"
_country["LS"] = "Africa/Maseru"
_country["LT"] = "Europe/Vilnius"
_country["LU"] = "Europe/Luxembourg"
_country["LV"] = "Europe/Riga"
_country["LY"] = "Africa/Tripoli"
_country["MA"] = "Africa/Casablanca"
_country["MC"] = "Europe/Monaco"
_country["MD"] = "Europe/Chisinau"
_country["ME"] = "Europe/Podgorica"
_country["MF"] = "America/Marigot"
_country["MG"] = "Indian/Antananarivo"
_country["MK"] = "Europe/Skopje"
_country["ML"] = "Africa/Bamako"
_country["MM"] = "Asia/Rangoon"
_country["MN"] = "Asia/Choibalsan"
_country["MO"] = "Asia/Macao"
_country["MP"] = "Pacific/Saipan"
_country["MQ"] = "America/Martinique"
_country["MR"] = "Africa/Nouakchott"
_country["MS"] = "America/Montserrat"
_country["MT"] = "Europe/Malta"
_country["MU"] = "Indian/Mauritius"
_country["MV"] = "Indian/Maldives"
_country["MW"] = "Africa/Blantyre"
_country["MX"] = {}
_country["MX"]["01"] = "America/Mexico_City"
_country["MX"]["02"] = "America/Tijuana"
_country["MX"]["03"] = "America/Hermosillo"
_country["MX"]["04"] = "America/Merida"
_country["MX"]["05"] = "America/Mexico_City"
_country["MX"]["06"] = "America/Chihuahua"
_country["MX"]["07"] = "America/Monterrey"
_country["MX"]["08"] = "America/Mexico_City"
_country["MX"]["09"] = "America/Mexico_City"
_country["MX"]["10"] = "America/Mazatlan"
_country["MX"]["11"] = "America/Mexico_City"
_country["MX"]["12"] = "America/Mexico_City"
_country["MX"]["13"] = "America/Mexico_City"
_country["MX"]["14"] = "America/Mazatlan"
_country["MX"]["15"] = "America/Chihuahua"
_country["MX"]["16"] = "America/Mexico_City"
_country["MX"]["17"] = "America/Mexico_City"
_country["MX"]["18"] = "America/Mazatlan"
_country["MX"]["19"] = "America/Monterrey"
_country["MX"]["20"] = "America/Mexico_City"
_country["MX"]["21"] = "America/Mexico_City"
_country["MX"]["22"] = "America/Mexico_City"
_country["MX"]["23"] = "America/Cancun"
_country["MX"]["24"] = "America/Mexico_City"
_country["MX"]["25"] = "America/Mazatlan"
_country["MX"]["26"] = "America/Hermosillo"
_country["MX"]["27"] = "America/Merida"
_country["MX"]["28"] = "America/Monterrey"
_country["MX"]["29"] = "America/Mexico_City"
_country["MX"]["30"] = "America/Mexico_City"
_country["MX"]["31"] = "America/Merida"
_country["MX"]["32"] = "America/Monterrey"
_country["MY"] = {}
_country["MY"]["01"] = "Asia/Kuala_Lumpur"
_country["MY"]["02"] = "Asia/Kuala_Lumpur"
_country["MY"]["03"] = "Asia/Kuala_Lumpur"
_country["MY"]["04"] = "Asia/Kuala_Lumpur"
_country["MY"]["05"] = "Asia/Kuala_Lumpur"
_country["MY"]["06"] = "Asia/Kuala_Lumpur"
_country["MY"]["07"] = "Asia/Kuala_Lumpur"
_country["MY"]["08"] = "Asia/Kuala_Lumpur"
_country["MY"]["09"] = "Asia/Kuala_Lumpur"
_country["MY"]["11"] = "Asia/Kuching"
_country["MY"]["12"] = "Asia/Kuala_Lumpur"
_country["MY"]["13"] = "Asia/Kuala_Lumpur"
_country["MY"]["14"] = "Asia/Kuala_Lumpur"
_country["MY"]["15"] = "Asia/Kuching"
_country["MY"]["16"] = "Asia/Kuching"
_country["MZ"] = "Africa/Maputo"
_country["NA"] = "Africa/Windhoek"
_country["NC"] = "Pacific/Noumea"
_country["NE"] = "Africa/Niamey"
_country["NF"] = "Pacific/Norfolk"
_country["NG"] = "Africa/Lagos"
_country["NI"] = "America/Managua"
_country["NL"] = "Europe/Amsterdam"
_country["NO"] = "Europe/Oslo"
_country["NP"] = "Asia/Katmandu"
_country["NR"] = "Pacific/Nauru"
_country["NU"] = "Pacific/Niue"
_country["NZ"] = {}
_country["NZ"]["85"] = "Pacific/Auckland"
_country["NZ"]["E7"] = "Pacific/Auckland"
_country["NZ"]["E8"] = "Pacific/Auckland"
_country["NZ"]["E9"] = "Pacific/Auckland"
_country["NZ"]["F1"] = "Pacific/Auckland"
_country["NZ"]["F2"] = "Pacific/Auckland"
_country["NZ"]["F3"] = "Pacific/Auckland"
_country["NZ"]["F4"] = "Pacific/Auckland"
_country["NZ"]["F5"] = "Pacific/Auckland"
_country["NZ"]["F7"] = "Pacific/Chatham"
_country["NZ"]["F8"] = "Pacific/Auckland"
_country["NZ"]["F9"] = "Pacific/Auckland"
_country["NZ"]["G1"] = "Pacific/Auckland"
_country["NZ"]["G2"] = "Pacific/Auckland"
_country["NZ"]["G3"] = "Pacific/Auckland"
_country["OM"] = "Asia/Muscat"
_country["PA"] = "America/Panama"
_country["PE"] = "America/Lima"
_country["PF"] = "Pacific/Marquesas"
_country["PG"] = "Pacific/Port_Moresby"
_country["PH"] = "Asia/Manila"
_country["PK"] = "Asia/Karachi"
_country["PL"] = "Europe/Warsaw"
_country["PM"] = "America/Miquelon"
_country["PN"] = "Pacific/Pitcairn"
_country["PR"] = "America/Puerto_Rico"
_country["PS"] = "Asia/Gaza"
_country["PT"] = {}
_country["PT"]["02"] = "Europe/Lisbon"
_country["PT"]["03"] = "Europe/Lisbon"
_country["PT"]["04"] = "Europe/Lisbon"
_country["PT"]["05"] = "Europe/Lisbon"
_country["PT"]["06"] = "Europe/Lisbon"
_country["PT"]["07"] = "Europe/Lisbon"
_country["PT"]["08"] = "Europe/Lisbon"
_country["PT"]["09"] = "Europe/Lisbon"
_country["PT"]["10"] = "Atlantic/Madeira"
_country["PT"]["11"] = "Europe/Lisbon"
_country["PT"]["13"] = "Europe/Lisbon"
_country["PT"]["14"] = "Europe/Lisbon"
_country["PT"]["16"] = "Europe/Lisbon"
_country["PT"]["17"] = "Europe/Lisbon"
_country["PT"]["18"] = "Europe/Lisbon"
_country["PT"]["19"] = "Europe/Lisbon"
_country["PT"]["20"] = "Europe/Lisbon"
_country["PT"]["21"] = "Europe/Lisbon"
_country["PT"]["22"] = "Europe/Lisbon"
_country["PW"] = "Pacific/Palau"
_country["PY"] = "America/Asuncion"
_country["QA"] = "Asia/Qatar"
_country["RE"] = "Indian/Reunion"
_country["RO"] = "Europe/Bucharest"
_country["RS"] = "Europe/Belgrade"
_country["RU"] = {}
_country["RU"]["01"] = "Europe/Volgograd"
_country["RU"]["02"] = "Asia/Irkutsk"
_country["RU"]["03"] = "Asia/Novokuznetsk"
_country["RU"]["04"] = "Asia/Novosibirsk"
_country["RU"]["05"] = "Asia/Vladivostok"
_country["RU"]["06"] = "Europe/Moscow"
_country["RU"]["07"] = "Europe/Volgograd"
_country["RU"]["08"] = "Europe/Samara"
_country["RU"]["09"] = "Europe/Moscow"
_country["RU"]["10"] = "Europe/Moscow"
_country["RU"]["11"] = "Asia/Irkutsk"
_country["RU"]["13"] = "Asia/Yekaterinburg"
_country["RU"]["14"] = "Asia/Irkutsk"
_country["RU"]["15"] = "Asia/Anadyr"
_country["RU"]["16"] = "Europe/Samara"
_country["RU"]["17"] = "Europe/Volgograd"
_country["RU"]["18"] = "Asia/Krasnoyarsk"
_country["RU"]["20"] = "Asia/Irkutsk"
_country["RU"]["21"] = "Europe/Moscow"
_country["RU"]["22"] = "Europe/Volgograd"
_country["RU"]["23"] = "Europe/Kaliningrad"
_country["RU"]["24"] = "Europe/Volgograd"
_country["RU"]["25"] = "Europe/Moscow"
_country["RU"]["26"] = "Asia/Kamchatka"
_country["RU"]["27"] = "Europe/Volgograd"
_country["RU"]["28"] = "Europe/Moscow"
_country["RU"]["29"] = "Asia/Novokuznetsk"
_country["RU"]["30"] = "Asia/Vladivostok"
_country["RU"]["31"] = "Asia/Krasnoyarsk"
_country["RU"]["32"] = "Asia/Omsk"
_country["RU"]["33"] = "Asia/Yekaterinburg"
_country["RU"]["34"] = "Asia/Yekaterinburg"
_country["RU"]["35"] = "Asia/Yekaterinburg"
_country["RU"]["36"] = "Asia/Anadyr"
_country["RU"]["37"] = "Europe/Moscow"
_country["RU"]["38"] = "Europe/Volgograd"
_country["RU"]["39"] = "Asia/Krasnoyarsk"
_country["RU"]["40"] = "Asia/Yekaterinburg"
_country["RU"]["41"] = "Europe/Moscow"
_country["RU"]["42"] = "Europe/Moscow"
_country["RU"]["43"] = "Europe/Moscow"
_country["RU"]["44"] = "Asia/Magadan"
_country["RU"]["45"] = "Europe/Samara"
_country["RU"]["46"] = "Europe/Samara"
_country["RU"]["47"] = "Europe/Moscow"
_country["RU"]["48"] = "Europe/Moscow"
_country["RU"]["49"] = "Europe/Moscow"
_country["RU"]["50"] = "Asia/Yekaterinburg"
_country["RU"]["51"] = "Europe/Moscow"
_country["RU"]["52"] = "Europe/Moscow"
_country["RU"]["53"] = "Asia/Novosibirsk"
_country["RU"]["54"] = "Asia/Omsk"
_country["RU"]["55"] = "Europe/Samara"
_country["RU"]["56"] = "Europe/Moscow"
_country["RU"]["57"] = "Europe/Samara"
_country["RU"]["58"] = "Asia/Yekaterinburg"
_country["RU"]["59"] = "Asia/Vladivostok"
_country["RU"]["60"] = "Europe/Kaliningrad"
_country["RU"]["61"] = "Europe/Volgograd"
_country["RU"]["62"] = "Europe/Moscow"
_country["RU"]["63"] = "Asia/Yakutsk"
_country["RU"]["64"] = "Asia/Sakhalin"
_country["RU"]["65"] = "Europe/Samara"
_country["RU"]["66"] = "Europe/Moscow"
_country["RU"]["67"] = "Europe/Samara"
_country["RU"]["68"] = "Europe/Volgograd"
_country["RU"]["69"] = "Europe/Moscow"
_country["RU"]["70"] = "Europe/Volgograd"
_country["RU"]["71"] = "Asia/Yekaterinburg"
_country["RU"]["72"] = "Europe/Moscow"
_country["RU"]["73"] = "Europe/Samara"
_country["RU"]["74"] = "Asia/Krasnoyarsk"
_country["RU"]["75"] = "Asia/Novosibirsk"
_country["RU"]["76"] = "Europe/Moscow"
_country["RU"]["77"] = "Europe/Moscow"
_country["RU"]["78"] = "Asia/Yekaterinburg"
_country["RU"]["79"] = "Asia/Irkutsk"
_country["RU"]["80"] = "Asia/Yekaterinburg"
_country["RU"]["81"] = "Europe/Samara"
_country["RU"]["82"] = "Asia/Irkutsk"
_country["RU"]["83"] = "Europe/Moscow"
_country["RU"]["84"] = "Europe/Volgograd"
_country["RU"]["85"] = "Europe/Moscow"
_country["RU"]["86"] = "Europe/Moscow"
_country["RU"]["87"] = "Asia/Novosibirsk"
_country["RU"]["88"] = "Europe/Moscow"
_country["RU"]["89"] = "Asia/Vladivostok"
_country["RW"] = "Africa/Kigali"
_country["SA"] = "Asia/Riyadh"
_country["SB"] = "Pacific/Guadalcanal"
_country["SC"] = "Indian/Mahe"
_country["SD"] = "Africa/Khartoum"
_country["SE"] = "Europe/Stockholm"
_country["SG"] = "Asia/Singapore"
_country["SH"] = "Atlantic/St_Helena"
_country["SI"] = "Europe/Ljubljana"
_country["SJ"] = "Arctic/Longyearbyen"
_country["SK"] = "Europe/Bratislava"
_country["SL"] = "Africa/Freetown"
_country["SM"] = "Europe/San_Marino"
_country["SN"] = "Africa/Dakar"
_country["SO"] = "Africa/Mogadishu"
_country["SR"] = "America/Paramaribo"
_country["ST"] = "Africa/Sao_Tome"
_country["SV"] = "America/El_Salvador"
_country["SX"] = "America/Curacao"
_country["SY"] = "Asia/Damascus"
_country["SZ"] = "Africa/Mbabane"
_country["TC"] = "America/Grand_Turk"
_country["TD"] = "Africa/Ndjamena"
_country["TF"] = "Indian/Kerguelen"
_country["TG"] = "Africa/Lome"
_country["TH"] = "Asia/Bangkok"
_country["TJ"] = "Asia/Dushanbe"
_country["TK"] = "Pacific/Fakaofo"
_country["TL"] = "Asia/Dili"
_country["TM"] = "Asia/Ashgabat"
_country["TN"] = "Africa/Tunis"
_country["TO"] = "Pacific/Tongatapu"
_country["TR"] = "Asia/Istanbul"
_country["TT"] = "America/Port_of_Spain"
_country["TV"] = "Pacific/Funafuti"
_country["TW"] = "Asia/Taipei"
_country["TZ"] = "Africa/Dar_es_Salaam"
_country["UA"] = {}
_country["UA"]["01"] = "Europe/Kiev"
_country["UA"]["02"] = "Europe/Kiev"
_country["UA"]["03"] = "Europe/Uzhgorod"
_country["UA"]["04"] = "Europe/Zaporozhye"
_country["UA"]["05"] = "Europe/Zaporozhye"
_country["UA"]["06"] = "Europe/Uzhgorod"
_country["UA"]["07"] = "Europe/Zaporozhye"
_country["UA"]["08"] = "Europe/Simferopol"
_country["UA"]["09"] = "Europe/Kiev"
_country["UA"]["10"] = "Europe/Zaporozhye"
_country["UA"]["11"] = "Europe/Simferopol"
_country["UA"]["13"] = "Europe/Kiev"
_country["UA"]["14"] = "Europe/Zaporozhye"
_country["UA"]["15"] = "Europe/Uzhgorod"
_country["UA"]["16"] = "Europe/Zaporozhye"
_country["UA"]["17"] = "Europe/Simferopol"
_country["UA"]["18"] = "Europe/Zaporozhye"
_country["UA"]["19"] = "Europe/Kiev"
_country["UA"]["20"] = "Europe/Simferopol"
_country["UA"]["21"] = "Europe/Kiev"
_country["UA"]["22"] = "Europe/Uzhgorod"
_country["UA"]["23"] = "Europe/Kiev"
_country["UA"]["24"] = "Europe/Uzhgorod"
_country["UA"]["25"] = "Europe/Uzhgorod"
_country["UA"]["26"] = "Europe/Zaporozhye"
_country["UA"]["27"] = "Europe/Kiev"
_country["UG"] = "Africa/Kampala"
_country["US"] = {}
_country["US"]["AK"] = "America/Anchorage"
_country["US"]["AL"] = "America/Chicago"
_country["US"]["AR"] = "America/Chicago"
_country["US"]["AZ"] = "America/Phoenix"
_country["US"]["CA"] = "America/Los_Angeles"
_country["US"]["CO"] = "America/Denver"
_country["US"]["CT"] = "America/New_York"
_country["US"]["DC"] = "America/New_York"
_country["US"]["DE"] = "America/New_York"
_country["US"]["FL"] = "America/New_York"
_country["US"]["GA"] = "America/New_York"
_country["US"]["HI"] = "Pacific/Honolulu"
_country["US"]["IA"] = "America/Chicago"
_country["US"]["ID"] = "America/Denver"
_country["US"]["IL"] = "America/Chicago"
_country["US"]["IN"] = "America/Indianapolis"
_country["US"]["KS"] = "America/Chicago"
_country["US"]["KY"] = "America/New_York"
_country["US"]["LA"] = "America/Chicago"
_country["US"]["MA"] = "America/New_York"
_country["US"]["MD"] = "America/New_York"
_country["US"]["ME"] = "America/New_York"
_country["US"]["MI"] = "America/New_York"
_country["US"]["MN"] = "America/Chicago"
_country["US"]["MO"] = "America/Chicago"
_country["US"]["MS"] = "America/Chicago"
_country["US"]["MT"] = "America/Denver"
_country["US"]["NC"] = "America/New_York"
_country["US"]["ND"] = "America/Chicago"
_country["US"]["NE"] = "America/Chicago"
_country["US"]["NH"] = "America/New_York"
_country["US"]["NJ"] = "America/New_York"
_country["US"]["NM"] = "America/Denver"
_country["US"]["NV"] = "America/Los_Angeles"
_country["US"]["NY"] = "America/New_York"
_country["US"]["OH"] = "America/New_York"
_country["US"]["OK"] = "America/Chicago"
_country["US"]["OR"] = "America/Los_Angeles"
_country["US"]["PA"] = "America/New_York"
_country["US"]["RI"] = "America/New_York"
_country["US"]["SC"] = "America/New_York"
_country["US"]["SD"] = "America/Chicago"
_country["US"]["TN"] = "America/Chicago"
_country["US"]["TX"] = "America/Chicago"
_country["US"]["UT"] = "America/Denver"
_country["US"]["VA"] = "America/New_York"
_country["US"]["VT"] = "America/New_York"
_country["US"]["WA"] = "America/Los_Angeles"
_country["US"]["WI"] = "America/Chicago"
_country["US"]["WV"] = "America/New_York"
_country["US"]["WY"] = "America/Denver"
_country["UY"] = "America/Montevideo"
_country["UZ"] = {}
_country["UZ"]["01"] = "Asia/Tashkent"
_country["UZ"]["02"] = "Asia/Samarkand"
_country["UZ"]["03"] = "Asia/Tashkent"
_country["UZ"]["06"] = "Asia/Tashkent"
_country["UZ"]["07"] = "Asia/Samarkand"
_country["UZ"]["08"] = "Asia/Samarkand"
_country["UZ"]["09"] = "Asia/Samarkand"
_country["UZ"]["10"] = "Asia/Samarkand"
_country["UZ"]["12"] = "Asia/Samarkand"
_country["UZ"]["13"] = "Asia/Tashkent"
_country["UZ"]["14"] = "Asia/Tashkent"
_country["VA"] = "Europe/Vatican"
_country["VC"] = "America/St_Vincent"
_country["VE"] = "America/Caracas"
_country["VG"] = "America/Tortola"
_country["VI"] = "America/St_Thomas"
_country["VN"] = "Asia/Phnom_Penh"
_country["VU"] = "Pacific/Efate"
_country["WF"] = "Pacific/Wallis"
_country["WS"] = "Pacific/Samoa"
_country["YE"] = "Asia/Aden"
_country["YT"] = "Indian/Mayotte"
_country["YU"] = "Europe/Belgrade"
_country["ZA"] = "Africa/Johannesburg"
_country["ZM"] = "Africa/Lusaka"
_country["ZW"] = "Africa/Harare"


def time_zone_by_country_and_region(country_code, region_name=None):
    if country_code not in _country:
        return ''

    if not region_name or region_name == '00':
        region_name = None

    timezones = _country[country_code]
    if isinstance(timezones, str):
        return timezones

    if not region_name:
        return ''

    return timezones.get(region_name)
