# Epic pandas &mdash; Extra treats for the data-oriented
[![Epic-pandas CI](https://github.com/Cybereason/epic-pandas/actions/workflows/ci.yml/badge.svg)](https://github.com/Cybereason/epic-pandas/actions/workflows/ci.yml)

## What is it?
The **epic-pandas** Python library provides various utilities for working with data. Most are built
on top of the *pandas* library, but some only require *numpy*. These are various functions and classes which 
can be useful and helpful in almost any data-oriented project. Some allow for more efficiency and
flexibility in some common tasks, while others are just convenient. Also included is a package full of helpers
and treats for plotting with *matplotlib*.

## Modules
- **algorithm:** Mostly statistical algorithms for working with binary data.
- **create:** Create a (potentially large) DataFrame or Series efficiently from an iterable.
- **matplotlib:** Package with easy plotting functions and other plotting utilities.
- **networkx:** Draw a networkx graph with labels and colors.
- **numpy:** Utilities for working with *numpy*.
- **parallel:** Apply a function over a DataFrame or Series in parallel.
- **sparse:** The `SparseDataFrame` class &mdash; a CSR sparse matrix with an `index` and `columns`.
- **utils:** General utilities, including functions for dumping and loading *pandas* objects, sampling,
displaying, and many more.
