# pylint: disable=too-many-lines
# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------
from typing import Any, AsyncIterable, Callable, Dict, IO, Optional, TypeVar, Union, overload
from urllib.parse import parse_qs, urljoin, urlparse

from azure.core.async_paging import AsyncItemPaged, AsyncList
from azure.core.exceptions import (
    ClientAuthenticationError,
    HttpResponseError,
    ResourceExistsError,
    ResourceNotFoundError,
    ResourceNotModifiedError,
    map_error,
)
from azure.core.pipeline import PipelineResponse
from azure.core.pipeline.transport import AsyncHttpResponse
from azure.core.rest import HttpRequest
from azure.core.tracing.decorator import distributed_trace
from azure.core.tracing.decorator_async import distributed_trace_async
from azure.core.utils import case_insensitive_dict
from azure.mgmt.core.exceptions import ARMErrorFormat

from ... import models as _models
from ..._vendor import _convert_request
from ...operations._resource_guards_operations import (
    build_delete_request,
    build_get_backup_security_pin_requests_objects_request,
    build_get_default_backup_security_pin_requests_object_request,
    build_get_default_delete_protected_item_requests_object_request,
    build_get_default_delete_resource_guard_proxy_requests_object_request,
    build_get_default_disable_soft_delete_requests_object_request,
    build_get_default_update_protected_item_requests_object_request,
    build_get_default_update_protection_policy_requests_object_request,
    build_get_delete_protected_item_requests_objects_request,
    build_get_delete_resource_guard_proxy_requests_objects_request,
    build_get_disable_soft_delete_requests_objects_request,
    build_get_request,
    build_get_resources_in_resource_group_request,
    build_get_resources_in_subscription_request,
    build_get_update_protected_item_requests_objects_request,
    build_get_update_protection_policy_requests_objects_request,
    build_patch_request,
    build_put_request,
)

T = TypeVar("T")
ClsType = Optional[Callable[[PipelineResponse[HttpRequest, AsyncHttpResponse], T, Dict[str, Any]], Any]]


class ResourceGuardsOperations:
    """
    .. warning::
        **DO NOT** instantiate this class directly.

        Instead, you should access the following operations through
        :class:`~azure.mgmt.dataprotection.aio.DataProtectionClient`'s
        :attr:`resource_guards` attribute.
    """

    models = _models

    def __init__(self, *args, **kwargs) -> None:
        input_args = list(args)
        self._client = input_args.pop(0) if input_args else kwargs.pop("client")
        self._config = input_args.pop(0) if input_args else kwargs.pop("config")
        self._serialize = input_args.pop(0) if input_args else kwargs.pop("serializer")
        self._deserialize = input_args.pop(0) if input_args else kwargs.pop("deserializer")

    @distributed_trace
    def get_resources_in_subscription(self, **kwargs: Any) -> AsyncIterable["_models.ResourceGuardResource"]:
        """Returns ResourceGuards collection belonging to a subscription.

        Returns ResourceGuards collection belonging to a subscription.

        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: An iterator like instance of either ResourceGuardResource or the result of
         cls(response)
        :rtype:
         ~azure.core.async_paging.AsyncItemPaged[~azure.mgmt.dataprotection.models.ResourceGuardResource]
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version = kwargs.pop("api_version", _params.pop("api-version", self._config.api_version))  # type: str
        cls = kwargs.pop("cls", None)  # type: ClsType[_models.ResourceGuardResourceList]

        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        def prepare_request(next_link=None):
            if not next_link:

                request = build_get_resources_in_subscription_request(
                    subscription_id=self._config.subscription_id,
                    api_version=api_version,
                    template_url=self.get_resources_in_subscription.metadata["url"],
                    headers=_headers,
                    params=_params,
                )
                request = _convert_request(request)
                request.url = self._client.format_url(request.url)  # type: ignore

            else:
                # make call to next link with the client's api-version
                _parsed_next_link = urlparse(next_link)
                _next_request_params = case_insensitive_dict(parse_qs(_parsed_next_link.query))
                _next_request_params["api-version"] = self._config.api_version
                request = HttpRequest("GET", urljoin(next_link, _parsed_next_link.path), params=_next_request_params)
                request = _convert_request(request)
                request.url = self._client.format_url(request.url)  # type: ignore
                request.method = "GET"
            return request

        async def extract_data(pipeline_response):
            deserialized = self._deserialize("ResourceGuardResourceList", pipeline_response)
            list_of_elem = deserialized.value
            if cls:
                list_of_elem = cls(list_of_elem)
            return deserialized.next_link or None, AsyncList(list_of_elem)

        async def get_next(next_link=None):
            request = prepare_request(next_link)

            pipeline_response = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
                request, stream=False, **kwargs
            )
            response = pipeline_response.http_response

            if response.status_code not in [200]:
                map_error(status_code=response.status_code, response=response, error_map=error_map)
                raise HttpResponseError(response=response, error_format=ARMErrorFormat)

            return pipeline_response

        return AsyncItemPaged(get_next, extract_data)

    get_resources_in_subscription.metadata = {"url": "/subscriptions/{subscriptionId}/providers/Microsoft.DataProtection/resourceGuards"}  # type: ignore

    @distributed_trace
    def get_resources_in_resource_group(
        self, resource_group_name: str, **kwargs: Any
    ) -> AsyncIterable["_models.ResourceGuardResource"]:
        """Returns ResourceGuards collection belonging to a ResourceGroup.

        Returns ResourceGuards collection belonging to a ResourceGroup.

        :param resource_group_name: The name of the resource group where the backup vault is present.
         Required.
        :type resource_group_name: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: An iterator like instance of either ResourceGuardResource or the result of
         cls(response)
        :rtype:
         ~azure.core.async_paging.AsyncItemPaged[~azure.mgmt.dataprotection.models.ResourceGuardResource]
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version = kwargs.pop("api_version", _params.pop("api-version", self._config.api_version))  # type: str
        cls = kwargs.pop("cls", None)  # type: ClsType[_models.ResourceGuardResourceList]

        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        def prepare_request(next_link=None):
            if not next_link:

                request = build_get_resources_in_resource_group_request(
                    resource_group_name=resource_group_name,
                    subscription_id=self._config.subscription_id,
                    api_version=api_version,
                    template_url=self.get_resources_in_resource_group.metadata["url"],
                    headers=_headers,
                    params=_params,
                )
                request = _convert_request(request)
                request.url = self._client.format_url(request.url)  # type: ignore

            else:
                # make call to next link with the client's api-version
                _parsed_next_link = urlparse(next_link)
                _next_request_params = case_insensitive_dict(parse_qs(_parsed_next_link.query))
                _next_request_params["api-version"] = self._config.api_version
                request = HttpRequest("GET", urljoin(next_link, _parsed_next_link.path), params=_next_request_params)
                request = _convert_request(request)
                request.url = self._client.format_url(request.url)  # type: ignore
                request.method = "GET"
            return request

        async def extract_data(pipeline_response):
            deserialized = self._deserialize("ResourceGuardResourceList", pipeline_response)
            list_of_elem = deserialized.value
            if cls:
                list_of_elem = cls(list_of_elem)
            return deserialized.next_link or None, AsyncList(list_of_elem)

        async def get_next(next_link=None):
            request = prepare_request(next_link)

            pipeline_response = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
                request, stream=False, **kwargs
            )
            response = pipeline_response.http_response

            if response.status_code not in [200]:
                map_error(status_code=response.status_code, response=response, error_map=error_map)
                raise HttpResponseError(response=response, error_format=ARMErrorFormat)

            return pipeline_response

        return AsyncItemPaged(get_next, extract_data)

    get_resources_in_resource_group.metadata = {"url": "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DataProtection/resourceGuards"}  # type: ignore

    @overload
    async def put(
        self,
        resource_group_name: str,
        resource_guards_name: str,
        parameters: _models.ResourceGuardResource,
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> _models.ResourceGuardResource:
        """Creates or updates a ResourceGuard resource belonging to a resource group.

        Creates or updates a ResourceGuard resource belonging to a resource group.

        :param resource_group_name: The name of the resource group where the backup vault is present.
         Required.
        :type resource_group_name: str
        :param resource_guards_name: The name of ResourceGuard. Required.
        :type resource_guards_name: str
        :param parameters: Request body for operation. Required.
        :type parameters: ~azure.mgmt.dataprotection.models.ResourceGuardResource
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: ResourceGuardResource or the result of cls(response)
        :rtype: ~azure.mgmt.dataprotection.models.ResourceGuardResource
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @overload
    async def put(
        self,
        resource_group_name: str,
        resource_guards_name: str,
        parameters: IO,
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> _models.ResourceGuardResource:
        """Creates or updates a ResourceGuard resource belonging to a resource group.

        Creates or updates a ResourceGuard resource belonging to a resource group.

        :param resource_group_name: The name of the resource group where the backup vault is present.
         Required.
        :type resource_group_name: str
        :param resource_guards_name: The name of ResourceGuard. Required.
        :type resource_guards_name: str
        :param parameters: Request body for operation. Required.
        :type parameters: IO
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Default value is "application/json".
        :paramtype content_type: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: ResourceGuardResource or the result of cls(response)
        :rtype: ~azure.mgmt.dataprotection.models.ResourceGuardResource
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @distributed_trace_async
    async def put(
        self,
        resource_group_name: str,
        resource_guards_name: str,
        parameters: Union[_models.ResourceGuardResource, IO],
        **kwargs: Any
    ) -> _models.ResourceGuardResource:
        """Creates or updates a ResourceGuard resource belonging to a resource group.

        Creates or updates a ResourceGuard resource belonging to a resource group.

        :param resource_group_name: The name of the resource group where the backup vault is present.
         Required.
        :type resource_group_name: str
        :param resource_guards_name: The name of ResourceGuard. Required.
        :type resource_guards_name: str
        :param parameters: Request body for operation. Is either a model type or a IO type. Required.
        :type parameters: ~azure.mgmt.dataprotection.models.ResourceGuardResource or IO
        :keyword content_type: Body Parameter content-type. Known values are: 'application/json'.
         Default value is None.
        :paramtype content_type: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: ResourceGuardResource or the result of cls(response)
        :rtype: ~azure.mgmt.dataprotection.models.ResourceGuardResource
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version = kwargs.pop("api_version", _params.pop("api-version", self._config.api_version))  # type: str
        content_type = kwargs.pop("content_type", _headers.pop("Content-Type", None))  # type: Optional[str]
        cls = kwargs.pop("cls", None)  # type: ClsType[_models.ResourceGuardResource]

        content_type = content_type or "application/json"
        _json = None
        _content = None
        if isinstance(parameters, (IO, bytes)):
            _content = parameters
        else:
            _json = self._serialize.body(parameters, "ResourceGuardResource")

        request = build_put_request(
            resource_group_name=resource_group_name,
            resource_guards_name=resource_guards_name,
            subscription_id=self._config.subscription_id,
            api_version=api_version,
            content_type=content_type,
            json=_json,
            content=_content,
            template_url=self.put.metadata["url"],
            headers=_headers,
            params=_params,
        )
        request = _convert_request(request)
        request.url = self._client.format_url(request.url)  # type: ignore

        pipeline_response = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            request, stream=False, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response, error_format=ARMErrorFormat)

        deserialized = self._deserialize("ResourceGuardResource", pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    put.metadata = {"url": "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DataProtection/resourceGuards/{resourceGuardsName}"}  # type: ignore

    @distributed_trace_async
    async def get(
        self, resource_group_name: str, resource_guards_name: str, **kwargs: Any
    ) -> _models.ResourceGuardResource:
        """Returns a ResourceGuard belonging to a resource group.

        Returns a ResourceGuard belonging to a resource group.

        :param resource_group_name: The name of the resource group where the backup vault is present.
         Required.
        :type resource_group_name: str
        :param resource_guards_name: The name of ResourceGuard. Required.
        :type resource_guards_name: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: ResourceGuardResource or the result of cls(response)
        :rtype: ~azure.mgmt.dataprotection.models.ResourceGuardResource
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version = kwargs.pop("api_version", _params.pop("api-version", self._config.api_version))  # type: str
        cls = kwargs.pop("cls", None)  # type: ClsType[_models.ResourceGuardResource]

        request = build_get_request(
            resource_group_name=resource_group_name,
            resource_guards_name=resource_guards_name,
            subscription_id=self._config.subscription_id,
            api_version=api_version,
            template_url=self.get.metadata["url"],
            headers=_headers,
            params=_params,
        )
        request = _convert_request(request)
        request.url = self._client.format_url(request.url)  # type: ignore

        pipeline_response = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            request, stream=False, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response, error_format=ARMErrorFormat)

        deserialized = self._deserialize("ResourceGuardResource", pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    get.metadata = {"url": "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DataProtection/resourceGuards/{resourceGuardsName}"}  # type: ignore

    @distributed_trace_async
    async def delete(  # pylint: disable=inconsistent-return-statements
        self, resource_group_name: str, resource_guards_name: str, **kwargs: Any
    ) -> None:
        """Deletes a ResourceGuard resource from the resource group.

        Deletes a ResourceGuard resource from the resource group.

        :param resource_group_name: The name of the resource group where the backup vault is present.
         Required.
        :type resource_group_name: str
        :param resource_guards_name: The name of ResourceGuard. Required.
        :type resource_guards_name: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: None or the result of cls(response)
        :rtype: None
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version = kwargs.pop("api_version", _params.pop("api-version", self._config.api_version))  # type: str
        cls = kwargs.pop("cls", None)  # type: ClsType[None]

        request = build_delete_request(
            resource_group_name=resource_group_name,
            resource_guards_name=resource_guards_name,
            subscription_id=self._config.subscription_id,
            api_version=api_version,
            template_url=self.delete.metadata["url"],
            headers=_headers,
            params=_params,
        )
        request = _convert_request(request)
        request.url = self._client.format_url(request.url)  # type: ignore

        pipeline_response = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            request, stream=False, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200, 204]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response, error_format=ARMErrorFormat)

        if cls:
            return cls(pipeline_response, None, {})

    delete.metadata = {"url": "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DataProtection/resourceGuards/{resourceGuardsName}"}  # type: ignore

    @overload
    async def patch(
        self,
        resource_group_name: str,
        resource_guards_name: str,
        parameters: _models.PatchResourceRequestInput,
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> _models.ResourceGuardResource:
        """Updates a ResourceGuard resource belonging to a resource group. For example, updating tags for
        a resource.

        Updates a ResourceGuard resource belonging to a resource group. For example, updating tags for
        a resource.

        :param resource_group_name: The name of the resource group where the backup vault is present.
         Required.
        :type resource_group_name: str
        :param resource_guards_name: The name of ResourceGuard. Required.
        :type resource_guards_name: str
        :param parameters: Request body for operation. Required.
        :type parameters: ~azure.mgmt.dataprotection.models.PatchResourceRequestInput
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: ResourceGuardResource or the result of cls(response)
        :rtype: ~azure.mgmt.dataprotection.models.ResourceGuardResource
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @overload
    async def patch(
        self,
        resource_group_name: str,
        resource_guards_name: str,
        parameters: IO,
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> _models.ResourceGuardResource:
        """Updates a ResourceGuard resource belonging to a resource group. For example, updating tags for
        a resource.

        Updates a ResourceGuard resource belonging to a resource group. For example, updating tags for
        a resource.

        :param resource_group_name: The name of the resource group where the backup vault is present.
         Required.
        :type resource_group_name: str
        :param resource_guards_name: The name of ResourceGuard. Required.
        :type resource_guards_name: str
        :param parameters: Request body for operation. Required.
        :type parameters: IO
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Default value is "application/json".
        :paramtype content_type: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: ResourceGuardResource or the result of cls(response)
        :rtype: ~azure.mgmt.dataprotection.models.ResourceGuardResource
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @distributed_trace_async
    async def patch(
        self,
        resource_group_name: str,
        resource_guards_name: str,
        parameters: Union[_models.PatchResourceRequestInput, IO],
        **kwargs: Any
    ) -> _models.ResourceGuardResource:
        """Updates a ResourceGuard resource belonging to a resource group. For example, updating tags for
        a resource.

        Updates a ResourceGuard resource belonging to a resource group. For example, updating tags for
        a resource.

        :param resource_group_name: The name of the resource group where the backup vault is present.
         Required.
        :type resource_group_name: str
        :param resource_guards_name: The name of ResourceGuard. Required.
        :type resource_guards_name: str
        :param parameters: Request body for operation. Is either a model type or a IO type. Required.
        :type parameters: ~azure.mgmt.dataprotection.models.PatchResourceRequestInput or IO
        :keyword content_type: Body Parameter content-type. Known values are: 'application/json'.
         Default value is None.
        :paramtype content_type: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: ResourceGuardResource or the result of cls(response)
        :rtype: ~azure.mgmt.dataprotection.models.ResourceGuardResource
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version = kwargs.pop("api_version", _params.pop("api-version", self._config.api_version))  # type: str
        content_type = kwargs.pop("content_type", _headers.pop("Content-Type", None))  # type: Optional[str]
        cls = kwargs.pop("cls", None)  # type: ClsType[_models.ResourceGuardResource]

        content_type = content_type or "application/json"
        _json = None
        _content = None
        if isinstance(parameters, (IO, bytes)):
            _content = parameters
        else:
            _json = self._serialize.body(parameters, "PatchResourceRequestInput")

        request = build_patch_request(
            resource_group_name=resource_group_name,
            resource_guards_name=resource_guards_name,
            subscription_id=self._config.subscription_id,
            api_version=api_version,
            content_type=content_type,
            json=_json,
            content=_content,
            template_url=self.patch.metadata["url"],
            headers=_headers,
            params=_params,
        )
        request = _convert_request(request)
        request.url = self._client.format_url(request.url)  # type: ignore

        pipeline_response = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            request, stream=False, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response, error_format=ARMErrorFormat)

        deserialized = self._deserialize("ResourceGuardResource", pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    patch.metadata = {"url": "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DataProtection/resourceGuards/{resourceGuardsName}"}  # type: ignore

    @distributed_trace
    def get_disable_soft_delete_requests_objects(
        self, resource_group_name: str, resource_guards_name: str, **kwargs: Any
    ) -> AsyncIterable["_models.DppBaseResource"]:
        """Returns collection of operation request objects for a critical operation protected by the given
        ResourceGuard resource.

        Returns collection of operation request objects for a critical operation protected by the given
        ResourceGuard resource.

        :param resource_group_name: The name of the resource group where the backup vault is present.
         Required.
        :type resource_group_name: str
        :param resource_guards_name: Required.
        :type resource_guards_name: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: An iterator like instance of either DppBaseResource or the result of cls(response)
        :rtype:
         ~azure.core.async_paging.AsyncItemPaged[~azure.mgmt.dataprotection.models.DppBaseResource]
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version = kwargs.pop("api_version", _params.pop("api-version", self._config.api_version))  # type: str
        cls = kwargs.pop("cls", None)  # type: ClsType[_models.DppBaseResourceList]

        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        def prepare_request(next_link=None):
            if not next_link:

                request = build_get_disable_soft_delete_requests_objects_request(
                    resource_group_name=resource_group_name,
                    resource_guards_name=resource_guards_name,
                    subscription_id=self._config.subscription_id,
                    api_version=api_version,
                    template_url=self.get_disable_soft_delete_requests_objects.metadata["url"],
                    headers=_headers,
                    params=_params,
                )
                request = _convert_request(request)
                request.url = self._client.format_url(request.url)  # type: ignore

            else:
                # make call to next link with the client's api-version
                _parsed_next_link = urlparse(next_link)
                _next_request_params = case_insensitive_dict(parse_qs(_parsed_next_link.query))
                _next_request_params["api-version"] = self._config.api_version
                request = HttpRequest("GET", urljoin(next_link, _parsed_next_link.path), params=_next_request_params)
                request = _convert_request(request)
                request.url = self._client.format_url(request.url)  # type: ignore
                request.method = "GET"
            return request

        async def extract_data(pipeline_response):
            deserialized = self._deserialize("DppBaseResourceList", pipeline_response)
            list_of_elem = deserialized.value
            if cls:
                list_of_elem = cls(list_of_elem)
            return deserialized.next_link or None, AsyncList(list_of_elem)

        async def get_next(next_link=None):
            request = prepare_request(next_link)

            pipeline_response = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
                request, stream=False, **kwargs
            )
            response = pipeline_response.http_response

            if response.status_code not in [200]:
                map_error(status_code=response.status_code, response=response, error_map=error_map)
                raise HttpResponseError(response=response, error_format=ARMErrorFormat)

            return pipeline_response

        return AsyncItemPaged(get_next, extract_data)

    get_disable_soft_delete_requests_objects.metadata = {"url": "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DataProtection/resourceGuards/{resourceGuardsName}/disableSoftDeleteRequests"}  # type: ignore

    @distributed_trace
    def get_delete_resource_guard_proxy_requests_objects(
        self, resource_group_name: str, resource_guards_name: str, **kwargs: Any
    ) -> AsyncIterable["_models.DppBaseResource"]:
        """Returns collection of operation request objects for a critical operation protected by the given
        ResourceGuard resource.

        Returns collection of operation request objects for a critical operation protected by the given
        ResourceGuard resource.

        :param resource_group_name: The name of the resource group where the backup vault is present.
         Required.
        :type resource_group_name: str
        :param resource_guards_name: Required.
        :type resource_guards_name: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: An iterator like instance of either DppBaseResource or the result of cls(response)
        :rtype:
         ~azure.core.async_paging.AsyncItemPaged[~azure.mgmt.dataprotection.models.DppBaseResource]
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version = kwargs.pop("api_version", _params.pop("api-version", self._config.api_version))  # type: str
        cls = kwargs.pop("cls", None)  # type: ClsType[_models.DppBaseResourceList]

        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        def prepare_request(next_link=None):
            if not next_link:

                request = build_get_delete_resource_guard_proxy_requests_objects_request(
                    resource_group_name=resource_group_name,
                    resource_guards_name=resource_guards_name,
                    subscription_id=self._config.subscription_id,
                    api_version=api_version,
                    template_url=self.get_delete_resource_guard_proxy_requests_objects.metadata["url"],
                    headers=_headers,
                    params=_params,
                )
                request = _convert_request(request)
                request.url = self._client.format_url(request.url)  # type: ignore

            else:
                # make call to next link with the client's api-version
                _parsed_next_link = urlparse(next_link)
                _next_request_params = case_insensitive_dict(parse_qs(_parsed_next_link.query))
                _next_request_params["api-version"] = self._config.api_version
                request = HttpRequest("GET", urljoin(next_link, _parsed_next_link.path), params=_next_request_params)
                request = _convert_request(request)
                request.url = self._client.format_url(request.url)  # type: ignore
                request.method = "GET"
            return request

        async def extract_data(pipeline_response):
            deserialized = self._deserialize("DppBaseResourceList", pipeline_response)
            list_of_elem = deserialized.value
            if cls:
                list_of_elem = cls(list_of_elem)
            return deserialized.next_link or None, AsyncList(list_of_elem)

        async def get_next(next_link=None):
            request = prepare_request(next_link)

            pipeline_response = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
                request, stream=False, **kwargs
            )
            response = pipeline_response.http_response

            if response.status_code not in [200]:
                map_error(status_code=response.status_code, response=response, error_map=error_map)
                raise HttpResponseError(response=response, error_format=ARMErrorFormat)

            return pipeline_response

        return AsyncItemPaged(get_next, extract_data)

    get_delete_resource_guard_proxy_requests_objects.metadata = {"url": "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DataProtection/resourceGuards/{resourceGuardsName}/deleteResourceGuardProxyRequests"}  # type: ignore

    @distributed_trace
    def get_backup_security_pin_requests_objects(
        self, resource_group_name: str, resource_guards_name: str, **kwargs: Any
    ) -> AsyncIterable["_models.DppBaseResource"]:
        """Returns collection of operation request objects for a critical operation protected by the given
        ResourceGuard resource.

        Returns collection of operation request objects for a critical operation protected by the given
        ResourceGuard resource.

        :param resource_group_name: The name of the resource group where the backup vault is present.
         Required.
        :type resource_group_name: str
        :param resource_guards_name: Required.
        :type resource_guards_name: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: An iterator like instance of either DppBaseResource or the result of cls(response)
        :rtype:
         ~azure.core.async_paging.AsyncItemPaged[~azure.mgmt.dataprotection.models.DppBaseResource]
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version = kwargs.pop("api_version", _params.pop("api-version", self._config.api_version))  # type: str
        cls = kwargs.pop("cls", None)  # type: ClsType[_models.DppBaseResourceList]

        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        def prepare_request(next_link=None):
            if not next_link:

                request = build_get_backup_security_pin_requests_objects_request(
                    resource_group_name=resource_group_name,
                    resource_guards_name=resource_guards_name,
                    subscription_id=self._config.subscription_id,
                    api_version=api_version,
                    template_url=self.get_backup_security_pin_requests_objects.metadata["url"],
                    headers=_headers,
                    params=_params,
                )
                request = _convert_request(request)
                request.url = self._client.format_url(request.url)  # type: ignore

            else:
                # make call to next link with the client's api-version
                _parsed_next_link = urlparse(next_link)
                _next_request_params = case_insensitive_dict(parse_qs(_parsed_next_link.query))
                _next_request_params["api-version"] = self._config.api_version
                request = HttpRequest("GET", urljoin(next_link, _parsed_next_link.path), params=_next_request_params)
                request = _convert_request(request)
                request.url = self._client.format_url(request.url)  # type: ignore
                request.method = "GET"
            return request

        async def extract_data(pipeline_response):
            deserialized = self._deserialize("DppBaseResourceList", pipeline_response)
            list_of_elem = deserialized.value
            if cls:
                list_of_elem = cls(list_of_elem)
            return deserialized.next_link or None, AsyncList(list_of_elem)

        async def get_next(next_link=None):
            request = prepare_request(next_link)

            pipeline_response = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
                request, stream=False, **kwargs
            )
            response = pipeline_response.http_response

            if response.status_code not in [200]:
                map_error(status_code=response.status_code, response=response, error_map=error_map)
                raise HttpResponseError(response=response, error_format=ARMErrorFormat)

            return pipeline_response

        return AsyncItemPaged(get_next, extract_data)

    get_backup_security_pin_requests_objects.metadata = {"url": "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DataProtection/resourceGuards/{resourceGuardsName}/getBackupSecurityPINRequests"}  # type: ignore

    @distributed_trace
    def get_delete_protected_item_requests_objects(
        self, resource_group_name: str, resource_guards_name: str, **kwargs: Any
    ) -> AsyncIterable["_models.DppBaseResource"]:
        """Returns collection of operation request objects for a critical operation protected by the given
        ResourceGuard resource.

        Returns collection of operation request objects for a critical operation protected by the given
        ResourceGuard resource.

        :param resource_group_name: The name of the resource group where the backup vault is present.
         Required.
        :type resource_group_name: str
        :param resource_guards_name: Required.
        :type resource_guards_name: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: An iterator like instance of either DppBaseResource or the result of cls(response)
        :rtype:
         ~azure.core.async_paging.AsyncItemPaged[~azure.mgmt.dataprotection.models.DppBaseResource]
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version = kwargs.pop("api_version", _params.pop("api-version", self._config.api_version))  # type: str
        cls = kwargs.pop("cls", None)  # type: ClsType[_models.DppBaseResourceList]

        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        def prepare_request(next_link=None):
            if not next_link:

                request = build_get_delete_protected_item_requests_objects_request(
                    resource_group_name=resource_group_name,
                    resource_guards_name=resource_guards_name,
                    subscription_id=self._config.subscription_id,
                    api_version=api_version,
                    template_url=self.get_delete_protected_item_requests_objects.metadata["url"],
                    headers=_headers,
                    params=_params,
                )
                request = _convert_request(request)
                request.url = self._client.format_url(request.url)  # type: ignore

            else:
                # make call to next link with the client's api-version
                _parsed_next_link = urlparse(next_link)
                _next_request_params = case_insensitive_dict(parse_qs(_parsed_next_link.query))
                _next_request_params["api-version"] = self._config.api_version
                request = HttpRequest("GET", urljoin(next_link, _parsed_next_link.path), params=_next_request_params)
                request = _convert_request(request)
                request.url = self._client.format_url(request.url)  # type: ignore
                request.method = "GET"
            return request

        async def extract_data(pipeline_response):
            deserialized = self._deserialize("DppBaseResourceList", pipeline_response)
            list_of_elem = deserialized.value
            if cls:
                list_of_elem = cls(list_of_elem)
            return deserialized.next_link or None, AsyncList(list_of_elem)

        async def get_next(next_link=None):
            request = prepare_request(next_link)

            pipeline_response = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
                request, stream=False, **kwargs
            )
            response = pipeline_response.http_response

            if response.status_code not in [200]:
                map_error(status_code=response.status_code, response=response, error_map=error_map)
                raise HttpResponseError(response=response, error_format=ARMErrorFormat)

            return pipeline_response

        return AsyncItemPaged(get_next, extract_data)

    get_delete_protected_item_requests_objects.metadata = {"url": "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DataProtection/resourceGuards/{resourceGuardsName}/deleteProtectedItemRequests"}  # type: ignore

    @distributed_trace
    def get_update_protection_policy_requests_objects(
        self, resource_group_name: str, resource_guards_name: str, **kwargs: Any
    ) -> AsyncIterable["_models.DppBaseResource"]:
        """Returns collection of operation request objects for a critical operation protected by the given
        ResourceGuard resource.

        Returns collection of operation request objects for a critical operation protected by the given
        ResourceGuard resource.

        :param resource_group_name: The name of the resource group where the backup vault is present.
         Required.
        :type resource_group_name: str
        :param resource_guards_name: Required.
        :type resource_guards_name: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: An iterator like instance of either DppBaseResource or the result of cls(response)
        :rtype:
         ~azure.core.async_paging.AsyncItemPaged[~azure.mgmt.dataprotection.models.DppBaseResource]
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version = kwargs.pop("api_version", _params.pop("api-version", self._config.api_version))  # type: str
        cls = kwargs.pop("cls", None)  # type: ClsType[_models.DppBaseResourceList]

        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        def prepare_request(next_link=None):
            if not next_link:

                request = build_get_update_protection_policy_requests_objects_request(
                    resource_group_name=resource_group_name,
                    resource_guards_name=resource_guards_name,
                    subscription_id=self._config.subscription_id,
                    api_version=api_version,
                    template_url=self.get_update_protection_policy_requests_objects.metadata["url"],
                    headers=_headers,
                    params=_params,
                )
                request = _convert_request(request)
                request.url = self._client.format_url(request.url)  # type: ignore

            else:
                # make call to next link with the client's api-version
                _parsed_next_link = urlparse(next_link)
                _next_request_params = case_insensitive_dict(parse_qs(_parsed_next_link.query))
                _next_request_params["api-version"] = self._config.api_version
                request = HttpRequest("GET", urljoin(next_link, _parsed_next_link.path), params=_next_request_params)
                request = _convert_request(request)
                request.url = self._client.format_url(request.url)  # type: ignore
                request.method = "GET"
            return request

        async def extract_data(pipeline_response):
            deserialized = self._deserialize("DppBaseResourceList", pipeline_response)
            list_of_elem = deserialized.value
            if cls:
                list_of_elem = cls(list_of_elem)
            return deserialized.next_link or None, AsyncList(list_of_elem)

        async def get_next(next_link=None):
            request = prepare_request(next_link)

            pipeline_response = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
                request, stream=False, **kwargs
            )
            response = pipeline_response.http_response

            if response.status_code not in [200]:
                map_error(status_code=response.status_code, response=response, error_map=error_map)
                raise HttpResponseError(response=response, error_format=ARMErrorFormat)

            return pipeline_response

        return AsyncItemPaged(get_next, extract_data)

    get_update_protection_policy_requests_objects.metadata = {"url": "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DataProtection/resourceGuards/{resourceGuardsName}/updateProtectionPolicyRequests"}  # type: ignore

    @distributed_trace
    def get_update_protected_item_requests_objects(
        self, resource_group_name: str, resource_guards_name: str, **kwargs: Any
    ) -> AsyncIterable["_models.DppBaseResource"]:
        """Returns collection of operation request objects for a critical operation protected by the given
        ResourceGuard resource.

        Returns collection of operation request objects for a critical operation protected by the given
        ResourceGuard resource.

        :param resource_group_name: The name of the resource group where the backup vault is present.
         Required.
        :type resource_group_name: str
        :param resource_guards_name: Required.
        :type resource_guards_name: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: An iterator like instance of either DppBaseResource or the result of cls(response)
        :rtype:
         ~azure.core.async_paging.AsyncItemPaged[~azure.mgmt.dataprotection.models.DppBaseResource]
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version = kwargs.pop("api_version", _params.pop("api-version", self._config.api_version))  # type: str
        cls = kwargs.pop("cls", None)  # type: ClsType[_models.DppBaseResourceList]

        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        def prepare_request(next_link=None):
            if not next_link:

                request = build_get_update_protected_item_requests_objects_request(
                    resource_group_name=resource_group_name,
                    resource_guards_name=resource_guards_name,
                    subscription_id=self._config.subscription_id,
                    api_version=api_version,
                    template_url=self.get_update_protected_item_requests_objects.metadata["url"],
                    headers=_headers,
                    params=_params,
                )
                request = _convert_request(request)
                request.url = self._client.format_url(request.url)  # type: ignore

            else:
                # make call to next link with the client's api-version
                _parsed_next_link = urlparse(next_link)
                _next_request_params = case_insensitive_dict(parse_qs(_parsed_next_link.query))
                _next_request_params["api-version"] = self._config.api_version
                request = HttpRequest("GET", urljoin(next_link, _parsed_next_link.path), params=_next_request_params)
                request = _convert_request(request)
                request.url = self._client.format_url(request.url)  # type: ignore
                request.method = "GET"
            return request

        async def extract_data(pipeline_response):
            deserialized = self._deserialize("DppBaseResourceList", pipeline_response)
            list_of_elem = deserialized.value
            if cls:
                list_of_elem = cls(list_of_elem)
            return deserialized.next_link or None, AsyncList(list_of_elem)

        async def get_next(next_link=None):
            request = prepare_request(next_link)

            pipeline_response = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
                request, stream=False, **kwargs
            )
            response = pipeline_response.http_response

            if response.status_code not in [200]:
                map_error(status_code=response.status_code, response=response, error_map=error_map)
                raise HttpResponseError(response=response, error_format=ARMErrorFormat)

            return pipeline_response

        return AsyncItemPaged(get_next, extract_data)

    get_update_protected_item_requests_objects.metadata = {"url": "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DataProtection/resourceGuards/{resourceGuardsName}/updateProtectedItemRequests"}  # type: ignore

    @distributed_trace_async
    async def get_default_disable_soft_delete_requests_object(
        self, resource_group_name: str, resource_guards_name: str, request_name: str, **kwargs: Any
    ) -> _models.DppBaseResource:
        """Returns collection of operation request objects for a critical operation protected by the given
        ResourceGuard resource.

        Returns collection of operation request objects for a critical operation protected by the given
        ResourceGuard resource.

        :param resource_group_name: The name of the resource group where the backup vault is present.
         Required.
        :type resource_group_name: str
        :param resource_guards_name: Required.
        :type resource_guards_name: str
        :param request_name: Required.
        :type request_name: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: DppBaseResource or the result of cls(response)
        :rtype: ~azure.mgmt.dataprotection.models.DppBaseResource
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version = kwargs.pop("api_version", _params.pop("api-version", self._config.api_version))  # type: str
        cls = kwargs.pop("cls", None)  # type: ClsType[_models.DppBaseResource]

        request = build_get_default_disable_soft_delete_requests_object_request(
            resource_group_name=resource_group_name,
            resource_guards_name=resource_guards_name,
            request_name=request_name,
            subscription_id=self._config.subscription_id,
            api_version=api_version,
            template_url=self.get_default_disable_soft_delete_requests_object.metadata["url"],
            headers=_headers,
            params=_params,
        )
        request = _convert_request(request)
        request.url = self._client.format_url(request.url)  # type: ignore

        pipeline_response = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            request, stream=False, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response, error_format=ARMErrorFormat)

        deserialized = self._deserialize("DppBaseResource", pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    get_default_disable_soft_delete_requests_object.metadata = {"url": "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DataProtection/resourceGuards/{resourceGuardsName}/disableSoftDeleteRequests/{requestName}"}  # type: ignore

    @distributed_trace_async
    async def get_default_delete_resource_guard_proxy_requests_object(
        self, resource_group_name: str, resource_guards_name: str, request_name: str, **kwargs: Any
    ) -> _models.DppBaseResource:
        """Returns collection of operation request objects for a critical operation protected by the given
        ResourceGuard resource.

        Returns collection of operation request objects for a critical operation protected by the given
        ResourceGuard resource.

        :param resource_group_name: The name of the resource group where the backup vault is present.
         Required.
        :type resource_group_name: str
        :param resource_guards_name: Required.
        :type resource_guards_name: str
        :param request_name: Required.
        :type request_name: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: DppBaseResource or the result of cls(response)
        :rtype: ~azure.mgmt.dataprotection.models.DppBaseResource
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version = kwargs.pop("api_version", _params.pop("api-version", self._config.api_version))  # type: str
        cls = kwargs.pop("cls", None)  # type: ClsType[_models.DppBaseResource]

        request = build_get_default_delete_resource_guard_proxy_requests_object_request(
            resource_group_name=resource_group_name,
            resource_guards_name=resource_guards_name,
            request_name=request_name,
            subscription_id=self._config.subscription_id,
            api_version=api_version,
            template_url=self.get_default_delete_resource_guard_proxy_requests_object.metadata["url"],
            headers=_headers,
            params=_params,
        )
        request = _convert_request(request)
        request.url = self._client.format_url(request.url)  # type: ignore

        pipeline_response = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            request, stream=False, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response, error_format=ARMErrorFormat)

        deserialized = self._deserialize("DppBaseResource", pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    get_default_delete_resource_guard_proxy_requests_object.metadata = {"url": "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DataProtection/resourceGuards/{resourceGuardsName}/deleteResourceGuardProxyRequests/{requestName}"}  # type: ignore

    @distributed_trace_async
    async def get_default_backup_security_pin_requests_object(
        self, resource_group_name: str, resource_guards_name: str, request_name: str, **kwargs: Any
    ) -> _models.DppBaseResource:
        """Returns collection of operation request objects for a critical operation protected by the given
        ResourceGuard resource.

        Returns collection of operation request objects for a critical operation protected by the given
        ResourceGuard resource.

        :param resource_group_name: The name of the resource group where the backup vault is present.
         Required.
        :type resource_group_name: str
        :param resource_guards_name: Required.
        :type resource_guards_name: str
        :param request_name: Required.
        :type request_name: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: DppBaseResource or the result of cls(response)
        :rtype: ~azure.mgmt.dataprotection.models.DppBaseResource
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version = kwargs.pop("api_version", _params.pop("api-version", self._config.api_version))  # type: str
        cls = kwargs.pop("cls", None)  # type: ClsType[_models.DppBaseResource]

        request = build_get_default_backup_security_pin_requests_object_request(
            resource_group_name=resource_group_name,
            resource_guards_name=resource_guards_name,
            request_name=request_name,
            subscription_id=self._config.subscription_id,
            api_version=api_version,
            template_url=self.get_default_backup_security_pin_requests_object.metadata["url"],
            headers=_headers,
            params=_params,
        )
        request = _convert_request(request)
        request.url = self._client.format_url(request.url)  # type: ignore

        pipeline_response = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            request, stream=False, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response, error_format=ARMErrorFormat)

        deserialized = self._deserialize("DppBaseResource", pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    get_default_backup_security_pin_requests_object.metadata = {"url": "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DataProtection/resourceGuards/{resourceGuardsName}/getBackupSecurityPINRequests/{requestName}"}  # type: ignore

    @distributed_trace_async
    async def get_default_delete_protected_item_requests_object(
        self, resource_group_name: str, resource_guards_name: str, request_name: str, **kwargs: Any
    ) -> _models.DppBaseResource:
        """Returns collection of operation request objects for a critical operation protected by the given
        ResourceGuard resource.

        Returns collection of operation request objects for a critical operation protected by the given
        ResourceGuard resource.

        :param resource_group_name: The name of the resource group where the backup vault is present.
         Required.
        :type resource_group_name: str
        :param resource_guards_name: Required.
        :type resource_guards_name: str
        :param request_name: Required.
        :type request_name: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: DppBaseResource or the result of cls(response)
        :rtype: ~azure.mgmt.dataprotection.models.DppBaseResource
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version = kwargs.pop("api_version", _params.pop("api-version", self._config.api_version))  # type: str
        cls = kwargs.pop("cls", None)  # type: ClsType[_models.DppBaseResource]

        request = build_get_default_delete_protected_item_requests_object_request(
            resource_group_name=resource_group_name,
            resource_guards_name=resource_guards_name,
            request_name=request_name,
            subscription_id=self._config.subscription_id,
            api_version=api_version,
            template_url=self.get_default_delete_protected_item_requests_object.metadata["url"],
            headers=_headers,
            params=_params,
        )
        request = _convert_request(request)
        request.url = self._client.format_url(request.url)  # type: ignore

        pipeline_response = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            request, stream=False, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response, error_format=ARMErrorFormat)

        deserialized = self._deserialize("DppBaseResource", pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    get_default_delete_protected_item_requests_object.metadata = {"url": "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DataProtection/resourceGuards/{resourceGuardsName}/deleteProtectedItemRequests/{requestName}"}  # type: ignore

    @distributed_trace_async
    async def get_default_update_protection_policy_requests_object(
        self, resource_group_name: str, resource_guards_name: str, request_name: str, **kwargs: Any
    ) -> _models.DppBaseResource:
        """Returns collection of operation request objects for a critical operation protected by the given
        ResourceGuard resource.

        Returns collection of operation request objects for a critical operation protected by the given
        ResourceGuard resource.

        :param resource_group_name: The name of the resource group where the backup vault is present.
         Required.
        :type resource_group_name: str
        :param resource_guards_name: Required.
        :type resource_guards_name: str
        :param request_name: Required.
        :type request_name: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: DppBaseResource or the result of cls(response)
        :rtype: ~azure.mgmt.dataprotection.models.DppBaseResource
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version = kwargs.pop("api_version", _params.pop("api-version", self._config.api_version))  # type: str
        cls = kwargs.pop("cls", None)  # type: ClsType[_models.DppBaseResource]

        request = build_get_default_update_protection_policy_requests_object_request(
            resource_group_name=resource_group_name,
            resource_guards_name=resource_guards_name,
            request_name=request_name,
            subscription_id=self._config.subscription_id,
            api_version=api_version,
            template_url=self.get_default_update_protection_policy_requests_object.metadata["url"],
            headers=_headers,
            params=_params,
        )
        request = _convert_request(request)
        request.url = self._client.format_url(request.url)  # type: ignore

        pipeline_response = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            request, stream=False, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response, error_format=ARMErrorFormat)

        deserialized = self._deserialize("DppBaseResource", pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    get_default_update_protection_policy_requests_object.metadata = {"url": "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DataProtection/resourceGuards/{resourceGuardsName}/updateProtectionPolicyRequests/{requestName}"}  # type: ignore

    @distributed_trace_async
    async def get_default_update_protected_item_requests_object(
        self, resource_group_name: str, resource_guards_name: str, request_name: str, **kwargs: Any
    ) -> _models.DppBaseResource:
        """Returns collection of operation request objects for a critical operation protected by the given
        ResourceGuard resource.

        Returns collection of operation request objects for a critical operation protected by the given
        ResourceGuard resource.

        :param resource_group_name: The name of the resource group where the backup vault is present.
         Required.
        :type resource_group_name: str
        :param resource_guards_name: Required.
        :type resource_guards_name: str
        :param request_name: Required.
        :type request_name: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: DppBaseResource or the result of cls(response)
        :rtype: ~azure.mgmt.dataprotection.models.DppBaseResource
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version = kwargs.pop("api_version", _params.pop("api-version", self._config.api_version))  # type: str
        cls = kwargs.pop("cls", None)  # type: ClsType[_models.DppBaseResource]

        request = build_get_default_update_protected_item_requests_object_request(
            resource_group_name=resource_group_name,
            resource_guards_name=resource_guards_name,
            request_name=request_name,
            subscription_id=self._config.subscription_id,
            api_version=api_version,
            template_url=self.get_default_update_protected_item_requests_object.metadata["url"],
            headers=_headers,
            params=_params,
        )
        request = _convert_request(request)
        request.url = self._client.format_url(request.url)  # type: ignore

        pipeline_response = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            request, stream=False, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response, error_format=ARMErrorFormat)

        deserialized = self._deserialize("DppBaseResource", pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    get_default_update_protected_item_requests_object.metadata = {"url": "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DataProtection/resourceGuards/{resourceGuardsName}/updateProtectedItemRequests/{requestName}"}  # type: ignore
