/*
 * Decompiled with CFR 0.152.
 */
package oracle.pgx.config;

import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import oracle.pgx.common.util.JsonUtil;
import oracle.pgx.config.AbstractConfig;
import oracle.pgx.config.ClientConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractClientConfig
extends AbstractConfig {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractClientConfig.class);

    public static ClientConfig getInstance(Map<ClientConfig.Field, Object> values) {
        ClientConfig throwable2;
        block10: {
            InputStream is = JsonUtil.toJsonInputStream(values);
            try {
                ClientConfig config = ClientConfig.parse(is, true, null);
                if (LOG.isTraceEnabled()) {
                    for (ClientConfig.Field field : ClientConfig.Field.values()) {
                        LOG.trace("[" + field.toKey() + "=" + config.getValues().get((Object)field) + "]");
                    }
                }
                throwable2 = config;
                if (is == null) break block10;
            }
            catch (Throwable throwable) {
                try {
                    if (is != null) {
                        try {
                            is.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new IllegalArgumentException(e);
                }
            }
            is.close();
        }
        return throwable2;
    }

    public String getCleanedBaseUrl() {
        String baseUrl = this.getBaseUrl();
        if (!baseUrl.startsWith("http://") && !baseUrl.startsWith("https://")) {
            baseUrl = "https://" + baseUrl;
        }
        if (baseUrl.length() > 0 && baseUrl.charAt(baseUrl.length() - 1) == '/') {
            baseUrl = baseUrl.substring(0, baseUrl.length() - 1);
        }
        return baseUrl;
    }

    public abstract String getBaseUrl();
}

