/*
 * Decompiled with CFR 0.152.
 */
package oracle.pgx.api.mllib;

import java.io.IOException;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.function.Supplier;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import oracle.pgx.api.PgxFuture;
import oracle.pgx.api.PgxSession;
import oracle.pgx.api.internal.Core;
import oracle.pgx.config.internal.ConfigUtils;
import oracle.pgx.config.mllib.ModelRepositoryConfiguration;

public abstract class ModelRepository {
    protected final PgxSession session;
    protected final Core core;
    protected final Supplier<String> keystorePathSupplier;
    protected final Supplier<char[]> keystorePasswordSupplier;

    public ModelRepository(PgxSession session, Core core, Supplier<String> keystorePathSupplier, Supplier<char[]> keystorePasswordSupplier) {
        this.session = session;
        this.core = core;
        this.keystorePathSupplier = keystorePathSupplier;
        this.keystorePasswordSupplier = keystorePasswordSupplier;
    }

    public void deleteModelStore(String modelStoreName) throws ExecutionException, InterruptedException {
        this.deleteModelStoreAsync(modelStoreName).get();
    }

    public void create(String modelStoreName) throws ExecutionException, InterruptedException {
        this.createAsync(modelStoreName).get();
    }

    public List<String> listModelStoresNames() throws ExecutionException, InterruptedException {
        return this.listModelStoresNamesAsync().get();
    }

    public List<String> listModelStoresNamesMatching(String regex) throws ExecutionException, InterruptedException {
        Pattern pattern = Pattern.compile(regex);
        return this.listModelStoresNames().stream().filter(pattern.asPredicate()).collect(Collectors.toList());
    }

    public List<String> listModels(String modelStoreName) throws ExecutionException, InterruptedException {
        return this.listModelsAsync(modelStoreName).get();
    }

    public String getModelDescription(String modelStoreName, String modelName) throws ExecutionException, InterruptedException {
        return this.getModelDescriptionAsync(modelStoreName, modelName).get();
    }

    public void deleteModel(String modelStoreName, String modelName) throws ExecutionException, InterruptedException {
        this.deleteModelAsync(modelStoreName, modelName).get();
    }

    public abstract PgxFuture<Void> deleteModelStoreAsync(String var1);

    public abstract PgxFuture<Void> createAsync(String var1);

    public abstract PgxFuture<List<String>> listModelStoresNamesAsync();

    public abstract PgxFuture<List<String>> listModelsAsync(String var1);

    public abstract PgxFuture<String> getModelDescriptionAsync(String var1, String var2);

    public abstract PgxFuture<Void> deleteModelAsync(String var1, String var2);

    protected final void adaptConfig(ModelRepositoryConfiguration config) throws CertificateException, IOException, KeyStoreException, NoSuchAlgorithmException {
        if (this.keystorePathSupplier != null && this.keystorePasswordSupplier != null) {
            ConfigUtils.modifyModelRepositoryConfigWithCredentials((String)this.keystorePathSupplier.get(), (char[])this.keystorePasswordSupplier.get(), (ModelRepositoryConfiguration)config);
        }
    }
}

