/*
 * Decompiled with CFR 0.152.
 */
package oracle.pgx.api.internal.synchronizer;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Stream;
import oracle.pgx.api.subgraph.internal.PgGraphConfigUtil;
import oracle.pgx.common.ImmutablePair;
import oracle.pgx.common.util.ErrorMessages;
import oracle.pgx.config.EntityProviderConfig;
import oracle.pgx.config.PartitionedGraphConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class SqlGraphPropertyDefinitionReader {
    private static final Logger LOG = LoggerFactory.getLogger(SqlGraphPropertyDefinitionReader.class);
    private static final String QUERY_PROPERTY_DEFINITIONS = "SELECT ELEMENT_NAME, PROPERTY_NAME, COLUMN_EXPR FROM SYS.ALL_PG_PROP_DEFINITIONS WHERE GRAPH_NAME = ? AND OWNER = ? AND COLUMN_EXPR IS NOT NULL";
    private final Connection connection;
    private final PartitionedGraphConfig graphConfig;
    private final String graphName;

    SqlGraphPropertyDefinitionReader(Connection connection, PartitionedGraphConfig graphConfig) {
        this.connection = Objects.requireNonNull(connection);
        this.graphConfig = Objects.requireNonNull(graphConfig);
        this.graphName = PgGraphConfigUtil.getAndValidateSourceName((PartitionedGraphConfig)graphConfig);
    }

    Map<ImmutablePair<String, String>, String> getDefinitions() {
        if (!this.hasAnyMissingDefinition()) {
            LOG.debug("Columns for all properties are set, not reading metadata");
            return Collections.emptyMap();
        }
        Map<ImmutablePair<String, String>, String> definitions = this.readDefinitions();
        return Collections.unmodifiableMap(definitions);
    }

    private boolean hasAnyMissingDefinition() {
        return Stream.of(this.graphConfig.getVertexProviders(), this.graphConfig.getEdgeProviders()).flatMap(Collection::stream).map(EntityProviderConfig::getProps).flatMap(Collection::stream).anyMatch(propertyConfig -> propertyConfig.getColumn() == null);
    }

    private Map<ImmutablePair<String, String>, String> readDefinitions() {
        LOG.debug("Reading property definitions");
        HashMap<ImmutablePair<String, String>, String> definitions = new HashMap<ImmutablePair<String, String>, String>();
        try (PreparedStatement stmt = this.prepareQueryForDefinitions();
             ResultSet rs = stmt.executeQuery();){
            while (rs.next()) {
                String provider = rs.getString(1);
                String property = rs.getString(2);
                String definition = rs.getString(3);
                definitions.put((ImmutablePair<String, String>)ImmutablePair.of((Object)provider, (Object)property), definition);
            }
        }
        catch (SQLException sqlException) {
            LOG.error("Failed to query graph metadata", (Throwable)sqlException);
            throw new IllegalStateException(ErrorMessages.getMessage((String)"PG_SQL_METADATA_LOADING_FAILED", (Object[])new Object[]{this.graphName}), sqlException);
        }
        LOG.debug("Found {} definitions", (Object)definitions.size());
        return definitions;
    }

    private PreparedStatement prepareQueryForDefinitions() throws SQLException {
        PreparedStatement statement = this.connection.prepareStatement(QUERY_PROPERTY_DEFINITIONS);
        statement.setString(1, this.graphName);
        statement.setString(2, this.graphConfig.getSchema());
        return statement;
    }
}

