/*
 * Decompiled with CFR 0.152.
 */
package oracle.pgx.api.internal;

import javax.inject.Inject;
import oracle.pgx.api.PgxFuture;
import oracle.pgx.api.SessionContext;
import oracle.pgx.api.filter.GraphFilter;
import oracle.pgx.api.filter.VertexFilter;
import oracle.pgx.api.internal.AbstractBuiltinAlgorithms;
import oracle.pgx.api.internal.Argument;
import oracle.pgx.api.internal.CoreAnalysisApi;
import oracle.pgx.api.internal.characteristic.ParallelismCharacteristic;
import oracle.pgx.common.PgxId;

public class BuiltinAlgorithms
extends AbstractBuiltinAlgorithms {
    @Inject
    public BuiltinAlgorithms(CoreAnalysisApi coreAnalysisApi) {
        super(coreAnalysisApi);
    }

    public synchronized PgxFuture<Double> pgxBuiltinA1Prim(SessionContext sessionContext, PgxId G, PgxId weight, PgxId in_mst) {
        return this.runAnalysis(sessionContext, "pgx_builtin_a1_prim", new Argument[]{Argument.createGraphArg(G), Argument.createEdgePropertyArg(weight), Argument.createEdgePropertyArg(in_mst)}, Double.class, ParallelismCharacteristic.PARALLEL);
    }

    public synchronized PgxFuture<Double> pgxBuiltinA1uPrim(SessionContext sessionContext, PgxId G, PgxId weight, PgxId in_mst) {
        return this.runAnalysis(sessionContext, "pgx_builtin_a1u_prim", new Argument[]{Argument.createGraphArg(G), Argument.createEdgePropertyArg(weight), Argument.createEdgePropertyArg(in_mst)}, Double.class, ParallelismCharacteristic.PARALLEL);
    }

    public synchronized PgxFuture<Long> pgxBuiltinC1CommunityDetectionLabelPropagation(SessionContext sessionContext, PgxId G, int max_iter, PgxId label) {
        return this.runAnalysis(sessionContext, "pgx_builtin_c1_community_detection_label_propagation", new Argument[]{Argument.createGraphArg(G), Argument.createIntInArg(max_iter), Argument.createNodePropertyArg(label)}, Long.class, ParallelismCharacteristic.PARALLEL);
    }

    public synchronized PgxFuture<Long> pgxBuiltinC2CommunityDetectionConductanceMinimization(SessionContext sessionContext, PgxId G, int max_iterations, PgxId community_id) {
        return this.runAnalysis(sessionContext, "pgx_builtin_c2_community_detection_conductance_minimization", new Argument[]{Argument.createGraphArg(G), Argument.createIntInArg(max_iterations), Argument.createNodePropertyArg(community_id)}, Long.class, ParallelismCharacteristic.PARALLEL);
    }

    public synchronized PgxFuture<Long> pgxBuiltinC3Infomap(SessionContext sessionContext, PgxId G, PgxId rank, PgxId weight, double tau, double tol, int max_iter, PgxId module) {
        return this.runAnalysis(sessionContext, "pgx_builtin_c3_infomap", new Argument[]{Argument.createGraphArg(G), Argument.createNodePropertyArg(rank), Argument.createEdgePropertyArg(weight), Argument.createDoubleInArg(tau), Argument.createDoubleInArg(tol), Argument.createIntInArg(max_iter), Argument.createNodePropertyArg(module)}, Long.class, ParallelismCharacteristic.PARALLEL);
    }

    public synchronized PgxFuture<Void> pgxBuiltinC4Louvain(SessionContext sessionContext, PgxId G, PgxId weight, int max_iter, int nbr_pass, double tol, PgxId communityId) {
        return this.runAnalysis(sessionContext, "pgx_builtin_c4_louvain", new Argument[]{Argument.createGraphArg(G), Argument.createEdgePropertyArg(weight), Argument.createIntInArg(max_iter), Argument.createIntInArg(nbr_pass), Argument.createDoubleInArg(tol), Argument.createNodePropertyArg(communityId)}, Void.class, ParallelismCharacteristic.PARALLEL);
    }

    public synchronized PgxFuture<Void> pgxBuiltinC4bLouvainDirected(SessionContext sessionContext, PgxId G, PgxId weight, int max_iter, int nbr_pass, double tol, PgxId communityId) {
        return this.runAnalysis(sessionContext, "pgx_builtin_c4b_louvain_directed", new Argument[]{Argument.createGraphArg(G), Argument.createEdgePropertyArg(weight), Argument.createIntInArg(max_iter), Argument.createIntInArg(nbr_pass), Argument.createDoubleInArg(tol), Argument.createNodePropertyArg(communityId)}, Void.class, ParallelismCharacteristic.PARALLEL);
    }

    public synchronized PgxFuture<Void> pgxBuiltinC5SpeakerListenerLabelPropagation(SessionContext sessionContext, PgxId G, int max_iter, double threshold, String delimiter, PgxId labels) {
        return this.runAnalysis(sessionContext, "pgx_builtin_c5_speaker_listener_label_propagation", new Argument[]{Argument.createGraphArg(G), Argument.createIntInArg(max_iter), Argument.createDoubleInArg(threshold), Argument.createStringInArg(delimiter), Argument.createNodePropertyArg(labels)}, Void.class, ParallelismCharacteristic.PARALLEL);
    }

    public synchronized PgxFuture<Void> pgxBuiltinC5bFilteredSpeakerListenerLabelPropagation(SessionContext sessionContext, PgxId G, int max_iter, double threshold, String delimiter, GraphFilter filter, PgxId labels) {
        return this.runAnalysis(sessionContext, "pgx_builtin_c5b_filtered_speaker_listener_label_propagation", new Argument[]{Argument.createGraphArg(G), Argument.createIntInArg(max_iter), Argument.createDoubleInArg(threshold), Argument.createStringInArg(delimiter), Argument.createGenericFilterArg(filter), Argument.createNodePropertyArg(labels)}, Void.class, ParallelismCharacteristic.PARALLEL);
    }

    public synchronized PgxFuture<Void> pgxBuiltinC5cFilteredWeightedSpeakerListenerLabelPropagation(SessionContext sessionContext, PgxId G, int max_iter, double threshold, String delimiter, PgxId weight, GraphFilter filter, PgxId labels) {
        return this.runAnalysis(sessionContext, "pgx_builtin_c5c_filtered_weighted_speaker_listener_label_propagation", new Argument[]{Argument.createGraphArg(G), Argument.createIntInArg(max_iter), Argument.createDoubleInArg(threshold), Argument.createStringInArg(delimiter), Argument.createEdgePropertyArg(weight), Argument.createGenericFilterArg(filter), Argument.createNodePropertyArg(labels)}, Void.class, ParallelismCharacteristic.PARALLEL);
    }

    public synchronized PgxFuture<Void> pgxBuiltinC6WeightedSpeakerListenerLabelPropagation(SessionContext sessionContext, PgxId G, int max_iter, double threshold, String delimiter, PgxId weight, PgxId labels) {
        return this.runAnalysis(sessionContext, "pgx_builtin_c6_weighted_speaker_listener_label_propagation", new Argument[]{Argument.createGraphArg(G), Argument.createIntInArg(max_iter), Argument.createDoubleInArg(threshold), Argument.createStringInArg(delimiter), Argument.createEdgePropertyArg(weight), Argument.createNodePropertyArg(labels)}, Void.class, ParallelismCharacteristic.PARALLEL);
    }

    public synchronized PgxFuture<Long> pgxBuiltinG2aStronglyConnectedComponentsKosaraju(SessionContext sessionContext, PgxId G, PgxId scc) {
        return this.runAnalysis(sessionContext, "pgx_builtin_g2a_strongly_connected_components_kosaraju", new Argument[]{Argument.createGraphArg(G), Argument.createNodePropertyArg(scc)}, Long.class, ParallelismCharacteristic.PARALLEL);
    }

    public synchronized PgxFuture<Long> pgxBuiltinG2bStronglyConnectedComponentsTarjan(SessionContext sessionContext, PgxId G, PgxId scc) {
        return this.runAnalysis(sessionContext, "pgx_builtin_g2b_strongly_connected_components_tarjan", new Argument[]{Argument.createGraphArg(G), Argument.createNodePropertyArg(scc)}, Long.class, ParallelismCharacteristic.SEQUENTIAL);
    }

    public synchronized PgxFuture<Long> pgxBuiltinG3WeaklyConnectedComponents(SessionContext sessionContext, PgxId G, PgxId comp_id) {
        return this.runAnalysis(sessionContext, "pgx_builtin_g3_weakly_connected_components", new Argument[]{Argument.createGraphArg(G), Argument.createNodePropertyArg(comp_id)}, Long.class, ParallelismCharacteristic.PARALLEL);
    }

    public synchronized PgxFuture<Void> pgxBuiltinK10ArticleRank(SessionContext sessionContext, PgxId G, double tol, double damp, int max_iter, boolean norm, PgxId rank) {
        return this.runAnalysis(sessionContext, "pgx_builtin_k10_article_rank", new Argument[]{Argument.createGraphArg(G), Argument.createDoubleInArg(tol), Argument.createDoubleInArg(damp), Argument.createIntInArg(max_iter), Argument.createBooleanInArg(norm), Argument.createNodePropertyArg(rank)}, Void.class, ParallelismCharacteristic.PARALLEL);
    }

    public synchronized PgxFuture<Void> pgxBuiltinK1aPagerank(SessionContext sessionContext, PgxId G, double tol, double damp, int max_iter, boolean norm, PgxId rank) {
        return this.runAnalysis(sessionContext, "pgx_builtin_k1a_pagerank", new Argument[]{Argument.createGraphArg(G), Argument.createDoubleInArg(tol), Argument.createDoubleInArg(damp), Argument.createIntInArg(max_iter), Argument.createBooleanInArg(norm), Argument.createNodePropertyArg(rank)}, Void.class, ParallelismCharacteristic.PARALLEL);
    }

    public synchronized PgxFuture<Void> pgxBuiltinK1bPagerankApproximate(SessionContext sessionContext, PgxId G, double tol, double damp, int max_iter, PgxId rank) {
        return this.runAnalysis(sessionContext, "pgx_builtin_k1b_pagerank_approximate", new Argument[]{Argument.createGraphArg(G), Argument.createDoubleInArg(tol), Argument.createDoubleInArg(damp), Argument.createIntInArg(max_iter), Argument.createNodePropertyArg(rank)}, Void.class, ParallelismCharacteristic.PARALLEL);
    }

    public synchronized PgxFuture<Void> pgxBuiltinK1cPagerankWeighted(SessionContext sessionContext, PgxId G, double tol, double damp, int max_iter, boolean norm, PgxId weight, PgxId rank) {
        return this.runAnalysis(sessionContext, "pgx_builtin_k1c_pagerank_weighted", new Argument[]{Argument.createGraphArg(G), Argument.createDoubleInArg(tol), Argument.createDoubleInArg(damp), Argument.createIntInArg(max_iter), Argument.createBooleanInArg(norm), Argument.createEdgePropertyArg(weight), Argument.createNodePropertyArg(rank)}, Void.class, ParallelismCharacteristic.PARALLEL);
    }

    public synchronized PgxFuture<Void> pgxBuiltinK2PersonalizedPagerank(SessionContext sessionContext, PgxId G, Object v, double tol, double damp, int max_iter, boolean norm, PgxId rank) {
        return this.runAnalysis(sessionContext, "pgx_builtin_k2_personalized_pagerank", new Argument[]{Argument.createGraphArg(G), Argument.createNodeIdInArg(v), Argument.createDoubleInArg(tol), Argument.createDoubleInArg(damp), Argument.createIntInArg(max_iter), Argument.createBooleanInArg(norm), Argument.createNodePropertyArg(rank)}, Void.class, ParallelismCharacteristic.PARALLEL);
    }

    public synchronized PgxFuture<Void> pgxBuiltinK2bPersonalizedPagerankFromSet(SessionContext sessionContext, PgxId G, PgxId source, double tol, double damp, int max_iter, boolean norm, PgxId rank) {
        return this.runAnalysis(sessionContext, "pgx_builtin_k2b_personalized_pagerank_from_set", new Argument[]{Argument.createGraphArg(G), Argument.createCollectionArg(source), Argument.createDoubleInArg(tol), Argument.createDoubleInArg(damp), Argument.createIntInArg(max_iter), Argument.createBooleanInArg(norm), Argument.createNodePropertyArg(rank)}, Void.class, ParallelismCharacteristic.PARALLEL);
    }

    public synchronized PgxFuture<Void> pgxBuiltinK2cPersonalizedWeightedPagerank(SessionContext sessionContext, PgxId G, Object v, double tol, double damp, int max_iter, boolean norm, PgxId weight, PgxId rank) {
        return this.runAnalysis(sessionContext, "pgx_builtin_k2c_personalized_weighted_pagerank", new Argument[]{Argument.createGraphArg(G), Argument.createNodeIdInArg(v), Argument.createDoubleInArg(tol), Argument.createDoubleInArg(damp), Argument.createIntInArg(max_iter), Argument.createBooleanInArg(norm), Argument.createEdgePropertyArg(weight), Argument.createNodePropertyArg(rank)}, Void.class, ParallelismCharacteristic.PARALLEL);
    }

    public synchronized PgxFuture<Void> pgxBuiltinK2dPersonalizedWeightedPagerankFromSet(SessionContext sessionContext, PgxId G, PgxId source, double tol, double damp, int max_iter, boolean norm, PgxId weight, PgxId rank) {
        return this.runAnalysis(sessionContext, "pgx_builtin_k2d_personalized_weighted_pagerank_from_set", new Argument[]{Argument.createGraphArg(G), Argument.createCollectionArg(source), Argument.createDoubleInArg(tol), Argument.createDoubleInArg(damp), Argument.createIntInArg(max_iter), Argument.createBooleanInArg(norm), Argument.createEdgePropertyArg(weight), Argument.createNodePropertyArg(rank)}, Void.class, ParallelismCharacteristic.PARALLEL);
    }

    public synchronized PgxFuture<Void> pgxBuiltinK3aNodeBetweennessCentrality(SessionContext sessionContext, PgxId G, PgxId bc) {
        return this.runAnalysis(sessionContext, "pgx_builtin_k3a_node_betweenness_centrality", new Argument[]{Argument.createGraphArg(G), Argument.createNodePropertyArg(bc)}, Void.class, ParallelismCharacteristic.PARALLEL);
    }

    public synchronized PgxFuture<Void> pgxBuiltinK3bApproxNodeBetweennessCentrality(SessionContext sessionContext, PgxId G, int num_seeds, PgxId bc) {
        return this.runAnalysis(sessionContext, "pgx_builtin_k3b_approx_node_betweenness_centrality", new Argument[]{Argument.createGraphArg(G), Argument.createIntInArg(num_seeds), Argument.createNodePropertyArg(bc)}, Void.class, ParallelismCharacteristic.PARALLEL);
    }

    public synchronized PgxFuture<Void> pgxBuiltinK3cApproxNodeBetweennessCentralityFromSeeds(SessionContext sessionContext, PgxId G, PgxId seeds, PgxId bc) {
        return this.runAnalysis(sessionContext, "pgx_builtin_k3c_approx_node_betweenness_centrality_from_seeds", new Argument[]{Argument.createGraphArg(G), Argument.createCollectionArg(seeds), Argument.createNodePropertyArg(bc)}, Void.class, ParallelismCharacteristic.PARALLEL);
    }

    public synchronized PgxFuture<Boolean> pgxBuiltinK4aClosenessCentralityUnitLength(SessionContext sessionContext, PgxId G, PgxId cc) {
        return this.runAnalysis(sessionContext, "pgx_builtin_k4a_closeness_centrality_unit_length", new Argument[]{Argument.createGraphArg(G), Argument.createNodePropertyArg(cc)}, Boolean.class, ParallelismCharacteristic.PARALLEL);
    }

    public synchronized PgxFuture<Boolean> pgxBuiltinK4bClosenessCentralityDoubleLength(SessionContext sessionContext, PgxId G, PgxId weight, PgxId cc) {
        return this.runAnalysis(sessionContext, "pgx_builtin_k4b_closeness_centrality_double_length", new Argument[]{Argument.createGraphArg(G), Argument.createEdgePropertyArg(weight), Argument.createNodePropertyArg(cc)}, Boolean.class, ParallelismCharacteristic.PARALLEL);
    }

    public synchronized PgxFuture<Void> pgxBuiltinK5Hits(SessionContext sessionContext, PgxId G, int max_iter, PgxId auth, PgxId hub) {
        return this.runAnalysis(sessionContext, "pgx_builtin_k5_hits", new Argument[]{Argument.createGraphArg(G), Argument.createIntInArg(max_iter), Argument.createNodePropertyArg(auth), Argument.createNodePropertyArg(hub)}, Void.class, ParallelismCharacteristic.PARALLEL);
    }

    public synchronized PgxFuture<Void> pgxBuiltinK6EigenvectorCentrality(SessionContext sessionContext, PgxId G, int max_iter, double max_diff, boolean use_l2norm, boolean use_inEdges, PgxId ec) {
        return this.runAnalysis(sessionContext, "pgx_builtin_k6_eigenvector_centrality", new Argument[]{Argument.createGraphArg(G), Argument.createIntInArg(max_iter), Argument.createDoubleInArg(max_diff), Argument.createBooleanInArg(use_l2norm), Argument.createBooleanInArg(use_inEdges), Argument.createNodePropertyArg(ec)}, Void.class, ParallelismCharacteristic.PARALLEL);
    }

    public synchronized PgxFuture<Void> pgxBuiltinK7aOutdegreeCentrality(SessionContext sessionContext, PgxId G, PgxId oc) {
        return this.runAnalysis(sessionContext, "pgx_builtin_k7a_outdegree_centrality", new Argument[]{Argument.createGraphArg(G), Argument.createNodePropertyArg(oc)}, Void.class, ParallelismCharacteristic.PARALLEL);
    }

    public synchronized PgxFuture<Void> pgxBuiltinK7bIndegreeCentrality(SessionContext sessionContext, PgxId G, PgxId ic) {
        return this.runAnalysis(sessionContext, "pgx_builtin_k7b_indegree_centrality", new Argument[]{Argument.createGraphArg(G), Argument.createNodePropertyArg(ic)}, Void.class, ParallelismCharacteristic.PARALLEL);
    }

    public synchronized PgxFuture<Void> pgxBuiltinK7cDegreeCentrality(SessionContext sessionContext, PgxId G, PgxId dc) {
        return this.runAnalysis(sessionContext, "pgx_builtin_k7c_degree_centrality", new Argument[]{Argument.createGraphArg(G), Argument.createNodePropertyArg(dc)}, Void.class, ParallelismCharacteristic.PARALLEL);
    }

    public synchronized PgxFuture<Void> pgxBuiltinK8RandomWalkWithRestart(SessionContext sessionContext, PgxId G, Object source, int length, double reset_prob, String visit_count) {
        return this.runAnalysis(sessionContext, "pgx_builtin_k8_random_walk_with_restart", new Argument[]{Argument.createGraphArg(G), Argument.createNodeIdInArg(source), Argument.createIntInArg(length), Argument.createDoubleInArg(reset_prob), Argument.createMapArg(visit_count)}, Void.class, ParallelismCharacteristic.SEQUENTIAL);
    }

    public synchronized PgxFuture<Void> pgxBuiltinK9HarmonicCentrality(SessionContext sessionContext, PgxId G, PgxId HC) {
        return this.runAnalysis(sessionContext, "pgx_builtin_k9_harmonic_centrality", new Argument[]{Argument.createGraphArg(G), Argument.createNodePropertyArg(HC)}, Void.class, ParallelismCharacteristic.PARALLEL);
    }

    public synchronized PgxFuture<Void> pgxBuiltinL1WhomToFollow(SessionContext sessionContext, PgxId G, Object source, int top_k, int circle_of_trust, int max_iter, double tol, double damping_factor, int salsa_max_iter, double salsa_tol, PgxId hubs, PgxId auths) {
        return this.runAnalysis(sessionContext, "pgx_builtin_l1_whom_to_follow", new Argument[]{Argument.createGraphArg(G), Argument.createNodeIdInArg(source), Argument.createIntInArg(top_k), Argument.createIntInArg(circle_of_trust), Argument.createIntInArg(max_iter), Argument.createDoubleInArg(tol), Argument.createDoubleInArg(damping_factor), Argument.createIntInArg(salsa_max_iter), Argument.createDoubleInArg(salsa_tol), Argument.createCollectionArg(hubs), Argument.createCollectionArg(auths)}, Void.class, ParallelismCharacteristic.PARALLEL);
    }

    public synchronized PgxFuture<Void> pgxBuiltinM1aPropertyCountLong(SessionContext sessionContext, PgxId G, PgxId property, PgxId propertyCount) {
        return this.runAnalysis(sessionContext, "pgx_builtin_m1a_property_count_long", new Argument[]{Argument.createGraphArg(G), Argument.createNodePropertyArg(property), Argument.createNodePropertyArg(propertyCount)}, Void.class, ParallelismCharacteristic.PARALLEL);
    }

    public synchronized PgxFuture<Void> pgxBuiltinM1bPropertyCountInt(SessionContext sessionContext, PgxId G, PgxId property, PgxId propertyCount) {
        return this.runAnalysis(sessionContext, "pgx_builtin_m1b_property_count_int", new Argument[]{Argument.createGraphArg(G), Argument.createNodePropertyArg(property), Argument.createNodePropertyArg(propertyCount)}, Void.class, ParallelismCharacteristic.PARALLEL);
    }

    public synchronized PgxFuture<Boolean> pgxBuiltinO10AllReachableVerticesEdges(SessionContext sessionContext, PgxId G, Object src, Object dst, int k, PgxId verticesOnPath, PgxId edgesOnPath, String f_dist) {
        return this.runAnalysis(sessionContext, "pgx_builtin_o10_all_reachable_vertices_edges", new Argument[]{Argument.createGraphArg(G), Argument.createNodeIdInArg(src), Argument.createNodeIdInArg(dst), Argument.createIntInArg(k), Argument.createCollectionArg(verticesOnPath), Argument.createCollectionArg(edgesOnPath), Argument.createMapArg(f_dist)}, Boolean.class, ParallelismCharacteristic.PARALLEL);
    }

    public synchronized PgxFuture<Boolean> pgxBuiltinO11AllReachableVerticesEdgesFiltered(SessionContext sessionContext, PgxId G, Object src, Object dst, int k, GraphFilter filter, PgxId verticesOnPath, PgxId edgesOnPath, String f_dist) {
        return this.runAnalysis(sessionContext, "pgx_builtin_o11_all_reachable_vertices_edges_filtered", new Argument[]{Argument.createGraphArg(G), Argument.createNodeIdInArg(src), Argument.createNodeIdInArg(dst), Argument.createIntInArg(k), Argument.createGenericFilterArg(filter), Argument.createCollectionArg(verticesOnPath), Argument.createCollectionArg(edgesOnPath), Argument.createMapArg(f_dist)}, Boolean.class, ParallelismCharacteristic.PARALLEL);
    }

    public synchronized PgxFuture<Void> pgxBuiltinO12EnumerateSimplePaths(SessionContext sessionContext, PgxId G, Object src, Object dst, int k, PgxId verticesOnPath, PgxId edgesOnPath, String f_dist, PgxId pathLengths, PgxId pathVertices, PgxId pathEdges) {
        return this.runAnalysis(sessionContext, "pgx_builtin_o12_enumerate_simple_paths", new Argument[]{Argument.createGraphArg(G), Argument.createNodeIdInArg(src), Argument.createNodeIdInArg(dst), Argument.createIntInArg(k), Argument.createCollectionArg(verticesOnPath), Argument.createCollectionArg(edgesOnPath), Argument.createMapArg(f_dist), Argument.createCollectionArg(pathLengths), Argument.createCollectionArg(pathVertices), Argument.createCollectionArg(pathEdges)}, Void.class, ParallelismCharacteristic.SEQUENTIAL);
    }

    public synchronized PgxFuture<Void> pgxBuiltinO1FilteredBfs(SessionContext sessionContext, PgxId G, Object root, boolean init_with_inf, VertexFilter filter, VertexFilter navigator, int max_depth, PgxId dist, PgxId parent) {
        return this.runAnalysis(sessionContext, "pgx_builtin_o1_filtered_bfs", new Argument[]{Argument.createGraphArg(G), Argument.createNodeIdInArg(root), Argument.createBooleanInArg(init_with_inf), Argument.createGenericFilterArg((GraphFilter)filter), Argument.createGenericFilterArg((GraphFilter)navigator), Argument.createIntInArg(max_depth), Argument.createNodePropertyArg(dist), Argument.createNodePropertyArg(parent)}, Void.class, ParallelismCharacteristic.PARALLEL);
    }

    public synchronized PgxFuture<Void> pgxBuiltinO2FilteredDfs(SessionContext sessionContext, PgxId G, Object root, boolean init_with_inf, VertexFilter filter, VertexFilter navigator, int max_depth, PgxId dist, PgxId parent) {
        return this.runAnalysis(sessionContext, "pgx_builtin_o2_filtered_dfs", new Argument[]{Argument.createGraphArg(G), Argument.createNodeIdInArg(root), Argument.createBooleanInArg(init_with_inf), Argument.createGenericFilterArg((GraphFilter)filter), Argument.createGenericFilterArg((GraphFilter)navigator), Argument.createIntInArg(max_depth), Argument.createNodePropertyArg(dist), Argument.createNodePropertyArg(parent)}, Void.class, ParallelismCharacteristic.PARALLEL);
    }

    public synchronized PgxFuture<Void> pgxBuiltinO6ComputeSupernodes(SessionContext sessionContext, PgxId g, int k, String superNodeMapping, PgxId superNodes) {
        return this.runAnalysis(sessionContext, "pgx_builtin_o6_compute_supernodes", new Argument[]{Argument.createGraphArg(g), Argument.createIntInArg(k), Argument.createMapArg(superNodeMapping), Argument.createCollectionArg(superNodes)}, Void.class, ParallelismCharacteristic.SEQUENTIAL);
    }

    public synchronized PgxFuture<Void> pgxBuiltinO7ComputeDistanceIndex(SessionContext sessionContext, PgxId g, int k, String superNodeMapping, PgxId superNodes, PgxId distances) {
        return this.runAnalysis(sessionContext, "pgx_builtin_o7_compute_distance_index", new Argument[]{Argument.createGraphArg(g), Argument.createIntInArg(k), Argument.createMapArg(superNodeMapping), Argument.createCollectionArg(superNodes), Argument.createNodePropertyArg(distances)}, Void.class, ParallelismCharacteristic.PARALLEL);
    }

    public synchronized PgxFuture<Integer> pgxBuiltinO8LimitedPathFindingUndirected(SessionContext sessionContext, PgxId g, Object src, Object dst, int k, int maxHopsArg, PgxId superNodes, String superNodeMapping, PgxId distances, PgxId path, PgxId pathEdges) {
        return this.runAnalysis(sessionContext, "pgx_builtin_o8_limited_path_finding_undirected", new Argument[]{Argument.createGraphArg(g), Argument.createNodeIdInArg(src), Argument.createNodeIdInArg(dst), Argument.createIntInArg(k), Argument.createIntInArg(maxHopsArg), Argument.createCollectionArg(superNodes), Argument.createMapArg(superNodeMapping), Argument.createNodePropertyArg(distances), Argument.createCollectionArg(path), Argument.createCollectionArg(pathEdges)}, Integer.class, ParallelismCharacteristic.SEQUENTIAL);
    }

    public synchronized PgxFuture<Integer> pgxBuiltinO9LimitedPathFindingUndirectedFiltered(SessionContext sessionContext, PgxId g, Object src, Object dst, int k, int maxHopsArg, PgxId superNodes, String superNodeMapping, PgxId distances, GraphFilter filter, PgxId path, PgxId pathEdges) {
        return this.runAnalysis(sessionContext, "pgx_builtin_o9_limited_path_finding_undirected_filtered", new Argument[]{Argument.createGraphArg(g), Argument.createNodeIdInArg(src), Argument.createNodeIdInArg(dst), Argument.createIntInArg(k), Argument.createIntInArg(maxHopsArg), Argument.createCollectionArg(superNodes), Argument.createMapArg(superNodeMapping), Argument.createNodePropertyArg(distances), Argument.createGenericFilterArg(filter), Argument.createCollectionArg(path), Argument.createCollectionArg(pathEdges)}, Integer.class, ParallelismCharacteristic.SEQUENTIAL);
    }

    public synchronized PgxFuture<Boolean> pgxBuiltinP1aSingleSourceSingleDestinationDijkstra(SessionContext sessionContext, PgxId G, PgxId weight, Object root, Object dest, PgxId parent, PgxId parent_edge) {
        return this.runAnalysis(sessionContext, "pgx_builtin_p1a_single_source_single_destination_dijkstra", new Argument[]{Argument.createGraphArg(G), Argument.createEdgePropertyArg(weight), Argument.createNodeIdInArg(root), Argument.createNodeIdInArg(dest), Argument.createNodePropertyArg(parent), Argument.createNodePropertyArg(parent_edge)}, Boolean.class, ParallelismCharacteristic.SEQUENTIAL);
    }

    public synchronized PgxFuture<Boolean> pgxBuiltinP1auSingleSourceSingleDestinationDijkstraUndirected(SessionContext sessionContext, PgxId G, PgxId weight, Object root, Object dest, PgxId parent, PgxId parent_edge) {
        return this.runAnalysis(sessionContext, "pgx_builtin_p1au_single_source_single_destination_dijkstra_undirected", new Argument[]{Argument.createGraphArg(G), Argument.createEdgePropertyArg(weight), Argument.createNodeIdInArg(root), Argument.createNodeIdInArg(dest), Argument.createNodePropertyArg(parent), Argument.createNodePropertyArg(parent_edge)}, Boolean.class, ParallelismCharacteristic.SEQUENTIAL);
    }

    public synchronized PgxFuture<Boolean> pgxBuiltinP1bSingleSourceSingleDestinationFilteredDijkstra(SessionContext sessionContext, PgxId G, PgxId weight, Object root, Object dest, GraphFilter filter, PgxId parent, PgxId parent_edge) {
        return this.runAnalysis(sessionContext, "pgx_builtin_p1b_single_source_single_destination_filtered_dijkstra", new Argument[]{Argument.createGraphArg(G), Argument.createEdgePropertyArg(weight), Argument.createNodeIdInArg(root), Argument.createNodeIdInArg(dest), Argument.createGenericFilterArg(filter), Argument.createNodePropertyArg(parent), Argument.createNodePropertyArg(parent_edge)}, Boolean.class, ParallelismCharacteristic.SEQUENTIAL);
    }

    public synchronized PgxFuture<Boolean> pgxBuiltinP1buSingleSourceSingleDestinationFilteredDijkstraUndirected(SessionContext sessionContext, PgxId G, PgxId weight, Object root, Object dest, GraphFilter filter, PgxId parent, PgxId parent_edge) {
        return this.runAnalysis(sessionContext, "pgx_builtin_p1bu_single_source_single_destination_filtered_dijkstra_undirected", new Argument[]{Argument.createGraphArg(G), Argument.createEdgePropertyArg(weight), Argument.createNodeIdInArg(root), Argument.createNodeIdInArg(dest), Argument.createGenericFilterArg(filter), Argument.createNodePropertyArg(parent), Argument.createNodePropertyArg(parent_edge)}, Boolean.class, ParallelismCharacteristic.SEQUENTIAL);
    }

    public synchronized PgxFuture<Boolean> pgxBuiltinP2SingleSourceSingleDestinationBidirectionalDijkstra(SessionContext sessionContext, PgxId G, PgxId weight, Object src, Object dst, PgxId parent, PgxId parent_edge) {
        return this.runAnalysis(sessionContext, "pgx_builtin_p2_single_source_single_destination_bidirectional_dijkstra", new Argument[]{Argument.createGraphArg(G), Argument.createEdgePropertyArg(weight), Argument.createNodeIdInArg(src), Argument.createNodeIdInArg(dst), Argument.createNodePropertyArg(parent), Argument.createNodePropertyArg(parent_edge)}, Boolean.class, ParallelismCharacteristic.SEQUENTIAL);
    }

    public synchronized PgxFuture<Boolean> pgxBuiltinP2bSingleSourceSingleDestinationFilteredBidirectionalDijkstra(SessionContext sessionContext, PgxId G, PgxId weight, Object src, Object dst, GraphFilter filter, PgxId parent, PgxId parent_edge) {
        return this.runAnalysis(sessionContext, "pgx_builtin_p2b_single_source_single_destination_filtered_bidirectional_dijkstra", new Argument[]{Argument.createGraphArg(G), Argument.createEdgePropertyArg(weight), Argument.createNodeIdInArg(src), Argument.createNodeIdInArg(dst), Argument.createGenericFilterArg(filter), Argument.createNodePropertyArg(parent), Argument.createNodePropertyArg(parent_edge)}, Boolean.class, ParallelismCharacteristic.PARALLEL);
    }

    public synchronized PgxFuture<Boolean> pgxBuiltinP2buSingleSourceSingleDestinationFilteredBidirectionalDijkstraUndirected(SessionContext sessionContext, PgxId G, PgxId weight, Object src, Object dst, GraphFilter filter, PgxId parent, PgxId parent_edge) {
        return this.runAnalysis(sessionContext, "pgx_builtin_p2bu_single_source_single_destination_filtered_bidirectional_dijkstra_undirected", new Argument[]{Argument.createGraphArg(G), Argument.createEdgePropertyArg(weight), Argument.createNodeIdInArg(src), Argument.createNodeIdInArg(dst), Argument.createGenericFilterArg(filter), Argument.createNodePropertyArg(parent), Argument.createNodePropertyArg(parent_edge)}, Boolean.class, ParallelismCharacteristic.PARALLEL);
    }

    public synchronized PgxFuture<Boolean> pgxBuiltinP2uSingleSourceSingleDestinationBidirectionalDijkstraUndirected(SessionContext sessionContext, PgxId G, PgxId weight, Object src, Object dst, PgxId parent, PgxId parent_edge) {
        return this.runAnalysis(sessionContext, "pgx_builtin_p2u_single_source_single_destination_bidirectional_dijkstra_undirected", new Argument[]{Argument.createGraphArg(G), Argument.createEdgePropertyArg(weight), Argument.createNodeIdInArg(src), Argument.createNodeIdInArg(dst), Argument.createNodePropertyArg(parent), Argument.createNodePropertyArg(parent_edge)}, Boolean.class, ParallelismCharacteristic.SEQUENTIAL);
    }

    public synchronized PgxFuture<Void> pgxBuiltinP3SingleSourceAllDestinationsBellmanFord(SessionContext sessionContext, PgxId G, PgxId len, Object root, PgxId dist, PgxId prev, PgxId prev_edge) {
        return this.runAnalysis(sessionContext, "pgx_builtin_p3_single_source_all_destinations_bellman_ford", new Argument[]{Argument.createGraphArg(G), Argument.createEdgePropertyArg(len), Argument.createNodeIdInArg(root), Argument.createNodePropertyArg(dist), Argument.createNodePropertyArg(prev), Argument.createNodePropertyArg(prev_edge)}, Void.class, ParallelismCharacteristic.PARALLEL);
    }

    public synchronized PgxFuture<Void> pgxBuiltinP3rSingleSourceAllDestinationsBellmanFordReverse(SessionContext sessionContext, PgxId G, PgxId len, Object root, PgxId dist, PgxId prev, PgxId prev_edge) {
        return this.runAnalysis(sessionContext, "pgx_builtin_p3r_single_source_all_destinations_bellman_ford_reverse", new Argument[]{Argument.createGraphArg(G), Argument.createEdgePropertyArg(len), Argument.createNodeIdInArg(root), Argument.createNodePropertyArg(dist), Argument.createNodePropertyArg(prev), Argument.createNodePropertyArg(prev_edge)}, Void.class, ParallelismCharacteristic.PARALLEL);
    }

    public synchronized PgxFuture<Void> pgxBuiltinP3uSingleSourceAllDestinationsBellmanFord(SessionContext sessionContext, PgxId G, PgxId len, Object root, PgxId dist, PgxId prev, PgxId prev_edge) {
        return this.runAnalysis(sessionContext, "pgx_builtin_p3u_single_source_all_destinations_bellman_ford", new Argument[]{Argument.createGraphArg(G), Argument.createEdgePropertyArg(len), Argument.createNodeIdInArg(root), Argument.createNodePropertyArg(dist), Argument.createNodePropertyArg(prev), Argument.createNodePropertyArg(prev_edge)}, Void.class, ParallelismCharacteristic.PARALLEL);
    }

    public synchronized PgxFuture<Void> pgxBuiltinP4SingleSourceAllDestinationsHopDistance(SessionContext sessionContext, PgxId G, Object root, PgxId dist, PgxId prev, PgxId prev_edge) {
        return this.runAnalysis(sessionContext, "pgx_builtin_p4_single_source_all_destinations_hop_distance", new Argument[]{Argument.createGraphArg(G), Argument.createNodeIdInArg(root), Argument.createNodePropertyArg(dist), Argument.createNodePropertyArg(prev), Argument.createNodePropertyArg(prev_edge)}, Void.class, ParallelismCharacteristic.PARALLEL);
    }

    public synchronized PgxFuture<Void> pgxBuiltinP4rSingleSourceAllDestinationsHopDistanceReverse(SessionContext sessionContext, PgxId G, Object root, PgxId dist, PgxId prev, PgxId prev_edge) {
        return this.runAnalysis(sessionContext, "pgx_builtin_p4r_single_source_all_destinations_hop_distance_reverse", new Argument[]{Argument.createGraphArg(G), Argument.createNodeIdInArg(root), Argument.createNodePropertyArg(dist), Argument.createNodePropertyArg(prev), Argument.createNodePropertyArg(prev_edge)}, Void.class, ParallelismCharacteristic.PARALLEL);
    }

    public synchronized PgxFuture<Void> pgxBuiltinP5FattestPath(SessionContext sessionContext, PgxId G, PgxId capacity, Object root, PgxId parent_node, PgxId parent_edge, PgxId fat) {
        return this.runAnalysis(sessionContext, "pgx_builtin_p5_fattest_path", new Argument[]{Argument.createGraphArg(G), Argument.createEdgePropertyArg(capacity), Argument.createNodeIdInArg(root), Argument.createNodePropertyArg(parent_node), Argument.createNodePropertyArg(parent_edge), Argument.createNodePropertyArg(fat)}, Void.class, ParallelismCharacteristic.SEQUENTIAL);
    }

    public synchronized PgxFuture<Void> pgxBuiltinP4uSingleSourceAllDestinationsHopDistanceUndirected(SessionContext sessionContext, PgxId G, Object root, PgxId dist, PgxId prev, PgxId prev_edge) {
        return this.runAnalysis(sessionContext, "pgx_builtin_p4u_single_source_all_destinations_hop_distance_undirected", new Argument[]{Argument.createGraphArg(G), Argument.createNodeIdInArg(root), Argument.createNodePropertyArg(dist), Argument.createNodePropertyArg(prev), Argument.createNodePropertyArg(prev_edge)}, Void.class, ParallelismCharacteristic.PARALLEL);
    }

    public synchronized PgxFuture<Void> pgxBuiltinP5uFattestPathUndirected(SessionContext sessionContext, PgxId G, PgxId capacity, Object root, PgxId parent_node, PgxId parent_edge, PgxId fat) {
        return this.runAnalysis(sessionContext, "pgx_builtin_p5u_fattest_path_undirected", new Argument[]{Argument.createGraphArg(G), Argument.createEdgePropertyArg(capacity), Argument.createNodeIdInArg(root), Argument.createNodePropertyArg(parent_node), Argument.createNodePropertyArg(parent_edge), Argument.createNodePropertyArg(fat)}, Void.class, ParallelismCharacteristic.SEQUENTIAL);
    }

    public synchronized PgxFuture<Void> pgxBuiltinR1bSalsa(SessionContext sessionContext, PgxId G, PgxId is_left, double tol, int max_iter, PgxId rank) {
        return this.runAnalysis(sessionContext, "pgx_builtin_r1b_salsa", new Argument[]{Argument.createGraphArg(G), Argument.createNodePropertyArg(is_left), Argument.createDoubleInArg(tol), Argument.createIntInArg(max_iter), Argument.createNodePropertyArg(rank)}, Void.class, ParallelismCharacteristic.PARALLEL);
    }

    public synchronized PgxFuture<Void> pgxBuiltinR2PersonalizedSalsa(SessionContext sessionContext, PgxId G, Object v, PgxId is_left, double damp, double tol, int max_iter, PgxId rank) {
        return this.runAnalysis(sessionContext, "pgx_builtin_r2_personalized_salsa", new Argument[]{Argument.createGraphArg(G), Argument.createNodeIdInArg(v), Argument.createNodePropertyArg(is_left), Argument.createDoubleInArg(damp), Argument.createDoubleInArg(tol), Argument.createIntInArg(max_iter), Argument.createNodePropertyArg(rank)}, Void.class, ParallelismCharacteristic.PARALLEL);
    }

    public synchronized PgxFuture<Double> pgxBuiltinR2aMatrixFactorizationTraining(SessionContext sessionContext, PgxId G, PgxId is_left, PgxId weight, double learning_rate, double change_per_step, double lambda, int max_step, int vector_length, PgxId dest_property) {
        return this.runAnalysis(sessionContext, "pgx_builtin_r2a_matrix_factorization_training", new Argument[]{Argument.createGraphArg(G), Argument.createNodePropertyArg(is_left), Argument.createEdgePropertyArg(weight), Argument.createDoubleInArg(learning_rate), Argument.createDoubleInArg(change_per_step), Argument.createDoubleInArg(lambda), Argument.createIntInArg(max_step), Argument.createIntInArg(vector_length), Argument.createNodePropertyArg(dest_property)}, Double.class, ParallelismCharacteristic.PARALLEL);
    }

    public synchronized PgxFuture<Void> pgxBuiltinR2bMatrixFactorizationRecommendations(SessionContext sessionContext, PgxId G, Object user, PgxId is_left, int vector_length, PgxId feature, PgxId estimated_rating) {
        return this.runAnalysis(sessionContext, "pgx_builtin_r2b_matrix_factorization_recommendations", new Argument[]{Argument.createGraphArg(G), Argument.createNodeIdInArg(user), Argument.createNodePropertyArg(is_left), Argument.createIntInArg(vector_length), Argument.createNodePropertyArg(feature), Argument.createNodePropertyArg(estimated_rating)}, Void.class, ParallelismCharacteristic.PARALLEL);
    }

    public synchronized PgxFuture<Void> pgxBuiltinR3PersonalizedSalsaFromSet(SessionContext sessionContext, PgxId G, PgxId source, PgxId is_left, double damp, double tol, int max_iter, PgxId rank) {
        return this.runAnalysis(sessionContext, "pgx_builtin_r3_personalized_salsa_from_set", new Argument[]{Argument.createGraphArg(G), Argument.createCollectionArg(source), Argument.createNodePropertyArg(is_left), Argument.createDoubleInArg(damp), Argument.createDoubleInArg(tol), Argument.createIntInArg(max_iter), Argument.createNodePropertyArg(rank)}, Void.class, ParallelismCharacteristic.PARALLEL);
    }

    public synchronized PgxFuture<Boolean> pgxBuiltinS10BipartiteCheck(SessionContext sessionContext, PgxId G, PgxId is_left) {
        return this.runAnalysis(sessionContext, "pgx_builtin_s10_bipartite_check", new Argument[]{Argument.createGraphArg(G), Argument.createNodePropertyArg(is_left)}, Boolean.class, ParallelismCharacteristic.PARALLEL);
    }

    public synchronized PgxFuture<Integer> pgxBuiltinS11Diameter(SessionContext sessionContext, PgxId G, boolean diameterOn, PgxId eccentricity) {
        return this.runAnalysis(sessionContext, "pgx_builtin_s11_diameter", new Argument[]{Argument.createGraphArg(G), Argument.createBooleanInArg(diameterOn), Argument.createNodePropertyArg(eccentricity)}, Integer.class, ParallelismCharacteristic.PARALLEL);
    }

    public synchronized PgxFuture<Void> pgxBuiltinS12Periphery(SessionContext sessionContext, PgxId G, boolean peripheryOn, PgxId periphery) {
        return this.runAnalysis(sessionContext, "pgx_builtin_s12_periphery", new Argument[]{Argument.createGraphArg(G), Argument.createBooleanInArg(peripheryOn), Argument.createCollectionArg(periphery)}, Void.class, ParallelismCharacteristic.PARALLEL);
    }

    public synchronized PgxFuture<Void> pgxBuiltinS13LocalClusteringCoefficient(SessionContext sessionContext, PgxId G, PgxId lcc) {
        return this.runAnalysis(sessionContext, "pgx_builtin_s13_local_clustering_coefficient", new Argument[]{Argument.createGraphArg(G), Argument.createNodePropertyArg(lcc)}, Void.class, ParallelismCharacteristic.PARALLEL);
    }

    public synchronized PgxFuture<Void> pgxBuiltinS13dLocalClusteringCoefficient(SessionContext sessionContext, PgxId G, PgxId lcc) {
        return this.runAnalysis(sessionContext, "pgx_builtin_s13d_local_clustering_coefficient", new Argument[]{Argument.createGraphArg(G), Argument.createNodePropertyArg(lcc)}, Void.class, ParallelismCharacteristic.PARALLEL);
    }

    public synchronized PgxFuture<Void> pgxBuiltinS13uLocalClusteringCoefficient(SessionContext sessionContext, PgxId G, PgxId lcc) {
        return this.runAnalysis(sessionContext, "pgx_builtin_s13u_local_clustering_coefficient", new Argument[]{Argument.createGraphArg(G), Argument.createNodePropertyArg(lcc)}, Void.class, ParallelismCharacteristic.PARALLEL);
    }

    public synchronized PgxFuture<Boolean> pgxBuiltinS14aFindCycle(SessionContext sessionContext, PgxId G, PgxId cycle_nodes, PgxId cycle_edges) {
        return this.runAnalysis(sessionContext, "pgx_builtin_s14a_find_cycle", new Argument[]{Argument.createGraphArg(G), Argument.createCollectionArg(cycle_nodes), Argument.createCollectionArg(cycle_edges)}, Boolean.class, ParallelismCharacteristic.PARALLEL);
    }

    public synchronized PgxFuture<Boolean> pgxBuiltinS14bFindCycleFromNode(SessionContext sessionContext, PgxId G, Object s, PgxId cycle_nodes, PgxId cycle_edges) {
        return this.runAnalysis(sessionContext, "pgx_builtin_s14b_find_cycle_from_node", new Argument[]{Argument.createGraphArg(G), Argument.createNodeIdInArg(s), Argument.createCollectionArg(cycle_nodes), Argument.createCollectionArg(cycle_edges)}, Boolean.class, ParallelismCharacteristic.PARALLEL);
    }

    public synchronized PgxFuture<Integer> pgxBuiltinS15aReachability(SessionContext sessionContext, PgxId G, Object source, Object dest, int maxHops) {
        return this.runAnalysis(sessionContext, "pgx_builtin_s15a_reachability", new Argument[]{Argument.createGraphArg(G), Argument.createNodeIdInArg(source), Argument.createNodeIdInArg(dest), Argument.createIntInArg(maxHops)}, Integer.class, ParallelismCharacteristic.PARALLEL);
    }

    public synchronized PgxFuture<Integer> pgxBuiltinS15bReachabilityUndirected(SessionContext sessionContext, PgxId G, Object source, Object dest, int maxHops) {
        return this.runAnalysis(sessionContext, "pgx_builtin_s15b_reachability_undirected", new Argument[]{Argument.createGraphArg(G), Argument.createNodeIdInArg(source), Argument.createNodeIdInArg(dest), Argument.createIntInArg(maxHops)}, Integer.class, ParallelismCharacteristic.PARALLEL);
    }

    public synchronized PgxFuture<Boolean> pgxBuiltinS16aTopologicalSort(SessionContext sessionContext, PgxId G, PgxId top_order) {
        return this.runAnalysis(sessionContext, "pgx_builtin_s16a_topological_sort", new Argument[]{Argument.createGraphArg(G), Argument.createNodePropertyArg(top_order)}, Boolean.class, ParallelismCharacteristic.PARALLEL);
    }

    public synchronized PgxFuture<Void> pgxBuiltinS16bTopologicalSchedule(SessionContext sessionContext, PgxId G, PgxId source, PgxId top_sched) {
        return this.runAnalysis(sessionContext, "pgx_builtin_s16b_topological_schedule", new Argument[]{Argument.createGraphArg(G), Argument.createCollectionArg(source), Argument.createNodePropertyArg(top_sched)}, Void.class, ParallelismCharacteristic.PARALLEL);
    }

    public synchronized PgxFuture<Long> pgxBuiltinS1TriangleCounting(SessionContext sessionContext, PgxId G) {
        return this.runAnalysis(sessionContext, "pgx_builtin_s1_triangle_counting", new Argument[]{Argument.createGraphArg(G)}, Long.class, ParallelismCharacteristic.PARALLEL);
    }

    public synchronized PgxFuture<Long> pgxBuiltinS1bTriangleCountingUndirected(SessionContext sessionContext, PgxId G) {
        return this.runAnalysis(sessionContext, "pgx_builtin_s1b_triangle_counting_undirected", new Argument[]{Argument.createGraphArg(G)}, Long.class, ParallelismCharacteristic.PARALLEL);
    }

    public synchronized PgxFuture<Void> pgxBuiltinS2AdamicAdarCounting(SessionContext sessionContext, PgxId G, PgxId aa) {
        return this.runAnalysis(sessionContext, "pgx_builtin_s2_adamic_adar_counting", new Argument[]{Argument.createGraphArg(G), Argument.createEdgePropertyArg(aa)}, Void.class, ParallelismCharacteristic.PARALLEL);
    }

    public synchronized PgxFuture<Void> pgxBuiltinS2dAdamicAdarCounting(SessionContext sessionContext, PgxId G, PgxId aa) {
        return this.runAnalysis(sessionContext, "pgx_builtin_s2d_adamic_adar_counting", new Argument[]{Argument.createGraphArg(G), Argument.createEdgePropertyArg(aa)}, Void.class, ParallelismCharacteristic.PARALLEL);
    }

    public synchronized PgxFuture<Double> pgxBuiltinS3Conductance(SessionContext sessionContext, PgxId G, PgxId member, long num) {
        return this.runAnalysis(sessionContext, "pgx_builtin_s3_conductance", new Argument[]{Argument.createGraphArg(G), Argument.createNodePropertyArg(member), Argument.createLongInArg(num)}, Double.class, ParallelismCharacteristic.PARALLEL);
    }

    public synchronized PgxFuture<Double> pgxBuiltinS4PartitionModularity(SessionContext sessionContext, PgxId G, PgxId member, long num_comp) {
        return this.runAnalysis(sessionContext, "pgx_builtin_s4_partition_modularity", new Argument[]{Argument.createGraphArg(G), Argument.createNodePropertyArg(member), Argument.createLongInArg(num_comp)}, Double.class, ParallelismCharacteristic.PARALLEL);
    }

    public synchronized PgxFuture<Double> pgxBuiltinS5PartitionConductance(SessionContext sessionContext, PgxId G, PgxId member, long num_comp, String min_cond) {
        return this.runAnalysis(sessionContext, "pgx_builtin_s5_partition_conductance", new Argument[]{Argument.createGraphArg(G), Argument.createNodePropertyArg(member), Argument.createLongInArg(num_comp), Argument.createDoubleOutArg(min_cond)}, Double.class, ParallelismCharacteristic.PARALLEL);
    }

    public synchronized PgxFuture<Void> pgxBuiltinS6OutDegreeDistribution(SessionContext sessionContext, PgxId G, String distribution) {
        return this.runAnalysis(sessionContext, "pgx_builtin_s6_out_degree_distribution", new Argument[]{Argument.createGraphArg(G), Argument.createMapArg(distribution)}, Void.class, ParallelismCharacteristic.SEQUENTIAL);
    }

    public synchronized PgxFuture<Void> pgxBuiltinS7InDegreeDistribution(SessionContext sessionContext, PgxId G, String distribution) {
        return this.runAnalysis(sessionContext, "pgx_builtin_s7_in_degree_distribution", new Argument[]{Argument.createGraphArg(G), Argument.createMapArg(distribution)}, Void.class, ParallelismCharacteristic.SEQUENTIAL);
    }

    public synchronized PgxFuture<Void> pgxBuiltinS8Sparsification(SessionContext sessionContext, PgxId G, double e, PgxId keepCount, PgxId sim) {
        return this.runAnalysis(sessionContext, "pgx_builtin_s8_sparsification", new Argument[]{Argument.createGraphArg(G), Argument.createDoubleInArg(e), Argument.createNodePropertyArg(keepCount), Argument.createEdgePropertyArg(sim)}, Void.class, ParallelismCharacteristic.PARALLEL);
    }

    public synchronized PgxFuture<Long> pgxBuiltinS9Kcore(SessionContext sessionContext, PgxId G, long min_core, long max_core, PgxId k_core) {
        return this.runAnalysis(sessionContext, "pgx_builtin_s9_kcore", new Argument[]{Argument.createGraphArg(G), Argument.createLongInArg(min_core), Argument.createLongInArg(max_core), Argument.createNodePropertyArg(k_core)}, Long.class, ParallelismCharacteristic.PARALLEL);
    }

    public static enum Type {
        PGX_BUILTIN_A1_PRIM,
        PGX_BUILTIN_A1U_PRIM,
        PGX_BUILTIN_C1_COMMUNITY_DETECTION_LABEL_PROPAGATION,
        PGX_BUILTIN_C2_COMMUNITY_DETECTION_CONDUCTANCE_MINIMIZATION,
        PGX_BUILTIN_C3_INFOMAP,
        PGX_BUILTIN_C4_LOUVAIN,
        PGX_BUILTIN_C4B_LOUVAIN_DIRECTED,
        PGX_BUILTIN_C5_SPEAKER_LISTENER_LABEL_PROPAGATION,
        PGX_BUILTIN_C5B_FILTERED_SPEAKER_LISTENER_LABEL_PROPAGATION,
        PGX_BUILTIN_C5C_FILTERED_WEIGHTED_SPEAKER_LISTENER_LABEL_PROPAGATION,
        PGX_BUILTIN_C6_WEIGHTED_SPEAKER_LISTENER_LABEL_PROPAGATION,
        PGX_BUILTIN_G2A_STRONGLY_CONNECTED_COMPONENTS_KOSARAJU,
        PGX_BUILTIN_G2B_STRONGLY_CONNECTED_COMPONENTS_TARJAN,
        PGX_BUILTIN_G3_WEAKLY_CONNECTED_COMPONENTS,
        PGX_BUILTIN_K10_ARTICLE_RANK,
        PGX_BUILTIN_K1A_PAGERANK,
        PGX_BUILTIN_K1B_PAGERANK_APPROXIMATE,
        PGX_BUILTIN_K1C_PAGERANK_WEIGHTED,
        PGX_BUILTIN_K2_PERSONALIZED_PAGERANK,
        PGX_BUILTIN_K2B_PERSONALIZED_PAGERANK_FROM_SET,
        PGX_BUILTIN_K2C_PERSONALIZED_WEIGHTED_PAGERANK,
        PGX_BUILTIN_K2D_PERSONALIZED_WEIGHTED_PAGERANK_FROM_SET,
        PGX_BUILTIN_K3A_NODE_BETWEENNESS_CENTRALITY,
        PGX_BUILTIN_K3B_APPROX_NODE_BETWEENNESS_CENTRALITY,
        PGX_BUILTIN_K3C_APPROX_NODE_BETWEENNESS_CENTRALITY_FROM_SEEDS,
        PGX_BUILTIN_K4A_CLOSENESS_CENTRALITY_UNIT_LENGTH,
        PGX_BUILTIN_K4B_CLOSENESS_CENTRALITY_DOUBLE_LENGTH,
        PGX_BUILTIN_K5_HITS,
        PGX_BUILTIN_K6_EIGENVECTOR_CENTRALITY,
        PGX_BUILTIN_K7A_OUTDEGREE_CENTRALITY,
        PGX_BUILTIN_K7B_INDEGREE_CENTRALITY,
        PGX_BUILTIN_K7C_DEGREE_CENTRALITY,
        PGX_BUILTIN_K8_RANDOM_WALK_WITH_RESTART,
        PGX_BUILTIN_K9_HARMONIC_CENTRALITY,
        PGX_BUILTIN_L1_WHOM_TO_FOLLOW,
        PGX_BUILTIN_M1A_PROPERTY_COUNT_LONG,
        PGX_BUILTIN_M1B_PROPERTY_COUNT_INT,
        PGX_BUILTIN_O10_ALL_REACHABLE_VERTICES_EDGES,
        PGX_BUILTIN_O11_ALL_REACHABLE_VERTICES_EDGES_FILTERED,
        PGX_BUILTIN_O12_ENUMERATE_SIMPLE_PATHS,
        PGX_BUILTIN_O1_FILTERED_BFS,
        PGX_BUILTIN_O2_FILTERED_DFS,
        PGX_BUILTIN_O6_COMPUTE_SUPERNODES,
        PGX_BUILTIN_O7_COMPUTE_DISTANCE_INDEX,
        PGX_BUILTIN_O8_LIMITED_PATH_FINDING_UNDIRECTED,
        PGX_BUILTIN_O9_LIMITED_PATH_FINDING_UNDIRECTED_FILTERED,
        PGX_BUILTIN_P1A_SINGLE_SOURCE_SINGLE_DESTINATION_DIJKSTRA,
        PGX_BUILTIN_P1AU_SINGLE_SOURCE_SINGLE_DESTINATION_DIJKSTRA_UNDIRECTED,
        PGX_BUILTIN_P1B_SINGLE_SOURCE_SINGLE_DESTINATION_FILTERED_DIJKSTRA,
        PGX_BUILTIN_P1BU_SINGLE_SOURCE_SINGLE_DESTINATION_FILTERED_DIJKSTRA_UNDIRECTED,
        PGX_BUILTIN_P2_SINGLE_SOURCE_SINGLE_DESTINATION_BIDIRECTIONAL_DIJKSTRA,
        PGX_BUILTIN_P2B_SINGLE_SOURCE_SINGLE_DESTINATION_FILTERED_BIDIRECTIONAL_DIJKSTRA,
        PGX_BUILTIN_P2BU_SINGLE_SOURCE_SINGLE_DESTINATION_FILTERED_BIDIRECTIONAL_DIJKSTRA_UNDIRECTED,
        PGX_BUILTIN_P2U_SINGLE_SOURCE_SINGLE_DESTINATION_BIDIRECTIONAL_DIJKSTRA_UNDIRECTED,
        PGX_BUILTIN_P3_SINGLE_SOURCE_ALL_DESTINATIONS_BELLMAN_FORD,
        PGX_BUILTIN_P3R_SINGLE_SOURCE_ALL_DESTINATIONS_BELLMAN_FORD_REVERSE,
        PGX_BUILTIN_P3U_SINGLE_SOURCE_ALL_DESTINATIONS_BELLMAN_FORD,
        PGX_BUILTIN_P4_SINGLE_SOURCE_ALL_DESTINATIONS_HOP_DISTANCE,
        PGX_BUILTIN_P4R_SINGLE_SOURCE_ALL_DESTINATIONS_HOP_DISTANCE_REVERSE,
        PGX_BUILTIN_P5_FATTEST_PATH,
        PGX_BUILTIN_P4U_SINGLE_SOURCE_ALL_DESTINATIONS_HOP_DISTANCE_UNDIRECTED,
        PGX_BUILTIN_P5U_FATTEST_PATH_UNDIRECTED,
        PGX_BUILTIN_R1B_SALSA,
        PGX_BUILTIN_R2_PERSONALIZED_SALSA,
        PGX_BUILTIN_R2A_MATRIX_FACTORIZATION_TRAINING,
        PGX_BUILTIN_R2B_MATRIX_FACTORIZATION_RECOMMENDATIONS,
        PGX_BUILTIN_R3_PERSONALIZED_SALSA_FROM_SET,
        PGX_BUILTIN_S10_BIPARTITE_CHECK,
        PGX_BUILTIN_S11_DIAMETER,
        PGX_BUILTIN_S12_PERIPHERY,
        PGX_BUILTIN_S13_LOCAL_CLUSTERING_COEFFICIENT,
        PGX_BUILTIN_S13D_LOCAL_CLUSTERING_COEFFICIENT,
        PGX_BUILTIN_S13U_LOCAL_CLUSTERING_COEFFICIENT,
        PGX_BUILTIN_S14A_FIND_CYCLE,
        PGX_BUILTIN_S14B_FIND_CYCLE_FROM_NODE,
        PGX_BUILTIN_S15A_REACHABILITY,
        PGX_BUILTIN_S15B_REACHABILITY_UNDIRECTED,
        PGX_BUILTIN_S16A_TOPOLOGICAL_SORT,
        PGX_BUILTIN_S16B_TOPOLOGICAL_SCHEDULE,
        PGX_BUILTIN_S1_TRIANGLE_COUNTING,
        PGX_BUILTIN_S1B_TRIANGLE_COUNTING_UNDIRECTED,
        PGX_BUILTIN_S2_ADAMIC_ADAR_COUNTING,
        PGX_BUILTIN_S2D_ADAMIC_ADAR_COUNTING,
        PGX_BUILTIN_S3_CONDUCTANCE,
        PGX_BUILTIN_S4_PARTITION_MODULARITY,
        PGX_BUILTIN_S5_PARTITION_CONDUCTANCE,
        PGX_BUILTIN_S6_OUT_DEGREE_DISTRIBUTION,
        PGX_BUILTIN_S7_IN_DEGREE_DISTRIBUTION,
        PGX_BUILTIN_S8_SPARSIFICATION,
        PGX_BUILTIN_S9_KCORE;


        public String getId() {
            return this.name().toLowerCase();
        }
    }
}

