/*
 * Decompiled with CFR 0.152.
 */
package oracle.pgx.api.frames.internal;

import java.io.PrintStream;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.function.Supplier;
import java.util.stream.Stream;
import oracle.pgx.api.PgqlResultSet;
import oracle.pgx.api.PgxFuture;
import oracle.pgx.api.PgxSession;
import oracle.pgx.api.SessionContext;
import oracle.pgx.api.frames.PgxFrame;
import oracle.pgx.api.frames.PgxFrameColumn;
import oracle.pgx.api.frames.PgxGenericFrameStorer;
import oracle.pgx.api.frames.functions.ColumnRenaming;
import oracle.pgx.api.frames.internal.PgxFrameColumnImpl;
import oracle.pgx.api.frames.internal.PgxFrameInternal;
import oracle.pgx.api.internal.Core;
import oracle.pgx.api.internal.FrameColumnMetaData;
import oracle.pgx.api.internal.FrameMetaData;
import oracle.pgx.api.internal.PgqlResultSetImpl;
import oracle.pgx.api.internal.PgqlResultSetProxy;
import oracle.pgx.common.PgxId;
import oracle.pgx.common.util.ErrorMessages;

public class PgxFrameImpl
extends PgxFrameInternal {
    private final PgxSession session;
    private final Core core;
    private FrameMetaData metaData;
    private final Supplier<String> keystorePathSupplier;
    private final Supplier<char[]> keystorePasswordSupplier;

    public PgxFrameImpl(PgxSession session, Core core, FrameMetaData frameMetaData, Supplier<String> keystorePathSupplier, Supplier<char[]> keystorePasswordSupplier) {
        this.session = session;
        this.core = core;
        this.metaData = frameMetaData;
        this.keystorePathSupplier = keystorePathSupplier;
        this.keystorePasswordSupplier = keystorePasswordSupplier;
    }

    @Override
    public FrameMetaData getMetaData() {
        return this.metaData;
    }

    @Override
    public PgxId getFrameId() {
        return this.metaData.getFrameUid();
    }

    @Override
    protected PgxFrameColumn[] getColumns() {
        return (PgxFrameColumn[])this.metaData.getColumnMetaDataMap().values().stream().map(this::columnFromMetaData).toArray(PgxFrameColumn[]::new);
    }

    @Override
    public PgxFrameColumn getColumn(String columnName) {
        FrameColumnMetaData columnMetaData = this.getColumnMetaData(columnName);
        return this.columnFromMetaData(columnMetaData);
    }

    private FrameColumnMetaData getColumnMetaData(String columnName) {
        return this.metaData.getColumnMetaDataMap().get(columnName);
    }

    @Override
    protected PgxFuture<PgxFrame> renameColumnsAsync(boolean inPlace, ColumnRenaming ... columnsWithRenamings) {
        HashMap<String, String> renamings = new HashMap<String, String>();
        for (ColumnRenaming renaming : columnsWithRenamings) {
            String inputColumnName = renaming.getColumnName();
            if (renamings.containsKey(inputColumnName)) {
                String previousRenaming = (String)renamings.get(inputColumnName);
                String newRenaming = renaming.getNewColumnName();
                throw new IllegalArgumentException(ErrorMessages.getMessage((String)"COLUMN_CAN_ONLY_BE_RENAMED_ONCE", (Object[])new Object[]{inputColumnName, previousRenaming, newRenaming}));
            }
            renamings.put(inputColumnName, renaming.getNewColumnName());
        }
        LinkedHashMap<String, String> columnMappings = new LinkedHashMap<String, String>();
        this.metaData.getColumnMetaDataMap().keySet().forEach(columnName -> columnMappings.put((String)columnName, renamings.getOrDefault(columnName, (String)columnName)));
        return this.selectAsync(inPlace, columnMappings);
    }

    @Override
    protected PgxFuture<PgxFrame> selectAsync(boolean inPlace, LinkedHashMap<String, String> columnMappings) {
        return this.core.selectFrame(this.getSessionContext(), this.metaData.getFrameUid(), columnMappings, inPlace).thenApply(newFrameMetaData -> this.modifyOrCreateFrame(inPlace, (FrameMetaData)((Object)newFrameMetaData)));
    }

    @Override
    public PgxFuture<PgxFrame> flattenAsync(boolean inPlace, String[] columns) {
        return this.core.flattenFrame(this.getSessionContext(), this.metaData.getFrameUid(), inPlace, columns).thenApply(newFrameMetaData -> this.modifyOrCreateFrame(inPlace, (FrameMetaData)((Object)newFrameMetaData)));
    }

    @Override
    protected PgxFuture<PgxFrame> headAsync(boolean inPlace, long numRows) {
        return this.core.frameHead(this.getSessionContext(), this.metaData.getFrameUid(), numRows, inPlace).thenApply(newFrameMetaData -> this.modifyOrCreateFrame(inPlace, (FrameMetaData)((Object)newFrameMetaData)));
    }

    @Override
    protected PgxFuture<PgxFrame> tailAsync(boolean inPlace, long numRows) {
        return this.core.frameTail(this.getSessionContext(), this.metaData.getFrameUid(), numRows, inPlace).thenApply(newFrameMetaData -> this.modifyOrCreateFrame(inPlace, (FrameMetaData)((Object)newFrameMetaData)));
    }

    @Override
    public PgxFuture<Long> countAsync() {
        return this.core.frameCount(this.getSessionContext(), this.metaData.getFrameUid());
    }

    @Override
    public PgxGenericFrameStorer write() {
        return new PgxGenericFrameStorer(this.session, this.core, this, this.keystorePathSupplier, this.keystorePasswordSupplier);
    }

    @Override
    protected PgxFuture<PgxFrame> printAsync(PrintStream printStream, long numResults, long from, boolean truncate) {
        String lineSeparator = System.lineSeparator();
        return ((PgxFuture)this.core.printFrame(this.getSessionContext(), this.metaData.getFrameUid(), numResults, from, truncate, lineSeparator).thenApply(text -> {
            printStream.print((String)text);
            printStream.flush();
            return null;
        })).thenApply(arg -> this);
    }

    @Override
    public PgxFuture<PgxFrame> joinAsync(PgxFrame right, String leftOn, String rightOn, String leftPrefix, String rightPrefix) {
        return this.core.joinFrame(this.getSessionContext(), this.getFrameId(), ((PgxFrameInternal)right).getFrameId(), leftOn, rightOn, leftPrefix, rightPrefix).thenApply(newFrameMetaData -> this.modifyOrCreateFrame(false, (FrameMetaData)((Object)newFrameMetaData)));
    }

    @Override
    public PgxFuture<PgxFrame> unionAsync(PgxFrame b, PgxFrame ... others) {
        PgxId[] othersId = (PgxId[])Stream.of(others).map(frame -> ((PgxFrameInternal)frame).getFrameId()).toArray(PgxId[]::new);
        return this.core.frameUnion(this.getSessionContext(), this.getFrameId(), ((PgxFrameInternal)b).getFrameId(), othersId).thenApply(newFrameMetaData -> this.modifyOrCreateFrame(false, (FrameMetaData)((Object)newFrameMetaData)));
    }

    @Override
    public PgxFuture<PgqlResultSet> toPgqlResultSetAsync() {
        return this.core.frameToPgqlResultSet(this.getSessionContext(), this.metaData.getFrameUid()).thenApply(resultSet -> new PgqlResultSetImpl(this.core, this.session, null, this.keystorePathSupplier, this.keystorePasswordSupplier, (PgqlResultSetProxy)resultSet));
    }

    @Override
    public PgxFuture<Void> destroyAsync() {
        return this.core.destroyFrame(this.getSessionContext(), this.metaData.getFrameUid());
    }

    private PgxFrameImpl modifyOrCreateFrame(boolean inPlace, FrameMetaData newFrameMetaData) {
        if (inPlace) {
            this.metaData = newFrameMetaData;
            return this;
        }
        return new PgxFrameImpl(this.session, this.core, newFrameMetaData, this.keystorePathSupplier, this.keystorePasswordSupplier);
    }

    private PgxFrameColumnImpl columnFromMetaData(FrameColumnMetaData columnMetaData) {
        return new PgxFrameColumnImpl(columnMetaData);
    }

    private SessionContext getSessionContext() {
        return this.session.getSessionContext();
    }
}

