/*
 * Decompiled with CFR 0.152.
 */
package oracle.pgx.api.frames;

import java.util.concurrent.ExecutionException;
import java.util.function.Function;
import oracle.pgx.api.PgxFuture;
import oracle.pgx.api.PgxGraph;
import oracle.pgx.api.SessionContext;
import oracle.pgx.api.frames.PgxEdgeProviderFromFramesCreator;
import oracle.pgx.api.frames.PgxEdgeTableFromFramesCreator;
import oracle.pgx.api.frames.PgxFrame;
import oracle.pgx.api.frames.PgxVertexProviderFromFramesCreator;
import oracle.pgx.api.frames.PgxVertexTableFromFramesCreator;
import oracle.pgx.api.frames.internal.EdgeFrameDeclaration;
import oracle.pgx.api.frames.internal.GraphFrameDeclaration;
import oracle.pgx.api.frames.internal.PgxFrameInternal;
import oracle.pgx.api.frames.internal.VertexFrameDeclaration;
import oracle.pgx.api.internal.Core;
import oracle.pgx.api.internal.Graph;
import oracle.pgx.common.types.IdStrategy;

public class PgxGraphFromFramesCreator {
    protected SessionContext sessionContext;
    protected Core core;
    private final GraphFrameDeclaration graphFrameDeclaration;
    private final Function<Graph, PgxGraph> graphConstructor;

    public PgxGraphFromFramesCreator(SessionContext sessionContext, Core core, String graphName, Function<Graph, PgxGraph> graphConstructor) {
        this.sessionContext = sessionContext;
        this.core = core;
        this.graphConstructor = graphConstructor;
        this.graphFrameDeclaration = new GraphFrameDeclaration(graphName);
    }

    @Deprecated
    public PgxVertexTableFromFramesCreator vertexTable(String tableName, PgxFrame frame) {
        VertexFrameDeclaration vertexFrameDeclaration = new VertexFrameDeclaration(tableName, "id", ((PgxFrameInternal)frame).getMetaData());
        this.graphFrameDeclaration.addVertexFrameDeclaration(vertexFrameDeclaration);
        return new PgxVertexTableFromFramesCreator(this.sessionContext, this.core, vertexFrameDeclaration, this);
    }

    public PgxVertexProviderFromFramesCreator vertexProvider(String providerName, PgxFrame frame) {
        VertexFrameDeclaration vertexFrameDeclaration = new VertexFrameDeclaration(providerName, "id", ((PgxFrameInternal)frame).getMetaData());
        this.graphFrameDeclaration.addVertexFrameDeclaration(vertexFrameDeclaration);
        return new PgxVertexProviderFromFramesCreator(this.sessionContext, this.core, vertexFrameDeclaration, this);
    }

    @Deprecated
    public PgxEdgeTableFromFramesCreator edgeTable(String tableName, String sourceVertexTable, String destinationVertexTable, PgxFrame frame) {
        PgxFrameInternal frameInternal = (PgxFrameInternal)frame;
        EdgeFrameDeclaration edgeFrameDeclaration = new EdgeFrameDeclaration(tableName, sourceVertexTable, "src", destinationVertexTable, "dst", frameInternal.getMetaData());
        this.graphFrameDeclaration.addEdgeFrameDeclaration(edgeFrameDeclaration);
        return new PgxEdgeTableFromFramesCreator(this.sessionContext, this.core, edgeFrameDeclaration, this);
    }

    public PgxEdgeProviderFromFramesCreator edgeProvider(String providerName, String sourceVertexProvider, String destinationVertexProvider, PgxFrame frame) {
        PgxFrameInternal frameInternal = (PgxFrameInternal)frame;
        EdgeFrameDeclaration edgeFrameDeclaration = new EdgeFrameDeclaration(providerName, sourceVertexProvider, "src", destinationVertexProvider, "dst", frameInternal.getMetaData());
        this.graphFrameDeclaration.addEdgeFrameDeclaration(edgeFrameDeclaration);
        return new PgxEdgeProviderFromFramesCreator(this.sessionContext, this.core, edgeFrameDeclaration, this);
    }

    public void partitioned(boolean partitioned) {
        this.graphFrameDeclaration.setPartitioned(partitioned);
    }

    public void vertexIdStrategy(IdStrategy strategy) {
        this.graphFrameDeclaration.setVertexIdStrategy(strategy);
    }

    public void edgeIdStrategy(IdStrategy strategy) {
        this.graphFrameDeclaration.setEdgeIdStrategy(strategy);
    }

    public PgxFuture<PgxGraph> createAsync() {
        return this.core.createGraphFromFrames(this.sessionContext, this.graphFrameDeclaration).thenApply(this.graphConstructor);
    }

    public PgxGraph create() throws InterruptedException, ExecutionException {
        return this.createAsync().get();
    }
}

