/*
 * Decompiled with CFR 0.152.
 */
package oracle.pgx.api;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import oracle.pgx.api.EntityProviderMetaData;
import oracle.pgx.api.PropertyMetaData;
import oracle.pgx.common.types.IdType;

public class EdgeProviderMetaData
extends EntityProviderMetaData {
    private Boolean directed;
    private final String sourceVertexProviderName;
    private final String destinationVertexProviderName;

    @JsonCreator
    public EdgeProviderMetaData(@JsonProperty(value="name") String name, @JsonProperty(value="idType") IdType idType, @JsonProperty(value="directed") boolean directed, @JsonProperty(value="labels") Set<String> labels, @JsonProperty(value="properties") List<PropertyMetaData> properties, @JsonProperty(value="sourceVertexProviderName") String sourceVertexProviderName, @JsonProperty(value="destinationVertexProviderName") String destinationVertexProviderName) {
        super(name, idType, labels, properties);
        this.directed = directed;
        this.sourceVertexProviderName = sourceVertexProviderName;
        this.destinationVertexProviderName = destinationVertexProviderName;
    }

    public EdgeProviderMetaData(EdgeProviderMetaData other) {
        super(other);
        this.directed = other.directed;
        this.sourceVertexProviderName = other.sourceVertexProviderName;
        this.destinationVertexProviderName = other.destinationVertexProviderName;
    }

    public String getSourceVertexProviderName() {
        return this.sourceVertexProviderName;
    }

    public String getDestinationVertexProviderName() {
        return this.destinationVertexProviderName;
    }

    public boolean isDirected() {
        return this.directed;
    }

    public void setDirected(boolean directed) {
        this.directed = directed;
    }

    @Override
    public String toString() {
        return "EdgeProviderMetaData [name=" + this.name + ", edgeIdType=" + this.getIdType() + ", directed=" + this.directed + "]";
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.directed);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (((Object)((Object)this)).getClass() != obj.getClass()) {
            return false;
        }
        EdgeProviderMetaData other = (EdgeProviderMetaData)((Object)obj);
        return super.equals((Object)other) && this.directed == other.directed;
    }
}

