/*
 * Decompiled with CFR 0.152.
 */
package oracle.pg.rdbms.sqlpgq;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Future;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.sql.DataSource;
import oracle.datastudio.graphviz.formatter.DataStudioFormatter;
import oracle.datastudio.graphviz.gvt.GvtFormatter;
import oracle.pg.rdbms.RdbmsDriver;
import oracle.pg.rdbms.sqlpgq.SqlPgqEnhancedResultSet;
import oracle.pg.rdbms.sqlpgq.SqlPgqMetadataUtils;
import oracle.pg.rdbms.sqlpgq.SqlPgqResultSetTable;
import oracle.pg.rdbms.sqlpgq.exception.SqlPgqVisualizationException;
import oracle.pgql.lang.PgqlException;
import oracle.pgx.graphviz.driver.GraphInformation;
import oracle.pgx.graphviz.driver.GraphName;
import oracle.pgx.graphviz.formatter.EnhancedResultSet;
import oracle.pgx.graphviz.formatter.Result;
import oracle.pgx.graphviz.formatter.ResultType;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SqlPgqDriver
extends RdbmsDriver {
    private static final Logger LOG = LoggerFactory.getLogger(SqlPgqDriver.class);
    private static final String DATASTUDIO_CLASS_NAME = DataStudioFormatter.class.getName();
    private static final String GVT_CLASS_NAME = GvtFormatter.class.getName();
    private static String custSqlFunction;
    private static int ORA_CODE_NON_VISUALIZABLE_RESULT;
    private static int ORA_CODE_FUNCTION_NOT_INSTALLED;
    private static String SQL_FUNCTION_ERROR_MESSAGE;
    private static ObjectMapper mapper;

    public SqlPgqDriver(Map<String, Object> properties) throws SQLException, IOException {
        super(properties);
        custSqlFunction = this.readFunction();
    }

    private String readFunction() throws IOException {
        return IOUtils.toString((InputStream)((Object)((Object)this)).getClass().getResourceAsStream("/cust_sqlgraph_json.sql"), (Charset)StandardCharsets.UTF_8);
    }

    public EnhancedResultSet query(@Nonnull String query, String graphName, @Nullable String schema, Map<String, Object> properties) throws PgqlException, SQLException {
        throw new UnsupportedOperationException();
    }

    public String modify(@Nonnull String pgqlQuery, String graphName, Map<String, Object> properties) throws PgqlException, SQLException {
        throw new UnsupportedOperationException();
    }

    public Collection<GraphName> getGraphs(Map<String, Object> properties) throws SQLException {
        DataSource ods = (DataSource)properties.get("datasource");
        try (Connection conn = ods.getConnection();){
            Set<GraphName> graphs;
            Set<GraphName> set = graphs = SqlPgqMetadataUtils.getGraphNames(conn);
            return set;
        }
    }

    @Nonnull
    public GraphInformation getGraph(@Nullable String schemaName, @Nonnull String name, Map<String, Object> properties) throws SQLException {
        throw new UnsupportedOperationException();
    }

    public boolean isDirectedSupported() {
        throw new UnsupportedOperationException();
    }

    public boolean supportsMultipleIterations() {
        throw new UnsupportedOperationException();
    }

    public void close() {
    }

    private String constructTable(Connection conn, String query, int start, int size) throws SQLException {
        ArrayList<String> header = new ArrayList<String>();
        try (PreparedStatement preparedStatement = conn.prepareStatement(query);){
            ResultSet rs = preparedStatement.executeQuery();
            ResultSetMetaData resultSetMetaData = rs.getMetaData();
            int count = resultSetMetaData.getColumnCount();
            if (rs.next()) {
                for (int i = 1; i <= count; ++i) {
                    String columnName = resultSetMetaData.getColumnName(i);
                    header.add(columnName);
                }
            }
            SqlPgqResultSetTable table = new SqlPgqResultSetTable(rs, header);
            String string = String.join((CharSequence)"\t", table.getHeader()) + "\n" + StreamSupport.stream(table.getRows().spliterator(), false).skip(start).limit(size).map(cells -> cells.stream().map(DataStudioFormatter::toStringValue).collect(Collectors.joining("\t"))).collect(Collectors.joining("\n"));
            return string;
        }
    }

    private Optional<Result> constructFullJson(String graph, String table, String schema, String graphName) throws JsonProcessingException {
        HashMap<String, String> ret = new HashMap<String, String>();
        ret.put("graph", graph);
        ret.put("name", graphName);
        ret.put("schema", schema);
        ret.put("resultSetId", UUID.randomUUID().toString());
        ret.put("table", table);
        String json = mapper.writeValueAsString(ret);
        LOG.debug("Result as JSON: {}", (Object)json);
        return Optional.of(new Result(ResultType.NETWORK, json));
    }

    private Optional<Result> constructTableJson(String table, String schema, String graphName) throws JsonProcessingException {
        HashMap<String, String> ret = new HashMap<String, String>();
        ret.put("table", table);
        String json = mapper.writeValueAsString(ret);
        return Optional.of(new Result(ResultType.TABLE, json));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Optional<Result> execute(String query, @Nullable String schema, String graphName, Map<String, Object> properties) {
        DataSource ods = (DataSource)properties.get("datasource");
        try (Connection conn = ods.getConnection();){
            Statement statement;
            block21: {
                if (schema == null) {
                    schema = conn.getSchema();
                }
                String formatterClass = (String)properties.getOrDefault("graphviz.formatter.class", GVT_CLASS_NAME);
                int size = Integer.parseInt(properties.getOrDefault("size", 100).toString());
                int start = Integer.parseInt(properties.getOrDefault("start", 0).toString());
                if (formatterClass.equals(DATASTUDIO_CLASS_NAME)) {
                    SqlPgqEnhancedResultSet resultSet = new SqlPgqEnhancedResultSet(query, conn, properties);
                    DataStudioFormatter formatter = new DataStudioFormatter();
                    Optional<Result> optional = Optional.of(formatter.format((EnhancedResultSet)resultSet, properties));
                    return optional;
                }
                if (!formatterClass.equals(GVT_CLASS_NAME)) throw new IllegalArgumentException("The formatter specified does not exist");
                String table = null;
                String usingCustFunction = custSqlFunction + String.format("SELECT CUST_SQLGRAPH_JSON('%s', %d, %d) AS RESULT FROM DUAL", query, start, size);
                try {
                    Optional<Result> optional;
                    statement = conn.createStatement();
                    try {
                        table = this.constructTable(conn, query, start, size);
                        ResultSet rs = statement.executeQuery(usingCustFunction);
                        if (!rs.next()) break block21;
                        String resultStr = rs.getString("RESULT");
                        LOG.debug("Result from function {}", (Object)resultStr);
                        optional = this.constructFullJson(resultStr, table, schema, graphName);
                        if (statement == null) return optional;
                    }
                    catch (Throwable rs) {
                        if (statement == null) throw rs;
                        try {
                            statement.close();
                            throw rs;
                        }
                        catch (Throwable throwable) {
                            rs.addSuppressed(throwable);
                        }
                        throw rs;
                    }
                    statement.close();
                    return optional;
                }
                catch (SQLException e) {
                    int oraCode = e.getErrorCode();
                    if (oraCode == ORA_CODE_NON_VISUALIZABLE_RESULT) {
                        if (!e.getMessage().contains(SQL_FUNCTION_ERROR_MESSAGE)) throw e;
                        Optional<Result> optional = this.constructTableJson(table, schema, graphName);
                        if (conn == null) return optional;
                        conn.close();
                        return optional;
                    }
                    if (oraCode != ORA_CODE_FUNCTION_NOT_INSTALLED) throw e;
                    throw new IllegalArgumentException("This feature is only supported on Oracle Database version 23.4 or newer");
                }
            }
            if (statement == null) throw new IllegalArgumentException("The formatter specified does not exist");
            statement.close();
            throw new IllegalArgumentException("The formatter specified does not exist");
        }
        catch (IOException | SQLException ex) {
            throw new SqlPgqVisualizationException(ex);
        }
    }

    public Future<Optional<Result>> executeAsync(String query, String schema, String graphName, Map<String, Object> properties) {
        CompletableFuture<Optional<Result>> queryExecution = CompletableFuture.supplyAsync(() -> this.execute(query, schema, graphName, properties));
        return queryExecution;
    }

    static {
        ORA_CODE_NON_VISUALIZABLE_RESULT = 20000;
        ORA_CODE_FUNCTION_NOT_INSTALLED = 6553;
        SQL_FUNCTION_ERROR_MESSAGE = "Please add vertex_id/edge_id in CLOUMNS clause";
        mapper = new ObjectMapper();
    }
}

