/*
 * Decompiled with CFR 0.152.
 */
package oracle.pg.rdbms.pgql.pgview;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashSet;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import oracle.pg.rdbms.pgql.PgProperty;
import oracle.pg.rdbms.pgql.PgqlConnection;
import oracle.pg.rdbms.pgql.PgqlPreparedStatement;
import oracle.pg.rdbms.pgql.PgqlResultSet;
import oracle.pgql.lang.PgqlException;
import oracle.pgql.lang.ir.SchemaQualifiedName;
import oracle.pgx.graphviz.driver.GraphInformation;
import oracle.pgx.graphviz.driver.GraphName;
import oracle.pgx.graphviz.driver.Property;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class PgViewMetadataInformation
implements GraphInformation {
    @Nonnull
    private Set<String> edgeProperties = new HashSet<String>();
    @Nonnull
    private Set<String> vertexProperties = new HashSet<String>();
    @Nonnull
    private Set<String> edgeLabels = new HashSet<String>();
    @Nonnull
    private Set<String> vertexLabels = new HashSet<String>();
    private static String PG_VIEW_POSTFIX = "_ELEM_TABLE$";
    private final Connection conn;
    private final String graphName;
    private final String schemaName;
    private static final String PGVIEW_NAMES_QUERY = "SELECT OWNER, SUBSTR(TABLE_NAME, 1, LENGTH(TABLE_NAME) - 12) FROM SYS.ALL_TABLES WHERE TABLE_NAME LIKE '%ELEM_TABLE$'";
    private static final String EDGE_QUERY_WITH_SCHEMA_PGM = "SELECT DISTINCT l.label_name, p.property_name FROM MATCH (g:property_graph)-[:has_edge_table]->(v)-[:has_label]->(l:label)-[:has_property]->(p:property) ON property_graph_metadata WHERE g.graph_name = ? AND g.owner = ?";
    private static final String VERTEX_QUERY_WITH_SCHEMA_PGM = "SELECT DISTINCT l.label_name, p.property_name FROM MATCH (g:property_graph)-[:has_vertex_table]->(v)-[:has_label]->(l:label)-[:has_property]->(p:property) ON property_graph_metadata WHERE g.graph_name = ? AND g.owner = ?";
    private static final String LABELS_QUERY = "SELECT LABEL_NAME, ET_TYPE FROM %s";
    private static final String PROPERTIES_QUERY = "SELECT PROPERTY_NAME, ET_TYPE FROM %s";
    private static final Logger LOG = LoggerFactory.getLogger(PgViewMetadataInformation.class);

    public PgViewMetadataInformation(String schemaName, String graphName, Connection conn) throws PgqlException, SQLException {
        this.conn = conn;
        this.schemaName = schemaName == null ? this.conn.getSchema() : schemaName;
        this.graphName = graphName;
        if ("PROPERTY_GRAPH_METADATA".equals(graphName)) {
            this.getGraphMetadataFromPropertyGraphMetadata(EDGE_QUERY_WITH_SCHEMA_PGM, false);
            this.getGraphMetadataFromPropertyGraphMetadata(VERTEX_QUERY_WITH_SCHEMA_PGM, true);
        } else {
            this.checkIfGraphExists(schemaName, graphName);
            this.getGraphMetadataFromPgViewMetadataTables(LABELS_QUERY, false);
            this.getGraphMetadataFromPgViewMetadataTables(PROPERTIES_QUERY, true);
        }
    }

    private void checkIfGraphExists(String schema, String graphName) throws SQLException {
        String query = "";
        query = this.schemaName == null ? "SELECT TABLE_NAME FROM SYS.ALL_TABLES WHERE TABLE_NAME LIKE ? OR OWNER = ?" : "SELECT TABLE_NAME FROM SYS.ALL_TABLES WHERE TABLE_NAME LIKE ? AND OWNER = ?";
        try (PreparedStatement preparedStatement = this.conn.prepareStatement(query);){
            preparedStatement.setString(1, graphName + PG_VIEW_POSTFIX);
            preparedStatement.setString(2, this.schemaName);
            try (ResultSet rs = preparedStatement.executeQuery();){
                if (!rs.next()) {
                    throw new NoSuchElementException(String.format("no graph named %s found in database", graphName));
                }
            }
        }
    }

    private void getGraphMetadataFromPropertyGraphMetadata(String query, boolean isVertex) throws PgqlException {
        PgqlConnection pgqlConnection = PgqlConnection.getConnection((Connection)this.conn);
        try (PgqlPreparedStatement statement = pgqlConnection.prepareStatement(query);){
            statement.setString(1, this.graphName);
            if (this.schemaName != null) {
                statement.setString(2, this.schemaName);
            }
            try (PgqlResultSet rs = statement.executeQuery();){
                while (rs.next()) {
                    String label = rs.getString(1);
                    String property = rs.getString(2);
                    if (label != null) {
                        if (isVertex) {
                            LOG.debug("Adding vertex label: {}", (Object)label);
                            this.vertexLabels.add(label);
                        } else {
                            LOG.debug("Adding edge label: {}", (Object)label);
                            this.edgeLabels.add(label);
                        }
                    }
                    if (property == null) continue;
                    if (isVertex) {
                        LOG.debug("Adding vertex property: {}", (Object)property);
                        this.vertexProperties.add(property);
                        continue;
                    }
                    LOG.debug("Adding edge property: {}", (Object)property);
                    this.edgeProperties.add(property);
                }
            }
        }
    }

    private void getGraphMetadataFromPgViewMetadataTables(String query, boolean isProperties) throws SQLException {
        try (Statement stmnt = this.conn.createStatement();){
            SchemaQualifiedName schemaQualifiedName = new SchemaQualifiedName(this.schemaName, this.graphName + "_LABEL$");
            if (isProperties) {
                schemaQualifiedName.setName(this.graphName + "_PROPERTY$");
            }
            String queryWithTableName = String.format(query, schemaQualifiedName.toString());
            try (ResultSet rs = stmnt.executeQuery(queryWithTableName);){
                while (rs.next()) {
                    String metadata = rs.getString(1);
                    String type = rs.getString(2);
                    if (metadata == null || type == null) continue;
                    if (type.equals("VERTEX")) {
                        if (isProperties) {
                            this.vertexProperties.add(metadata);
                        } else {
                            this.vertexLabels.add(metadata);
                        }
                    } else if (isProperties) {
                        this.edgeProperties.add(metadata);
                    } else {
                        this.edgeLabels.add(metadata);
                    }
                    LOG.debug("PG View metadata added to graph information: {}", (Object)metadata);
                }
            }
        }
    }

    public static Set<GraphName> getPgViewNames(Connection conn) throws SQLException {
        HashSet<GraphName> pgViews = new HashSet<GraphName>();
        try (Statement stmnt = conn.createStatement();){
            ResultSet rs = stmnt.executeQuery(PGVIEW_NAMES_QUERY);
            while (rs.next()) {
                String schema = rs.getString(1);
                String graphName = rs.getString(2);
                if (schema == null || graphName == null) continue;
                GraphName graphNameObject = new GraphName(schema, graphName);
                LOG.debug("PG View name added to the list: {}", (Object)graphNameObject.toString());
                pgViews.add(graphNameObject);
            }
        }
        return pgViews;
    }

    public String getSchema() {
        return this.schemaName;
    }

    public String getGraphName() {
        return this.graphName;
    }

    @Nonnull
    public Set<Property> getVertexProperties() {
        return this.vertexProperties.stream().map(PgProperty::new).collect(Collectors.toSet());
    }

    @Nonnull
    public Set<Property> getEdgeProperties() {
        return this.edgeProperties.stream().map(PgProperty::new).collect(Collectors.toSet());
    }

    @Nonnull
    public Set<String> getEdgeLabels() {
        return this.edgeLabels;
    }

    @Nonnull
    public Set<String> getVertexLabels() {
        return this.vertexLabels;
    }
}

