/*
 * Decompiled with CFR 0.152.
 */
package oracle.pg.rdbms;

import java.sql.Connection;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.Map;
import java.util.Properties;
import java.util.UUID;
import javax.sql.DataSource;
import oracle.jdbc.OracleDriver;
import oracle.pgx.graphviz.driver.KerberosAuthentication;
import oracle.ucp.UniversalConnectionPoolAdapter;
import oracle.ucp.UniversalConnectionPoolException;
import oracle.ucp.admin.UniversalConnectionPoolManager;
import oracle.ucp.admin.UniversalConnectionPoolManagerImpl;
import oracle.ucp.jdbc.PoolDataSource;
import oracle.ucp.jdbc.PoolDataSourceFactory;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RdbmsLoginHelper {
    private static final Logger LOG = LoggerFactory.getLogger(RdbmsLoginHelper.class);
    private static final String MAX_POOL_SIZE = "graphviz.driver.rdbms.max_pool_size";
    private static final String DEFAULT_POOL_SIZE = "10";
    private static final String CONNECTION_FACTORY_NAME = "oracle.jdbc.pool.OracleDataSource";
    private static final int ORA_01017_INVALID_USERNAME_PASSWORD = 1017;
    private static final int ORA_28000_ACCOUNT_LOCKED = 28000;
    private static final int ORA_28001_EXPIRED_PASSWORD = 28001;
    private static final int ORA_12543_HOST_UNREACHABLE = 12543;
    private static final int ORA_12154_COULD_NOT_RESOLVE = 12154;
    private static final int ORA_12203_UNABLE_CONNECT = 12203;
    private static final int ORA_17002_DB_IO_EXCEPTION = 17002;
    private static final int ORA_12514_NO_LISTENER = 12514;
    private static final int ORA_12505_LISTENER_DOES_NOT_KNOW_SID = 12505;
    private static final UniversalConnectionPoolManager UCPM;
    private final int maxPoolSize;
    private final boolean isKerberosAuthEnabled;

    public RdbmsLoginHelper(Map<String, Object> properties) {
        this.maxPoolSize = Integer.parseInt((String)properties.getOrDefault(MAX_POOL_SIZE, DEFAULT_POOL_SIZE));
        this.isKerberosAuthEnabled = Boolean.parseBoolean((String)properties.get("graphviz.driver.auth.kerberos"));
    }

    private DataSource getDataSourceFromUserCredentials(String jdbcUrl, String username, String password, Map<String, Object> properties) throws SQLException, UniversalConnectionPoolException {
        String poolName = UUID.randomUUID().toString();
        properties.put("connection-pool-id", poolName);
        PoolDataSource pds = PoolDataSourceFactory.getPoolDataSource();
        pds.setConnectionPoolName(poolName);
        pds.setConnectionFactoryClassName(CONNECTION_FACTORY_NAME);
        pds.setMaxPoolSize(this.maxPoolSize);
        pds.setURL(jdbcUrl);
        pds.setUser(username);
        pds.setPassword(password);
        LOG.info("registering connection pool {} at UCP manager", (Object)poolName);
        UCPM.createConnectionPool((UniversalConnectionPoolAdapter)pds);
        UCPM.startConnectionPool(poolName);
        return pds;
    }

    private DataSource getDataSourceFromKerberos(String okinitPath, String jdbcUrl, String username, String password, Map<String, Object> properties) throws SQLException, UniversalConnectionPoolException {
        String poolName = UUID.randomUUID().toString();
        properties.put("connection-pool-id", poolName);
        String kerberosTicketPath = (String)properties.get("kerberos-ticket-path");
        Properties props = new Properties();
        props.setProperty("oracle.net.authentication_services", "( KERBEROS5 )");
        props.setProperty("oracle.net.kerberos5_mutual_authentication", "true");
        props.setProperty("oracle.net.kerberos5_cc_name", kerberosTicketPath);
        PoolDataSource pds = PoolDataSourceFactory.getPoolDataSource();
        pds.setConnectionPoolName(poolName);
        pds.setConnectionFactoryClassName(CONNECTION_FACTORY_NAME);
        pds.setMaxPoolSize(this.maxPoolSize);
        pds.setURL(jdbcUrl);
        pds.setConnectionProperties(props);
        LOG.info("registering connection pool {} at UCP manager", (Object)poolName);
        UCPM.createConnectionPool((UniversalConnectionPoolAdapter)pds);
        UCPM.startConnectionPool(poolName);
        return pds;
    }

    public Connection connect(String jdbcUrl, String username, String password, Map<String, Object> properties) throws SQLException {
        if (StringUtils.isAnyEmpty((CharSequence[])new CharSequence[]{jdbcUrl, username, password})) {
            throw new IllegalArgumentException("The username, password or the JDBC URL is empty, please verify.");
        }
        LOG.info("connecting using JDBC URL {}", (Object)jdbcUrl);
        Properties props = new Properties();
        if (this.isKerberosAuthEnabled) {
            String kerberosTicketPath = KerberosAuthentication.getUniqueFileName(properties);
            properties.put("kerberos-ticket-path", kerberosTicketPath);
            String kerberosTicket = KerberosAuthentication.getKerberosTicket(properties, (String)kerberosTicketPath, (String)username, (String)password);
            props.setProperty("oracle.net.authentication_services", "( KERBEROS5 )");
            props.setProperty("oracle.net.kerberos5_mutual_authentication", "true");
            props.setProperty("oracle.net.kerberos5_cc_name", kerberosTicketPath);
        } else {
            props.setProperty("user", username);
            props.setProperty("password", password);
        }
        return DriverManager.getConnection(jdbcUrl, props);
    }

    public DataSource createDataSource(String jdbcUrl, String username, String password, Map<String, Object> properties) throws SQLException, UniversalConnectionPoolException {
        if (this.isKerberosAuthEnabled) {
            String okinitPath = (String)properties.get("graphviz.driver.auth.kerberos.okinit-location");
            return this.getDataSourceFromKerberos(okinitPath, jdbcUrl, username, password, properties);
        }
        return this.getDataSourceFromUserCredentials(jdbcUrl, username, password, properties);
    }

    public void removeExistingConnectionPool(Map<String, Object> properties) {
        try {
            String ticketPath;
            String poolName = (String)properties.get("connection-pool-id");
            LOG.info("destroying connection pool {}", (Object)poolName);
            if (this.isKerberosAuthEnabled && (ticketPath = (String)properties.get("kerberos-ticket-path")) != null) {
                KerberosAuthentication.deleteKerberosTicket((String)ticketPath);
            }
            UCPM.destroyConnectionPool(poolName);
        }
        catch (UniversalConnectionPoolException e) {
            throw new RuntimeException("failed to destroy connection pool", e);
        }
    }

    public String manageSqlException(int errorCode) {
        switch (errorCode) {
            case 1017: {
                return "Invalid username/password";
            }
            case 28000: {
                return "The account is locked";
            }
            case 28001: {
                return "Password has expired";
            }
            case 12154: 
            case 12203: 
            case 12505: 
            case 12514: 
            case 12543: 
            case 17002: {
                return "Could not connect to database";
            }
        }
        return "Authentication failed due to a database error. This is most likely a server configuration problem. Please consult with the server administrator";
    }

    static {
        try {
            DriverManager.registerDriver((Driver)new OracleDriver());
            UCPM = UniversalConnectionPoolManagerImpl.getUniversalConnectionPoolManager();
        }
        catch (SQLException | UniversalConnectionPoolException e) {
            throw new IllegalStateException(e);
        }
    }
}

