/*
 * Decompiled with CFR 0.152.
 */
package oracle.pgx.config.mllib.inputconfig;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.fasterxml.jackson.annotation.JsonTypeName;
import oracle.pgx.common.util.ErrorMessages;
import oracle.pgx.config.mllib.inputconfig.CategoricalEmbeddingType;
import oracle.pgx.config.mllib.inputconfig.EmbeddingTableConfig;
import oracle.pgx.config.mllib.inputconfig.InputPropertyConfig;
import oracle.pgx.config.mllib.inputconfig.OneHotEncodingConfig;

@JsonTypeName(value="categorical_property_config")
@JsonSubTypes(value={@JsonSubTypes.Type(value=EmbeddingTableConfig.class, name="embedding_table_config"), @JsonSubTypes.Type(value=OneHotEncodingConfig.class, name="one_hot_encoding_config")})
public class CategoricalPropertyConfig
extends InputPropertyConfig {
    public static final CategoricalEmbeddingType DEFAULT_CATEGORY_METHOD = CategoricalEmbeddingType.ONE_HOT_ENCODING;
    public static final boolean DEFAULT_SHARED = true;
    public static final int DEFAULT_MAX_VOCAB = 1000;
    private boolean isShared = true;
    private CategoricalEmbeddingType categoricalEmbeddingType = DEFAULT_CATEGORY_METHOD;
    private int maxVocabularySize = 1000;

    public CategoricalPropertyConfig(String propertyName) {
        super(propertyName, true);
    }

    public CategoricalPropertyConfig(String propertyName, CategoricalEmbeddingType type) {
        super(propertyName, true);
        this.categoricalEmbeddingType = type;
    }

    public CategoricalPropertyConfig(CategoricalPropertyConfig otherConfig, CategoricalEmbeddingType type) {
        super(otherConfig);
        this.isShared = otherConfig.getShared();
        this.maxVocabularySize = otherConfig.maxVocabularySize;
        this.categoricalEmbeddingType = type;
    }

    public void setShared(boolean isShared) {
        this.isShared = isShared;
    }

    public boolean getShared() {
        return this.isShared;
    }

    public CategoricalEmbeddingType getCategoricalEmbeddingType() {
        return this.categoricalEmbeddingType;
    }

    public void setMaxVocabularySize(int size) {
        this.maxVocabularySize = size;
    }

    public int getMaxVocabularySize() {
        return this.maxVocabularySize;
    }

    @JsonIgnore
    public void validateProperties() {
        if (this.maxVocabularySize <= 0) {
            throw new IllegalArgumentException(ErrorMessages.getMessage((String)"INVALID_MAX_VOCAB_SIZE", (Object[])new Object[]{this.maxVocabularySize}));
        }
    }
}

