/*
 * Decompiled with CFR 0.152.
 */
package oracle.pgx.config.mllib.edgecombination;

import oracle.pgx.common.util.ErrorMessages;
import oracle.pgx.config.mllib.edgecombination.ConcatEdgeCombinationMethod;
import oracle.pgx.config.mllib.edgecombination.ProductEdgeCombinationMethod;

public final class EdgeCombinationMethods {
    public static final boolean DEFAULT_USE_SOURCE_VERTEX = true;
    public static final boolean DEFAULT_USE_DESTINATION_VERTEX = true;
    public static final boolean DEFAULT_USE_EDGE = true;
    public static final ProductEdgeCombinationMethod DEFAULT_PRODUCT_METHOD = new ProductEdgeCombinationMethod(true, true, true);
    public static final ConcatEdgeCombinationMethod DEFAULT_CONCAT_METHOD = new ConcatEdgeCombinationMethod(true, true, true);

    private EdgeCombinationMethods() {
    }

    public static ConcatEdgeCombinationMethod concatEdgeCombinationMethod(boolean useSourceVertex, boolean useDestinationVertex, boolean useEdge) {
        if (!(useSourceVertex || useDestinationVertex || useEdge)) {
            throw new IllegalArgumentException(ErrorMessages.getMessage((String)"INVALID_EDGE_EMBEDDING_METHOD", (Object[])new Object[0]));
        }
        return new ConcatEdgeCombinationMethod(useSourceVertex, useDestinationVertex, useEdge);
    }

    public static ProductEdgeCombinationMethod productEdgeCombinationMethod(boolean useSourceVertex, boolean useDestinationVertex, boolean useEdge) {
        if (!(useSourceVertex || useDestinationVertex || useEdge)) {
            throw new IllegalArgumentException(ErrorMessages.getMessage((String)"INVALID_EDGE_EMBEDDING_METHOD", (Object[])new Object[0]));
        }
        return new ProductEdgeCombinationMethod(useSourceVertex, useDestinationVertex, useEdge);
    }
}

