/*
 * Decompiled with CFR 0.152.
 */
package oracle.pgx.config;

import com.fasterxml.jackson.annotation.JsonValue;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.Set;
import oracle.pgx.api.filter.FilterStrategy;
import oracle.pgx.common.util.ConfigJsonUtil;
import oracle.pgx.config.AbstractConfig;
import oracle.pgx.config.ConfigField;
import oracle.pgx.config.ConfigParser;
import oracle.pgx.config.FilterExpressionConfig;
import oracle.pgx.config.ParseResult;
import oracle.pgx.config.PropertiesConfigParser;
import oracle.pgx.config.SnapshotsSource;

public class GraphLoadingConfig
extends AbstractConfig {
    private final Map<Field, Object> values;
    private final Set<Field> defaults;
    private final Map<String, Object> leftoverValues;

    public static GraphLoadingConfig parse(InputStream is, boolean strict, String parentPath) throws IOException {
        return GraphLoadingConfig.parse(ConfigParser.parseRaw(is), strict, parentPath);
    }

    static GraphLoadingConfig parse(InputStream is, boolean strict, String parentPath, boolean parseHiddenValues) throws IOException {
        return GraphLoadingConfig.parse(ConfigParser.parseRaw(is), strict, parentPath, parseHiddenValues);
    }

    public static GraphLoadingConfig parse(Map<String, Object> raw, boolean strict, String parentPath) {
        ParseResult pr = ConfigParser.parse(raw, (ConfigField[])Field.values(), (boolean)strict, (String)parentPath);
        return new GraphLoadingConfig(pr.getValues(), raw, pr.getDefaults());
    }

    static GraphLoadingConfig parse(Map<String, Object> raw, boolean strict, String parentPath, boolean parseHiddenValues) {
        ParseResult pr = ConfigParser.parse(raw, (ConfigField[])Field.values(), (boolean)strict, (String)parentPath, (boolean)parseHiddenValues);
        return new GraphLoadingConfig(pr.getValues(), raw, pr.getDefaults());
    }

    public static GraphLoadingConfig parse(Properties props, boolean strict) {
        ParseResult pr = PropertiesConfigParser.parse((Properties)props, (ConfigField[])Field.values(), (boolean)strict);
        return new GraphLoadingConfig(pr.getValues(), null, pr.getDefaults());
    }

    public static Field[] getConfigFields() {
        return Field.values();
    }

    protected GraphLoadingConfig(Map<Field, Object> values, Map<String, Object> leftoverValues, Set<Field> defaults) {
        this.values = values;
        this.leftoverValues = leftoverValues == null ? Collections.emptyMap() : leftoverValues;
        this.defaults = defaults;
        this.initialize();
    }

    public Map<Field, Object> getValues() {
        return this.values;
    }

    public boolean isEmpty() {
        return this.getValuesWithoutDefaults().isEmpty();
    }

    public boolean hasDefaultValue(Field field) {
        return this.defaults.contains(field);
    }

    @JsonValue
    public Map<Field, Object> getValuesWithoutDefaults() {
        HashMap<Field, Object> valuesWithoutDefaults = new HashMap<Field, Object>(this.values);
        for (Field field : this.defaults) {
            valuesWithoutDefaults.remove(field);
        }
        return valuesWithoutDefaults;
    }

    public Map<String, Object> getLeftoverValues() {
        return this.leftoverValues;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean hideSensitiveData) {
        if (!this.canSerialize()) {
            throw new UnsupportedOperationException("some objects part of this config cannot be serialized");
        }
        try {
            Object configValues = hideSensitiveData ? this.hiddenSensitiveData() : this;
            return ConfigJsonUtil.toJson(configValues);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private final Map<Field, Object> hiddenSensitiveData() {
        HashMap<Field, Object> hiddenValues = new HashMap<Field, Object>(this.getValuesWithoutDefaults());
        for (Field f : this.values.keySet()) {
            if (!f.isSensitive()) continue;
            hiddenValues.put(f, "*******");
        }
        return hiddenValues;
    }

    @Deprecated
    public FilterExpressionConfig getFilter() {
        return (FilterExpressionConfig)this.values.get(Field.FILTER);
    }

    @Deprecated
    public FilterStrategy getFilterStrategy() {
        return (FilterStrategy)this.values.get(Field.FILTER_STRATEGY);
    }

    public Boolean isCreateVertexIdIndex() {
        return (Boolean)this.values.get(Field.CREATE_VERTEX_ID_INDEX);
    }

    public Boolean isCreateVertexIdMapping() {
        return (Boolean)this.values.get(Field.CREATE_VERTEX_ID_MAPPING);
    }

    public Boolean isCreateEdgeIdIndex() {
        return (Boolean)this.values.get(Field.CREATE_EDGE_ID_INDEX);
    }

    public Boolean isCreateEdgeIdMapping() {
        return (Boolean)this.values.get(Field.CREATE_EDGE_ID_MAPPING);
    }

    public Boolean isAutoRefresh() {
        return (Boolean)this.values.get(Field.AUTO_REFRESH);
    }

    public SnapshotsSource getSnapshotsSource() {
        return (SnapshotsSource)((Object)this.values.get(Field.SNAPSHOTS_SOURCE));
    }

    public Integer getFetchIntervalSec() {
        return (Integer)this.values.get(Field.FETCH_INTERVAL_SEC);
    }

    public Integer getUpdateIntervalSec() {
        return (Integer)this.values.get(Field.UPDATE_INTERVAL_SEC);
    }

    public Integer getUpdateThreshold() {
        return (Integer)this.values.get(Field.UPDATE_THRESHOLD);
    }

    public Boolean isStrictMode() {
        return (Boolean)this.values.get(Field.STRICT_MODE);
    }

    public Boolean loadVertexLabels() {
        return (Boolean)this.values.get(Field.LOAD_VERTEX_LABELS);
    }

    public Boolean loadEdgeLabel() {
        return (Boolean)this.values.get(Field.LOAD_EDGE_LABEL);
    }

    public String getUseVertexPropertyValueAsLabel() {
        return (String)this.values.get(Field.USE_VERTEX_PROPERTY_VALUE_AS_LABEL);
    }

    public String getPropertyValueDelimiter() {
        return (String)this.values.get(Field.PROPERTY_VALUE_DELIMITER);
    }

    public Boolean skipEdges() {
        return (Boolean)this.values.get(Field.SKIP_EDGES);
    }

    public Boolean skipVertices() {
        return (Boolean)this.values.get(Field.SKIP_VERTICES);
    }

    public Boolean isCreateLabelHistogram() {
        return (Boolean)this.values.get(Field.CREATE_LABEL_HISTOGRAM);
    }

    public Boolean isUpdatePropertiesInPlace() {
        return (Boolean)this.values.get(Field.UPDATE_PROPERTIES_IN_PLACE);
    }

    public Boolean isPartitionDiscardDefaultValues() {
        return (Boolean)this.values.get(Field.PARTITION_DISCARD_DEFAULT_VALUES);
    }

    public Integer getLoadingProgressReportingFrequency() {
        return (Integer)this.values.get(Field.LOADING_PROGRESS_REPORTING_FREQUENCY);
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        GraphLoadingConfig other = (GraphLoadingConfig)obj;
        if (!Objects.equals(this.getFilter(), other.getFilter())) {
            return false;
        }
        if (!Objects.equals(this.getFilterStrategy(), other.getFilterStrategy())) {
            return false;
        }
        if (!Objects.equals(this.isCreateVertexIdIndex(), other.isCreateVertexIdIndex())) {
            return false;
        }
        if (!Objects.equals(this.isCreateVertexIdMapping(), other.isCreateVertexIdMapping())) {
            return false;
        }
        if (!Objects.equals(this.isCreateEdgeIdIndex(), other.isCreateEdgeIdIndex())) {
            return false;
        }
        if (!Objects.equals(this.isCreateEdgeIdMapping(), other.isCreateEdgeIdMapping())) {
            return false;
        }
        if (!Objects.equals(this.isAutoRefresh(), other.isAutoRefresh())) {
            return false;
        }
        if (!Objects.equals((Object)this.getSnapshotsSource(), (Object)other.getSnapshotsSource())) {
            return false;
        }
        if (!Objects.equals(this.getFetchIntervalSec(), other.getFetchIntervalSec())) {
            return false;
        }
        if (!Objects.equals(this.getUpdateIntervalSec(), other.getUpdateIntervalSec())) {
            return false;
        }
        if (!Objects.equals(this.getUpdateThreshold(), other.getUpdateThreshold())) {
            return false;
        }
        if (!Objects.equals(this.isStrictMode(), other.isStrictMode())) {
            return false;
        }
        if (!Objects.equals(this.loadVertexLabels(), other.loadVertexLabels())) {
            return false;
        }
        if (!Objects.equals(this.loadEdgeLabel(), other.loadEdgeLabel())) {
            return false;
        }
        if (!Objects.equals(this.getUseVertexPropertyValueAsLabel(), other.getUseVertexPropertyValueAsLabel())) {
            return false;
        }
        if (!Objects.equals(this.getPropertyValueDelimiter(), other.getPropertyValueDelimiter())) {
            return false;
        }
        if (!Objects.equals(this.skipEdges(), other.skipEdges())) {
            return false;
        }
        if (!Objects.equals(this.skipVertices(), other.skipVertices())) {
            return false;
        }
        if (!Objects.equals(this.isCreateLabelHistogram(), other.isCreateLabelHistogram())) {
            return false;
        }
        if (!Objects.equals(this.isUpdatePropertiesInPlace(), other.isUpdatePropertiesInPlace())) {
            return false;
        }
        if (!Objects.equals(this.isPartitionDiscardDefaultValues(), other.isPartitionDiscardDefaultValues())) {
            return false;
        }
        return Objects.equals(this.getLoadingProgressReportingFrequency(), other.getLoadingProgressReportingFrequency());
    }

    public static enum Field implements ConfigField
    {
        FILTER(Collections.emptyList(), Collections.emptyList(), FilterExpressionConfig.class, false, Collections.emptyMap(), false, false, false, false),
        FILTER_STRATEGY(Collections.emptyList(), Collections.emptyList(), FilterStrategy.class, false, FilterStrategy.AUTO, false, false, false, false),
        CREATE_VERTEX_ID_INDEX(Arrays.asList("create_node_id_index"), Collections.emptyList(), Boolean.class, false, true, false, false, false, false),
        CREATE_VERTEX_ID_MAPPING(Arrays.asList("create_node_id_mapping"), Collections.emptyList(), Boolean.class, false, true, false, false, false, false),
        CREATE_EDGE_ID_INDEX(Collections.emptyList(), Collections.emptyList(), Boolean.class, false, false, false, false, false, false),
        CREATE_EDGE_ID_MAPPING(Collections.emptyList(), Collections.emptyList(), Boolean.class, false, false, false, false, false, false),
        AUTO_REFRESH(Collections.emptyList(), Collections.emptyList(), Boolean.class, false, false, false, false, false, false),
        SNAPSHOTS_SOURCE(Collections.emptyList(), Collections.emptyList(), SnapshotsSource.class, false, (Object)((Object)SnapshotsSource.REFRESH), false, false, false, false),
        FETCH_INTERVAL_SEC(Collections.emptyList(), Collections.emptyList(), Integer.class, false, -1, false, false, false, false),
        UPDATE_INTERVAL_SEC(Collections.emptyList(), Collections.emptyList(), Integer.class, false, 60, false, false, false, false),
        UPDATE_THRESHOLD(Collections.emptyList(), Collections.emptyList(), Integer.class, false, -1, false, false, false, false),
        STRICT_MODE(Collections.emptyList(), Collections.emptyList(), Boolean.class, false, true, false, false, false, false),
        LOAD_VERTEX_LABELS(Collections.emptyList(), Collections.emptyList(), Boolean.class, false, false, false, false, false, false),
        LOAD_EDGE_LABEL(Collections.emptyList(), Collections.emptyList(), Boolean.class, false, false, false, false, false, false),
        USE_VERTEX_PROPERTY_VALUE_AS_LABEL(Collections.emptyList(), Collections.emptyList(), String.class, false, null, false, false, false, false),
        PROPERTY_VALUE_DELIMITER(Arrays.asList("label_value_delimiter"), Collections.emptyList(), String.class, false, null, false, false, false, false),
        SKIP_EDGES(Collections.emptyList(), Collections.emptyList(), Boolean.class, false, false, false, false, false, false),
        SKIP_VERTICES(Collections.emptyList(), Collections.emptyList(), Boolean.class, false, false, false, false, false, false),
        CREATE_LABEL_HISTOGRAM(Collections.emptyList(), Collections.emptyList(), Boolean.class, false, true, false, false, false, false),
        UPDATE_PROPERTIES_IN_PLACE(Collections.emptyList(), Collections.emptyList(), Boolean.class, false, false, false, false, false, false),
        PARTITION_DISCARD_DEFAULT_VALUES(Collections.emptyList(), Collections.emptyList(), Boolean.class, false, false, false, false, false, false),
        LOADING_PROGRESS_REPORTING_FREQUENCY(Collections.emptyList(), Collections.emptyList(), Integer.class, false, 10000000, false, false, false, false);

        private final List<String> aliases;
        private final List<String> singletonListAliases;
        private final Class<?> type;
        private final boolean required;
        private final Object defaultVal;
        private final boolean array;
        private final boolean path;
        private final boolean sensitive;
        private final boolean hidden;

        private Field(List<String> aliases, List<String> singletonListAliases, Class<?> type, boolean required, Object factoryDefaultVal, boolean array, boolean path, boolean sensitive, boolean hidden) {
            this.aliases = aliases;
            this.singletonListAliases = singletonListAliases;
            this.type = type;
            this.required = required;
            this.defaultVal = AbstractConfig.getDefault("graph.loading.json", this, factoryDefaultVal);
            this.array = array;
            this.path = path;
            this.sensitive = sensitive;
            this.hidden = hidden;
        }

        @Override
        public List<String> getKeyAliases() {
            return this.aliases;
        }

        @Override
        public List<String> getSingletonListKeyAliases() {
            return this.singletonListAliases;
        }

        @Override
        public Class<?> getType() {
            return this.type;
        }

        @Override
        public boolean isRequired() {
            return this.required;
        }

        @Override
        public boolean isArray() {
            return this.array;
        }

        @Override
        public boolean isPath() {
            return this.path;
        }

        @Override
        public Object getDefaultVal() {
            return this.defaultVal;
        }

        @Override
        @JsonValue
        public String toKey() {
            return this.name().toLowerCase();
        }

        public String toString() {
            return this.toKey();
        }

        @Override
        public boolean isSensitive() {
            return this.sensitive;
        }

        @Override
        public boolean isHidden() {
            return this.hidden;
        }
    }
}

