/*
 * Decompiled with CFR 0.152.
 */
package oracle.pgx.config;

import java.io.IOException;
import java.util.Map;
import java.util.Properties;
import oracle.pgx.config.AbstractGraphConfigFactory;
import oracle.pgx.config.DbEngine;
import oracle.pgx.config.FileGraphConfigFactory;
import oracle.pgx.config.Format;
import oracle.pgx.config.GraphConfig;
import oracle.pgx.config.PartitionedGraphConfigFactory;
import oracle.pgx.config.PgHbaseGraphConfigFactory;
import oracle.pgx.config.PgNosqlGraphConfigFactory;
import oracle.pgx.config.PgRdbmsGraphConfig;
import oracle.pgx.config.PgRdbmsGraphConfigFactory;
import oracle.pgx.config.RdfGraphConfigFactory;
import oracle.pgx.config.TwoTablesDatastore;
import oracle.pgx.config.TwoTablesRdbmsGraphConfig;
import oracle.pgx.config.TwoTablesRdbmsGraphConfigFactory;
import oracle.pgx.config.TwoTablesTextGraphConfigFactory;

public class AnyFormatGraphConfigFactory
extends AbstractGraphConfigFactory<GraphConfig> {
    private static final String PARTITIONED_FORMAT = "partitioned";
    private final boolean strict;

    public AnyFormatGraphConfigFactory(boolean strict) {
        this.strict = strict;
    }

    protected AnyFormatGraphConfigFactory(boolean strict, boolean parseHiddenValues) {
        super(parseHiddenValues);
        this.strict = strict;
    }

    @Override
    protected boolean supports(Format format) {
        return true;
    }

    @Override
    protected GraphConfig fromMap(Map<String, Object> raw, String parentPath) throws IOException {
        Object ttDatastoreObj;
        Object dbEngineObj;
        Object formatObj = raw.get(PgRdbmsGraphConfig.Field.FORMAT.toKey());
        if (formatObj == null) {
            formatObj = PARTITIONED_FORMAT;
        }
        if ((dbEngineObj = raw.get(PgRdbmsGraphConfig.Field.DB_ENGINE.toKey())) == null) {
            dbEngineObj = PgRdbmsGraphConfig.Field.DB_ENGINE.getDefaultVal();
        }
        if ((ttDatastoreObj = raw.get(TwoTablesRdbmsGraphConfig.Field.DATASTORE.toKey())) == null) {
            ttDatastoreObj = TwoTablesRdbmsGraphConfig.Field.DATASTORE.getDefaultVal();
        }
        assert (dbEngineObj != null);
        assert (ttDatastoreObj != null);
        AbstractGraphConfigFactory<? extends GraphConfig> factory = this.createFactory(formatObj.toString(), dbEngineObj.toString(), ttDatastoreObj.toString());
        return (GraphConfig)factory.fromMap(raw, parentPath);
    }

    @Override
    public GraphConfig fromProperties(Properties props) {
        String ttDatastoreStr;
        String dbEngineStr;
        String formatStr = props.getProperty(PgRdbmsGraphConfig.Field.FORMAT.toKey());
        if (formatStr == null) {
            formatStr = PARTITIONED_FORMAT;
        }
        if ((dbEngineStr = props.getProperty(PgRdbmsGraphConfig.Field.DB_ENGINE.toKey())) == null) {
            DbEngine defaultDbEngine = (DbEngine)((Object)PgRdbmsGraphConfig.Field.DB_ENGINE.getDefaultVal());
            dbEngineStr = defaultDbEngine.toKey();
        }
        if ((ttDatastoreStr = props.getProperty(TwoTablesRdbmsGraphConfig.Field.DATASTORE.toKey())) == null) {
            TwoTablesDatastore defaultTtDatastore = (TwoTablesDatastore)((Object)TwoTablesRdbmsGraphConfig.Field.DATASTORE.getDefaultVal());
            ttDatastoreStr = defaultTtDatastore.toKey();
        }
        return (GraphConfig)this.createFactory(formatStr, dbEngineStr, ttDatastoreStr).fromProperties(props);
    }

    private AbstractGraphConfigFactory<? extends GraphConfig> createFactory(String formatStr, String dbEngineStr, String ttDatastoreStr) {
        if (formatStr.equals(PARTITIONED_FORMAT)) {
            return new PartitionedGraphConfigFactory(this.strict, this.parseHiddenValues);
        }
        Format format = Format.valueOf(formatStr.toUpperCase());
        switch (format) {
            case ADJ_LIST: 
            case EDGE_LIST: 
            case GRAPHML: 
            case PGB: 
            case FLAT_FILE: 
            case CSV: {
                return new FileGraphConfigFactory(this.strict, this.parseHiddenValues);
            }
            case PG: {
                assert (dbEngineStr != null);
                DbEngine dbEngine = DbEngine.valueOf(dbEngineStr.toUpperCase());
                switch (dbEngine) {
                    case HBASE: {
                        return new PgHbaseGraphConfigFactory(this.strict, this.parseHiddenValues);
                    }
                    case NOSQL: {
                        return new PgNosqlGraphConfigFactory(this.strict, this.parseHiddenValues);
                    }
                    case RDBMS: {
                        return new PgRdbmsGraphConfigFactory(this.strict, this.parseHiddenValues);
                    }
                }
                throw new UnsupportedOperationException("unsupported DB engine " + (Object)((Object)dbEngine));
            }
            case TWO_TABLES: {
                assert (ttDatastoreStr != null);
                TwoTablesDatastore ttDatastore = TwoTablesDatastore.valueOf(ttDatastoreStr.toUpperCase());
                switch (ttDatastore) {
                    case RDBMS: {
                        return new TwoTablesRdbmsGraphConfigFactory(this.strict, this.parseHiddenValues);
                    }
                    case FILE: {
                        return new TwoTablesTextGraphConfigFactory(this.strict, this.parseHiddenValues);
                    }
                }
                throw new UnsupportedOperationException("unsupported Two Tables Datastore " + (Object)((Object)ttDatastore));
            }
            case RDF: {
                return new RdfGraphConfigFactory(this.strict, this.parseHiddenValues);
            }
        }
        throw new UnsupportedOperationException("unsupported format " + (Object)((Object)format));
    }
}

