/*
 * Decompiled with CFR 0.152.
 */
package oracle.pgx.config;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import oracle.pgx.common.auth.PgxGeneralPermission;
import oracle.pgx.common.auth.PgxResourcePermission;
import oracle.pgx.common.util.ErrorMessages;
import oracle.pgx.config.AbstractAuthorizationEntityPermissionConfig;
import oracle.pgx.config.AbstractConfig;
import oracle.pgx.config.AuthorizationEntityConfig;
import oracle.pgx.config.AuthorizationEntityPermissionConfig;
import oracle.pgx.config.DataMemoryLimit;
import oracle.pgx.config.DataMemoryLimitType;
import oracle.pgx.config.PgxConfigPermission;

public abstract class AbstractAuthorizationEntityConfig
extends AbstractConfig {
    public abstract String getPgxUser();

    public abstract String getPgxRole();

    abstract List<AuthorizationEntityPermissionConfig> getPgxPermissions();

    public boolean isUser() {
        return this.getPgxUser() != null;
    }

    public boolean isRole() {
        return this.getPgxRole() != null;
    }

    public Permissions getAllPermissions() {
        Permissions permissions = new Permissions();
        permissions.addGraphPermissions(this.getPermissions(AuthorizationEntityPermissionConfig::getPreloadedGraph));
        permissions.addStoragePermissions(this.getPermissions(AuthorizationEntityPermissionConfig::getFileLocation));
        permissions.addGeneralPermissions(this.getGeneralPermissions());
        return permissions;
    }

    private Map<String, PgxResourcePermission> getPermissions(Function<AuthorizationEntityPermissionConfig, String> entityGetter) {
        return this.getPgxPermissions().stream().filter(item -> entityGetter.apply((AuthorizationEntityPermissionConfig)item) != null).collect(Collectors.toMap(entityGetter, AbstractAuthorizationEntityPermissionConfig::getPermission));
    }

    public List<PgxGeneralPermission> getGeneralPermissions() {
        return this.getPgxPermissions().stream().filter(item -> item.getGrant().isGeneralPermission()).map(AuthorizationEntityPermissionConfig::getGrant).map(PgxConfigPermission::toGeneralPermission).collect(Collectors.toList());
    }

    public abstract String getMaxDataMemorySize();

    public abstract Double getMaxDataMemoryRatio();

    @Override
    protected void validate() {
        super.validate();
        if (this.getPgxUser() == null && this.getPgxRole() == null) {
            throw new IllegalArgumentException(ErrorMessages.getMessage((String)"AUTH_NEITHER_USER_OR_ROLE_SPECIFIED", (Object[])new Object[0]));
        }
        if (this.getPgxUser() != null && this.getPgxRole() != null) {
            throw new IllegalArgumentException(ErrorMessages.getMessage((String)"AUTH_BOTH_USER_AND_ROLE_SPECIFIED", (Object[])new Object[0]));
        }
        this.getPgxPermissions().forEach(item -> {
            int count = 0;
            if (item.getPreloadedGraph() != null) {
                ++count;
            }
            if (item.getFileLocation() != null) {
                ++count;
            }
            if (item.getGrant().isGeneralPermission()) {
                ++count;
            }
            if (count == 0) {
                throw new IllegalArgumentException(ErrorMessages.getMessage((String)"AUTH_NO_RESOURCE_VALUE_SPECIFIED", (Object[])new Object[0]));
            }
            if (count > 1) {
                throw new IllegalArgumentException(ErrorMessages.getMessage((String)"AUTH_TOO_MANY_RESOURCES_VALUES_SPECIFIED", (Object[])new Object[0]));
            }
        });
        this.validateResourcePermissions(AuthorizationEntityPermissionConfig::getPreloadedGraph);
        this.validateResourcePermissions(AuthorizationEntityPermissionConfig::getFileLocation);
        this.validateMemoryLimits();
    }

    private void validateResourcePermissions(Function<AuthorizationEntityPermissionConfig, String> entityGetter) {
        HashSet resources = new HashSet();
        this.getPgxPermissions().stream().map(entityGetter).filter(Objects::nonNull).sorted().forEach(entry -> {
            if (resources.contains(entry)) {
                throw new IllegalArgumentException(ErrorMessages.getMessage((String)"AUTH_DUPLICATE_RESOURCE_ENTRY", (Object[])new Object[]{entry}));
            }
            resources.add(entry);
        });
    }

    public abstract boolean hasDefaultValue(AuthorizationEntityConfig.Field var1);

    protected boolean isMaxDataMemoryRatioSet() {
        return !this.hasDefaultValue(AuthorizationEntityConfig.Field.MAX_DATA_MEMORY_RATIO);
    }

    public DataMemoryLimit getMaxMemoryLimit() {
        return new DataMemoryLimit(this.isRole() ? DataMemoryLimitType.ROLE_SPECIFIC_MAX_DATA_MEMORY : DataMemoryLimitType.USER_SPECIFIC_MAX_DATA_MEMORY, this.getMaxDataMemorySize(), this.getMaxDataMemoryRatio(), this.isMaxDataMemoryRatioSet());
    }

    private void validateMemoryLimits() {
        DataMemoryLimit.validateInput(this.isRole() ? DataMemoryLimitType.ROLE_SPECIFIC_MAX_DATA_MEMORY : DataMemoryLimitType.USER_SPECIFIC_MAX_DATA_MEMORY, this.getMaxDataMemorySize(), this.getMaxDataMemoryRatio(), this.isMaxDataMemoryRatioSet());
    }

    public static final class Permissions {
        private final List<PgxGeneralPermission> generalPermissions = new ArrayList<PgxGeneralPermission>();
        private final Map<String, PgxResourcePermission> graphPermissions = new HashMap<String, PgxResourcePermission>();
        private final Map<String, PgxResourcePermission> storagePermissions = new HashMap<String, PgxResourcePermission>();

        public List<PgxGeneralPermission> getGeneralPermissions() {
            return this.generalPermissions;
        }

        private void addGeneralPermissions(List<PgxGeneralPermission> permissions) {
            this.generalPermissions.addAll(permissions);
        }

        public Map<String, PgxResourcePermission> getGraphPermissions() {
            return this.graphPermissions;
        }

        private void addGraphPermissions(Map<String, PgxResourcePermission> graphPermissions) {
            graphPermissions.forEach(this.graphPermissions::put);
        }

        public Map<String, PgxResourcePermission> getStoragePermissions() {
            return this.storagePermissions;
        }

        private void addStoragePermissions(Map<String, PgxResourcePermission> storagePermissions) {
            storagePermissions.forEach(this.storagePermissions::put);
        }
    }
}

