/*
 * Decompiled with CFR 0.152.
 */
package oracle.pgx.api.subgraph.internal;

import oracle.pgx.common.GmParseException;
import oracle.pgx.common.util.ErrorMessages;
import oracle.pgx.common.util.TemporalTypeUtils;
import oracle.pgx.config.PreparedQueryArgumentConfig;

public class PreparedStatementUtil {
    private PreparedStatementUtil() {
    }

    public static Object getValue(PreparedQueryArgumentConfig argument) {
        Object value;
        Object argumentValue = argument.getValue();
        try {
            switch (argument.getType()) {
                case BOOLEAN: 
                case DOUBLE: 
                case FLOAT: 
                case INTEGER: 
                case LONG: 
                case STRING: {
                    value = argumentValue;
                    break;
                }
                case LOCAL_DATE: {
                    value = TemporalTypeUtils.getAsLocalDate((Object)argumentValue);
                    break;
                }
                case TIME: {
                    value = TemporalTypeUtils.getAsLocalTime((Object)argumentValue);
                    break;
                }
                case TIME_WITH_TIMEZONE: {
                    value = TemporalTypeUtils.getAsOffsetTime((Object)argumentValue);
                    break;
                }
                case TIMESTAMP: {
                    value = TemporalTypeUtils.getAsLocalDateTime((Object)argumentValue);
                    break;
                }
                case TIMESTAMP_WITH_TIMEZONE: {
                    value = TemporalTypeUtils.getAsOffsetDateTime((Object)argumentValue);
                    break;
                }
                default: {
                    throw new IllegalStateException(ErrorMessages.getMessage((String)"PGQL_PREPARED_STATEMENT_UNKNOWN_TYPE", (Object[])new Object[]{argument.getType()}));
                }
            }
        }
        catch (GmParseException e) {
            throw new IllegalArgumentException(ErrorMessages.getMessage((String)"PREPARED_STATEMENT_FAILED_TO_PARSE_ARG", (Object[])new Object[0]));
        }
        if (!argument.getType().getTypeClass().isInstance(value)) {
            throw new IllegalArgumentException(ErrorMessages.getMessage((String)"PGQL_PREPARED_STATEMENT_TYPE_MISMATCH", (Object[])new Object[]{argument.getType().getTypeClass().getSimpleName(), value.getClass().getSimpleName()}));
        }
        return value;
    }
}

