/*
 * Decompiled with CFR 0.152.
 */
package oracle.pgx.api.internal;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Objects;
import oracle.pgx.api.internal.Entity;
import oracle.pgx.common.Link;
import oracle.pgx.common.LinkRel;
import oracle.pgx.common.PgxId;
import oracle.pgx.common.types.EntityType;
import oracle.pgx.common.types.IdType;
import oracle.pgx.config.LinkTemplate;

public class Edge
extends Entity {
    @JsonCreator
    public Edge(@JsonProperty(value="graphId") PgxId graphId, @JsonProperty(value="tableName") String tableName, @JsonProperty(value="idType") IdType keyType, @JsonProperty(value="key") Object key) {
        super(graphId, tableName, keyType == null ? IdType.LONG : keyType, key);
    }

    public Edge(PgxId graphId, IdType idType, Object localId) {
        this(graphId, "E", idType, localId);
    }

    @Override
    public EntityType getEntityType() {
        return EntityType.EDGE;
    }

    @Override
    public void injectLinks() {
        if (Objects.equals("E", this.tableName)) {
            Link selfLink = new Link(LinkRel.SELF, LinkTemplate.EDGE_SELF.generateLink(new Object[0]));
            Link labelLink = new Link(LinkRel.RELATED, LinkTemplate.EDGE_LABEL_SELF.generateLink(new Object[0]));
            Link vertexLink = new Link(LinkRel.RELATED, LinkTemplate.VERTEX_FROM_EDGE.generateLink(new Object[0]));
            this.addLinks(new Link[]{selfLink, labelLink, vertexLink});
        } else {
            Link selfInTableLink = new Link(LinkRel.SELF, LinkTemplate.EDGE_IN_TABLE_SELF.generateLink(new Object[0]));
            this.addLinks(new Link[]{selfInTableLink});
        }
    }

    @Override
    public final boolean isFromDefaultTable() {
        return Objects.equals("E", this.getTableName());
    }
}

