/*
 * Decompiled with CFR 0.152.
 */
package oracle.pgx.graphviz.library;

import java.lang.reflect.InvocationTargetException;
import java.util.Map;
import oracle.pgql.lang.PgqlException;
import oracle.pgx.graphviz.driver.Driver;
import oracle.pgx.graphviz.formatter.Formatter;
import oracle.pgx.graphviz.library.CachedQueryEnhancer;
import oracle.pgx.graphviz.library.QueryEnhancer;
import oracle.pgx.graphviz.library.autocompletion.PgqlCompleter;

public class Configuration {
    public static final String DRIVER_CLASS = "graphviz.driver.class";
    public static final String FORMATTER_CLASS = "graphviz.formatter.class";
    private static Driver driver;

    public static Driver createDriver(Map<String, Object> properties) {
        Driver driver = null;
        try {
            Class<?> driverClass = Class.forName((String)properties.get(DRIVER_CLASS));
            driver = (Driver)driverClass.getConstructor(Map.class).newInstance(properties);
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            e.printStackTrace();
        }
        return driver;
    }

    public static void initDriver(Map<String, Object> properties) throws ClassNotFoundException, InstantiationException, IllegalAccessException, IllegalArgumentException, InvocationTargetException, NoSuchMethodException, SecurityException {
        Class<?> driverClass = Class.forName((String)properties.get(DRIVER_CLASS));
        driver = (Driver)driverClass.getConstructor(Map.class).newInstance(properties);
    }

    public static <T> QueryEnhancer<T> getEnhancer(Map<String, Object> properties) {
        try {
            if (driver == null) {
                Configuration.initDriver(properties);
            }
            Class<?> formatterClass = Class.forName((String)properties.get(FORMATTER_CLASS));
            Formatter formatter = (Formatter)formatterClass.getConstructor(new Class[0]).newInstance(new Object[0]);
            String numCachedResultSets = (String)properties.get("num_cached_resultsets");
            if (numCachedResultSets == null || numCachedResultSets.equals("0")) {
                return new QueryEnhancer(driver, formatter);
            }
            return new CachedQueryEnhancer(driver, formatter, properties);
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException | PgqlException e) {
            throw new IllegalArgumentException("Could not instantiate driver or formatter", e);
        }
    }

    public static <T> QueryEnhancer<T> getEnhancer(Map<String, Object> properties, Driver driver) {
        try {
            Class<?> formatterClass = Class.forName((String)properties.get(FORMATTER_CLASS));
            Formatter formatter = (Formatter)formatterClass.getConstructor(new Class[0]).newInstance(new Object[0]);
            String numCachedResultSets = (String)properties.get("num_cached_resultsets");
            if (numCachedResultSets == null || numCachedResultSets.equals("0")) {
                return new QueryEnhancer(driver, formatter);
            }
            return new CachedQueryEnhancer(driver, formatter, properties);
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException | PgqlException e) {
            throw new IllegalArgumentException("Could not instantiate driver or formatter", e);
        }
    }

    public static PgqlCompleter getPgqlCompleter(Driver driver) {
        try {
            return new PgqlCompleter(driver);
        }
        catch (PgqlException e) {
            throw new IllegalArgumentException("Could not instantiate driver or formatter", e);
        }
    }

    public static PgqlCompleter getPgqlCompleter(Map<String, Object> properties) {
        try {
            if (driver == null) {
                Configuration.initDriver(properties);
            }
            PgqlCompleter pgqlCompleter = new PgqlCompleter(driver);
            return pgqlCompleter;
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException | PgqlException e) {
            throw new IllegalArgumentException("Could not instantiate driver or formatter", e);
        }
    }

    public static Driver getDriver(Map<String, Object> properties) {
        try {
            if (driver == null) {
                Configuration.initDriver(properties);
            }
            return driver;
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            throw new IllegalArgumentException("Could not instantiate driver", e);
        }
    }
}

