/*
 * Decompiled with CFR 0.152.
 */
package oracle.pg.rdbms.pgql.pgview.translation;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import oracle.pg.rdbms.pgql.BindValueInfo;
import oracle.pg.rdbms.pgql.DbmsUtils;
import oracle.pg.rdbms.pgql.PgqlUtils;
import oracle.pg.rdbms.pgql.QueryContext;
import oracle.pg.rdbms.pgql.pgview.metadata.MetadataConnector;
import oracle.pg.rdbms.pgql.pgview.translation.GraphPatternTranslator;
import oracle.pg.rdbms.pgql.pgview.translation.PathTranslator;
import oracle.pg.rdbms.pgql.pgview.translation.QueryTranslator;
import oracle.pg.rdbms.pgql.pgview.translation.SubqueryInfo;
import oracle.pg.rdbms.pgql.pgview.translation.TranslationInfo;
import oracle.pg.rdbms.pgql.pgview.translation.expression.NullExpression;
import oracle.pg.rdbms.pgql.pgview.util.Pair;
import oracle.pgql.lang.ir.DerivedTable;
import oracle.pgql.lang.ir.ExpAsVar;
import oracle.pgql.lang.ir.GraphPattern;
import oracle.pgql.lang.ir.GraphQuery;
import oracle.pgql.lang.ir.OrderBy;
import oracle.pgql.lang.ir.OrderByElem;
import oracle.pgql.lang.ir.QueryEdge;
import oracle.pgql.lang.ir.QueryExpression;
import oracle.pgql.lang.ir.QueryVariable;
import oracle.pgql.lang.ir.QueryVertex;
import oracle.pgql.lang.ir.SelectQuery;
import oracle.pgql.lang.ir.TableExpression;
import oracle.pgql.lang.ir.VertexPairConnection;
import oracle.pgql.lang.ir.unnest.OneRowPerStep;

class ExpressionTranslator {
    static final String DECODE = "DECODE";
    static final String ELEMENT_NUMBER = "element_number";
    static final String MATCH_NUMBER = "match_number";
    static final String KEY_TAG = "K";
    static final String MOD = "MOD";
    static final String REGEXP_INSTR = "REGEXP_INSTR";
    static final String REGEXP_REPLACE = "REGEXP_REPLACE";
    static final String REPLACE = "REPLACE";
    static final String REGEXP_EXP = "(\\,|\\(|\\)|\")";
    static final String JOIN_SUBQUERY_FUNCTION = "_ora_join_key_to_var_";
    static final String VARREF_SUBQUERY_FUNCTION = "_ora_varref_function_";
    static final String UNNESTED_EXP_FUNCTION = "_ora_unnested_function_";

    ExpressionTranslator() {
    }

    static String translateQueryExpression(QueryExpression queryExpression, QueryExpTransOptions transOptions) {
        switch (queryExpression.getExpType()) {
            case INTEGER: 
            case DECIMAL: 
            case STRING: 
            case BOOLEAN: 
            case DATE: 
            case TIME: 
            case TIMESTAMP: {
                return queryExpression.toString();
            }
            case TIME_WITH_TIMEZONE: 
            case TIMESTAMP_WITH_TIMEZONE: {
                return queryExpression.toString().replace("Z", "+00:00");
            }
            case SUB: {
                return ExpressionTranslator.translateBinaryExpression((QueryExpression.BinaryExpression)queryExpression, "-", transOptions);
            }
            case ADD: {
                return ExpressionTranslator.translateBinaryExpression((QueryExpression.BinaryExpression)queryExpression, "+", transOptions);
            }
            case MUL: {
                return ExpressionTranslator.translateBinaryExpression((QueryExpression.BinaryExpression)queryExpression, "*", transOptions);
            }
            case DIV: {
                return ExpressionTranslator.translateBinaryExpression((QueryExpression.BinaryExpression)queryExpression, "/", transOptions);
            }
            case MOD: {
                QueryExpression.BinaryExpression binaryExpression = (QueryExpression.BinaryExpression)queryExpression;
                String translatedExp1 = ExpressionTranslator.translateQueryExpression(binaryExpression.getExp1(), transOptions);
                String translatedExp2 = ExpressionTranslator.translateQueryExpression(binaryExpression.getExp2(), transOptions);
                return "MOD(" + translatedExp1 + ", " + translatedExp2 + ")";
            }
            case AND: {
                return ExpressionTranslator.translateBinaryExpression((QueryExpression.BinaryExpression)queryExpression, "AND", transOptions);
            }
            case OR: {
                return ExpressionTranslator.translateBinaryExpression((QueryExpression.BinaryExpression)queryExpression, "OR", transOptions);
            }
            case EQUAL: {
                return ExpressionTranslator.translateBinaryExpression((QueryExpression.BinaryExpression)queryExpression, "=", transOptions);
            }
            case NOT_EQUAL: {
                return ExpressionTranslator.translateBinaryExpression((QueryExpression.BinaryExpression)queryExpression, "<>", transOptions);
            }
            case GREATER: {
                return ExpressionTranslator.translateBinaryExpression((QueryExpression.BinaryExpression)queryExpression, ">", transOptions);
            }
            case GREATER_EQUAL: {
                return ExpressionTranslator.translateBinaryExpression((QueryExpression.BinaryExpression)queryExpression, ">=", transOptions);
            }
            case LESS: {
                return ExpressionTranslator.translateBinaryExpression((QueryExpression.BinaryExpression)queryExpression, "<", transOptions);
            }
            case LESS_EQUAL: {
                return ExpressionTranslator.translateBinaryExpression((QueryExpression.BinaryExpression)queryExpression, "<=", transOptions);
            }
            case CONCAT: {
                return ExpressionTranslator.translateBinaryExpression((QueryExpression.BinaryExpression)queryExpression, "||", transOptions);
            }
            case UMIN: {
                QueryExpression.UnaryExpression unaryExpression = (QueryExpression.UnaryExpression)queryExpression;
                return "-(" + ExpressionTranslator.translateQueryExpression(unaryExpression.getExp(), transOptions) + ")";
            }
            case NOT: {
                QueryExpression.UnaryExpression unaryExpression = (QueryExpression.UnaryExpression)queryExpression;
                return "NOT(" + ExpressionTranslator.translateQueryExpression(unaryExpression.getExp(), transOptions) + ")";
            }
            case AGGR_COUNT: {
                return ExpressionTranslator.translateAggregate((QueryExpression.Aggregation.AbstractAggregation)queryExpression, "COUNT", "", transOptions, false);
            }
            case AGGR_MIN: {
                return ExpressionTranslator.translateAggregate((QueryExpression.Aggregation.AbstractAggregation)queryExpression, "MIN", "", transOptions, false);
            }
            case AGGR_MAX: {
                return ExpressionTranslator.translateAggregate((QueryExpression.Aggregation.AbstractAggregation)queryExpression, "MAX", "", transOptions, false);
            }
            case AGGR_SUM: {
                return ExpressionTranslator.translateAggregate((QueryExpression.Aggregation.AbstractAggregation)queryExpression, "SUM", "", transOptions, false);
            }
            case AGGR_AVG: {
                return ExpressionTranslator.translateAggregate((QueryExpression.Aggregation.AbstractAggregation)queryExpression, "AVG", "", transOptions, false);
            }
            case AGGR_LISTAGG: {
                QueryExpression.Aggregation.AggrListagg listagg = (QueryExpression.Aggregation.AggrListagg)queryExpression;
                return ExpressionTranslator.translateAggregate((QueryExpression.Aggregation.AbstractAggregation)listagg, "LISTAGG", listagg.getSeparator(), transOptions, false);
            }
            case AGGR_JSON_ARRAYAGG: {
                QueryExpression.Aggregation.AggrJsonArrayagg jsonArrayagg = (QueryExpression.Aggregation.AggrJsonArrayagg)queryExpression;
                return ExpressionTranslator.translateJsonArrayagg(jsonArrayagg, transOptions, false);
            }
            case VARREF: {
                QueryVariable variable = ((QueryExpression.VarRef)queryExpression).getVariable();
                boolean isParentVar = transOptions.subqueryInfo.parentVariables.containsKey(variable.getName());
                if (isParentVar && variable.getVariableType() == QueryVariable.VariableType.EXP_AS_VAR) {
                    return PgqlUtils.escapeAndEnquoteIdentifier(((ExpAsVar)variable).getExp().toString());
                }
                switch (variable.getVariableType()) {
                    case EXP_AS_VAR: {
                        if (transOptions.useAlias) {
                            return PgqlUtils.escapeAndEnquoteIdentifier(variable.getName());
                        }
                        return ExpressionTranslator.translateQueryExpression(((ExpAsVar)variable).getExp(), transOptions);
                    }
                    case VERTEX: 
                    case EDGE: {
                        return PgqlUtils.escapeAndEnquoteIdentifier(queryExpression.toString());
                    }
                }
                throw new IllegalArgumentException("Cannot project variable of type " + variable.getVariableType());
            }
            case BIND_VARIABLE: {
                QueryExpression.BindVariable bv = (QueryExpression.BindVariable)queryExpression;
                return BindValueInfo.getBvEncoding(bv);
            }
            case STAR: {
                return "*";
            }
            case SCALAR_SUBQUERY: {
                if ("null".equals(queryExpression.toString())) {
                    return "null";
                }
                String translatedExp1 = ExpressionTranslator.translateSubquery((QueryExpression.Subquery)((QueryExpression.ScalarSubquery)queryExpression), transOptions);
                return "(" + translatedExp1 + ")";
            }
            case EXISTS: {
                String translatedExp1 = ExpressionTranslator.translateSubquery((QueryExpression.Subquery)((QueryExpression.Function.Exists)queryExpression), transOptions);
                return "EXISTS (" + translatedExp1 + ")";
            }
            case PROP_ACCESS: {
                boolean varIsInScope;
                QueryExpression.PropertyAccess propertyAccess = (QueryExpression.PropertyAccess)queryExpression;
                boolean isParentVar = transOptions.subqueryInfo.parentVariables.containsKey(propertyAccess.getVariable().getName());
                boolean bl = varIsInScope = transOptions.forWhere && (!isParentVar || transOptions.subqueryInfo.forParentWhere);
                if (varIsInScope) {
                    return ExpressionTranslator.escapePropertyAccess(propertyAccess);
                }
                return ExpressionTranslator.aggregateIfRequired(PgqlUtils.escapeAndEnquoteIdentifier(propertyAccess.toString()), transOptions.addAggregate);
            }
            case CAST: {
                QueryExpression.Function.Cast cast = (QueryExpression.Function.Cast)queryExpression;
                String translatedExp1 = ExpressionTranslator.translateQueryExpression(cast.getExp(), transOptions);
                return "CAST(" + translatedExp1 + " AS " + cast.getTargetTypeName().replace("TIMEZONE", "TIME ZONE") + ")";
            }
            case FUNCTION_CALL: {
                QueryExpression.FunctionCall functionCall = (QueryExpression.FunctionCall)queryExpression;
                String schemaName = functionCall.getSchemaName();
                String packageName = functionCall.getPackageName();
                String functionName = functionCall.getFunctionName().toLowerCase();
                List translatedArgs = functionCall.getArgs().stream().map(x -> ExpressionTranslator.translateQueryExpression(x, transOptions)).collect(Collectors.toList());
                if (schemaName == null) {
                    if (packageName == null) {
                        if (functionName.equals("id") || functionName.equals("label") || functionName.equals("is_source_of") || functionName.equals("is_destination_of") || functionName.equals(ELEMENT_NUMBER) || functionName.equals(MATCH_NUMBER)) {
                            return ExpressionTranslator.aggregateIfRequired(PgqlUtils.escapeAndEnquoteIdentifier(functionCall.toString()), transOptions.addAggregate);
                        }
                        if (functionName.equals("has_label")) {
                            String translatedExp1 = ExpressionTranslator.translateQueryExpression((QueryExpression)new QueryExpression.FunctionCall("label", PgqlUtils.buildList(functionCall.getArgs().get(0))), transOptions);
                            String translatedExp2 = ExpressionTranslator.translateQueryExpression((QueryExpression)functionCall.getArgs().get(1), transOptions);
                            return "(" + translatedExp1 + " = " + translatedExp2 + ")";
                        }
                        if (functionName.equals("java_regexp_like")) {
                            return "REGEXP_INSTR(" + (String)translatedArgs.get(0) + ", " + (String)translatedArgs.get(1) + ") > 0";
                        }
                        if (functionName.equals("all_different")) {
                            if (translatedArgs.size() < 2) {
                                return "1 = 1";
                            }
                            StringBuilder translatedExp = new StringBuilder("(");
                            boolean appendAnd = false;
                            for (int i = 0; i < translatedArgs.size() - 1; ++i) {
                                for (int j = i + 1; j < translatedArgs.size(); ++j) {
                                    if (appendAnd) {
                                        translatedExp.append(" AND ");
                                    }
                                    appendAnd = true;
                                    translatedExp.append("(").append((String)translatedArgs.get(i)).append(" <> ").append((String)translatedArgs.get(j)).append(")");
                                }
                            }
                            translatedExp.append(")");
                            return translatedExp.toString();
                        }
                        if (functionName.equals("ceiling")) {
                            return "CEIL(" + String.join((CharSequence)", ", translatedArgs) + ")";
                        }
                        if (functionName.equals(JOIN_SUBQUERY_FUNCTION)) {
                            String exp = ((QueryExpression.VarRef)functionCall.getArgs().get(0)).getVariable().getName();
                            QueryExpression.FunctionCall f = (QueryExpression.FunctionCall)functionCall.getArgs().get(1);
                            String join = "";
                            for (int i = 0; i < f.getArgs().size(); ++i) {
                                if (i > 0) {
                                    join = join + " AND ";
                                }
                                join = join + f.getArgs().get(i) + " = " + PgqlUtils.escapeAndEnquoteIdentifier(exp + "_" + i);
                            }
                            return join;
                        }
                        if (functionName.equals(VARREF_SUBQUERY_FUNCTION)) {
                            QueryExpression exp = (QueryExpression)functionCall.getArgs().get(0);
                            switch (exp.getExpType()) {
                                case VARREF: {
                                    QueryExpression.VarRef varRef = (QueryExpression.VarRef)exp;
                                    if (varRef.getVariable().getVariableType() == QueryVariable.VariableType.EXP_AS_VAR) {
                                        return PgqlUtils.escapeAndEnquoteIdentifier(varRef.getVariable().getName());
                                    }
                                    return PgqlUtils.escapeAndEnquoteIdentifier(varRef.toString());
                                }
                                case AGGR_LISTAGG: {
                                    QueryExpression.Aggregation.AggrListagg listagg = (QueryExpression.Aggregation.AggrListagg)exp;
                                    return ExpressionTranslator.translateAggregate((QueryExpression.Aggregation.AbstractAggregation)listagg, "LISTAGG", listagg.getSeparator(), transOptions, true);
                                }
                                case AGGR_JSON_ARRAYAGG: {
                                    QueryExpression.Aggregation.AggrJsonArrayagg jsonArrayagg = (QueryExpression.Aggregation.AggrJsonArrayagg)exp;
                                    return ExpressionTranslator.translateJsonArrayagg(jsonArrayagg, transOptions, true);
                                }
                                case AGGR_SUM: {
                                    return ExpressionTranslator.translateAggregate((QueryExpression.Aggregation.AbstractAggregation)exp, "SUM", "", transOptions, true);
                                }
                                case AGGR_MIN: {
                                    return ExpressionTranslator.translateAggregate((QueryExpression.Aggregation.AbstractAggregation)exp, "MIN", "", transOptions, true);
                                }
                                case AGGR_MAX: {
                                    return ExpressionTranslator.translateAggregate((QueryExpression.Aggregation.AbstractAggregation)exp, "MAX", "", transOptions, true);
                                }
                                case AGGR_AVG: {
                                    return ExpressionTranslator.translateAggregate((QueryExpression.Aggregation.AbstractAggregation)exp, "AVG", "", transOptions, true);
                                }
                                case AGGR_COUNT: {
                                    return ExpressionTranslator.translateAggregate((QueryExpression.Aggregation.AbstractAggregation)exp, "COUNT", "", transOptions, true);
                                }
                                case AGGR_ARRAY_AGG: {
                                    throw new UnsupportedOperationException("ARRAY_AGG not supported");
                                }
                            }
                            return PgqlUtils.escapeAndEnquoteIdentifier(exp.toString());
                        }
                        if (functionName.equals(UNNESTED_EXP_FUNCTION)) {
                            boolean isParentExpression = oracle.pgql.lang.ir.PgqlUtils.getVariables((QueryExpression)functionCall).stream().allMatch(var -> transOptions.subqueryInfo.parentVariables.containsKey(var.getName()));
                            if (isParentExpression) {
                                return PgqlUtils.escapeAndEnquoteIdentifier(((QueryExpression)functionCall.getArgs().get(0)).toString());
                            }
                            return GraphPatternTranslator.getUnnestedExpressionReference(functionCall, transOptions.pathExpressions);
                        }
                        return PgqlUtils.escapeAndEnquoteIdentifier(functionCall.getFunctionName(), false) + "(" + String.join((CharSequence)", ", translatedArgs) + ")";
                    }
                    return PgqlUtils.escapeAndEnquoteIdentifier(functionCall.getPackageName()) + "." + PgqlUtils.escapeAndEnquoteIdentifier(functionCall.getFunctionName(), false) + "(" + String.join((CharSequence)", ", translatedArgs) + ")";
                }
                return PgqlUtils.escapeAndEnquoteIdentifier(functionCall.getSchemaName()) + PgqlUtils.escapeAndEnquoteIdentifier(functionCall.getPackageName()) + "." + PgqlUtils.escapeAndEnquoteIdentifier(functionCall.getFunctionName(), false) + "(" + String.join((CharSequence)", ", translatedArgs) + ")";
            }
            case EXTRACT_EXPRESSION: {
                QueryExpression.ExtractExpression extract = (QueryExpression.ExtractExpression)queryExpression;
                String translatedExp1 = ExpressionTranslator.translateQueryExpression(extract.getExp(), transOptions);
                return "EXTRACT(" + extract.getField() + " FROM " + translatedExp1 + ")";
            }
            case IN_EXPRESSION: {
                QueryExpression.InPredicate inPredicate = (QueryExpression.InPredicate)queryExpression;
                String translatedExp1 = ExpressionTranslator.translateQueryExpression(inPredicate.getExp(), transOptions);
                String translatedExp2 = ExpressionTranslator.translateQueryExpression(inPredicate.getInValueList(), transOptions);
                return translatedExp1 + " IN " + translatedExp2;
            }
            case IN_VALUE_LIST: {
                return queryExpression.toString();
            }
            case IS_NULL: {
                QueryExpression.IsNull isNull = (QueryExpression.IsNull)queryExpression;
                String translatedExp1 = ExpressionTranslator.translateQueryExpression(isNull.getExp(), transOptions);
                return translatedExp1 + " IS NULL";
            }
            case IF_ELSE: {
                QueryExpression.IfElse ifElse = (QueryExpression.IfElse)queryExpression;
                String translatedExp1 = ExpressionTranslator.translateQueryExpression(ifElse.getExp1(), transOptions);
                String translatedExp2 = ExpressionTranslator.translateQueryExpression(ifElse.getExp2(), transOptions);
                String elseExp = "";
                if (ifElse.getExp3() != null) {
                    String translatedExp3 = ExpressionTranslator.translateQueryExpression(ifElse.getExp3(), transOptions);
                    elseExp = " ELSE " + translatedExp3;
                }
                return "CASE WHEN " + translatedExp1 + " THEN " + translatedExp2 + elseExp + " END";
            }
            case SIMPLE_CASE: {
                QueryExpression.SimpleCase simpleCase = (QueryExpression.SimpleCase)queryExpression;
                StringBuilder translatedExp = new StringBuilder("CASE ").append(ExpressionTranslator.translateQueryExpression(simpleCase.getCaseOperand(), transOptions));
                for (QueryExpression.WhenThenExpression whenThen : simpleCase.getWhenThenExps()) {
                    translatedExp.append(" WHEN ").append(ExpressionTranslator.translateQueryExpression(whenThen.getWhen(), transOptions)).append(" THEN ").append(ExpressionTranslator.translateQueryExpression(whenThen.getThen(), transOptions));
                }
                if (simpleCase.getElseExp() != null) {
                    translatedExp.append(" ELSE ").append(ExpressionTranslator.translateQueryExpression(simpleCase.getElseExp(), transOptions));
                }
                translatedExp.append(" END");
                return translatedExp.toString();
            }
            case SOURCE_DESTINATION_PREDICATE: {
                return ExpressionTranslator.aggregateIfRequired(PgqlUtils.escapeAndEnquoteIdentifier(queryExpression.toString()), transOptions.addAggregate);
            }
            case SUBSTRING: {
                QueryExpression.SubstringExpression substring = (QueryExpression.SubstringExpression)queryExpression;
                String translatedExp1 = ExpressionTranslator.translateQueryExpression(substring.getExp(), transOptions);
                String translatedExp2 = ExpressionTranslator.translateQueryExpression(substring.getStartPosition(), transOptions);
                String translatedExp3 = "";
                if (substring.getStringLength() != null) {
                    translatedExp3 = ", " + ExpressionTranslator.translateQueryExpression(substring.getStringLength(), transOptions);
                }
                return "SUBSTR(" + translatedExp1 + ", " + translatedExp2 + translatedExp3 + ")";
            }
        }
        throw new UnsupportedOperationException("Expression " + queryExpression + " of type " + queryExpression.getExpType() + " is not supported");
    }

    private static String translateWithoutAggregate(QueryExpression exp, QueryExpTransOptions transOptions) {
        boolean prevAddAggregate = transOptions.addAggregate;
        transOptions.addAggregate = false;
        String translatedExp = ExpressionTranslator.translateQueryExpression(exp, transOptions);
        transOptions.addAggregate = prevAddAggregate;
        return translatedExp;
    }

    private static String translateJsonArrayagg(QueryExpression.Aggregation.AggrJsonArrayagg jsonArrayagg, QueryExpTransOptions transOptions, boolean isOuterAgg) {
        String formatJson = jsonArrayagg.isFormatJson() ? " FORMAT JSON" : "";
        String orderBy = jsonArrayagg.getOrderBy().getElements().isEmpty() ? "" : " ORDER BY " + jsonArrayagg.getOrderBy().getElements().stream().map(orderByElem -> ExpressionTranslator.translateWithoutAggregate(orderByElem.getExp(), transOptions) + (orderByElem.isAscending() ? "" : " DESC")).collect(Collectors.joining(", "));
        String jsonOnNull = jsonArrayagg.getJsonOnNull() == QueryExpression.JsonOnNull.NULL_ON_NULL ? " NULL ON NULL" : "";
        String jsonReturnType = jsonArrayagg.getJsonReturnType() == null ? "" : " RETURNING " + jsonArrayagg.getJsonReturnType();
        return ExpressionTranslator.translateAggregate((QueryExpression.Aggregation.AbstractAggregation)jsonArrayagg, "JSON_ARRAYAGG", "", formatJson, orderBy, jsonOnNull, jsonReturnType, transOptions, isOuterAgg);
    }

    private static String translateSubquery(QueryExpression.Subquery subquery, QueryExpTransOptions transOptions) {
        SelectQuery select = subquery.getQuery();
        List<SubqueryInfo.Constraints> originalConstraints = null;
        if (transOptions.extraConstraints != null) {
            originalConstraints = ExpressionTranslator.pushConstraints(subquery, transOptions.extraConstraints, true);
        }
        HashMap<String, Pair<Boolean, QueryVariable>> parentVariables = new HashMap<String, Pair<Boolean, QueryVariable>>(transOptions.subqueryInfo.parentVariables);
        parentVariables.putAll(transOptions.subqueryInfo.variables);
        if (!transOptions.forSelect) {
            parentVariables.putAll(transOptions.subqueryInfo.selectAliases);
        }
        HashMap<String, Pair<Boolean, QueryVariable>> parentGroupByVariables = null;
        if (transOptions.subqueryInfo.groupByVariables != null) {
            parentGroupByVariables = new HashMap<String, Pair<Boolean, QueryVariable>>(transOptions.subqueryInfo.groupByVariables);
            if (transOptions.subqueryInfo.parentGroupByVariables != null) {
                parentGroupByVariables.putAll(transOptions.subqueryInfo.parentGroupByVariables);
            }
        }
        HashSet<VertexPairConnection> parentConnections = new HashSet<VertexPairConnection>(transOptions.subqueryInfo.parentConnections);
        parentConnections.addAll(transOptions.subqueryInfo.connections);
        String translatedExp = QueryTranslator.translateQuery((GraphQuery)select, transOptions.metadataConnector, transOptions.ctx, new SubqueryInfo(parentVariables, transOptions.subqueryInfo.unnestedVariables, parentGroupByVariables, parentConnections, transOptions.forWhere, transOptions.parentConf, !transOptions.addAggregate)).prettyPrint();
        if (originalConstraints != null) {
            ExpressionTranslator.pushConstraints(subquery, originalConstraints, false);
        }
        String[] translation = new String[]{translatedExp};
        DbmsUtils.removeWithClause(translation);
        return translation[0];
    }

    static String aggregateIfRequired(String expression, boolean addAggregate) {
        if (addAggregate) {
            return "MAX(" + expression + ")";
        }
        return expression;
    }

    private static String translateBinaryExpression(QueryExpression.BinaryExpression binaryExpression, String operator, QueryExpTransOptions transOptions) {
        String translatedExp1 = ExpressionTranslator.translateQueryExpression(binaryExpression.getExp1(), transOptions);
        String translatedExp2 = ExpressionTranslator.translateQueryExpression(binaryExpression.getExp2(), transOptions);
        return "(" + translatedExp1 + " " + operator + " " + translatedExp2 + ")";
    }

    private static String translateAggregate(QueryExpression.Aggregation.AbstractAggregation agg, String operator, String separator, QueryExpTransOptions transOptions, boolean isOuterAgg) {
        return ExpressionTranslator.translateAggregate(agg, operator, separator, "", "", "", "", transOptions, isOuterAgg);
    }

    private static String translateAggregate(QueryExpression.Aggregation.AbstractAggregation agg, String operator, String separator, String formatJson, String orderBy, String jsonOnNull, String jsonReturnType, QueryExpTransOptions transOptions, boolean isOuterAgg) {
        if (transOptions.pathExpressions.containsKey(agg)) {
            PathTranslator.PathExpressionInfo info = transOptions.pathExpressions.get(agg);
            String aggTrans = transOptions.forWhere && !isOuterAgg ? new QueryExpression.PropertyAccess((QueryVariable)info.queryPath, "EXP_PATH").toString() : PgqlUtils.escapeAndEnquoteIdentifier(agg.toString());
            String exp = ExpressionTranslator.castForMinMax("exp", agg, transOptions);
            return "(select " + ExpressionTranslator.getAggregateTranslation(operator, agg.isDistinct(), exp, separator, formatJson, orderBy, jsonOnNull, jsonReturnType, info.isReversed) + " from xmltable('/EXP_PATH/EXPRESSIONS' passing xmltype(nvl(" + aggTrans + ", '')) columns exp varchar2(4000) path '/EXPRESSIONS/EXP" + transOptions.pathExpressions.get((Object)agg).expNumber + "'))";
        }
        String translatedExp = ExpressionTranslator.translateWithoutAggregate(agg.getExp(), transOptions);
        return ExpressionTranslator.getAggregateTranslation(operator, agg.isDistinct(), translatedExp, separator, formatJson, orderBy, jsonOnNull, jsonReturnType, false);
    }

    private static String castForMinMax(String expression, QueryExpression.Aggregation.AbstractAggregation agg, QueryExpTransOptions transOptions) {
        switch (agg.getExpType()) {
            case AGGR_SUM: 
            case AGGR_AVG: {
                return "CAST(" + expression + " AS number)";
            }
            case AGGR_MIN: 
            case AGGR_MAX: {
                if (agg.getExp().getExpType().equals((Object)QueryExpression.ExpressionType.CAST)) {
                    String dataType = ((QueryExpression.Function.Cast)agg.getExp()).getTargetTypeName();
                    return "CAST(" + expression + " as " + dataType + ")";
                }
                if (agg.getExp().getExpType().equals((Object)QueryExpression.ExpressionType.PROP_ACCESS)) {
                    String dataType = "" + transOptions.pathExpressions.get((Object)agg).dataType;
                    return "CAST(" + expression + " as " + dataType + ")";
                }
                throw new UnsupportedOperationException("Path aggregate MIN/MAX on expressions is not supported");
            }
        }
        return expression;
    }

    private static String getAggregateTranslation(String operator, boolean isDistinct, String exp, String separator, String formatJson, String orderBy, String jsonOnNull, String jsonReturnType, boolean isReversed) {
        String distinct = isDistinct ? "DISTINCT " : "";
        String separatorTrans = "";
        String withinClause = "";
        if ("LISTAGG".equals(operator)) {
            withinClause = " WITHIN GROUP (ORDER BY rownum" + (isReversed ? " desc" : "") + ")";
        }
        if (separator.length() > 0) {
            separatorTrans = ", " + oracle.pgql.lang.ir.PgqlUtils.printLiteral((String)separator);
        }
        return operator + "(" + distinct + exp + separatorTrans + formatJson + orderBy + jsonOnNull + jsonReturnType + ")" + withinClause;
    }

    static String escapePropertyAccess(QueryExpression.PropertyAccess propertyAccess) {
        return oracle.pgql.lang.ir.PgqlUtils.printIdentifier((String)propertyAccess.getVariable().getName(), (boolean)true) + "." + oracle.pgql.lang.ir.PgqlUtils.printIdentifier((String)propertyAccess.getPropertyName(), (boolean)true);
    }

    static QueryExpression translateForSubSelect(QueryExpression queryExpression, SubSelectTransOptions transOptions) {
        QueryExpression.ExpressionType type = queryExpression.getExpType();
        switch (type) {
            case INTEGER: 
            case DECIMAL: 
            case STRING: 
            case BOOLEAN: 
            case DATE: 
            case TIME: 
            case TIMESTAMP: 
            case TIME_WITH_TIMEZONE: 
            case TIMESTAMP_WITH_TIMEZONE: {
                return queryExpression;
            }
            case SUB: {
                QueryExpression.BinaryExpression binaryExpression = (QueryExpression.BinaryExpression)queryExpression;
                QueryExpression translatedExp1 = ExpressionTranslator.translateForSubSelect(binaryExpression.getExp1(), transOptions);
                QueryExpression translatedExp2 = ExpressionTranslator.translateForSubSelect(binaryExpression.getExp2(), transOptions);
                return new QueryExpression.ArithmeticExpression.Sub(translatedExp1, translatedExp2);
            }
            case ADD: {
                QueryExpression.BinaryExpression binaryExpression = (QueryExpression.BinaryExpression)queryExpression;
                QueryExpression translatedExp1 = ExpressionTranslator.translateForSubSelect(binaryExpression.getExp1(), transOptions);
                QueryExpression translatedExp2 = ExpressionTranslator.translateForSubSelect(binaryExpression.getExp2(), transOptions);
                return new QueryExpression.ArithmeticExpression.Add(translatedExp1, translatedExp2);
            }
            case MUL: {
                QueryExpression.BinaryExpression binaryExpression = (QueryExpression.BinaryExpression)queryExpression;
                QueryExpression translatedExp1 = ExpressionTranslator.translateForSubSelect(binaryExpression.getExp1(), transOptions);
                QueryExpression translatedExp2 = ExpressionTranslator.translateForSubSelect(binaryExpression.getExp2(), transOptions);
                return new QueryExpression.ArithmeticExpression.Mul(translatedExp1, translatedExp2);
            }
            case DIV: {
                QueryExpression.BinaryExpression binaryExpression = (QueryExpression.BinaryExpression)queryExpression;
                QueryExpression translatedExp1 = ExpressionTranslator.translateForSubSelect(binaryExpression.getExp1(), transOptions);
                QueryExpression translatedExp2 = ExpressionTranslator.translateForSubSelect(binaryExpression.getExp2(), transOptions);
                return new QueryExpression.ArithmeticExpression.Div(translatedExp1, translatedExp2);
            }
            case MOD: {
                QueryExpression.BinaryExpression binaryExpression = (QueryExpression.BinaryExpression)queryExpression;
                QueryExpression translatedExp1 = ExpressionTranslator.translateForSubSelect(binaryExpression.getExp1(), transOptions);
                QueryExpression translatedExp2 = ExpressionTranslator.translateForSubSelect(binaryExpression.getExp2(), transOptions);
                ArrayList<QueryExpression> args = new ArrayList<QueryExpression>();
                args.add(translatedExp1);
                args.add(translatedExp2);
                return new QueryExpression.FunctionCall(MOD, args);
            }
            case AND: {
                QueryExpression.BinaryExpression binaryExpression = (QueryExpression.BinaryExpression)queryExpression;
                QueryExpression translatedExp1 = ExpressionTranslator.translateForSubSelect(binaryExpression.getExp1(), transOptions);
                QueryExpression translatedExp2 = ExpressionTranslator.translateForSubSelect(binaryExpression.getExp2(), transOptions);
                return new QueryExpression.LogicalExpression.And(translatedExp1, translatedExp2);
            }
            case OR: {
                QueryExpression.BinaryExpression binaryExpression = (QueryExpression.BinaryExpression)queryExpression;
                QueryExpression translatedExp1 = ExpressionTranslator.translateForSubSelect(binaryExpression.getExp1(), transOptions);
                QueryExpression translatedExp2 = ExpressionTranslator.translateForSubSelect(binaryExpression.getExp2(), transOptions);
                return new QueryExpression.LogicalExpression.Or(translatedExp1, translatedExp2);
            }
            case EQUAL: {
                QueryExpression.BinaryExpression binaryExpression = (QueryExpression.BinaryExpression)queryExpression;
                QueryExpression translatedExp1 = ExpressionTranslator.translateForSubSelect(binaryExpression.getExp1(), transOptions);
                QueryExpression translatedExp2 = ExpressionTranslator.translateForSubSelect(binaryExpression.getExp2(), transOptions);
                return new QueryExpression.RelationalExpression.Equal(translatedExp1, translatedExp2);
            }
            case NOT_EQUAL: {
                QueryExpression.BinaryExpression binaryExpression = (QueryExpression.BinaryExpression)queryExpression;
                QueryExpression translatedExp1 = ExpressionTranslator.translateForSubSelect(binaryExpression.getExp1(), transOptions);
                QueryExpression translatedExp2 = ExpressionTranslator.translateForSubSelect(binaryExpression.getExp2(), transOptions);
                return new QueryExpression.RelationalExpression.NotEqual(translatedExp1, translatedExp2);
            }
            case GREATER: {
                QueryExpression.BinaryExpression binaryExpression = (QueryExpression.BinaryExpression)queryExpression;
                QueryExpression translatedExp1 = ExpressionTranslator.translateForSubSelect(binaryExpression.getExp1(), transOptions);
                QueryExpression translatedExp2 = ExpressionTranslator.translateForSubSelect(binaryExpression.getExp2(), transOptions);
                return new QueryExpression.RelationalExpression.Greater(translatedExp1, translatedExp2);
            }
            case GREATER_EQUAL: {
                QueryExpression.BinaryExpression binaryExpression = (QueryExpression.BinaryExpression)queryExpression;
                QueryExpression translatedExp1 = ExpressionTranslator.translateForSubSelect(binaryExpression.getExp1(), transOptions);
                QueryExpression translatedExp2 = ExpressionTranslator.translateForSubSelect(binaryExpression.getExp2(), transOptions);
                return new QueryExpression.RelationalExpression.GreaterEqual(translatedExp1, translatedExp2);
            }
            case LESS: {
                QueryExpression.BinaryExpression binaryExpression = (QueryExpression.BinaryExpression)queryExpression;
                QueryExpression translatedExp1 = ExpressionTranslator.translateForSubSelect(binaryExpression.getExp1(), transOptions);
                QueryExpression translatedExp2 = ExpressionTranslator.translateForSubSelect(binaryExpression.getExp2(), transOptions);
                return new QueryExpression.RelationalExpression.Less(translatedExp1, translatedExp2);
            }
            case LESS_EQUAL: {
                QueryExpression.BinaryExpression binaryExpression = (QueryExpression.BinaryExpression)queryExpression;
                QueryExpression translatedExp1 = ExpressionTranslator.translateForSubSelect(binaryExpression.getExp1(), transOptions);
                QueryExpression translatedExp2 = ExpressionTranslator.translateForSubSelect(binaryExpression.getExp2(), transOptions);
                return new QueryExpression.RelationalExpression.LessEqual(translatedExp1, translatedExp2);
            }
            case CONCAT: {
                QueryExpression.ConcatExpression concat = (QueryExpression.ConcatExpression)queryExpression;
                return new QueryExpression.ConcatExpression(ExpressionTranslator.translateForSubSelect(concat.getExp1(), transOptions), ExpressionTranslator.translateForSubSelect(concat.getExp2(), transOptions));
            }
            case UMIN: {
                QueryExpression.UnaryExpression unaryExpression = (QueryExpression.UnaryExpression)queryExpression;
                QueryExpression translatedExp = ExpressionTranslator.translateForSubSelect(unaryExpression.getExp(), transOptions);
                return new QueryExpression.ArithmeticExpression.UMin(translatedExp);
            }
            case NOT: {
                QueryExpression.UnaryExpression unaryExpression = (QueryExpression.UnaryExpression)queryExpression;
                QueryExpression translatedExp = ExpressionTranslator.translateForSubSelect(unaryExpression.getExp(), transOptions);
                if (translatedExp.getExpType() == QueryExpression.ExpressionType.BOOLEAN) {
                    QueryExpression.Constant.ConstBoolean constBoolean;
                    constBoolean.setValue((Object)((Boolean)(constBoolean = (QueryExpression.Constant.ConstBoolean)translatedExp).getValue() == false ? 1 : 0));
                    return constBoolean;
                }
                return new QueryExpression.LogicalExpression.Not(translatedExp);
            }
            case AGGR_COUNT: {
                return ExpressionTranslator.translateForSubSelect((QueryExpression.Aggregation.AbstractAggregation)queryExpression, transOptions, QueryExpression.Aggregation.AggrCount::new, null, false);
            }
            case AGGR_MIN: {
                return ExpressionTranslator.translateForSubSelect((QueryExpression.Aggregation.AbstractAggregation)queryExpression, transOptions, QueryExpression.Aggregation.AggrMin::new, null, false);
            }
            case AGGR_MAX: {
                return ExpressionTranslator.translateForSubSelect((QueryExpression.Aggregation.AbstractAggregation)queryExpression, transOptions, QueryExpression.Aggregation.AggrMax::new, null, false);
            }
            case AGGR_SUM: {
                return ExpressionTranslator.translateForSubSelect((QueryExpression.Aggregation.AbstractAggregation)queryExpression, transOptions, QueryExpression.Aggregation.AggrSum::new, null, false);
            }
            case AGGR_AVG: {
                return ExpressionTranslator.translateForSubSelect((QueryExpression.Aggregation.AbstractAggregation)queryExpression, transOptions, QueryExpression.Aggregation.AggrAvg::new, null, false);
            }
            case AGGR_ARRAY_AGG: {
                return ExpressionTranslator.translateForSubSelect((QueryExpression.Aggregation.AbstractAggregation)queryExpression, transOptions, QueryExpression.Aggregation.AggrArrayAgg::new, null, false);
            }
            case AGGR_LISTAGG: {
                QueryExpression.Aggregation.AggrListagg agg = (QueryExpression.Aggregation.AggrListagg)queryExpression;
                return ExpressionTranslator.translateForSubSelect((QueryExpression.Aggregation.AbstractAggregation)agg, transOptions, null, agg.getSeparator(), false);
            }
            case AGGR_JSON_ARRAYAGG: {
                QueryExpression.Aggregation.AggrJsonArrayagg jAgg = (QueryExpression.Aggregation.AggrJsonArrayagg)queryExpression;
                return ExpressionTranslator.translateForSubSelect((QueryExpression.Aggregation.AbstractAggregation)jAgg, transOptions, null, null, true);
            }
            case VARREF: {
                QueryExpression.VarRef varRef = (QueryExpression.VarRef)queryExpression;
                return ExpressionTranslator.getVarRefAccess(varRef, transOptions, true, false);
            }
            case BIND_VARIABLE: 
            case STAR: {
                return queryExpression;
            }
            case SCALAR_SUBQUERY: {
                QueryExpression.ScalarSubquery subquery = (QueryExpression.ScalarSubquery)queryExpression;
                ExpressionTranslator.processSubquery((QueryExpression.Subquery)subquery, transOptions);
                return subquery;
            }
            case EXISTS: {
                QueryExpression.Function.Exists exists = (QueryExpression.Function.Exists)queryExpression;
                ExpressionTranslator.processSubquery((QueryExpression.Subquery)exists, transOptions);
                return exists;
            }
            case PROP_ACCESS: {
                QueryExpression.PropertyAccess propertyAccess = (QueryExpression.PropertyAccess)queryExpression;
                QueryVariable variable = ExpressionTranslator.getQueryVariable(propertyAccess.getVariable());
                String propertyName = propertyAccess.getPropertyName();
                if (transOptions.translationInfo.getPathExpressions().containsKey(propertyAccess)) {
                    return new QueryExpression.FunctionCall(UNNESTED_EXP_FUNCTION, PgqlUtils.buildList(propertyAccess));
                }
                if (!(!transOptions.translationInfo.isParentVariable(variable.getName()) || transOptions.conf.containsKey(variable) && transOptions.translationInfo.isForParentWhere())) {
                    return propertyAccess;
                }
                String tableName = transOptions.conf.get(variable);
                if (variable.getVariableType() == QueryVariable.VariableType.VERTEX) {
                    return ExpressionTranslator.getPropertyAccess(variable, tableName, propertyName, transOptions.metadataConnector::isPropertyForVertexTable, transOptions.metadataConnector::getColumnNameForVertexTable);
                }
                if (variable.getVariableType() == QueryVariable.VariableType.EDGE) {
                    return ExpressionTranslator.getPropertyAccess(variable, tableName, propertyName, transOptions.metadataConnector::isPropertyForEdgeTable, transOptions.metadataConnector::getColumnNameForEdgeTable);
                }
                throw new UnsupportedOperationException("Property access on unsupported variable type: " + variable.getVariableType());
            }
            case CAST: {
                QueryExpression.Function.Cast cast = (QueryExpression.Function.Cast)queryExpression;
                return new QueryExpression.Function.Cast(ExpressionTranslator.translateForSubSelect(cast.getExp(), transOptions), cast.getTargetTypeName());
            }
            case FUNCTION_CALL: {
                QueryExpression.FunctionCall functionCall = (QueryExpression.FunctionCall)queryExpression;
                String schemaName = functionCall.getSchemaName();
                String packageName = functionCall.getPackageName();
                String functionName = functionCall.getFunctionName().toLowerCase();
                if (functionName.equals(VARREF_SUBQUERY_FUNCTION)) {
                    return functionCall;
                }
                if (schemaName == null && packageName == null) {
                    if (transOptions.translationInfo.getPathExpressions().containsKey(functionCall)) {
                        if (functionCall.getFunctionName().equals("_ora_comp_key_f_")) {
                            QueryVertex pathVar;
                            String variableName = ((QueryExpression.VarRef)functionCall.getArgs().get(0)).getVariable().getName();
                            PathTranslator.PathExpressionInfo info = transOptions.translationInfo.getPathExpressions().get(functionCall);
                            OneRowPerStep orps = (OneRowPerStep)info.queryPath.getRowsPerMatch();
                            if (variableName.equals(orps.getVertex1().getName())) {
                                pathVar = info.queryPath.getSrc();
                            } else if (variableName.equals(orps.getVertex2().getName())) {
                                pathVar = info.queryPath.getDst();
                            } else {
                                throw new IllegalArgumentException("Invalid variable:" + variableName);
                            }
                            String elementTable = transOptions.conf.get(pathVar);
                            info.numKeyColumns = transOptions.metadataConnector.getVertexTableKey(elementTable).size();
                        }
                        return new QueryExpression.FunctionCall(UNNESTED_EXP_FUNCTION, PgqlUtils.buildList(functionCall));
                    }
                    if (functionName.equals("id")) {
                        return ExpressionTranslator.translateKeyAccess(functionCall, transOptions);
                    }
                    if (functionName.equals("label")) {
                        return ExpressionTranslator.translateLabel(functionCall, transOptions.conf, transOptions.metadataConnector);
                    }
                    if (functionCall.getFunctionName().equalsIgnoreCase("has_label")) {
                        QueryExpression labelTranslation = ExpressionTranslator.translateForSubSelect((QueryExpression)new QueryExpression.FunctionCall("label", PgqlUtils.buildList(functionCall.getArgs().get(0))), transOptions);
                        QueryExpression labelStr = ExpressionTranslator.translateForSubSelect((QueryExpression)functionCall.getArgs().get(1), transOptions);
                        return new QueryExpression.RelationalExpression.Equal(labelTranslation, labelStr);
                    }
                    if (functionName.equals("_ora_comp_key_f_")) {
                        return ExpressionTranslator.getVarRefAccess((QueryExpression.VarRef)functionCall.getArgs().get(0), transOptions, false, false);
                    }
                    if (functionName.equals("_ora_comp_key_xml_f_")) {
                        return ExpressionTranslator.getVarRefAccess((QueryExpression.VarRef)functionCall.getArgs().get(0), transOptions, false, true);
                    }
                    if (functionName.equals(JOIN_SUBQUERY_FUNCTION)) {
                        QueryExpression.VarRef v = (QueryExpression.VarRef)functionCall.getArgs().get(0);
                        ArrayList<QueryExpression> l = new ArrayList<QueryExpression>(functionCall.getArgs());
                        l.add(ExpressionTranslator.getVarRefAccess(v, transOptions, false, false));
                        return new QueryExpression.FunctionCall(JOIN_SUBQUERY_FUNCTION, l);
                    }
                    if (functionName.equals("is_source_of")) {
                        return ExpressionTranslator.isSrcOrDstOf(functionCall, functionName, VertexPairConnection::getSrc, transOptions);
                    }
                    if (functionName.equals("is_destination_of")) {
                        return ExpressionTranslator.isSrcOrDstOf(functionCall, functionName, VertexPairConnection::getDst, transOptions);
                    }
                    if (functionName.equals(ELEMENT_NUMBER) || functionName.equals(MATCH_NUMBER)) {
                        return functionCall;
                    }
                }
                List translatedArgs = functionCall.getArgs().stream().map(argument -> ExpressionTranslator.translateForSubSelect(argument, transOptions)).collect(Collectors.toList());
                return new QueryExpression.FunctionCall(schemaName, packageName, functionCall.getFunctionName(), translatedArgs);
            }
            case EXTRACT_EXPRESSION: {
                QueryExpression.ExtractExpression extractExpression = (QueryExpression.ExtractExpression)queryExpression;
                QueryExpression translatedExp = ExpressionTranslator.translateForSubSelect(extractExpression.getExp(), transOptions);
                return new QueryExpression.ExtractExpression(extractExpression.getField(), translatedExp);
            }
            case IN_EXPRESSION: {
                QueryExpression.InPredicate inPredicate = (QueryExpression.InPredicate)queryExpression;
                QueryExpression translatedExp = ExpressionTranslator.translateForSubSelect(inPredicate.getExp(), transOptions);
                QueryExpression translatedInValueList = ExpressionTranslator.translateForSubSelect(inPredicate.getInValueList(), transOptions);
                return new QueryExpression.InPredicate(translatedExp, translatedInValueList);
            }
            case IN_VALUE_LIST: {
                return queryExpression;
            }
            case IS_NULL: {
                QueryExpression.IsNull isNull = (QueryExpression.IsNull)queryExpression;
                QueryExpression translatedExp = ExpressionTranslator.translateForSubSelect(isNull.getExp(), transOptions);
                return new QueryExpression.IsNull(translatedExp);
            }
            case IF_ELSE: {
                QueryExpression.IfElse ifElse = (QueryExpression.IfElse)queryExpression;
                QueryExpression translatedCondition = ExpressionTranslator.translateForSubSelect(ifElse.getExp1(), transOptions);
                QueryExpression translatedTrueBranch = ExpressionTranslator.translateForSubSelect(ifElse.getExp2(), transOptions);
                QueryExpression translatedElseBranch = ExpressionTranslator.translateForSubSelect(ifElse.getExp3(), transOptions);
                return new QueryExpression.IfElse(translatedCondition, translatedTrueBranch, translatedElseBranch);
            }
            case SIMPLE_CASE: {
                QueryExpression.SimpleCase simpleCase = (QueryExpression.SimpleCase)queryExpression;
                return new QueryExpression.SimpleCase(ExpressionTranslator.translateForSubSelect(simpleCase.getCaseOperand(), transOptions), simpleCase.getWhenThenExps().stream().map(exp -> new QueryExpression.WhenThenExpression(ExpressionTranslator.translateForSubSelect(exp.getWhen(), transOptions), ExpressionTranslator.translateForSubSelect(exp.getThen(), transOptions))).collect(Collectors.toList()), ExpressionTranslator.translateForSubSelect(simpleCase.getElseExp(), transOptions), (QueryExpression.IfElse)ExpressionTranslator.translateForSubSelect((QueryExpression)simpleCase.getIfElseRepresentation(), transOptions));
            }
            case SOURCE_DESTINATION_PREDICATE: {
                QueryExpression.SourceDestinationPredicate sdp = (QueryExpression.SourceDestinationPredicate)queryExpression;
                return ExpressionTranslator.isSrcOrDstOfBool(sdp.getEdgeReference(), sdp.getVertexReference(), sdp.isSourcePredicate() ? VertexPairConnection::getSrc : VertexPairConnection::getDst, transOptions);
            }
            case SUBSTRING: {
                QueryExpression.SubstringExpression substring = (QueryExpression.SubstringExpression)queryExpression;
                return new QueryExpression.SubstringExpression(ExpressionTranslator.translateForSubSelect(substring.getExp(), transOptions), ExpressionTranslator.translateForSubSelect(substring.getStartPosition(), transOptions), ExpressionTranslator.translateForSubSelect(substring.getStringLength(), transOptions));
            }
        }
        throw new UnsupportedOperationException("Expression " + queryExpression + " of type " + queryExpression.getExpType() + " is not supported");
    }

    private static void processSubquery(QueryExpression.Subquery subquery, SubSelectTransOptions transOptions) {
        if (transOptions.forWhere) {
            transOptions.translationInfo.subqueryInfo.parentConf = transOptions.conf;
            transOptions.translationInfo.subqueryInfo.extraConstraints = ExpressionTranslator.addExtraConstraints(subquery, transOptions);
        }
    }

    private static List<SubqueryInfo.Constraints> pushConstraints(QueryExpression.Subquery subquery, List<SubqueryInfo.Constraints> extraConstraints, boolean keepOriginal) {
        ArrayList<SubqueryInfo.Constraints> originalConstraints = new ArrayList<SubqueryInfo.Constraints>();
        block4: for (int i = 0; i < subquery.getQuery().getTableExpressions().size(); ++i) {
            TableExpression t = (TableExpression)subquery.getQuery().getTableExpressions().get(i);
            switch (t.getTableExpressionType()) {
                case GRAPH_PATTERN: {
                    GraphPattern gp = (GraphPattern)t;
                    SubqueryInfo.GPConstraints gpConstraints = (SubqueryInfo.GPConstraints)extraConstraints.get(i);
                    Set gpOriginal = gp.getConstraints();
                    originalConstraints.add(new SubqueryInfo.GPConstraints(gpOriginal));
                    HashSet<QueryExpression> newConstraints = new HashSet<QueryExpression>();
                    if (keepOriginal) {
                        newConstraints.addAll(gpOriginal);
                    }
                    newConstraints.addAll(gpConstraints.extraConstraints);
                    gp.setConstraints(newConstraints);
                    continue block4;
                }
                case DERIVED_TABLE: {
                    SubqueryInfo.DTConstraints dtConstraints = (SubqueryInfo.DTConstraints)extraConstraints.get(i);
                    originalConstraints.add(new SubqueryInfo.DTConstraints(ExpressionTranslator.pushConstraints((QueryExpression.Subquery)((DerivedTable)t), dtConstraints.extraConstraints, keepOriginal)));
                }
            }
        }
        return originalConstraints;
    }

    private static List<SubqueryInfo.Constraints> addExtraConstraints(QueryExpression.Subquery subquery, SubSelectTransOptions transOptions) {
        ArrayList<SubqueryInfo.Constraints> list = new ArrayList<SubqueryInfo.Constraints>();
        subquery.getQuery().getTableExpressions().forEach(t -> {
            switch (t.getTableExpressionType()) {
                case GRAPH_PATTERN: {
                    list.add(new SubqueryInfo.GPConstraints(ExpressionTranslator.addExtraConstraints((GraphPattern)t, transOptions)));
                    break;
                }
                case DERIVED_TABLE: {
                    list.add(new SubqueryInfo.DTConstraints(ExpressionTranslator.addExtraConstraints((QueryExpression.Subquery)((DerivedTable)t), transOptions)));
                }
            }
        });
        return list;
    }

    private static Set<QueryExpression> addExtraConstraints(GraphPattern graphPattern, SubSelectTransOptions transOptions) {
        HashSet<QueryExpression> extraConstraints = new HashSet<QueryExpression>();
        for (QueryVertex vertex : graphPattern.getVertices()) {
            String table = transOptions.conf.get(vertex);
            if (table == null) continue;
            ArrayList<QueryExpression.VarRef> list = new ArrayList<QueryExpression.VarRef>();
            list.add(new QueryExpression.VarRef((QueryVariable)vertex));
            extraConstraints.add((QueryExpression)new QueryExpression.RelationalExpression.Equal((QueryExpression)new QueryExpression.FunctionCall("label", list), (QueryExpression)new QueryExpression.Constant.ConstString(transOptions.metadataConnector.getLabelForVertexTable(table))));
        }
        return extraConstraints;
    }

    private static QueryExpression translateForSubSelect(QueryExpression.Aggregation.AbstractAggregation agg, SubSelectTransOptions transOptions, BiFunction<Boolean, QueryExpression, QueryExpression.Aggregation.AbstractAggregation> constructor, String separator, boolean isJsonArrAgg) {
        Map<QueryExpression, PathTranslator.PathExpressionInfo> pathExpressions = transOptions.translationInfo.getPathExpressions();
        if (pathExpressions.containsKey(agg)) {
            if (transOptions.forWhere) {
                return agg;
            }
            return new QueryExpression.PropertyAccess((QueryVariable)pathExpressions.get((Object)agg).queryPath, "EXP_PATH");
        }
        QueryExpression translatedExp = ExpressionTranslator.translateForSubSelect(agg.getExp(), transOptions);
        if (isJsonArrAgg) {
            QueryExpression.Aggregation.AggrJsonArrayagg jsonArrayagg = (QueryExpression.Aggregation.AggrJsonArrayagg)agg;
            List orderByElems = jsonArrayagg.getOrderBy().getElements().stream().map(orderByElem -> new OrderByElem(ExpressionTranslator.translateForSubSelect(orderByElem.getExp(), transOptions), orderByElem.isAscending())).collect(Collectors.toList());
            return new QueryExpression.Aggregation.AggrJsonArrayagg(translatedExp, jsonArrayagg.isFormatJson(), new OrderBy(orderByElems), jsonArrayagg.getJsonOnNull(), jsonArrayagg.getJsonReturnType());
        }
        if (constructor == null) {
            return new QueryExpression.Aggregation.AggrListagg(agg.isDistinct(), translatedExp, separator);
        }
        return (QueryExpression)constructor.apply(agg.isDistinct(), translatedExp);
    }

    private static QueryExpression getPropertyAccess(QueryVariable variable, String tableName, String propertyName, BiFunction<String, String, Boolean> tableNameValidator, BiFunction<String, String, String> columnNameResolver) {
        if (!tableNameValidator.apply(tableName, propertyName).booleanValue()) {
            return new NullExpression();
        }
        String columnName = columnNameResolver.apply(tableName, propertyName);
        if (columnName == null) {
            return new NullExpression();
        }
        return new QueryExpression.PropertyAccess(variable, columnName);
    }

    private static QueryExpression translateLabel(QueryExpression.FunctionCall functionCall, Map<QueryVariable, String> conf, MetadataConnector metadataConnector) {
        ExpAsVar expAsVar;
        assert (functionCall.getArgs().size() == 1);
        assert (functionCall.getArgs().get(0) instanceof QueryExpression.VarRef);
        QueryExpression.VarRef varRef = (QueryExpression.VarRef)functionCall.getArgs().get(0);
        QueryVariable var = ExpressionTranslator.getQueryVariable(varRef);
        if (var.getVariableType() == QueryVariable.VariableType.VERTEX) {
            return new QueryExpression.Constant.ConstString(metadataConnector.getLabelForVertexTable(conf.get(var)));
        }
        if (var.getVariableType() == QueryVariable.VariableType.EDGE) {
            return new QueryExpression.Constant.ConstString(metadataConnector.getLabelForEdgeTable(conf.get(var)));
        }
        if (var.getVariableType() == QueryVariable.VariableType.EXP_AS_VAR && (expAsVar = (ExpAsVar)var).getExp().getExpType() == QueryExpression.ExpressionType.VARREF) {
            QueryExpression.VarRef vRef = (QueryExpression.VarRef)expAsVar.getExp();
            if (vRef.getVariable().getVariableType() == QueryVariable.VariableType.VERTEX) {
                QueryVertex vertex = (QueryVertex)vRef.getVariable();
                return new QueryExpression.Constant.ConstString(metadataConnector.getLabelForVertexTable(conf.get(vertex)));
            }
            if (vRef.getVariable().getVariableType() == QueryVariable.VariableType.EDGE) {
                QueryEdge edge = (QueryEdge)vRef.getVariable();
                return new QueryExpression.Constant.ConstString(metadataConnector.getLabelForEdgeTable(conf.get(edge)));
            }
        }
        throw new IllegalArgumentException("Invalid var type");
    }

    private static QueryExpression translateKeyAccess(QueryExpression.FunctionCall functionCall, SubSelectTransOptions transOptions) {
        assert (functionCall.getArgs().size() == 1);
        assert (functionCall.getArgs().get(0) instanceof QueryExpression.VarRef);
        QueryExpression.VarRef varRef = (QueryExpression.VarRef)functionCall.getArgs().get(0);
        return ExpressionTranslator.getVarRefAccess(varRef, transOptions, true, false);
    }

    private static QueryExpression getVarRefAccess(QueryExpression.VarRef varRef, SubSelectTransOptions transOptions, boolean getCompositeId, boolean forXml) {
        List<String> keyColumns;
        QueryVariable var = ExpressionTranslator.getQueryVariable(varRef);
        String elementTable = transOptions.conf.get(var);
        if (transOptions.translationInfo.isParentVariable(var.getName()) && (!transOptions.conf.containsKey(var) || !transOptions.translationInfo.isForParentWhere() && !transOptions.forWhere)) {
            return varRef;
        }
        if (transOptions.translationInfo.getPathExpressions().containsKey(varRef)) {
            return new QueryExpression.FunctionCall(UNNESTED_EXP_FUNCTION, PgqlUtils.buildList(varRef));
        }
        if (elementTable == null) {
            QueryVariable var2 = null;
            if (transOptions.translationInfo.subqueryInfo.selectAliases.containsKey(var.getName())) {
                var2 = (QueryVariable)transOptions.translationInfo.subqueryInfo.selectAliases.get((Object)var.getName()).second;
            }
            if (transOptions.translationInfo.subqueryInfo.variables.containsKey(var.getName())) {
                var2 = (QueryVariable)transOptions.translationInfo.subqueryInfo.variables.get((Object)var.getName()).second;
            }
            if (var2 != null) {
                if (var2.getVariableType() == QueryVariable.VariableType.EXP_AS_VAR) {
                    return ExpressionTranslator.translateForSubSelect(((ExpAsVar)var2).getExp(), transOptions);
                }
                if (var2.getVariableType() == QueryVariable.VariableType.VERTEX || var2.getVariableType() == QueryVariable.VariableType.EDGE) {
                    var = var2;
                    elementTable = transOptions.conf.get(var2);
                }
            }
        }
        String referencedTable = elementTable;
        switch (var.getVariableType()) {
            case VERTEX: {
                Pair<VertexPairConnection, TranslationInfo.Position> edge = transOptions.translationInfo.getEdgeConnection(var);
                if (edge == null) {
                    keyColumns = transOptions.metadataConnector.getVertexTableKey(elementTable);
                    break;
                }
                var = (QueryVariable)edge.first;
                referencedTable = transOptions.conf.get(var);
                if (edge.second == TranslationInfo.Position.SRC) {
                    keyColumns = transOptions.metadataConnector.getEdgeTableSrcKey(referencedTable).stream().map(x -> (String)x.first).collect(Collectors.toList());
                    break;
                }
                keyColumns = transOptions.metadataConnector.getEdgeTableDstKey(referencedTable).stream().map(x -> (String)x.first).collect(Collectors.toList());
                break;
            }
            case EDGE: {
                keyColumns = transOptions.metadataConnector.getEdgeTableKey(elementTable);
                break;
            }
            case EXP_AS_VAR: {
                return ExpressionTranslator.translateForSubSelect(((ExpAsVar)var).getExp(), transOptions);
            }
            default: {
                throw new IllegalArgumentException("Invalid var type:" + var.getVariableType());
            }
        }
        if (getCompositeId) {
            QueryExpression concatKeys = ExpressionTranslator.escapeKeyColumn(var, keyColumns.get(0), referencedTable, transOptions.metadataConnector);
            for (int i = 1; i < keyColumns.size(); ++i) {
                concatKeys = ExpressionTranslator.buildConcat(new QueryExpression[]{concatKeys, new QueryExpression.Constant.ConstString(","), ExpressionTranslator.escapeKeyColumn(var, keyColumns.get(i), referencedTable, transOptions.metadataConnector)});
            }
            return ExpressionTranslator.buildConcat(new QueryExpression[]{new QueryExpression.Constant.ConstString(ExpressionTranslator.escapeTableName(elementTable)), new QueryExpression.Constant.ConstString("("), concatKeys, new QueryExpression.Constant.ConstString(")")});
        }
        if (forXml) {
            String keyTag = "K0";
            QueryExpression exp = ExpressionTranslator.buildConcat(new QueryExpression[]{new QueryExpression.Constant.ConstString("<" + keyTag + ">"), new QueryExpression.Constant.ConstString(elementTable), new QueryExpression.Constant.ConstString("</" + keyTag + ">")});
            for (int i = 0; i < keyColumns.size(); ++i) {
                keyTag = KEY_TAG + (i + 1);
                exp = ExpressionTranslator.buildConcat(new QueryExpression[]{exp, new QueryExpression.Constant.ConstString("<" + keyTag + ">"), new QueryExpression.PropertyAccess(var, keyColumns.get(i)), new QueryExpression.Constant.ConstString("</" + keyTag + ">")});
            }
            return exp;
        }
        ArrayList<Object> args = new ArrayList<Object>();
        args.add(new QueryExpression.Constant.ConstString(elementTable));
        for (String keyColumn : keyColumns) {
            args.add(new QueryExpression.PropertyAccess(var, keyColumn));
        }
        return new QueryExpression.FunctionCall("_ora_comp_key_f_", args);
    }

    private static QueryExpression buildConcat(QueryExpression ... args) {
        QueryExpression concat = args[0];
        for (int i = 1; i < args.length; ++i) {
            concat = new QueryExpression.ConcatExpression(concat, args[i]);
        }
        return concat;
    }

    static QueryVariable getQueryVariable(QueryExpression.VarRef varRef) {
        return ExpressionTranslator.getQueryVariable(varRef.getVariable());
    }

    static QueryVariable getQueryVariable(QueryVariable variable) {
        QueryExpression exp;
        if (variable.getVariableType() == QueryVariable.VariableType.EXP_AS_VAR && (exp = ((ExpAsVar)variable).getExp()).getExpType() == QueryExpression.ExpressionType.VARREF) {
            variable = ((QueryExpression.VarRef)exp).getVariable();
            return ExpressionTranslator.getQueryVariable(variable);
        }
        return variable;
    }

    static QueryExpression escapeKeyColumn(QueryVariable var, String columnName, String elementTable, MetadataConnector metadataConnector) {
        QueryExpression.PropertyAccess prop = new QueryExpression.PropertyAccess(var, columnName);
        if (var.getVariableType() == QueryVariable.VariableType.VERTEX && metadataConnector.isNotVertexStringKeyColumn(elementTable, columnName)) {
            return prop;
        }
        if (var.getVariableType() == QueryVariable.VariableType.EDGE && metadataConnector.isNotEdgeStringKeyColumn(elementTable, columnName)) {
            return prop;
        }
        QueryExpression.Constant.ConstString regexExp = new QueryExpression.Constant.ConstString(REGEXP_EXP);
        QueryExpression.Constant.ConstString doubleQuoteExp = new QueryExpression.Constant.ConstString("\"");
        QueryExpression.Constant.ConstString replaceExp = new QueryExpression.Constant.ConstString("\"\"");
        ArrayList<Object> instrArgs = new ArrayList<Object>();
        instrArgs.add(prop);
        instrArgs.add(regexExp);
        QueryExpression.FunctionCall instr = new QueryExpression.FunctionCall(REGEXP_INSTR, instrArgs);
        ArrayList<Object> replaceArgs = new ArrayList<Object>();
        replaceArgs.add(prop);
        replaceArgs.add(doubleQuoteExp);
        replaceArgs.add(replaceExp);
        QueryExpression.FunctionCall replace = new QueryExpression.FunctionCall(REGEXP_REPLACE, replaceArgs);
        QueryExpression.ConcatExpression enquote = (QueryExpression.ConcatExpression)ExpressionTranslator.buildConcat(new QueryExpression[]{doubleQuoteExp, replace, doubleQuoteExp});
        ArrayList<Object> decodeArgs = new ArrayList<Object>();
        decodeArgs.add(instr);
        decodeArgs.add(new QueryExpression.Constant.ConstString("0"));
        decodeArgs.add(prop);
        decodeArgs.add(enquote);
        return new QueryExpression.FunctionCall(DECODE, decodeArgs);
    }

    static String escapeTableName(String tableName) {
        if (tableName.contains("\"") || tableName.contains("(") || tableName.contains(",") || tableName.contains(")")) {
            return '\"' + tableName.replace("\"", "\"\"") + '\"';
        }
        return tableName;
    }

    static QueryExpression escapeKeyColumnForPath(QueryVariable var, String columnName, String elementTable, MetadataConnector metadataConnector) {
        QueryExpression.PropertyAccess prop = new QueryExpression.PropertyAccess(var, columnName);
        if (var.getVariableType() == QueryVariable.VariableType.VERTEX && metadataConnector.isNotVertexStringKeyColumn(elementTable, columnName)) {
            return prop;
        }
        if (var.getVariableType() == QueryVariable.VariableType.EDGE && metadataConnector.isNotEdgeStringKeyColumn(elementTable, columnName)) {
            return prop;
        }
        return ExpressionTranslator.escapeCommas((QueryExpression)prop);
    }

    static QueryExpression escapeCommas(QueryExpression exp) {
        ArrayList<Object> replaceArgs = new ArrayList<Object>();
        replaceArgs.add(exp);
        replaceArgs.add(new QueryExpression.Constant.ConstString(","));
        replaceArgs.add(new QueryExpression.Constant.ConstString("\\,"));
        return new QueryExpression.FunctionCall(REPLACE, replaceArgs);
    }

    private static QueryExpression isSrcOrDstOf(QueryExpression.FunctionCall functionCall, String functionName, Function<QueryEdge, QueryVertex> getVertex, SubSelectTransOptions transOptions) {
        List args = functionCall.getArgs();
        if (args.size() != 2) {
            throw new IllegalArgumentException("Function " + functionName + " should have two arguments");
        }
        if (((QueryExpression)args.get(0)).getExpType() != QueryExpression.ExpressionType.VARREF) {
            throw new IllegalArgumentException("Function " + functionName + " should receive an edge as first argument");
        }
        QueryVariable edge = ((QueryExpression.VarRef)args.get(0)).getVariable();
        QueryVariable originalEdge = ExpressionTranslator.getQueryVariable(edge);
        if (originalEdge.getVariableType() != QueryVariable.VariableType.EDGE) {
            throw new IllegalArgumentException("Function " + functionName + " should receive an edge as first argument");
        }
        if (((QueryExpression)args.get(1)).getExpType() != QueryExpression.ExpressionType.VARREF) {
            throw new IllegalArgumentException("Function " + functionName + " should receive a vertex as second argument");
        }
        QueryVariable vertex = ((QueryExpression.VarRef)args.get(1)).getVariable();
        QueryVariable originalVertex = ExpressionTranslator.getQueryVariable(vertex);
        if (originalVertex.getVariableType() != QueryVariable.VariableType.VERTEX) {
            throw new IllegalArgumentException("Function " + functionName + " should receive a vertex as second argument");
        }
        QueryVertex compareVertex = getVertex.apply((QueryEdge)edge);
        if (ExpressionTranslator.isSameTable(compareVertex, vertex, transOptions)) {
            QueryExpression value = ExpressionTranslator.isSameVertex(compareVertex, vertex, transOptions);
            return new QueryExpression.IfElse(value, (QueryExpression)new QueryExpression.Constant.ConstString("Y"), (QueryExpression)new QueryExpression.Constant.ConstString("N"));
        }
        return new QueryExpression.Constant.ConstString("N");
    }

    private static QueryExpression isSrcOrDstOfBool(QueryExpression.VarRef edgeReference, QueryExpression.VarRef vertexReference, Function<QueryEdge, QueryVertex> getVertex, SubSelectTransOptions transOptions) {
        QueryVariable edge = edgeReference.getVariable();
        QueryVariable vertex = vertexReference.getVariable();
        QueryVertex compareVertex = getVertex.apply((QueryEdge)edge);
        if (ExpressionTranslator.isSameTable(compareVertex, vertex, transOptions)) {
            return ExpressionTranslator.isSameVertex(compareVertex, vertex, transOptions);
        }
        return new QueryExpression.Constant.ConstBoolean(false);
    }

    private static boolean isSameTable(QueryVertex compareVertex, QueryVariable vertex, SubSelectTransOptions transOptions) {
        return Objects.equals(transOptions.conf.get(compareVertex), transOptions.conf.get(vertex));
    }

    private static QueryExpression isSameVertex(QueryVertex compareVertex, QueryVariable vertex, SubSelectTransOptions transOptions) {
        QueryExpression.FunctionCall key1 = (QueryExpression.FunctionCall)ExpressionTranslator.getVarRefAccess(new QueryExpression.VarRef((QueryVariable)compareVertex), transOptions, false, false);
        QueryExpression.FunctionCall key2 = (QueryExpression.FunctionCall)ExpressionTranslator.getVarRefAccess(new QueryExpression.VarRef(vertex), transOptions, false, false);
        return IntStream.range(1, key1.getArgs().size()).mapToObj(i -> new QueryExpression.RelationalExpression.Equal((QueryExpression)key1.getArgs().get(i), (QueryExpression)key2.getArgs().get(i))).reduce(QueryExpression.LogicalExpression.And::new).orElse(new NullExpression());
    }

    static class SubSelectTransOptions {
        Map<QueryVariable, String> conf;
        MetadataConnector metadataConnector;
        boolean forWhere;
        TranslationInfo translationInfo;

        public SubSelectTransOptions(Map<QueryVariable, String> conf, MetadataConnector metadataConnector, boolean forWhere, TranslationInfo translationInfo) {
            this.conf = conf;
            this.metadataConnector = metadataConnector;
            this.forWhere = forWhere;
            this.translationInfo = translationInfo;
        }
    }

    static class QueryExpTransOptions {
        boolean addAggregate;
        boolean useAlias;
        boolean forWhere;
        boolean forSelect;
        Map<QueryExpression, PathTranslator.PathExpressionInfo> pathExpressions;
        MetadataConnector metadataConnector;
        QueryContext ctx;
        List<SubqueryInfo.Constraints> extraConstraints;
        Map<QueryVariable, String> parentConf;
        SubqueryInfo subqueryInfo;

        public QueryExpTransOptions(boolean addAggregate, boolean useAlias, boolean forWhere, boolean forSelect, Map<QueryExpression, PathTranslator.PathExpressionInfo> pathExpressions, MetadataConnector metadataConnector, QueryContext ctx, SubqueryInfo subqueryInfo) {
            this(addAggregate, useAlias, forWhere, forSelect, pathExpressions, metadataConnector, ctx, null, null, subqueryInfo);
        }

        public QueryExpTransOptions(boolean addAggregate, boolean useAlias, boolean forWhere, boolean forSelect, Map<QueryExpression, PathTranslator.PathExpressionInfo> pathExpressions, MetadataConnector metadataConnector, QueryContext ctx, List<SubqueryInfo.Constraints> extraConstraints, Map<QueryVariable, String> parentConf, SubqueryInfo subqueryInfo) {
            this.addAggregate = addAggregate;
            this.useAlias = useAlias;
            this.forWhere = forWhere;
            this.forSelect = forSelect;
            this.pathExpressions = pathExpressions;
            this.metadataConnector = metadataConnector;
            this.ctx = ctx;
            this.extraConstraints = extraConstraints;
            this.parentConf = parentConf;
            this.subqueryInfo = subqueryInfo;
        }
    }
}

