/*
 * Decompiled with CFR 0.152.
 */
package oracle.pg.rdbms.pgql.pgview;

import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import oracle.pg.rdbms.pgql.DbmsUtils;
import oracle.pg.rdbms.pgql.PgqlConnection;
import oracle.pg.rdbms.pgql.PgqlCpgRdbmsExpander;
import oracle.pg.rdbms.pgql.PgqlCreatePgVerifier;
import oracle.pg.rdbms.pgql.PgqlToSqlException;
import oracle.pg.rdbms.pgql.pgview.CspgToCpg;
import oracle.pg.rdbms.pgql.pgview.GraphMetadataHandler;
import oracle.pg.rdbms.pgql.pgview.util.Pair;
import oracle.pgql.lang.ddl.propertygraph.CreatePropertyGraph;
import oracle.pgql.lang.ddl.propertygraph.CreateSuperPropertyGraph;
import oracle.pgql.lang.ddl.propertygraph.EdgeTable;
import oracle.pgql.lang.ddl.propertygraph.ElementTable;
import oracle.pgql.lang.ddl.propertygraph.Key;
import oracle.pgql.lang.ddl.propertygraph.Label;
import oracle.pgql.lang.ddl.propertygraph.Property;
import oracle.pgql.lang.ddl.propertygraph.VertexTable;
import oracle.pgql.lang.ir.PgqlUtils;
import oracle.pgql.lang.ir.QueryExpression;
import oracle.pgql.lang.ir.QueryExpressionVisitor;
import oracle.pgql.lang.ir.QueryVariable;
import oracle.pgql.lang.ir.QueryVertex;
import oracle.pgql.lang.ir.SchemaQualifiedName;
import oracle.pgql.lang.ir.StatementType;
import oracle.pgql.lang.util.AbstractQueryExpressionVisitor;

public class PgViewDdlExecution {
    private static final String CREATE_TABLES_STR = "DECLARE\n  elem_table_tab   VARCHAR2(128) := SYS.DBMS_ASSERT.QUALIFIED_SQL_NAME(?);\n  elem_table_pk    VARCHAR2(128) := SYS.DBMS_ASSERT.ENQUOTE_NAME(?);\n  label_tab        VARCHAR2(128) := SYS.DBMS_ASSERT.QUALIFIED_SQL_NAME(?);\n  label_pk         VARCHAR2(128) := SYS.DBMS_ASSERT.ENQUOTE_NAME(?);\n  property_tab     VARCHAR2(128) := SYS.DBMS_ASSERT.QUALIFIED_SQL_NAME(?);\n  property_pk      VARCHAR2(128) := SYS.DBMS_ASSERT.ENQUOTE_NAME(?);\n  key_tab          VARCHAR2(128) := SYS.DBMS_ASSERT.QUALIFIED_SQL_NAME(?);\n  key_pk           VARCHAR2(128) := SYS.DBMS_ASSERT.ENQUOTE_NAME(?);\n  src_dst_key_tab  VARCHAR2(128) := SYS.DBMS_ASSERT.QUALIFIED_SQL_NAME(?);\n  src_dst_key_pk   VARCHAR2(128) := SYS.DBMS_ASSERT.ENQUOTE_NAME(?);\nBEGIN\n  execute immediate\n  'CREATE TABLE ' || elem_table_tab || ' (\n     ET_NAME      VARCHAR2(128),\n     ET_TYPE      VARCHAR2(6),\n     SCHEMA_NAME  VARCHAR2(128),\n     TABLE_NAME   VARCHAR2(128),\n     CONSTRAINT ' || elem_table_pk || ' PRIMARY KEY(ET_NAME, ET_TYPE)\n   )';\n  execute immediate\n  'CREATE TABLE ' || label_tab || ' (\n     LABEL_NAME  VARCHAR2(128),\n     ET_NAME     VARCHAR2(128),\n     ET_TYPE     VARCHAR2(6),\n     CONSTRAINT ' || label_pk || ' PRIMARY KEY(LABEL_NAME, ET_NAME, ET_TYPE)\n   )';\n  execute immediate\n  'CREATE TABLE ' || property_tab || ' (\n     PROPERTY_NAME  VARCHAR2(128),\n     ET_NAME        VARCHAR2(128),\n     ET_TYPE        VARCHAR2(6),\n     LABEL_NAME     VARCHAR2(128),\n     COLUMN_NAME    VARCHAR2(128),\n     CONSTRAINT ' || property_pk || ' PRIMARY KEY(PROPERTY_NAME, ET_NAME, LABEL_NAME)\n   )';\n  execute immediate\n  'CREATE TABLE ' || key_tab || ' (\n     COLUMN_NAME    VARCHAR2(128),\n     COLUMN_NUMBER  NUMBER,\n     KEY_TYPE       VARCHAR2(6),\n     ET_NAME        VARCHAR2(128),\n     CONSTRAINT ' || key_pk || ' PRIMARY KEY(COLUMN_NAME, KEY_TYPE, ET_NAME)\n   )';\n  execute immediate\n  'CREATE TABLE ' || src_dst_key_tab || ' (\n     ET_NAME           VARCHAR2(128),\n     VT_NAME           VARCHAR2(128),\n     KEY_TYPE          VARCHAR2(16),\n     ET_COLUMN_NAME    VARCHAR2(128),\n     ET_COLUMN_NUMBER  NUMBER,\n     CONSTRAINT ' || src_dst_key_pk || ' PRIMARY KEY(ET_NAME, VT_NAME, KEY_TYPE, ET_COLUMN_NAME)\n   )';\nEND;";
    private static final String DROP_TABLES_STR = "DECLARE\n  elem_table_tab  VARCHAR2(128) := SYS.DBMS_ASSERT.QUALIFIED_SQL_NAME(?);\n  label_tab       VARCHAR2(128) := SYS.DBMS_ASSERT.QUALIFIED_SQL_NAME(?);\n  property_tab    VARCHAR2(128) := SYS.DBMS_ASSERT.QUALIFIED_SQL_NAME(?);\n  key_tab         VARCHAR2(128) := SYS.DBMS_ASSERT.QUALIFIED_SQL_NAME(?);\n  src_dst_key_tab VARCHAR2(128) := SYS.DBMS_ASSERT.QUALIFIED_SQL_NAME(?);\n  view_name       VARCHAR2(128) := ?;\n  TYPE TableInfoType IS RECORD (\n    schema_name VARCHAR2(128),\n    table_name  VARCHAR2(128)\n  );\n  TYPE TableInfoArrayType IS TABLE OF TableInfoType;\n  table_info_array TableInfoArrayType := TableInfoArrayType();\n  BEGIN\n  execute immediate 'SELECT DISTINCT schema_name, table_name FROM ' || elem_table_tab || ' where table_name LIKE :view_name '\n  bulk collect into table_info_array USING view_name;\n    FOR i IN 1..table_info_array.COUNT LOOP\n     BEGIN\n       execute immediate 'DROP VIEW ' || SYS.DBMS_ASSERT.ENQUOTE_NAME(table_info_array(i).schema_name, false) || '.' || SYS.DBMS_ASSERT.ENQUOTE_NAME(table_info_array(i).table_name, false);\n     EXCEPTION\n      WHEN OTHERS THEN\n        IF SQLCODE != -942 THEN\n           RAISE;\n        END IF;\n     END;    END LOOP;\n  execute immediate\n  'DROP TABLE ' || elem_table_tab;\n  execute immediate\n  'DROP TABLE ' || label_tab;\n  execute immediate\n  'DROP TABLE ' || property_tab;\n  execute immediate\n  'DROP TABLE ' || key_tab;\n  execute immediate\n  'DROP TABLE ' || src_dst_key_tab;\nEND;";
    private static final String INSERT_ELEMENT_TABLE_STR = "DECLARE\n  elem_table_tab  VARCHAR2(128) := SYS.DBMS_ASSERT.QUALIFIED_SQL_NAME(?);\n  et_name         VARCHAR2(128) := ?;\n  et_type         VARCHAR2(128) := ?;\n  schema_name     VARCHAR2(128) := ?;\n  table_name      VARCHAR2(128) := ?;\nBEGIN\n  execute immediate 'INSERT INTO ' || elem_table_tab || '   (ET_NAME, ET_TYPE, SCHEMA_NAME, TABLE_NAME) VALUES (:et_name, :et_type, :schema_name, :table_name)'\n  using et_name, et_type, schema_name, table_name;\nEND;";
    private static final String INSERT_KEY_STR = "DECLARE\n  key_tab        VARCHAR2(128) := SYS.DBMS_ASSERT.QUALIFIED_SQL_NAME(?);\n  column_name    VARCHAR2(128) := ?;\n  column_number  NUMBER        := ?;\n  key_type       VARCHAR2(128) := ?;\n  et_name        VARCHAR2(128) := ?;\nBEGIN\n  execute immediate 'INSERT INTO ' || key_tab || '   (COLUMN_NAME, COLUMN_NUMBER, KEY_TYPE, ET_NAME)   VALUES (:column_name, :column_number, :key_type, :et_name)'\n  using column_name, column_number, key_type, et_name;\nEND;";
    private static final String INSERT_SRC_DST_KEY_STR = "DECLARE\n  src_dst_key_tab   VARCHAR2(128) := SYS.DBMS_ASSERT.QUALIFIED_SQL_NAME(?);\n  et_name           VARCHAR2(128) := ?;\n  vt_name           VARCHAR2(128) := ?;\n  key_type          VARCHAR2(128) := ?;\n  et_column_name    VARCHAR2(128) := ?;\n  et_column_number  NUMBER := ?;\nBEGIN\n  execute immediate 'INSERT INTO ' || src_dst_key_tab || '   (ET_NAME, VT_NAME, KEY_TYPE, ET_COLUMN_NAME, ET_COLUMN_NUMBER)  VALUES (:et_name, :vt_name, :key_type, :et_column_name, :et_column_number)'\n  using et_name, vt_name, key_type, et_column_name, et_column_number;\nEND;";
    private static final String INSERT_LABEL_STR = "DECLARE\n  label_tab   VARCHAR2(128) := SYS.DBMS_ASSERT.QUALIFIED_SQL_NAME(?);\n  label_name  VARCHAR2(128) := ?;\n  et_name     VARCHAR2(128) := ?;\n  et_type     VARCHAR2(128) := ?;\nBEGIN\n  execute immediate 'INSERT INTO ' || label_tab || '   (LABEL_NAME, ET_NAME, ET_TYPE) VALUES (:label_name, :et_name, :et_type)'\n  using label_name, et_name, et_type;\nEND;";
    private static final String INSERT_PROPERTY_STR = "DECLARE\n  property_tab   VARCHAR2(128) := SYS.DBMS_ASSERT.QUALIFIED_SQL_NAME(?);\n  property_name  VARCHAR2(128) := ?;\n  et_name        VARCHAR2(128) := ?;\n  et_type        VARCHAR2(128) := ?;\n  label_name     VARCHAR2(128) := ?;\n  column_name    VARCHAR2(128) := ?;\nBEGIN\n  execute immediate 'INSERT INTO ' || property_tab || '   (PROPERTY_NAME, ET_NAME, ET_TYPE, LABEL_NAME, COLUMN_NAME)   VALUES (:property_name, :et_name, :et_type, :label_name, :column_name)'\n  using property_name, et_name, et_type, label_name, column_name;\nEND;";
    private static final String CHECK_FOR_UDF = "DECLARE\n    v_input CLOB := ?;\n    v_count NUMBER := 0;\n    v_token VARCHAR(120);\n    v_pos   NUMBER;\n    v_start NUMBER := 1;\nBEGIN\n    LOOP\n        v_pos := instr(v_input, '\"', v_start);\n        -- If the delimiter is found\n        IF v_pos > 0 THEN\n         -- Extract the token\n            v_token := substr(v_input, v_start, v_pos - v_start);\n            v_count := 0;\n            EXECUTE IMMEDIATE 'SELECT COUNT(*) FROM v$sqlfn_metadata WHERE name=:v1'\n            INTO v_count\n                USING v_token;\n            IF v_count = 0 THEN\n                raise_application_error(-20001, 'invalid property graph label property definition: ' || v_token);\n            END IF;\n         -- Move the start position to the next character after the delimiter\n            v_start := v_pos + 1;\n        ELSE\n         -- If no more delimiter found, exit the loop\n            EXIT;\n        END IF;\n    END LOOP;\nEND;";
    private static final String DROP_VIEW = "  BEGIN\n     EXECUTE IMMEDIATE 'DROP VIEW *view_name*';\n  EXCEPTION\n    WHEN OTHERS THEN\n     NULL;\n  END;\n";
    private final PgqlConnection pgqlConn;
    private final String graphSchema;
    private final String graphName;
    private final PgqlCpgRdbmsExpander expander;
    private final Map<Pair<SchemaQualifiedName, String>, Set<String>> tablesWithExpressions = new HashMap<Pair<SchemaQualifiedName, String>, Set<String>>();

    public PgViewDdlExecution(PgqlConnection pgqlConn, String graphSchema, String graphName) {
        this.pgqlConn = pgqlConn;
        this.graphSchema = graphSchema;
        this.graphName = graphName;
        this.expander = PgqlCpgRdbmsExpander.getPgqlCpgRdbmsExpander(pgqlConn, true);
    }

    public void createPG(CreatePropertyGraph cpg, boolean checkTypes) throws SQLException {
        Throwable throwable;
        this.tablesWithExpressions.clear();
        if (cpg.getStatementType() == StatementType.CREATE_SUPER_PROPERTY_GRAPH) {
            cpg = CspgToCpg.getCspgToCpg(this.pgqlConn, this.graphSchema, (CreateSuperPropertyGraph)cpg).mapCspgToCpg();
        }
        this.expander.expand(cpg);
        HashSet<String> functionNames = new HashSet<String>();
        List<VertexTable> newVertexTables = this.getNewVertexTables(cpg, functionNames);
        cpg.setVertexTables(newVertexTables);
        cpg.setEdgeTables(this.getNewEdgeTables(cpg, newVertexTables, functionNames));
        if (!functionNames.isEmpty()) {
            try {
                throwable = null;
                try (PreparedStatement ps = this.pgqlConn.getJdbcConnection().prepareStatement(CHECK_FOR_UDF);){
                    ps.setString(1, String.join((CharSequence)"\"", functionNames) + "\"");
                    ps.execute();
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
            }
            catch (SQLException e) {
                if (e.getErrorCode() != 20001) {
                    throw new PgqlToSqlException(e.getMessage());
                }
                throw new PgqlToSqlException(e.getMessage().replace("ORA-20001: ", "").replace("ORA-06512: at line 19", ""));
            }
        }
        if (!this.tablesWithExpressions.isEmpty()) {
            try {
                throwable = null;
                try (Statement stmt = this.pgqlConn.getJdbcConnection().createStatement();){
                    for (Map.Entry<Pair<SchemaQualifiedName, String>, Set<String>> entry : this.tablesWithExpressions.entrySet()) {
                        String query = "CREATE VIEW " + PgqlUtils.printIdentifier((String)(cpg.getGraphName().getName() + "$" + (String)entry.getKey().second + "_VIEW$")) + "AS SELECT " + String.join((CharSequence)", ", (Iterable<? extends CharSequence>)entry.getValue()) + " FROM " + ((SchemaQualifiedName)entry.getKey().first).toString(true);
                        stmt.addBatch(query);
                    }
                    stmt.executeBatch();
                }
                catch (Throwable throwable3) {
                    throwable = throwable3;
                    throw throwable3;
                }
            }
            catch (SQLException e) {
                this.clearCreatedViews(cpg);
                throw new PgqlToSqlException(e.getMessage());
            }
        }
        PgqlCreatePgVerifier.verify(cpg, this.pgqlConn.getJdbcConnection(), checkTypes);
        throwable = null;
        try (PreparedStatement createTablesPS = this.pgqlConn.getJdbcConnection().prepareStatement(CREATE_TABLES_STR);){
            String[] pgTablesSuffix = new String[]{"_ELEM_TABLE$", "_LABEL$", "_PROPERTY$", "_KEY$", "_SRC_DST_KEY$"};
            for (int i = 0; i < pgTablesSuffix.length; ++i) {
                createTablesPS.setString(2 * i + 1, this.getTableForSuffix(pgTablesSuffix[i]));
                createTablesPS.setString(2 * i + 2, this.getTablePrimaryKeyForSuffix(pgTablesSuffix[i]));
            }
            createTablesPS.execute();
        }
        catch (Throwable pgTablesSuffix) {
            throwable = pgTablesSuffix;
            throw pgTablesSuffix;
        }
        throwable = null;
        try (PreparedStatement insertElemTabPS = this.pgqlConn.getJdbcConnection().prepareStatement(INSERT_ELEMENT_TABLE_STR);
             PreparedStatement insertKeyPS = this.pgqlConn.getJdbcConnection().prepareStatement(INSERT_KEY_STR);
             PreparedStatement insertSrcDstKeyPS = this.pgqlConn.getJdbcConnection().prepareStatement(INSERT_SRC_DST_KEY_STR);
             PreparedStatement insertLabelPS = this.pgqlConn.getJdbcConnection().prepareStatement(INSERT_LABEL_STR);
             PreparedStatement insertPropertyPS = this.pgqlConn.getJdbcConnection().prepareStatement(INSERT_PROPERTY_STR);){
            for (VertexTable vt : cpg.getVertexTables()) {
                this.insertElementTable(insertElemTabPS, insertKeyPS, insertLabelPS, insertPropertyPS, (ElementTable)vt, "VERTEX");
            }
            for (EdgeTable et : cpg.getEdgeTables()) {
                this.insertElementTable(insertElemTabPS, insertKeyPS, insertLabelPS, insertPropertyPS, (ElementTable)et, "EDGE");
                int columnNumber = 1;
                String edgeTab = et.getTableAlias();
                String sourceTab = et.getSourceVertexTable().getTableAlias();
                for (String column : et.getEdgeSourceKey().getColumnNames()) {
                    this.insertSrcDstKey(insertSrcDstKeyPS, edgeTab, sourceTab, "EDGE_SOURCE", column, columnNumber++);
                }
                columnNumber = 1;
                String destTab = et.getDestinationVertexTable().getTableAlias();
                for (String column : et.getEdgeDestinationKey().getColumnNames()) {
                    this.insertSrcDstKey(insertSrcDstKeyPS, edgeTab, destTab, "EDGE_DESTINATION", column, columnNumber++);
                }
            }
            insertElemTabPS.executeBatch();
            insertKeyPS.executeBatch();
            insertSrcDstKeyPS.executeBatch();
            insertLabelPS.executeBatch();
            insertPropertyPS.executeBatch();
        }
        catch (Throwable throwable4) {
            throwable = throwable4;
            throw throwable4;
        }
        this.pgqlConn.getJdbcConnection().commit();
    }

    private void clearCreatedViews(CreatePropertyGraph cpg) {
        StringBuilder query = new StringBuilder("BEGIN\n");
        try (Statement stmt = this.pgqlConn.getJdbcConnection().createStatement();){
            for (Map.Entry<Pair<SchemaQualifiedName, String>, Set<String>> entry : this.tablesWithExpressions.entrySet()) {
                query.append(DROP_VIEW.replace("*view_name*", PgqlUtils.printIdentifier((String)(cpg.getGraphName().getName() + "$" + (String)entry.getKey().second + "_VIEW$"))));
            }
            query.append("END;");
            stmt.execute(query.toString());
        }
        catch (SQLException e) {
            throw new PgqlToSqlException(e.getMessage());
        }
    }

    private List<VertexTable> getNewVertexTables(CreatePropertyGraph cpg, Set<String> functionNames) {
        List vertexTables = cpg.getVertexTables();
        ArrayList<VertexTable> newVertexTables = new ArrayList<VertexTable>();
        for (VertexTable vt : vertexTables) {
            ArrayList<Label> newLabels;
            boolean hasExpression = this.getNewElemTablesLabels((ElementTable)vt, newLabels = new ArrayList<Label>(), functionNames);
            newVertexTables.add(new VertexTable(hasExpression ? new SchemaQualifiedName(cpg.getGraphName().getSchemaName(), cpg.getGraphName().getName() + "$" + vt.getTableAlias() + "_VIEW$") : vt.getTableName(), vt.getTableAlias(), new Key(vt.getKey().getColumnNames()), newLabels));
        }
        return newVertexTables;
    }

    private List<EdgeTable> getNewEdgeTables(CreatePropertyGraph cpg, List<VertexTable> updatedVertexTables, Set<String> functionNames) {
        List EdgeTables = cpg.getEdgeTables();
        ArrayList<EdgeTable> newEdgeTables = new ArrayList<EdgeTable>();
        for (EdgeTable et : EdgeTables) {
            ArrayList<Label> newLabels;
            boolean hasExpression;
            VertexTable newSourceVt = null;
            VertexTable newDestinationVt = null;
            for (VertexTable e : updatedVertexTables) {
                if (newSourceVt != null && newDestinationVt != null) break;
                String vertexTableName = e.getTableAlias();
                String sourceTableName = et.getSourceVertexTable().getTableAlias();
                String destinationTableName = et.getDestinationVertexTable().getTableAlias();
                if (sourceTableName.equals(vertexTableName)) {
                    newSourceVt = e;
                }
                if (!destinationTableName.equals(vertexTableName)) continue;
                newDestinationVt = e;
            }
            if (newSourceVt == null) {
                newSourceVt = et.getSourceVertexTable();
            }
            if (newDestinationVt == null) {
                newDestinationVt = et.getDestinationVertexTable();
            }
            newEdgeTables.add(new EdgeTable((hasExpression = this.getNewElemTablesLabels((ElementTable)et, newLabels = new ArrayList<Label>(), functionNames)) ? new SchemaQualifiedName(cpg.getGraphName().getSchemaName(), cpg.getGraphName().getName() + "$" + et.getTableAlias() + "_VIEW$") : et.getTableName(), et.getTableAlias(), et.getKey(), newSourceVt, et.getEdgeSourceKey(), et.getSourceVertexKey(), newDestinationVt, et.getEdgeDestinationKey(), et.getDestinationVertexKey(), newLabels));
        }
        return newEdgeTables;
    }

    private boolean getNewElemTablesLabels(ElementTable et, List<Label> newLabels, Set<String> functionNames) {
        List labels = et.getLabels();
        HashSet<String> expressions = new HashSet<String>();
        boolean hasExpression = false;
        for (Label l : labels) {
            List properties = l.getProperties();
            ArrayList<Property> newProperties = null;
            if (properties != null) {
                newProperties = new ArrayList<Property>();
                for (Property prt : properties) {
                    Property tmpProperty = new Property(prt.getValueExpression(), prt.getPropertyName() + "$");
                    functionNames.addAll(PgViewDdlExecution.getFunctionNames(tmpProperty.getValueExpression()));
                    expressions.add(tmpProperty.toString());
                    QueryExpression.ExpressionType expType = tmpProperty.getValueExpression().getExpType();
                    if (!hasExpression && expType != QueryExpression.ExpressionType.VARREF) {
                        hasExpression = true;
                    }
                    newProperties.add(new Property((QueryExpression)new QueryExpression.VarRef((QueryVariable)new QueryVertex(tmpProperty.getPropertyName(), false)), prt.getPropertyName()));
                }
            }
            if (hasExpression) {
                newLabels.add(new Label(l.getName(), newProperties));
                continue;
            }
            newLabels.add(l);
        }
        if (hasExpression) {
            expressions.addAll(et.getKey().getColumnNames().stream().map(PgqlUtils::printIdentifier).collect(Collectors.toList()));
            if (et instanceof EdgeTable) {
                EdgeTable tmpEt = (EdgeTable)et;
                expressions.addAll(tmpEt.getEdgeSourceKey().getColumnNames().stream().map(PgqlUtils::printIdentifier).collect(Collectors.toList()));
                expressions.addAll(tmpEt.getEdgeDestinationKey().getColumnNames().stream().map(PgqlUtils::printIdentifier).collect(Collectors.toList()));
            }
            this.tablesWithExpressions.put(new Pair<SchemaQualifiedName, String>(et.getTableName(), et.getTableAlias()), expressions);
        }
        return hasExpression;
    }

    private static Set<String> getFunctionNames(QueryExpression exp) {
        final HashSet<String> result = new HashSet<String>();
        exp.accept((QueryExpressionVisitor)new AbstractQueryExpressionVisitor(){

            public void visit(QueryExpression.FunctionCall fnc) {
                if (fnc.getSchemaName() != null || fnc.getPackageName() != null) {
                    throw new PgqlToSqlException("invalid property graph label property definition: " + PgViewDdlExecution.printFunctionName(fnc));
                }
                result.add(fnc.getFunctionName());
            }
        });
        return result;
    }

    private static String printFunctionName(QueryExpression.FunctionCall fnc) {
        String schemaNamePart = fnc.getSchemaName() == null ? "" : fnc.getSchemaName() + ".";
        String packageNamePart = fnc.getPackageName() == null ? "" : fnc.getPackageName() + ".";
        return schemaNamePart + packageNamePart + fnc.getFunctionName();
    }

    public void dropPG() throws SQLException {
        try (PreparedStatement dropTablesPS = this.pgqlConn.getJdbcConnection().prepareStatement(DROP_TABLES_STR);){
            String[] pgTablesSuffix = new String[]{"_ELEM_TABLE$", "_LABEL$", "_PROPERTY$", "_KEY$", "_SRC_DST_KEY$"};
            for (int i = 0; i < pgTablesSuffix.length; ++i) {
                dropTablesPS.setString(i + 1, this.getTableForSuffix(pgTablesSuffix[i]));
            }
            dropTablesPS.setString(6, this.graphName + "_%_VIEW$");
            dropTablesPS.execute();
            if (this.graphName.equals("PROPERTY_GRAPH_METADATA")) {
                GraphMetadataHandler.cleanup(this.pgqlConn.getJdbcConnection());
            }
        }
    }

    private void insertElementTable(PreparedStatement insertElemTabPS, PreparedStatement insertKeyPS, PreparedStatement insertLabelPS, PreparedStatement insertPropertyPS, ElementTable elementTable, String tableType) throws SQLException {
        String tableAlias = elementTable.getTableAlias();
        insertElemTabPS.setString(1, this.getTableForSuffix("_ELEM_TABLE$"));
        insertElemTabPS.setString(2, tableAlias);
        insertElemTabPS.setString(3, tableType);
        insertElemTabPS.setString(4, elementTable.getTableName().getSchemaName());
        insertElemTabPS.setString(5, elementTable.getTableName().getName());
        insertElemTabPS.addBatch();
        if (elementTable.getKey() != null) {
            int columnNumber = 1;
            for (String column : elementTable.getKey().getColumnNames()) {
                insertKeyPS.setString(1, this.getTableForSuffix("_KEY$"));
                insertKeyPS.setString(2, column);
                insertKeyPS.setInt(3, columnNumber++);
                insertKeyPS.setString(4, tableType);
                insertKeyPS.setString(5, tableAlias);
                insertKeyPS.addBatch();
            }
        }
        for (Label label : elementTable.getLabels()) {
            String labelName = label.getName();
            insertLabelPS.setString(1, this.getTableForSuffix("_LABEL$"));
            insertLabelPS.setString(2, labelName);
            insertLabelPS.setString(3, tableAlias);
            insertLabelPS.setString(4, tableType);
            insertLabelPS.addBatch();
            for (Property property : label.getProperties()) {
                QueryExpression qe = property.getValueExpression();
                String propertyName = property.getPropertyName();
                String columnName = ((QueryExpression.VarRef)qe).getVariable().getName();
                insertPropertyPS.setString(1, this.getTableForSuffix("_PROPERTY$"));
                insertPropertyPS.setString(2, propertyName);
                insertPropertyPS.setString(3, tableAlias);
                insertPropertyPS.setString(4, tableType);
                insertPropertyPS.setString(5, labelName);
                insertPropertyPS.setString(6, columnName);
                insertPropertyPS.addBatch();
            }
        }
    }

    private void insertSrcDstKey(PreparedStatement insertSrcDstKeyPS, String edgeTable, String vertexTable, String keyType, String columnName, int columnNumber) throws SQLException {
        insertSrcDstKeyPS.setString(1, this.getTableForSuffix("_SRC_DST_KEY$"));
        insertSrcDstKeyPS.setString(2, edgeTable);
        insertSrcDstKeyPS.setString(3, vertexTable);
        insertSrcDstKeyPS.setString(4, keyType);
        insertSrcDstKeyPS.setString(5, columnName);
        insertSrcDstKeyPS.setInt(6, columnNumber);
        insertSrcDstKeyPS.addBatch();
    }

    private String getTableForSuffix(String suffix) {
        try {
            return DbmsUtils.getTableForSuffix(this.pgqlConn.getJdbcConnection(), this.graphSchema, this.graphName, suffix);
        }
        catch (SQLException ex) {
            throw new PgqlToSqlException(ex);
        }
    }

    private String getTablePrimaryKeyForSuffix(String suffix) {
        try {
            return DbmsUtils.enquoteTableName(this.pgqlConn.getJdbcConnection(), this.graphName + suffix + "_PK");
        }
        catch (SQLException ex) {
            throw new PgqlToSqlException(ex);
        }
    }
}

