/*
 * Decompiled with CFR 0.152.
 */
package oracle.pg.rdbms.pgql;

import java.util.List;
import oracle.pg.rdbms.pgql.PgqlSqlQueryTrans;
import oracle.pg.rdbms.pgql.PgqlSqlTrans;

public class PgqlSqlQueryTransImpl
implements PgqlSqlQueryTrans {
    private final String sqlTranslation;
    private final List<Object> sqlBvList;

    public PgqlSqlQueryTransImpl(StringBuffer sqlBuff, List<Object> sqlBvList) {
        this.sqlTranslation = sqlBuff.toString();
        this.sqlBvList = sqlBvList;
    }

    @Override
    public PgqlSqlTrans.TranslationType getTranslationType() {
        return PgqlSqlTrans.TranslationType.QUERY;
    }

    @Override
    public String getSqlTranslation() {
        return this.sqlTranslation;
    }

    @Override
    public List<Object> getSqlBvList() {
        return this.sqlBvList;
    }

    public String toString() {
        StringBuffer buff = new StringBuffer();
        buff.append("}\n");
        buff.append("SQL Translation:\n");
        buff.append(this.getSqlTranslation());
        buff.append("\nBind Values List:\n");
        buff.append(this.getSqlBvList());
        return buff.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PgqlSqlQueryTrans s = (PgqlSqlQueryTrans)o;
        String sql = s.getSqlTranslation();
        if (sql != null && !sql.equals(this.sqlTranslation)) {
            return false;
        }
        if (this.sqlTranslation != null) {
            return false;
        }
        List<Object> bvList = s.getSqlBvList();
        if (bvList != null && !bvList.equals(this.sqlBvList)) {
            return false;
        }
        return this.sqlBvList == null;
    }

    public int hashCode() {
        int hc = 31;
        if (this.sqlTranslation != null) {
            hc ^= 31 * this.sqlTranslation.hashCode();
        }
        if (this.sqlBvList != null) {
            hc ^= 31 * this.sqlBvList.hashCode();
        }
        return hc;
    }
}

