/*
 * Decompiled with CFR 0.152.
 */
package oracle.pgx.client;

import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.type.CollectionType;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import oracle.pgx.api.internal.Edge;
import oracle.pgx.api.internal.Vertex;
import oracle.pgx.client.AbstractRemoteIterator;
import oracle.pgx.common.IllegalEnumConstantException;
import oracle.pgx.common.types.IdType;
import oracle.pgx.common.types.PropertyType;
import oracle.pgx.common.util.JsonUtil;
import org.apache.hc.client5.http.fluent.Executor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RemoteKeyIterator<K>
extends AbstractRemoteIterator<K> {
    private static final Logger LOG = LoggerFactory.getLogger(RemoteKeyIterator.class);
    private final PropertyType valueType;
    private final IdType nodeEdgeValueType;

    public RemoteKeyIterator(Executor httpExecutor, String requestUrl, String proxyId, int prefetchSize, PropertyType valueType, IdType nodeEdgeValueType) {
        super(httpExecutor, requestUrl, proxyId, prefetchSize);
        this.valueType = valueType;
        this.nodeEdgeValueType = nodeEdgeValueType;
    }

    @Override
    protected Collection<K> parseResults(String jsonString) throws JsonParseException, JsonMappingException, IOException {
        if (this.valueType != null) {
            if (this.valueType.isNodeOrEdge()) {
                return this.parseEntityResults(jsonString);
            }
            CollectionType collectionClass = JsonUtil.getTypeFactory().constructCollectionType(ArrayList.class, this.valueType.getTypeClass());
            JsonNode node = (JsonNode)JsonUtil.readTopLevelJson((String)jsonString, JsonNode.class);
            ArrayList fetchedValues = (ArrayList)JsonUtil.readValue((String)node.get("items").findValues("key").toString(), (JavaType)collectionClass);
            return fetchedValues;
        }
        LOG.warn("valueType is null, I assume this means there was no entries in the List. Returning empty List.");
        return Collections.emptyList();
    }

    protected Collection<K> parseEntityResults(String jsonString) throws IOException, IllegalEnumConstantException {
        CollectionType collectionClass;
        JsonNode node = (JsonNode)JsonUtil.readTopLevelJson((String)jsonString, JsonNode.class);
        if (node.get("count").asInt() == 0) {
            return Collections.emptyList();
        }
        if (!node.get("items").findValue("key").has("tableName")) {
            CollectionType collectionClass2 = JsonUtil.getTypeFactory().constructCollectionType(ArrayList.class, this.nodeEdgeValueType.getTypeClass());
            return (Collection)JsonUtil.readValue((String)node.get("items").findValues("key").toString(), (JavaType)collectionClass2);
        }
        switch (this.valueType) {
            case VERTEX: {
                collectionClass = JsonUtil.getTypeFactory().constructCollectionType(ArrayList.class, Vertex.class);
                break;
            }
            case EDGE: {
                collectionClass = JsonUtil.getTypeFactory().constructCollectionType(ArrayList.class, Edge.class);
                break;
            }
            default: {
                throw new IllegalEnumConstantException((Enum)this.valueType);
            }
        }
        return (Collection)JsonUtil.readValue((String)node.get("items").findValues("key").toString(), (JavaType)collectionClass);
    }
}

