/*
 * Decompiled with CFR 0.152.
 */
package oracle.pgx.client;

import java.io.IOException;
import java.net.SocketTimeoutException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import oracle.pgx.api.FutureProgress;
import oracle.pgx.api.MalformedQueryException;
import oracle.pgx.api.PgxFuture;
import oracle.pgx.client.RemoteUtils;
import oracle.pgx.common.AsyncStatus;
import oracle.pgx.common.IllegalEnumConstantException;
import oracle.pgx.common.Progress;
import oracle.pgx.common.marshalers.GenericMarshaler;
import oracle.pgx.common.marshalers.Marshaler;
import oracle.pgx.common.marshalers.Marshalers;
import oracle.pgx.common.util.ErrorMessages;
import oracle.pgx.config.InteractionMode;
import org.apache.hc.client5.http.fluent.Executor;
import org.apache.hc.client5.http.fluent.Request;
import org.apache.hc.client5.http.fluent.Response;
import org.apache.hc.core5.net.URIBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PgxRemoteFuture<T>
extends PgxFuture<T> {
    private static final Logger LOG = LoggerFactory.getLogger(PgxRemoteFuture.class);
    private final Executor httpExecutor;
    private final ExecutorService executorService;
    private final String csrfToken;
    private final URI remoteFutureStatusLocation;
    private final URI remoteFutureProgressLocation;
    private final String futureUuid;
    private final Marshaler<T> marshaler;
    private final int pendingRetryMillis;
    private boolean started;
    private boolean successfullyCancelled;

    public PgxRemoteFuture(Executor httpExecutor, ExecutorService executorService, String csrfToken, URI remoteFuturePath, String futureUuid, Marshaler<T> marshaler, int pendingRetryMillis, boolean autostart, InteractionMode interactionMode) {
        this.httpExecutor = httpExecutor;
        this.executorService = executorService;
        this.csrfToken = csrfToken;
        this.remoteFutureStatusLocation = remoteFuturePath.resolve("status");
        this.remoteFutureProgressLocation = remoteFuturePath.resolve("progress");
        this.futureUuid = futureUuid;
        this.marshaler = marshaler;
        this.pendingRetryMillis = pendingRetryMillis;
        if (futureUuid == null) {
            throw new IllegalArgumentException(ErrorMessages.getMessage((String)"PARAMETER_IS_REQUIRED", (Object[])new Object[]{futureUuid}));
        }
        this.started = false;
        this.successfullyCancelled = false;
        if (autostart) {
            if (interactionMode == InteractionMode.ASYNC_POLLING) {
                this.fetchRemoteResultAsync();
            } else if (interactionMode == InteractionMode.BLOCKING) {
                this.fetchRemoteResult();
            } else {
                throw new IllegalEnumConstantException((Enum)interactionMode);
            }
        }
    }

    public synchronized void startFetchRemote() throws IllegalStateException {
        if (this.started) {
            throw new IllegalStateException("We already started fetching the remote result.");
        }
        this.fetchRemoteResult();
    }

    public void executeRequest(URI url) {
        boolean retry;
        Request request = this.prepareRequest(Request.get((URI)url));
        do {
            try {
                Response response = this.httpExecutor.execute(request);
                try {
                    T value = RemoteUtils.parse(response, this.marshaler);
                    this.complete(value);
                    retry = false;
                }
                catch (Exception e) {
                    retry = this.handleParsingExceptions(e);
                }
            }
            catch (Exception e) {
                retry = this.handleRequestExecutionExceptions(e, request);
            }
        } while (retry);
    }

    private synchronized void fetchRemoteResult() {
        this.started = true;
        this.executorService.execute(() -> this.executeRequest(this.remoteFutureStatusLocation.resolve("value")));
    }

    public synchronized boolean cancel(boolean mayInterruptIfRunning) {
        try {
            URIBuilder builder = new URIBuilder(this.remoteFutureStatusLocation.resolve(""));
            builder.addParameter("_csrf_token", this.csrfToken);
            Request request = this.prepareRequest(Request.delete((URI)builder.build()));
            Response response = this.httpExecutor.execute(request);
            try {
                Boolean value = (Boolean)RemoteUtils.parse(response, Marshalers.BOOLEAN_MARSHALER);
                if (!value.booleanValue()) {
                    LOG.warn("Canceling the RemoteFuture returned false.");
                    return false;
                }
            }
            catch (IOException | RemoteUtils.RequestPendingException e) {
                LOG.error("HTTP response parsing error", (Throwable)e);
                return false;
            }
            catch (ExecutionException e) {
                LOG.error("received serialized exception", e.getCause());
                return false;
            }
        }
        catch (URISyntaxException e) {
            LOG.error("could not build URI to delete future", (Throwable)e);
            return false;
        }
        catch (IOException e) {
            LOG.error("HTTP/network error", (Throwable)e);
            return false;
        }
        this.started = false;
        this.successfullyCancelled = true;
        LOG.debug("Remote future {} has been successfully cancelled", (Object)this.remoteFutureStatusLocation.resolve(""));
        return super.cancel(mayInterruptIfRunning);
    }

    public synchronized boolean isCancelled() {
        if (this.successfullyCancelled) {
            LOG.debug("Remote future {} has been successfully cancelled", (Object)this.remoteFutureStatusLocation.resolve(""));
            return true;
        }
        Request request = this.prepareRequest(Request.get((URI)this.remoteFutureStatusLocation));
        boolean retry = false;
        do {
            try {
                Response response = this.httpExecutor.execute(request);
                try {
                    AsyncStatus asyncStatus = RemoteUtils.parseAsyncStatus(response);
                    LOG.debug("Future id {}", (Object)asyncStatus.getId());
                    Progress progress = Progress.valueOf((String)asyncStatus.getProgress().toUpperCase());
                    if (progress == Progress.ABORTED) {
                        this.successfullyCancelled = true;
                        return true;
                    }
                }
                catch (Exception e) {
                    retry = this.handleParsingExceptions(e);
                }
            }
            catch (Exception e) {
                retry = this.handleRequestExecutionExceptions(e, request);
            }
        } while (retry);
        return false;
    }

    private synchronized void fetchRemoteResultAsync() {
        this.started = true;
        this.executorService.execute(() -> {
            this.pollFutureStatus(this.remoteFutureStatusLocation);
            URI valuePath = this.remoteFutureStatusLocation.resolve("value");
            this.executeRequest(valuePath);
        });
    }

    private AsyncStatus pollFutureStatus(URI remoteFuturePath) {
        boolean retry;
        AsyncStatus asyncStatus = null;
        Request request = this.prepareRequest(Request.get((URI)remoteFuturePath));
        do {
            try {
                Response response = this.httpExecutor.execute(request);
                try {
                    asyncStatus = RemoteUtils.parseAsyncStatus(response);
                    boolean bl = retry = asyncStatus.getCompleted() == false;
                    if (!retry) continue;
                    try {
                        Thread.sleep(asyncStatus.getIntervalToPoll());
                    }
                    catch (InterruptedException ie) {
                        LOG.error("Got interrupted while waiting for retry", (Throwable)ie);
                        this.completeExceptionally(ie);
                        retry = false;
                    }
                }
                catch (Exception e) {
                    retry = this.handleParsingExceptions(e);
                }
            }
            catch (Exception e) {
                retry = this.handleRequestExecutionExceptions(e, request);
            }
        } while (retry);
        return asyncStatus;
    }

    public FutureProgress getProgress() {
        Request request = this.prepareRequest(Request.get((URI)this.remoteFutureProgressLocation));
        try {
            Response response = this.httpExecutor.execute(request);
            return (FutureProgress)RemoteUtils.parse(response, new GenericMarshaler(FutureProgress.class));
        }
        catch (IOException | ExecutionException | RemoteUtils.RequestPendingException e) {
            throw new IllegalStateException(e);
        }
    }

    private Request prepareRequest(Request request) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Requesting {}", (Object)request.toString());
        }
        request.addHeader("x-future-id", this.futureUuid);
        return request;
    }

    private boolean handleParsingExceptions(Throwable e) {
        boolean retry;
        if (e instanceof IOException) {
            LOG.error("HTTP response parsing error", e);
            this.completeExceptionally(e);
            retry = false;
        } else if (e instanceof RemoteUtils.RequestPendingException) {
            LOG.trace("got 202 - will retry again after {} milliseconds", (Object)this.pendingRetryMillis);
            retry = true;
            try {
                Thread.sleep(this.pendingRetryMillis);
            }
            catch (InterruptedException ie) {
                LOG.error("Got interrupted while waiting for retry", (Throwable)ie);
                this.completeExceptionally(ie);
                retry = false;
            }
        } else if (e instanceof ExecutionException) {
            if (!(e.getCause() instanceof MalformedQueryException)) {
                LOG.error("received serialized exception", e.getCause());
            }
            this.completeExceptionally(e.getCause());
            retry = false;
        } else {
            LOG.error("caught exception", e);
            this.completeExceptionally(e);
            retry = false;
        }
        return retry;
    }

    private boolean handleRequestExecutionExceptions(Exception e, Request request) {
        boolean retry = false;
        if (e instanceof SocketTimeoutException) {
            LOG.debug("Ran into HTTP timeout, retry instantly. Request: {}", (Object)request.toString());
            retry = true;
        } else if (e instanceof IOException) {
            LOG.error("IO/network error", (Throwable)e);
            this.completeExceptionally(e);
            retry = false;
        }
        return retry;
    }
}

