/*
 * Decompiled with CFR 0.152.
 */
package oracle.pgx.vfs;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PushbackInputStream;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.ServiceLoader;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicReference;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import oracle.pgx.common.IllegalEnumConstantException;
import oracle.pgx.common.UserContext;
import oracle.pgx.common.util.ErrorMessages;
import oracle.pgx.common.util.Plugins;
import oracle.pgx.common.util.Versions;
import oracle.pgx.vfs.CommonsVfsProvider;
import oracle.pgx.vfs.CompressionScheme;
import oracle.pgx.vfs.VirtualFile;
import oracle.pgx.vfs.VirtualFileProvider;
import org.apache.commons.vfs2.impl.DefaultFileReplicator;
import org.apache.commons.vfs2.impl.DefaultFileSystemManager;
import org.apache.commons.vfs2.provider.FileReplicator;
import org.apache.commons.vfs2.provider.UriParser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VirtualFileManager
implements AutoCloseable {
    private static final Logger LOG = LoggerFactory.getLogger(VirtualFileManager.class);
    private static final AtomicReference<VirtualFileManager> VFM_REFERENCE = new AtomicReference<Object>(null);
    final Map<String, VirtualFileProvider> providers = new ConcurrentHashMap<String, VirtualFileProvider>();
    private final Set<String> nonNetworkSchemes = new HashSet<String>();
    private final Set<String> schemesRequiringDirectoryWhiteListing = new HashSet<String>();
    private final Set<String> schemesAllowingRemoteLoading = new HashSet<String>();
    private final String[] supportedSchemes;

    private VirtualFileManager(boolean checkPluginVersion) {
        HashSet<String> schemesSet = new HashSet<String>();
        String expectedVersion = Versions.getVersionOf(VirtualFileProvider.class);
        ServiceLoader<VirtualFileProvider> services = Plugins.loadPlugins(VirtualFileProvider.class, expectedVersion, plugin -> {
            throw new IllegalStateException(ErrorMessages.getMessage("VERSION_MISMATCH_FILE_SYSTEM", plugin.getSchemes().get(0), plugin.getVersion(), expectedVersion));
        }, checkPluginVersion);
        for (VirtualFileProvider vfp : services) {
            for (String scheme : vfp.getSchemes()) {
                schemesSet.add(scheme);
                boolean networkScheme = vfp.schemePerformsNetworkCommunications(scheme);
                boolean requiresWhiteListing = vfp.schemeRequiresDirectoryWhiteListing(scheme);
                boolean allowsRemoteLoading = vfp.schemePerformsInsecureRemoteLoading(scheme);
                LOG.debug("adding provider for scheme {}", (Object)scheme);
                this.addProvider(scheme, vfp);
                if (!networkScheme) {
                    this.nonNetworkSchemes.add(scheme);
                }
                if (requiresWhiteListing) {
                    this.schemesRequiringDirectoryWhiteListing.add(scheme);
                }
                if (!allowsRemoteLoading) continue;
                this.schemesAllowingRemoteLoading.add(scheme);
            }
        }
        String[] schemesArray = new String[schemesSet.size()];
        this.supportedSchemes = schemesSet.toArray(schemesArray);
    }

    public String[] getSupportedSchemes() {
        return this.supportedSchemes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static VirtualFileManager getInstance(boolean checkPluginVersion) {
        AtomicReference<VirtualFileManager> atomicReference = VFM_REFERENCE;
        synchronized (atomicReference) {
            VirtualFileManager vfm = VFM_REFERENCE.get();
            if (vfm == null) {
                VFM_REFERENCE.set(new VirtualFileManager(checkPluginVersion));
            }
            return VFM_REFERENCE.get();
        }
    }

    private void addProvider(String scheme, VirtualFileProvider vfp) {
        VirtualFileProvider prev = this.providers.put(scheme, vfp);
        if (prev != null) {
            throw new IllegalArgumentException(ErrorMessages.getMessage("VFS_PROVIDER_ALREADY_EXISTS", scheme));
        }
    }

    private VirtualFileProvider findProvider(String path, boolean allowNetworkLoading) {
        String scheme = UriParser.extractScheme((String)path);
        if (scheme == null) {
            scheme = "file";
        }
        this.checkThatSchemeIsAllowed(scheme, allowNetworkLoading);
        LOG.trace("look for provider with scheme {}", (Object)scheme);
        VirtualFileProvider vfp = this.providers.get(scheme);
        if (vfp == null) {
            throw new UnsupportedOperationException(ErrorMessages.getMessage("VFS_PROVIDER_NOT_FOUND", scheme, path));
        }
        return vfp;
    }

    private void checkThatSchemeIsAllowed(String scheme, boolean allowNetworkLoading) {
        boolean schemeNotAllowed;
        if (allowNetworkLoading) {
            return;
        }
        boolean bl = schemeNotAllowed = !this.nonNetworkSchemes.contains(scheme.toLowerCase());
        if (schemeNotAllowed) {
            throw new IllegalArgumentException(ErrorMessages.getMessage("NETWORK_LOADING_DISALLOWED", scheme));
        }
    }

    public VirtualFile resolve(String path, UserContext userContext) throws IOException {
        return this.resolve(path, Collections.emptyMap(), userContext);
    }

    public VirtualFile resolve(String path, boolean allowNetworkLoading, UserContext userContext) throws IOException {
        return this.resolve(path, Collections.emptyMap(), allowNetworkLoading, userContext);
    }

    public VirtualFile resolve(String path, Map<String, String> attributes, UserContext userContext) throws IOException {
        return this.resolve(path, attributes, true, userContext);
    }

    public VirtualFile resolve(String path, Map<String, String> attributes, boolean allowNetworkLoading, UserContext userContext) throws IOException {
        LOG.trace("resolve {} (with attributes: {})", (Object)path, attributes);
        VirtualFileProvider vfp = this.findProvider(path, allowNetworkLoading);
        return vfp.resolve(path, attributes, userContext);
    }

    public VirtualFile find(String path, UserContext userContext) throws IOException {
        return this.find(path, Collections.emptyMap(), userContext);
    }

    public VirtualFile find(String path, Map<String, String> attributes, UserContext userContext) throws IOException {
        return this.find(path, attributes, true, userContext);
    }

    public VirtualFile find(String path, Map<String, String> attributes, boolean allowNetworkLoading, UserContext userContext) throws IOException {
        VirtualFile file = this.resolve(path, attributes, allowNetworkLoading, userContext);
        if (!file.exists()) {
            throw new FileNotFoundException(ErrorMessages.getMessage("FILE_NOT_FOUND", path));
        }
        return file;
    }

    public boolean isLocalFileSystemPathRequiringWhiteListing(String path) {
        String scheme = UriParser.extractScheme((String)path);
        return scheme == null || this.schemesRequiringDirectoryWhiteListing.contains(scheme);
    }

    public String getRemoteLoadingScheme(String path) {
        String scheme = UriParser.extractScheme((String)path, null);
        if (this.schemesAllowingRemoteLoading.contains(scheme)) {
            return scheme;
        }
        return null;
    }

    public boolean isLocalRawFileSystemPath(String path) {
        String scheme = UriParser.extractScheme((String)path);
        return scheme == null || scheme.equals("file");
    }

    public String resolve(String parent, String relative, UserContext userContext) throws IOException {
        if (parent == null) {
            return relative;
        }
        if (UriParser.extractScheme((String)relative) != null) {
            return relative;
        }
        LOG.trace("try resolve {} on {}", (Object)relative, (Object)parent);
        VirtualFileProvider vfp = this.findProvider(parent, true);
        LOG.trace("using provider: {}", vfp.getClass());
        VirtualFile file = vfp.resolve(parent, relative, userContext);
        String combined = file.getPath();
        LOG.trace("-> {}", (Object)combined);
        return combined;
    }

    private static InputStream convertToGzipStreamIfNeeded(InputStream input) throws IOException {
        int bytesOfMagicNumber = 2;
        PushbackInputStream pushbackStream = new PushbackInputStream(input, bytesOfMagicNumber);
        byte[] magicNumber = new byte[bytesOfMagicNumber];
        int bytesRead = pushbackStream.read(magicNumber);
        if (bytesRead == -1) {
            return pushbackStream;
        }
        pushbackStream.unread(magicNumber, 0, bytesRead);
        if (VirtualFileManager.matchesGzipMagicNumber(magicNumber)) {
            return new GZIPInputStream(pushbackStream);
        }
        return pushbackStream;
    }

    private static boolean matchesGzipMagicNumber(byte[] magicNumber) {
        if (magicNumber == null || magicNumber.length < 2) {
            return false;
        }
        return magicNumber[0] == 31 && magicNumber[1] == -117;
    }

    public InputStream getInputStream(String path, UserContext userContext) throws IOException {
        return this.getInputStream(path, Collections.emptyMap(), userContext);
    }

    public InputStream getInputStream(String path, boolean allowNetworkLoading, UserContext userContext) throws IOException {
        return this.getInputStream(path, Collections.emptyMap(), allowNetworkLoading, userContext);
    }

    public InputStream getInputStream(String path, Map<String, String> attributes, UserContext userContext) throws IOException {
        return this.find(path, attributes, userContext).getInputStream();
    }

    public InputStream getInputStream(String path, Map<String, String> attributes, boolean allowNetworkLoading, UserContext userContext) throws IOException {
        return this.find(path, attributes, allowNetworkLoading, userContext).getInputStream();
    }

    public InputStream getInputStream(String path, boolean detectGzip, Map<String, String> attributes, UserContext userContext) throws IOException {
        InputStream inputStream = this.getInputStream(path, attributes, userContext);
        return detectGzip ? VirtualFileManager.convertToGzipStreamIfNeeded(inputStream) : inputStream;
    }

    public OutputStream getOutputStream(String path, boolean overwrite, UserContext userContext) throws IOException {
        return this.getOutputStream(path, overwrite, CompressionScheme.NONE, userContext);
    }

    public OutputStream getOutputStream(String path, boolean overwrite, CompressionScheme compressionScheme, UserContext userContext) throws IOException {
        return this.getOutputStream(path, overwrite, compressionScheme, Collections.emptyMap(), userContext);
    }

    public OutputStream getOutputStream(String path, boolean overwrite, Map<String, String> attributes, UserContext userContext) throws IOException {
        return this.getOutputStream(path, overwrite, CompressionScheme.NONE, attributes, userContext);
    }

    public OutputStream getOutputStream(String path, boolean overwrite, CompressionScheme compressionScheme, Map<String, String> attributes, UserContext userContext) throws IOException {
        VirtualFile file = this.resolve(path, attributes, userContext);
        if (file.exists() && !overwrite) {
            throw new IllegalArgumentException(ErrorMessages.getMessage("FILE_EXISTS_NO_OVERWRITE", path));
        }
        if (!file.exists()) {
            file.createFile();
        }
        compressionScheme = compressionScheme == null ? CompressionScheme.NONE : compressionScheme;
        switch (compressionScheme) {
            case GZIP: {
                return new GZIPOutputStream(file.getOutputStream());
            }
            case NONE: {
                return file.getOutputStream();
            }
        }
        throw new IllegalEnumConstantException(compressionScheme);
    }

    @Override
    public void close() throws Exception {
        DefaultFileSystemManager fileSystemManager = CommonsVfsProvider.FSM;
        if (fileSystemManager instanceof DefaultFileSystemManager) {
            DefaultFileSystemManager defaultFileSystemManager = fileSystemManager;
            FileReplicator replicator = defaultFileSystemManager.getReplicator();
            if (replicator instanceof DefaultFileReplicator) {
                DefaultFileReplicator defaultFileReplicator = (DefaultFileReplicator)replicator;
                defaultFileReplicator.close();
            } else {
                LOG.warn("File replicator {} does not support cleaning up generated temporary files", (Object)replicator);
            }
        } else {
            LOG.warn("File system manager {} does not support cleaning up generated temporary files", (Object)fileSystemManager);
        }
    }
}

