/*
 * Decompiled with CFR 0.152.
 */
package oracle.pgx.vfs;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.stream.Stream;
import oracle.pgx.common.util.ErrorMessages;

public interface VirtualFile {
    public String getParent() throws IOException;

    public String getPath() throws IOException;

    public boolean exists() throws IOException;

    default public void delete() throws IOException {
        throw new UnsupportedOperationException(ErrorMessages.getMessage("UNSUPPORTED_VIRTUAL_FILE_DELETION", this.getClass().getSimpleName()));
    }

    public void createFile() throws IOException;

    public InputStream getInputStream() throws IOException;

    public OutputStream getOutputStream() throws IOException;

    public long getLastModifiedTimestamp() throws IOException;

    public long getSizeInBytes() throws IOException;

    default public boolean isFile() throws IOException {
        throw new UnsupportedOperationException();
    }

    default public boolean isDirectory() throws IOException {
        return !this.isFile();
    }

    default public Stream<? extends VirtualFile> listFiles() throws IOException {
        throw new UnsupportedOperationException();
    }

    default public Stream<? extends VirtualFile> listJsonFiles() throws IOException {
        throw new UnsupportedOperationException();
    }
}

