/*
 * Decompiled with CFR 0.152.
 */
package oracle.pgx.utils;

import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Predicate;

public class NameGenerator {
    private static final String SEPARATOR = "_";
    private static final AtomicInteger COUNTER = new AtomicInteger();

    public static String getName(String name, Predicate<String> nameValidator) {
        String tryName = name;
        int i = 2;
        while (nameValidator.test(tryName)) {
            tryName = name + SEPARATOR + i;
            ++i;
        }
        return tryName;
    }

    public static synchronized String getUniqueName(String ... hints) {
        StringBuilder sb = new StringBuilder();
        for (String hint : hints) {
            if (hint == null || hint.isEmpty()) continue;
            sb.append(hint);
            sb.append(SEPARATOR);
        }
        sb.append(COUNTER.incrementAndGet());
        return NameGenerator.urlEncode(sb.toString());
    }

    public static String urlEncode(String s) {
        if (s == null) {
            return null;
        }
        try {
            return URLEncoder.encode(s, "UTF-8").toLowerCase();
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }
}

