/*
 * Decompiled with CFR 0.152.
 */
package oracle.pgx.common.util;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLRecoverableException;
import java.util.concurrent.TimeUnit;
import javax.sql.DataSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class DbUtils {
    private static final Logger LOG = LoggerFactory.getLogger(DbUtils.class);
    private static final int MAX_NUM_DB_CONNECTION_RETRY = 3;
    private static final int DB_CONNECTION_RETRY_TIME_OFF_SEC = 2;
    private static final int DB_CONNECTION_RETRY_BACKOFF_FACTOR = 2;

    private DbUtils() {
    }

    public static Connection getConnectionWithRetry(DataSource dataSource) throws SQLException {
        int dbConnectionRetryTimeSec = 2;
        Connection connection = null;
        int numRetries = 0;
        boolean connected = false;
        while (!connected) {
            try {
                connection = dataSource.getConnection();
                connected = true;
            }
            catch (SQLRecoverableException e) {
                if (++numRetries >= 3) {
                    LOG.error("Aborting making a DB connection after {} tries", (Object)numRetries);
                    throw e;
                }
                LOG.warn("There was a recoverable network issue while making a DB connection. will retry after {} seconds ({}/{})", new Object[]{dbConnectionRetryTimeSec, numRetries, 3});
                LOG.warn(e.toString());
                try {
                    Thread.sleep(TimeUnit.SECONDS.toMillis(dbConnectionRetryTimeSec));
                    dbConnectionRetryTimeSec *= 2;
                }
                catch (InterruptedException ie) {
                    LOG.debug(ie.getMessage(), (Throwable)ie);
                    LOG.warn("The thread has been interrupted while retrying");
                }
            }
        }
        return connection;
    }

    public static boolean checkIfTableExists(Connection connection, String schemaOrUsername, String tableName, String tableColumnSchema) throws SQLException {
        DatabaseMetaData meta = connection.getMetaData();
        if (schemaOrUsername == null && (schemaOrUsername = connection.getSchema()) == null) {
            LOG.warn("Could not retrieve schema from connection, unable to verify if table exists");
            return false;
        }
        schemaOrUsername = schemaOrUsername.toUpperCase();
        try (ResultSet res = meta.getTables(null, schemaOrUsername, tableName, new String[]{"TABLE", "VIEW"});){
            while (res.next()) {
                if (!schemaOrUsername.equals(res.getString(tableColumnSchema))) continue;
                boolean bl = true;
                return bl;
            }
        }
        return false;
    }

    public static long getCurrentScn(Connection rdbmsConn) throws SQLException {
        try {
            return DbUtils.tryGetCurrentScn("select dbms_flashback.get_system_change_number AS current_scn from sys.dual", rdbmsConn);
        }
        catch (SQLException e) {
            LOG.debug("Get SCN from DBMS_FLASHBACK alternative failed", (Throwable)e);
            try {
                return DbUtils.tryGetCurrentScn("SELECT current_scn FROM v$database", rdbmsConn);
            }
            catch (SQLException ex) {
                LOG.debug("Get SCN from V$DATABASE alternative failed", (Throwable)ex);
                return DbUtils.tryGetCurrentScn("select timestamp_to_scn(sysdate) from sys.dual", rdbmsConn);
            }
        }
    }

    private static long tryGetCurrentScn(String sql, Connection rdbmsConn) throws SQLException {
        long scn = -1L;
        try (PreparedStatement statement = rdbmsConn.prepareStatement(sql);
             ResultSet resultSet = statement.executeQuery();){
            resultSet.next();
            scn = resultSet.getLong(1);
        }
        return scn;
    }
}

