/*
 * Decompiled with CFR 0.152.
 */
package org.spoofax.terms.io;

import java.io.BufferedInputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PushbackReader;
import java.io.StringReader;
import java.util.function.Supplier;
import org.spoofax.terms.ParseError;
import org.spoofax.terms.io.TermVisitor;
import org.spoofax.terms.util.NotImplementedException;

public class TAFVisitingTermReader {
    private final StringBuilder sharedBuilder = new StringBuilder();

    public void parseFromFile(String path, TermVisitor visitor) throws IOException, ParseError {
        Throwable throwable = null;
        Object var4_5 = null;
        try (FileInputStream stream = new FileInputStream(path);){
            this.parseFromStream(stream, visitor);
            return;
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    public void parseFromString(String s, TermVisitor visitor) throws ParseError {
        try {
            Throwable throwable = null;
            Object var4_6 = null;
            try (PushbackReader reader = new PushbackReader(new StringReader(s));){
                this.parseFromStream(reader, visitor);
                return;
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public void parseFromStream(InputStream inputStream, TermVisitor visitor) throws IOException, ParseError {
        try {
            if (!(inputStream instanceof BufferedInputStream)) {
                inputStream = new BufferedInputStream(inputStream);
            }
            PushbackReader bis = new PushbackReader(new InputStreamReader(inputStream));
            this.parseFromStream(bis, visitor);
            return;
        }
        finally {
            inputStream.close();
        }
    }

    void parseFromStream(PushbackReader bis, TermVisitor visitor) throws IOException, ParseError {
        this.parseSkip(bis);
        int ch = bis.read();
        switch (ch) {
            case 91: {
                this.parseList(bis, visitor);
                break;
            }
            case 40: {
                this.parseTuple(bis, visitor);
                break;
            }
            case 34: {
                this.parseString(bis, visitor);
                break;
            }
            case 60: {
                this.parsePlaceholder(bis, visitor);
                break;
            }
            case 33: {
                throw new ParseError("Unsupported ATerm format: TAF");
            }
            default: {
                bis.unread(ch);
                if (TAFVisitingTermReader.isLetter(ch)) {
                    this.parseAppl(bis, visitor);
                    break;
                }
                if (TAFVisitingTermReader.isDigit(ch) || ch == 45) {
                    this.parseNumber(bis, visitor);
                    break;
                }
                throw new ParseError("Invalid start of term: 0x" + String.format("%04x", ch) + " '" + (char)ch + "'");
            }
        }
    }

    private void parseAnno(PushbackReader bis, TermVisitor visitor) throws IOException, ParseError {
        this.parseSkip(bis);
        int ch = bis.read();
        if (ch == 123) {
            this.parseTermSequence(bis, '}', visitor::visitAnnotation);
            return;
        }
        bis.unread(ch);
    }

    private void parseString(PushbackReader bis, TermVisitor visitor) throws IOException, ParseError {
        int ch = bis.read();
        if (ch == 34) {
            visitor.visitString("");
        } else {
            boolean escaped;
            StringBuilder sb = this.getSharedBuilder();
            do {
                escaped = false;
                if (ch == 92) {
                    escaped = true;
                    ch = bis.read();
                }
                if (escaped) {
                    switch (ch) {
                        case 110: {
                            sb.append('\n');
                            break;
                        }
                        case 116: {
                            sb.append('\t');
                            break;
                        }
                        case 98: {
                            sb.append('\b');
                            break;
                        }
                        case 102: {
                            sb.append('\f');
                            break;
                        }
                        case 114: {
                            sb.append('\r');
                            break;
                        }
                        case 92: {
                            sb.append('\\');
                            break;
                        }
                        case 39: {
                            sb.append('\'');
                            break;
                        }
                        case 34: {
                            sb.append('\"');
                            break;
                        }
                        case 48: 
                        case 49: 
                        case 50: 
                        case 51: 
                        case 52: 
                        case 53: 
                        case 54: 
                        case 55: 
                        case 56: 
                        case 57: {
                            throw new NotImplementedException();
                        }
                        default: {
                            sb.append('\\').append((char)ch);
                        }
                    }
                    ch = bis.read();
                    continue;
                }
                if (ch == 34) continue;
                if (ch == -1) {
                    throw new ParseError("Unterminated string: " + sb);
                }
                sb.append((char)ch);
                ch = bis.read();
            } while (escaped || ch != 34);
            visitor.visitString(sb.toString());
        }
        this.parseAnno(bis, visitor);
        visitor.endString();
    }

    private void parseAppl(PushbackReader bis, TermVisitor visitor) throws IOException, ParseError {
        StringBuilder sb = this.getSharedBuilder();
        int ch = bis.read();
        do {
            sb.append((char)ch);
        } while (TAFVisitingTermReader.isConstructorChar(ch = bis.read()));
        bis.unread(ch);
        this.parseSkip(bis);
        ch = bis.read();
        String constructor = sb.toString();
        visitor.visitAppl(constructor);
        if (ch == 40) {
            this.parseTermSequence(bis, ')', visitor::visitSubTerm);
        } else {
            bis.unread(ch);
        }
        this.parseAnno(bis, visitor);
        visitor.endAppl();
    }

    private void parsePlaceholder(PushbackReader bis, TermVisitor visitor) throws IOException, ParseError {
        this.parseFromStream(bis, visitor.visitPlaceholder());
        this.parseSkip(bis);
        if (bis.read() != 62) {
            throw new ParseError("Expected: '>'");
        }
    }

    private void parseTuple(PushbackReader bis, TermVisitor visitor) throws IOException, ParseError {
        visitor.visitTuple();
        this.parseTermSequence(bis, ')', visitor::visitSubTerm);
        this.parseAnno(bis, visitor);
        visitor.endTuple();
    }

    private void parseTermSequence(PushbackReader bis, char endChar, Supplier<TermVisitor> visitor) throws IOException, ParseError {
        this.parseSkip(bis);
        int ch = bis.read();
        if (ch == endChar) {
            return;
        }
        bis.unread(ch);
        do {
            this.parseFromStream(bis, visitor.get());
            this.parseSkip(bis);
        } while ((ch = bis.read()) == 44);
        if (ch != endChar) {
            bis.unread(ch);
            this.parseSkip(bis);
            ch = bis.read();
        }
        if (ch != endChar) {
            throw new ParseError("Sequence must end with '" + endChar + "', saw '" + (char)ch + "' '" + (char)bis.read() + "'");
        }
    }

    private void parseList(PushbackReader bis, TermVisitor visitor) throws IOException, ParseError {
        visitor.visitList();
        this.parseTermSequence(bis, ']', visitor::visitSubTerm);
        this.parseAnno(bis, visitor);
        visitor.endList();
    }

    private void parseNumber(PushbackReader bis, TermVisitor visitor) throws IOException {
        String whole = this.parseDigitSequence(bis);
        int ch = bis.read();
        if (ch == 46) {
            String frac = this.parseDigitSequence(bis);
            ch = bis.read();
            if (ch == 101 || ch == 69) {
                String exp = this.parseDigitSequence(bis);
                double d = Double.parseDouble(String.valueOf(whole) + "." + frac + "e" + exp);
                visitor.visitReal(d);
            } else {
                bis.unread(ch);
                double d = Double.parseDouble(String.valueOf(whole) + "." + frac);
                visitor.visitReal(d);
            }
            this.parseAnno(bis, visitor);
            visitor.endReal();
        } else {
            bis.unread(ch);
            visitor.visitInt(Integer.parseInt(whole));
            this.parseAnno(bis, visitor);
            visitor.endInt();
        }
    }

    private String parseDigitSequence(PushbackReader bis) throws IOException {
        StringBuilder sb = this.getSharedBuilder();
        int ch = bis.read();
        do {
            sb.append((char)ch);
        } while (TAFVisitingTermReader.isDigit(ch = bis.read()));
        bis.unread(ch);
        return sb.toString();
    }

    private void parseSkip(PushbackReader input) throws IOException {
        int b;
        block3: while (true) {
            b = input.read();
            switch (b) {
                case 9: 
                case 10: 
                case 13: 
                case 32: {
                    continue block3;
                }
            }
            break;
        }
        input.unread(b);
    }

    private static boolean isDigit(int ch) {
        return 48 <= ch && ch <= 57;
    }

    private static boolean isLetter(int ch) {
        return 65 <= ch && ch <= 90 || 97 <= ch && ch <= 122;
    }

    private static boolean isLetterOrDigit(int ch) {
        return TAFVisitingTermReader.isLetter(ch) || TAFVisitingTermReader.isDigit(ch);
    }

    private static boolean isConstructorChar(int ch) {
        if (TAFVisitingTermReader.isLetterOrDigit(ch)) {
            return true;
        }
        switch (ch) {
            case 36: 
            case 42: 
            case 43: 
            case 45: 
            case 95: {
                return true;
            }
        }
        return false;
    }

    private StringBuilder getSharedBuilder() {
        this.sharedBuilder.setLength(0);
        return this.sharedBuilder;
    }
}

