/*
 * Decompiled with CFR 0.152.
 */
package org.spoofax.terms;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.List;
import javax.annotation.Nullable;
import org.spoofax.interpreter.terms.IStrategoList;
import org.spoofax.interpreter.terms.IStrategoTerm;
import org.spoofax.interpreter.terms.ITermPrinter;
import org.spoofax.interpreter.terms.TermType;
import org.spoofax.terms.AbstractSimpleTerm;
import org.spoofax.terms.AbstractTermFactory;
import org.spoofax.terms.TermFactory;
import org.spoofax.terms.TermList;

public abstract class StrategoTerm
extends AbstractSimpleTerm
implements IStrategoTerm,
Cloneable {
    private static final long serialVersionUID = -2803845954655431574L;
    private static final int UNKNOWN_HASH = -1;
    private transient int hashCode = -1;
    @Nullable
    private IStrategoList annotations = null;

    protected StrategoTerm(@Nullable IStrategoList annotations) {
        if (annotations != null && !annotations.isEmpty()) {
            this.annotations = annotations;
        }
    }

    protected StrategoTerm() {
        this(null);
    }

    @Override
    public List<IStrategoTerm> getSubterms() {
        return TermList.ofUnsafe(this.getAllSubterms());
    }

    @Override
    public final boolean match(IStrategoTerm second) {
        if (this == second) {
            return true;
        }
        if (second == null) {
            return false;
        }
        return this.hashCode() == second.hashCode() && this.doSlowMatch(second);
    }

    protected abstract boolean doSlowMatch(IStrategoTerm var1);

    public final boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof IStrategoTerm)) {
            return false;
        }
        return this.match((IStrategoTerm)obj);
    }

    public int hashCode() {
        if (this.hashCode == -1) {
            this.initImmutableHashCode();
        }
        return this.hashCode;
    }

    protected final void initImmutableHashCode() {
        int hashCode = this.hashFunction();
        this.hashCode = this.annotations == null || this.annotations.isEmpty() ? hashCode : hashCode * 2423 + this.annotations.hashCode();
    }

    protected abstract int hashFunction();

    public String toString() {
        return this.toString(-1);
    }

    @Override
    public String toString(int maxDepth) {
        StringBuilder result = new StringBuilder();
        try {
            this.writeAsString(result, maxDepth);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return result.toString();
    }

    public final void writeToString(Appendable output) throws IOException {
        this.writeAsString(output, -1);
    }

    protected void appendAnnotations(Appendable sb, int maxDepth) throws IOException {
        IStrategoList annos = this.getAnnotations();
        if (annos.size() == 0) {
            return;
        }
        sb.append('{');
        annos.getSubterm(0).writeAsString(sb, maxDepth);
        annos = annos.tail();
        while (!annos.isEmpty()) {
            sb.append(',');
            annos.head().writeAsString(sb, maxDepth);
            annos = annos.tail();
        }
        sb.append('}');
    }

    @Deprecated
    protected void printAnnotations(ITermPrinter pp) {
        IStrategoList annos = this.getAnnotations();
        if (annos.size() == 0) {
            return;
        }
        pp.print("{");
        annos.head().prettyPrint(pp);
        annos = annos.tail();
        while (!annos.isEmpty()) {
            pp.print(",");
            annos.head().prettyPrint(pp);
            annos = annos.tail();
        }
        pp.print("}");
    }

    protected StrategoTerm clone() {
        try {
            return (StrategoTerm)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException(e);
        }
    }

    public StrategoTerm clone(boolean stripAttachments) {
        StrategoTerm result = this.clone();
        if (stripAttachments) {
            result.clearAttachments();
        }
        return result;
    }

    @Override
    public final IStrategoList getAnnotations() {
        return this.annotations == null ? TermFactory.EMPTY_LIST : this.annotations;
    }

    public final void internalSetAnnotations(IStrategoList annotations) {
        if (annotations != null && !annotations.isEmpty() && this == AbstractTermFactory.EMPTY_LIST) {
            throw new IllegalArgumentException("Attempting to internally mutate the shared EMPTY_LIST");
        }
        if (annotations == TermFactory.EMPTY_LIST || annotations == null || annotations.isEmpty()) {
            annotations = null;
        }
        if (this.annotations != annotations) {
            this.annotations = annotations;
            this.hashCode = -1;
        }
    }

    @Override
    @Deprecated
    public int getTermType() {
        return this.getType().getValue();
    }

    @Override
    public abstract TermType getType();

    @Override
    @Deprecated
    public final boolean isList() {
        return this.getType() == TermType.LIST;
    }

    private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
        stream.defaultReadObject();
        this.hashCode = -1;
    }
}

