/*
 * Decompiled with CFR 0.152.
 */
package org.spoofax.jsglr2.stack.collections;

import com.google.common.collect.Iterables;
import java.util.Comparator;
import java.util.Iterator;
import java.util.PriorityQueue;
import java.util.Queue;
import org.spoofax.jsglr2.parseforest.IDerivation;
import org.spoofax.jsglr2.parseforest.IParseForest;
import org.spoofax.jsglr2.parseforest.IParseNode;
import org.spoofax.jsglr2.parser.AbstractParseState;
import org.spoofax.jsglr2.parser.observing.ParserObserving;
import org.spoofax.jsglr2.stack.IStackNode;
import org.spoofax.jsglr2.stack.collections.IForActorStacks;

public abstract class ForActorStacks<ParseForest extends IParseForest, Derivation extends IDerivation<ParseForest>, ParseNode extends IParseNode<ParseForest, Derivation>, StackNode extends IStackNode, ParseState extends AbstractParseState<?, StackNode>>
implements IForActorStacks<StackNode> {
    private final ParserObserving<ParseForest, Derivation, ParseNode, StackNode, ParseState> observing;
    protected final Queue<StackNode> forActorDelayed;

    protected ForActorStacks(ParserObserving<ParseForest, Derivation, ParseNode, StackNode, ParseState> observing) {
        this.observing = observing;
        Comparator stackNodePriorityComparator = (stackNode1, stackNode2) -> 0;
        this.forActorDelayed = new PriorityQueue<StackNode>(stackNodePriorityComparator);
    }

    protected abstract void forActorAdd(StackNode var1);

    protected abstract boolean forActorContains(StackNode var1);

    protected abstract boolean forActorNonEmpty();

    protected abstract StackNode forActorRemove();

    protected abstract Iterable<StackNode> forActorIterable();

    @Override
    public void add(StackNode stack) {
        this.observing.notify(observer -> observer.addForActorStack(stack));
        if (stack.state().isRejectable()) {
            this.forActorDelayed.add(stack);
        } else {
            this.forActorAdd(stack);
        }
    }

    @Override
    public boolean contains(StackNode stack) {
        return this.forActorContains(stack) || this.forActorDelayed.contains(stack);
    }

    @Override
    public boolean nonEmpty() {
        return this.forActorNonEmpty() || !this.forActorDelayed.isEmpty();
    }

    @Override
    public StackNode remove() {
        if (this.forActorNonEmpty()) {
            return this.forActorRemove();
        }
        return (StackNode)((IStackNode)this.forActorDelayed.remove());
    }

    @Override
    public Iterator<StackNode> iterator() {
        return Iterables.concat(this.forActorIterable(), this.forActorDelayed).iterator();
    }
}

