/*
 * Decompiled with CFR 0.152.
 */
package org.spoofax.jsglr2.incremental.diff.jgit;

import org.spoofax.jsglr2.incremental.diff.jgit.Edit;
import org.spoofax.jsglr2.incremental.diff.jgit.EditList;
import org.spoofax.jsglr2.incremental.diff.jgit.HistogramDiff;
import org.spoofax.jsglr2.incremental.diff.jgit.MyersDiff;
import org.spoofax.jsglr2.incremental.diff.jgit.Sequence;
import org.spoofax.jsglr2.incremental.diff.jgit.SequenceComparator;
import org.spoofax.jsglr2.incremental.diff.jgit.Subsequence;
import org.spoofax.jsglr2.incremental.diff.jgit.SubsequenceComparator;

public abstract class DiffAlgorithm {
    public static DiffAlgorithm getAlgorithm(SupportedAlgorithm alg) {
        switch (alg) {
            case MYERS: {
                return MyersDiff.INSTANCE;
            }
            case HISTOGRAM: {
                return new HistogramDiff();
            }
        }
        throw new IllegalArgumentException();
    }

    public <S extends Sequence> EditList diff(SequenceComparator<? super S> cmp, S a, S b) {
        Edit region = cmp.reduceCommonStartEnd(a, b, DiffAlgorithm.coverEdit(a, b));
        switch (region.getType()) {
            case INSERT: 
            case DELETE: {
                return EditList.singleton(region);
            }
            case REPLACE: {
                if (region.getLengthA() == 1 && region.getLengthB() == 1) {
                    return EditList.singleton(region);
                }
                SubsequenceComparator<? super S> cs = new SubsequenceComparator<S>(cmp);
                Subsequence<S> as = Subsequence.a(a, region);
                Subsequence<S> bs = Subsequence.b(b, region);
                EditList e = Subsequence.toBase(this.diffNonCommon(cs, as, bs), as, bs);
                return DiffAlgorithm.normalize(cmp, e, a, b);
            }
            case EMPTY: {
                return new EditList(0);
            }
        }
        throw new IllegalStateException();
    }

    private static <S extends Sequence> Edit coverEdit(S a, S b) {
        return new Edit(0, a.size(), 0, b.size());
    }

    private static <S extends Sequence> EditList normalize(SequenceComparator<? super S> cmp, EditList e, S a, S b) {
        Edit prev = null;
        int i = e.size() - 1;
        while (i >= 0) {
            int maxB;
            Edit cur = (Edit)e.get(i);
            Edit.Type curType = cur.getType();
            int maxA = prev == null ? a.size() : prev.beginA;
            int n = maxB = prev == null ? b.size() : prev.beginB;
            if (curType == Edit.Type.INSERT) {
                while (cur.endA < maxA && cur.endB < maxB && cmp.equals(b, cur.beginB, b, cur.endB)) {
                    cur.shift(1);
                }
            } else if (curType == Edit.Type.DELETE) {
                while (cur.endA < maxA && cur.endB < maxB && cmp.equals(a, cur.beginA, a, cur.endA)) {
                    cur.shift(1);
                }
            }
            prev = cur;
            --i;
        }
        return e;
    }

    public abstract <S extends Sequence> EditList diffNonCommon(SequenceComparator<? super S> var1, S var2, S var3);

    public static enum SupportedAlgorithm {
        MYERS,
        HISTOGRAM;

    }
}

