/*
 * Decompiled with CFR 0.152.
 */
package org.spoofax.jsglr.client.editregion.detection;

import java.util.ArrayList;
import org.spoofax.interpreter.terms.IStrategoTerm;
import org.spoofax.jsglr.client.editregion.detection.DamagedTokenAnalyzer;
import org.spoofax.jsglr.client.editregion.detection.DiscardableRegion;
import org.spoofax.jsglr.client.editregion.detection.LCS;
import org.spoofax.jsglr.client.editregion.detection.LCSCommand;
import org.spoofax.jsglr.client.editregion.detection.LayoutEditsAnalyzer;
import org.spoofax.jsglr.client.editregion.detection.RecoverInterpretation;
import org.spoofax.jsglr.client.editregion.detection.TermEditsAnalyzer;
import org.spoofax.jsglr.client.editregion.detection.TerminalEditsAnalyzer;
import org.spoofax.jsglr.client.imploder.AbstractTokenizer;
import org.spoofax.jsglr.client.imploder.ITokens;
import org.spoofax.jsglr.client.imploder.ImploderAttachment;

public class EditRegionDetector {
    private final LCS<Character> lcs;
    private final String erroneousInput;
    private final IStrategoTerm correctAST;
    private RecoverInterpretation discardRecovery;
    private ArrayList<DiscardableRegion> discardableCommentRegions;

    public String getCorrectInput() {
        return ImploderAttachment.getTokenizer(this.correctAST).getInput();
    }

    public ArrayList<Integer> getDeletionOffsets() {
        return this.lcs.getUnMatchedIndices1();
    }

    public ArrayList<String> getDeletedSubstrings() {
        return this.constructSubstringsFromOffsets(this.getDeletionOffsets(), this.getCorrectInput());
    }

    public ArrayList<DiscardableRegion> getEditedRegionsCorrect() {
        if (this.discardRecovery == null) {
            RecoverInterpretation emptyRecovery = RecoverInterpretation.createDiscardInterpretation(this.correctAST, null);
            return emptyRecovery.getDamagedRegions();
        }
        return DiscardableRegion.mergeSubsequentRegions(DiscardableRegion.mergeRegions(this.discardRecovery.getDamagedRegions(), this.discardableCommentRegions));
    }

    public ArrayList<Integer> getDiscardOffsetsCorrectInput() {
        return DiscardableRegion.getOffsets(this.getEditedRegionsCorrect());
    }

    public ArrayList<IStrategoTerm> getEditedTerms() {
        return this.discardRecovery.getDamagedTerms();
    }

    public String getErroneousInput() {
        return this.erroneousInput;
    }

    public ArrayList<Integer> getInsertionOffsets() {
        return this.lcs.getUnMatchedIndices2();
    }

    public ArrayList<String> getInsertedSubstrings() {
        return this.constructSubstringsFromOffsets(this.getInsertionOffsets(), this.getErroneousInput());
    }

    public ArrayList<DiscardableRegion> getEditedRegionsErroneous() {
        ArrayList<DiscardableRegion> editsFromDeletions = this.mapRegions(this.getEditedRegionsCorrect(), true);
        ArrayList<DiscardableRegion> editsFromInsertions = DiscardableRegion.constructRegionsFromOffsets(this.getInsertionOffsets(), this.getErroneousInput());
        return DiscardableRegion.mergeSubsequentRegions(DiscardableRegion.mergeRegions(editsFromDeletions, editsFromInsertions));
    }

    public ArrayList<Integer> getDiscardOffsetsErroneousInput() {
        return DiscardableRegion.getOffsets(this.getEditedRegionsErroneous());
    }

    public String getRecoveredInput() {
        String recoveredProgram = DiscardableRegion.replaceAllRegionsByWhitespace(this.getEditedRegionsErroneous(), this.getErroneousInput());
        assert (recoveredProgram.length() == this.getErroneousInput().length()) : "whitespaces are inserted for characters in the edit regions";
        return recoveredProgram;
    }

    public EditRegionDetector(IStrategoTerm correctAST, String erroneousInput) {
        this.correctAST = correctAST;
        this.erroneousInput = erroneousInput;
        this.lcs = new LCS<Character>(new LCSCommand<Character>(){

            @Override
            public boolean isMatch(Character c1, Character c2) {
                return c1.charValue() == c2.charValue();
            }
        });
        this.detectEditRegions();
    }

    private void detectEditRegions() {
        ITokens tokens = ImploderAttachment.getTokenizer(this.correctAST);
        long time = System.currentTimeMillis();
        this.constructCharacterMatching();
        ArrayList<Integer> offsetsDeletedChars = this.lcs.getUnMatchedIndices1();
        System.out.println("LCS: " + (System.currentTimeMillis() - time));
        time = System.currentTimeMillis();
        DamagedTokenAnalyzer tokenEdits = new DamagedTokenAnalyzer((AbstractTokenizer)tokens, this.lcs);
        System.out.println("token edits: " + (System.currentTimeMillis() - time));
        time = System.currentTimeMillis();
        LayoutEditsAnalyzer loAnalyzer = new LayoutEditsAnalyzer(tokenEdits);
        this.discardableCommentRegions = loAnalyzer.getDamagedCommentRegions();
        loAnalyzer.filterNonLayoutOffsets(offsetsDeletedChars);
        System.out.println("layout edits: " + (System.currentTimeMillis() - time));
        time = System.currentTimeMillis();
        TerminalEditsAnalyzer terminalAnalyzer = new TerminalEditsAnalyzer(tokenEdits);
        terminalAnalyzer.addDamagedTokensStartOffsets(offsetsDeletedChars);
        System.out.println("terminal edits: " + (System.currentTimeMillis() - time));
        time = System.currentTimeMillis();
        TermEditsAnalyzer brokenConstructDetector = new TermEditsAnalyzer(offsetsDeletedChars, this.correctAST);
        this.discardRecovery = brokenConstructDetector.getDiscardRecovery();
        System.out.println("Term edits: " + (System.currentTimeMillis() - time));
        time = System.currentTimeMillis();
    }

    private void constructCharacterMatching() {
        ArrayList<Character> correctChars = EditRegionDetector.asCharacterList(this.getCorrectInput());
        ArrayList<Character> erroneousChars = EditRegionDetector.asCharacterList(this.getErroneousInput());
        this.lcs.createLCSResultsOptimized(correctChars, erroneousChars);
    }

    private static ArrayList<Character> asCharacterList(String correctInput) {
        ArrayList<Character> correctChars = new ArrayList<Character>();
        int i = 0;
        while (i < correctInput.length()) {
            correctChars.add(Character.valueOf(correctInput.charAt(i)));
            ++i;
        }
        return correctChars;
    }

    private DiscardableRegion mapRegion(DiscardableRegion region, boolean isInCorrectInputString) {
        String input = this.getCorrectInput();
        if (isInCorrectInputString) {
            input = this.getErroneousInput();
        }
        int startOffset = -1;
        int endOffset = -1;
        int offset = region.getStartOffset();
        while (offset <= region.getEndOffset()) {
            int correspondingOffset = this.lcs.getMatchIndex(offset, isInCorrectInputString);
            if (correspondingOffset != -1) {
                if (startOffset == -1) {
                    startOffset = correspondingOffset;
                }
                endOffset = correspondingOffset;
            }
            ++offset;
        }
        if (startOffset >= 0) {
            return new DiscardableRegion(startOffset, endOffset, input);
        }
        return null;
    }

    private ArrayList<DiscardableRegion> mapRegions(ArrayList<DiscardableRegion> regions, boolean isInCorrectInputString) {
        ArrayList<DiscardableRegion> result = new ArrayList<DiscardableRegion>();
        for (DiscardableRegion region : regions) {
            DiscardableRegion mappedRegion = this.mapRegion(region, isInCorrectInputString);
            if (mappedRegion == null) continue;
            result.add(mappedRegion);
        }
        return result;
    }

    private ArrayList<String> constructSubstringsFromOffsets(ArrayList<Integer> offsets, String inputString) {
        ArrayList<DiscardableRegion> regions = DiscardableRegion.constructRegionsFromOffsets(offsets, inputString);
        return DiscardableRegion.constructFragments(regions);
    }
}

